// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_AR_HPP
#define BOOST_TEXT_DATA_AR_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace ar {

inline string_view compat_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
[reorder Arab]
&ت<<ة<<<ﺔ<<<ﺓ
&ي<<ى<<<ﯨ<<<ﯩ<<<ﻰ<<<ﻯ<<<ﲐ<<<ﱝ
  )");
}

inline string_view standard_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"[reorder Arab]\n"
u8"&[before 2]ت<<‎ة\n"
u8"&[before 2]‎ي‎<<ی<<‎ى\n"
u8"&‎ء<<‎أ<<‎ؤ<<‎إ<<‎ئ<<‎ىٕ<<‎ا\n"
u8"  ‎&ءا‎<<‎آ‎\n"
u8"&[last secondary ignorable]<<<\\u064B<<<\\u08F0<<<\\u08E7<<<\\u064C<<<\\u08F1\n"
u8"  <<<\\u08E8<<<\\u064D<<<\\u08F2<<<\\u08E9<<<\\u064E<<<\\u08E4<<<\\u08F4<<<\\u08F5\n"
u8"  <<<\\u064F<<<\\u08E5<<<\\u08FE<<<\\u0650<<<\\u08E6<<<\\u08F6<<<\\u0651<<<\\u0652\n"
u8"  <<<\\u0653<<<\\u06DF<<<\\u06E1<<<\\u065F<<<\\u0656<<<\\u0657<<<\\u0658<<<\\u08FF\n"
u8"  <<<\\u0659<<<\\u065A<<<\\u065B<<<\\u065C<<<\\u065D<<<\\u065E<<<\\u08F7<<<\\u08F8\n"
u8"  <<<\\u08FD<<<\\u08FB<<<\\u08FC<<<\\u08F9<<<\\u08FA<<<\\u0670\n"
u8"&‎'بسم الله الرحمن الرحيم'<<<‎﷽\n"
u8"  ‎&ء‎=ﺀ\n"
u8"  ‎&ا‎=ﺍ‎=ﺎ\n"
u8"  ‎&اكبر‎<<<ﷳ\n"
u8"  ‎&الله‎<<<ﷲ\n"
u8"  ‎&ا\\u064B‎=ﴼ‎=ﴽ\n"
u8"  ‎&آ‎=ﺁ‎=ﺂ\n"
u8"  ‎&أ‎=ﺃ‎=ﺄ\n"
u8"  ‎&إ‎=ﺇ‎=ﺈ\n"
u8"  ‎&ب‎=ﺏ‎=ﺐ‎=ﺑ‎=ﺒ\n"
u8"  ‎&بج‎=ﰅ‎=ﲜ\n"
u8"  ‎&بح‎=ﰆ‎=ﲝ\n"
u8"  ‎&بحي‎=ﷂ\n"
u8"  ‎&بخ‎=ﰇ‎=ﲞ\n"
u8"  ‎&بخي‎=ﶞ\n"
u8"  ‎&بر‎=ﱪ\n"
u8"  ‎&بز‎=ﱫ\n"
u8"  ‎&بم‎=ﰈ‎=ﱬ‎=ﲟ‎=ﳡ\n"
u8"  ‎&بن‎=ﱭ\n"
u8"  ‎&به‎=ﲠ‎=ﳢ\n"
u8"  ‎&بى‎=ﰉ‎=ﱮ\n"
u8"  ‎&بي‎=ﰊ‎=ﱯ\n"
u8"  ‎&ة‎=ﺓ‎=ﺔ\n"
u8"  ‎&ت‎=ﺕ‎=ﺖ‎=ﺗ‎=ﺘ\n"
u8"  ‎&تج‎=ﰋ‎=ﲡ\n"
u8"  ‎&تجم‎=ﵐ\n"
u8"  ‎&تجى‎=ﶠ\n"
u8"  ‎&تجي‎=ﶟ\n"
u8"  ‎&تح‎=ﰌ‎=ﲢ\n"
u8"  ‎&تحج‎=ﵑ‎=ﵒ\n"
u8"  ‎&تحم‎=ﵓ\n"
u8"  ‎&تخ‎=ﰍ‎=ﲣ\n"
u8"  ‎&تخم‎=ﵔ\n"
u8"  ‎&تخى‎=ﶢ\n"
u8"  ‎&تخي‎=ﶡ\n"
u8"  ‎&تر‎=ﱰ\n"
u8"  ‎&تز‎=ﱱ\n"
u8"  ‎&تم‎=ﰎ‎=ﱲ‎=ﲤ‎=ﳣ\n"
u8"  ‎&تمج‎=ﵕ\n"
u8"  ‎&تمح‎=ﵖ\n"
u8"  ‎&تمخ‎=ﵗ\n"
u8"  ‎&تمى‎=ﶤ\n"
u8"  ‎&تمي‎=ﶣ\n"
u8"  ‎&تن‎=ﱳ\n"
u8"  ‎&ته‎=ﲥ‎=ﳤ\n"
u8"  ‎&تى‎=ﰏ‎=ﱴ\n"
u8"  ‎&تي‎=ﰐ‎=ﱵ\n"
u8"  ‎&ث‎=ﺙ‎=ﺚ‎=ﺛ‎=ﺜ\n"
u8"  ‎&ثج‎=ﰑ\n"
u8"  ‎&ثر‎=ﱶ\n"
u8"  ‎&ثز‎=ﱷ\n"
u8"  ‎&ثم‎=ﰒ‎=ﱸ‎=ﲦ‎=ﳥ\n"
u8"  ‎&ثن‎=ﱹ\n"
u8"  ‎&ثه‎=ﳦ\n"
u8"  ‎&ثى‎=ﰓ‎=ﱺ\n"
u8"  ‎&ثي‎=ﰔ‎=ﱻ\n"
u8"  ‎&ج‎=ﺝ‎=ﺞ‎=ﺟ‎=ﺠ\n"
u8"  ‎&جح‎=ﰕ‎=ﲧ\n"
u8"  ‎&جحى‎=ﶦ\n"
u8"  ‎&جحي‎=ﶾ\n"
u8"  ‎&'جل جلاله'‎<<<ﷻ\n"
u8"  ‎&جم‎=ﰖ‎=ﲨ\n"
u8"  ‎&جمح‎=ﵘ‎=ﵙ\n"
u8"  ‎&جمى‎=ﶧ\n"
u8"  ‎&جمي‎=ﶥ\n"
u8"  ‎&جى‎=ﴁ‎=ﴝ\n"
u8"  ‎&جي‎=ﴂ‎=ﴞ\n"
u8"  ‎&ح‎=ﺡ‎=ﺢ‎=ﺣ‎=ﺤ\n"
u8"  ‎&حج‎=ﰗ‎=ﲩ\n"
u8"  ‎&حجي‎=ﶿ\n"
u8"  ‎&حم‎=ﰘ‎=ﲪ\n"
u8"  ‎&حمى‎=ﵛ\n"
u8"  ‎&حمي‎=ﵚ\n"
u8"  ‎&حى‎=ﳿ‎=ﴛ\n"
u8"  ‎&حي‎=ﴀ‎=ﴜ\n"
u8"  ‎&خ‎=ﺥ‎=ﺦ‎=ﺧ‎=ﺨ\n"
u8"  ‎&خج‎=ﰙ‎=ﲫ\n"
u8"  ‎&خح‎=ﰚ\n"
u8"  ‎&خم‎=ﰛ‎=ﲬ\n"
u8"  ‎&خى‎=ﴃ‎=ﴟ\n"
u8"  ‎&خي‎=ﴄ‎=ﴠ\n"
u8"  ‎&د‎=ﺩ‎=ﺪ\n"
u8"  ‎&ذ‎=ﺫ‎=ﺬ\n"
u8"  ‎&ذ\\u0670‎=ﱛ\n"
u8"  ‎&ر‎=ﺭ‎=ﺮ\n"
u8"  ‎&رسول‎<<<ﷶ\n"
u8"  ‎&ر\\u0670‎=ﱜ\n"
u8"  ‎&ریال‎<<<﷼\n"
u8"  ‎&ز‎=ﺯ‎=ﺰ\n"
u8"  ‎&س‎=ﺱ‎=ﺲ‎=ﺳ‎=ﺴ\n"
u8"  ‎&سج‎=ﰜ‎=ﲭ‎=ﴴ\n"
u8"  ‎&سجح‎=ﵝ\n"
u8"  ‎&سجى‎=ﵞ\n"
u8"  ‎&سح‎=ﰝ‎=ﲮ‎=ﴵ\n"
u8"  ‎&سحج‎=ﵜ\n"
u8"  ‎&سخ‎=ﰞ‎=ﲯ‎=ﴶ\n"
u8"  ‎&سخى‎=ﶨ\n"
u8"  ‎&سخي‎=ﷆ\n"
u8"  ‎&سر‎=ﴎ‎=ﴪ\n"
u8"  ‎&سم‎=ﰟ‎=ﲰ‎=ﳧ\n"
u8"  ‎&سمج‎=ﵡ\n"
u8"  ‎&سمح‎=ﵟ‎=ﵠ\n"
u8"  ‎&سمم‎=ﵢ‎=ﵣ\n"
u8"  ‎&سه‎=ﳨ‎=ﴱ\n"
u8"  ‎&سى‎=ﳻ‎=ﴗ\n"
u8"  ‎&سي‎=ﳼ‎=ﴘ\n"
u8"  ‎&ش‎=ﺵ‎=ﺶ‎=ﺷ‎=ﺸ\n"
u8"  ‎&شج‎=ﴉ‎=ﴥ‎=ﴭ‎=ﴷ\n"
u8"  ‎&شجي‎=ﵩ\n"
u8"  ‎&شح‎=ﴊ‎=ﴦ‎=ﴮ‎=ﴸ\n"
u8"  ‎&شحم‎=ﵧ‎=ﵨ\n"
u8"  ‎&شحي‎=ﶪ\n"
u8"  ‎&شخ‎=ﴋ‎=ﴧ‎=ﴯ‎=ﴹ\n"
u8"  ‎&شر‎=ﴍ‎=ﴩ\n"
u8"  ‎&شم‎=ﳩ‎=ﴌ‎=ﴨ‎=ﴰ\n"
u8"  ‎&شمخ‎=ﵪ‎=ﵫ\n"
u8"  ‎&شمم‎=ﵬ‎=ﵭ\n"
u8"  ‎&شه‎=ﳪ‎=ﴲ\n"
u8"  ‎&شى‎=ﳽ‎=ﴙ\n"
u8"  ‎&شي‎=ﳾ‎=ﴚ\n"
u8"  ‎&ص‎=ﺹ‎=ﺺ‎=ﺻ‎=ﺼ\n"
u8"  ‎&صح‎=ﰠ‎=ﲱ\n"
u8"  ‎&صحح‎=ﵤ‎=ﵥ\n"
u8"  ‎&صحي‎=ﶩ\n"
u8"  ‎&صخ‎=ﲲ\n"
u8"  ‎&صر‎=ﴏ‎=ﴫ\n"
u8"  ‎&صلعم‎<<<ﷵ\n"
u8"  ‎&صلى‎<<<ﷹ\n"
u8"  ‎&'صلى الله عليه وسلم'‎<<<ﷺ\n"
u8"  ‎&صلے‎<<<ﷰ\n"
u8"  ‎&صم‎=ﰡ‎=ﲳ\n"
u8"  ‎&صمم‎=ﵦ‎=ﷅ\n"
u8"  ‎&صى‎=ﴅ‎=ﴡ\n"
u8"  ‎&صي‎=ﴆ‎=ﴢ\n"
u8"  ‎&ض‎=ﺽ‎=ﺾ‎=ﺿ‎=ﻀ\n"
u8"  ‎&ضج‎=ﰢ‎=ﲴ\n"
u8"  ‎&ضح‎=ﰣ‎=ﲵ\n"
u8"  ‎&ضحى‎=ﵮ\n"
u8"  ‎&ضحي‎=ﶫ\n"
u8"  ‎&ضخ‎=ﰤ‎=ﲶ\n"
u8"  ‎&ضخم‎=ﵯ‎=ﵰ\n"
u8"  ‎&ضر‎=ﴐ‎=ﴬ\n"
u8"  ‎&ضم‎=ﰥ‎=ﲷ\n"
u8"  ‎&ضى‎=ﴇ‎=ﴣ\n"
u8"  ‎&ضي‎=ﴈ‎=ﴤ\n"
u8"  ‎&ط‎=ﻁ‎=ﻂ‎=ﻃ‎=ﻄ\n"
u8"  ‎&طح‎=ﰦ‎=ﲸ\n"
u8"  ‎&طم‎=ﰧ‎=ﴳ‎=ﴺ\n"
u8"  ‎&طمح‎=ﵱ‎=ﵲ\n"
u8"  ‎&طمم‎=ﵳ\n"
u8"  ‎&طمي‎=ﵴ\n"
u8"  ‎&طى‎=ﳵ‎=ﴑ\n"
u8"  ‎&طي‎=ﳶ‎=ﴒ\n"
u8"  ‎&ظ‎=ﻅ‎=ﻆ‎=ﻇ‎=ﻈ\n"
u8"  ‎&ظم‎=ﰨ‎=ﲹ‎=ﴻ\n"
u8"  ‎&ع‎=ﻉ‎=ﻊ‎=ﻋ‎=ﻌ\n"
u8"  ‎&عج‎=ﰩ‎=ﲺ\n"
u8"  ‎&عجم‎=ﵵ‎=ﷄ\n"
u8"  ‎&عليه‎<<<ﷷ\n"
u8"  ‎&عم‎=ﰪ‎=ﲻ\n"
u8"  ‎&عمم‎=ﵶ‎=ﵷ\n"
u8"  ‎&عمى‎=ﵸ\n"
u8"  ‎&عمي‎=ﶶ\n"
u8"  ‎&عى‎=ﳷ‎=ﴓ\n"
u8"  ‎&عي‎=ﳸ‎=ﴔ\n"
u8"  ‎&غ‎=ﻍ‎=ﻎ‎=ﻏ‎=ﻐ\n"
u8"  ‎&غج‎=ﰫ‎=ﲼ\n"
u8"  ‎&غم‎=ﰬ‎=ﲽ\n"
u8"  ‎&غمم‎=ﵹ\n"
u8"  ‎&غمى‎=ﵻ\n"
u8"  ‎&غمي‎=ﵺ\n"
u8"  ‎&غى‎=ﳹ‎=ﴕ\n"
u8"  ‎&غي‎=ﳺ‎=ﴖ\n"
u8"  ‎&ـ\\u064B‎=ﹱ\n"
u8"  ‎&ـ\\u064E‎=ﹷ\n"
u8"  ‎&ـ\\u064E\\u0651‎=ﳲ\n"
u8"  ‎&ـ\\u064F‎=ﹹ\n"
u8"  ‎&ـ\\u064F\\u0651‎=ﳳ\n"
u8"  ‎&ـ\\u0650‎=ﹻ\n"
u8"  ‎&ـ\\u0650\\u0651‎=ﳴ\n"
u8"  ‎&ـ\\u0651‎=ﹽ\n"
u8"  ‎&ـ\\u0652‎=ﹿ\n"
u8"  ‎&ف‎=ﻑ‎=ﻒ‎=ﻓ‎=ﻔ\n"
u8"  ‎&فج‎=ﰭ‎=ﲾ\n"
u8"  ‎&فح‎=ﰮ‎=ﲿ\n"
u8"  ‎&فخ‎=ﰯ‎=ﳀ\n"
u8"  ‎&فخم‎=ﵼ‎=ﵽ\n"
u8"  ‎&فم‎=ﰰ‎=ﳁ\n"
u8"  ‎&فمي‎=ﷁ\n"
u8"  ‎&فى‎=ﰱ‎=ﱼ\n"
u8"  ‎&في‎=ﰲ‎=ﱽ\n"
u8"  ‎&ق‎=ﻕ‎=ﻖ‎=ﻗ‎=ﻘ\n"
u8"  ‎&قح‎=ﰳ‎=ﳂ\n"
u8"  ‎&قلے‎<<<ﷱ\n"
u8"  ‎&قم‎=ﰴ‎=ﳃ\n"
u8"  ‎&قمح‎=ﵾ‎=ﶴ\n"
u8"  ‎&قمم‎=ﵿ\n"
u8"  ‎&قمي‎=ﶲ\n"
u8"  ‎&قى‎=ﰵ‎=ﱾ\n"
u8"  ‎&قي‎=ﰶ‎=ﱿ\n"
u8"  ‎&ك‎=ﻙ‎=ﻚ‎=ﻛ‎=ﻜ\n"
u8"  ‎&كا‎=ﰷ‎=ﲀ\n"
u8"  ‎&كج‎=ﰸ‎=ﳄ\n"
u8"  ‎&كح‎=ﰹ‎=ﳅ\n"
u8"  ‎&كخ‎=ﰺ‎=ﳆ\n"
u8"  ‎&كل‎=ﰻ‎=ﲁ‎=ﳇ‎=ﳫ\n"
u8"  ‎&كم‎=ﰼ‎=ﲂ‎=ﳈ‎=ﳬ\n"
u8"  ‎&كمم‎=ﶻ‎=ﷃ\n"
u8"  ‎&كمي‎=ﶷ\n"
u8"  ‎&كى‎=ﰽ‎=ﲃ\n"
u8"  ‎&كي‎=ﰾ‎=ﲄ\n"
u8"  ‎&ل‎=ﻝ‎=ﻞ‎=ﻟ‎=ﻠ\n"
u8"  ‎&لا‎=ﻻ‎=ﻼ\n"
u8"  ‎&لآ‎=ﻵ‎=ﻶ\n"
u8"  ‎&لأ‎=ﻷ‎=ﻸ\n"
u8"  ‎&لإ‎=ﻹ‎=ﻺ\n"
u8"  ‎&لج‎=ﰿ‎=ﳉ\n"
u8"  ‎&لجج‎=ﶃ‎=ﶄ\n"
u8"  ‎&لجم‎=ﶺ‎=ﶼ\n"
u8"  ‎&لجي‎=ﶬ\n"
u8"  ‎&لح‎=ﱀ‎=ﳊ\n"
u8"  ‎&لحم‎=ﶀ‎=ﶵ\n"
u8"  ‎&لحى‎=ﶂ\n"
u8"  ‎&لحي‎=ﶁ\n"
u8"  ‎&لخ‎=ﱁ‎=ﳋ\n"
u8"  ‎&لخم‎=ﶅ‎=ﶆ\n"
u8"  ‎&لم‎=ﱂ‎=ﲅ‎=ﳌ‎=ﳭ\n"
u8"  ‎&لمح‎=ﶇ‎=ﶈ\n"
u8"  ‎&لمي‎=ﶭ\n"
u8"  ‎&له‎=ﳍ\n"
u8"  ‎&لى‎=ﱃ‎=ﲆ\n"
u8"  ‎&لي‎=ﱄ‎=ﲇ\n"
u8"  ‎&م‎=ﻡ‎=ﻢ‎=ﻣ‎=ﻤ\n"
u8"  ‎&ما‎=ﲈ\n"
u8"  ‎&مج‎=ﱅ‎=ﳎ\n"
u8"  ‎&مجح‎=ﶌ\n"
u8"  ‎&مجخ‎=ﶒ\n"
u8"  ‎&مجم‎=ﶍ\n"
u8"  ‎&مجي‎=ﷀ\n"
u8"  ‎&مح‎=ﱆ‎=ﳏ\n"
u8"  ‎&محج‎=ﶉ\n"
u8"  ‎&محم‎=ﶊ\n"
u8"  ‎&محمد‎<<<ﷴ\n"
u8"  ‎&محي‎=ﶋ\n"
u8"  ‎&مخ‎=ﱇ‎=ﳐ\n"
u8"  ‎&مخج‎=ﶎ\n"
u8"  ‎&مخم‎=ﶏ\n"
u8"  ‎&مخي‎=ﶹ\n"
u8"  ‎&مم‎=ﱈ‎=ﲉ‎=ﳑ\n"
u8"  ‎&ممي‎=ﶱ\n"
u8"  ‎&مى‎=ﱉ\n"
u8"  ‎&مي‎=ﱊ\n"
u8"  ‎&ن‎=ﻥ‎=ﻦ‎=ﻧ‎=ﻨ\n"
u8"  ‎&نج‎=ﱋ‎=ﳒ\n"
u8"  ‎&نجح‎=ﶸ‎=ﶽ\n"
u8"  ‎&نجم‎=ﶗ‎=ﶘ\n"
u8"  ‎&نجى‎=ﶙ\n"
u8"  ‎&نجي‎=ﷇ\n"
u8"  ‎&نح‎=ﱌ‎=ﳓ\n"
u8"  ‎&نحم‎=ﶕ\n"
u8"  ‎&نحى‎=ﶖ\n"
u8"  ‎&نحي‎=ﶳ\n"
u8"  ‎&نخ‎=ﱍ‎=ﳔ\n"
u8"  ‎&نر‎=ﲊ\n"
u8"  ‎&نز‎=ﲋ\n"
u8"  ‎&نم‎=ﱎ‎=ﲌ‎=ﳕ‎=ﳮ\n"
u8"  ‎&نمى‎=ﶛ\n"
u8"  ‎&نمي‎=ﶚ\n"
u8"  ‎&نن‎=ﲍ\n"
u8"  ‎&نه‎=ﳖ‎=ﳯ\n"
u8"  ‎&نى‎=ﱏ‎=ﲎ\n"
u8"  ‎&ني‎=ﱐ‎=ﲏ\n"
u8"  ‎&ه‎=ﻩ‎=ﻪ‎=ﻫ‎=ﻬ\n"
u8"  ‎&هج‎=ﱑ‎=ﳗ\n"
u8"  ‎&هم‎=ﱒ‎=ﳘ\n"
u8"  ‎&همج‎=ﶓ\n"
u8"  ‎&همم‎=ﶔ\n"
u8"  ‎&هى‎=ﱓ\n"
u8"  ‎&هي‎=ﱔ\n"
u8"  ‎&ه\\u0670‎=ﳙ\n"
u8"  ‎&و‎=ﻭ‎=ﻮ\n"
u8"  ‎&وسلم‎<<<ﷸ\n"
u8"  ‎&ؤ‎=ﺅ‎=ﺆ\n"
u8"  ‎&ى‎=ﯨ‎=ﯩ‎=ﻯ‎=ﻰ\n"
u8"  ‎&ى\\u0670‎=ﱝ‎=ﲐ\n"
u8"  ‎&ي‎=ﻱ‎=ﻲ‎=ﻳ‎=ﻴ\n"
u8"  ‎&يج‎=ﱕ‎=ﳚ\n"
u8"  ‎&يجي‎=ﶯ\n"
u8"  ‎&يح‎=ﱖ‎=ﳛ\n"
u8"  ‎&يحي‎=ﶮ\n"
u8"  ‎&يخ‎=ﱗ‎=ﳜ\n"
u8"  ‎&ير‎=ﲑ\n"
u8"  ‎&يز‎=ﲒ\n"
u8"  ‎&يم‎=ﱘ‎=ﲓ‎=ﳝ‎=ﳰ\n"
u8"  ‎&يمم‎=ﶜ‎=ﶝ\n"
u8"  ‎&يمي‎=ﶰ\n"
u8"  ‎&ين‎=ﲔ\n"
u8"  ‎&يه‎=ﳞ‎=ﳱ\n"
u8"  ‎&يى‎=ﱙ‎=ﲕ\n"
u8"  ‎&يي‎=ﱚ‎=ﲖ\n"
u8"  ‎&ئ‎=ﺉ‎=ﺊ‎=ﺋ‎=ﺌ\n"
u8"  ‎&ئا‎=ﯪ‎=ﯫ\n"
u8"  ‎&ئج‎=ﰀ‎=ﲗ\n"
u8"  ‎&ئح‎=ﰁ‎=ﲘ\n"
u8"  ‎&ئخ‎=ﲙ\n"
u8"  ‎&ئر‎=ﱤ\n"
u8"  ‎&ئز‎=ﱥ\n"
u8"  ‎&ئم‎=ﰂ‎=ﱦ‎=ﲚ‎=ﳟ\n"
u8"  ‎&ئن‎=ﱧ\n"
u8"  ‎&ئه‎=ﲛ‎=ﳠ\n"
u8"  ‎&ئو‎=ﯮ‎=ﯯ\n"
u8"  ‎&ئى‎=ﯹ‎=ﯺ‎=ﯻ‎=ﰃ‎=ﱨ\n"
u8"  ‎&ئي‎=ﰄ‎=ﱩ\n"
u8"  ‎&ئۆ‎=ﯲ‎=ﯳ\n"
u8"  ‎&ئۇ‎=ﯰ‎=ﯱ\n"
u8"  ‎&ئۈ‎=ﯴ‎=ﯵ\n"
u8"  ‎&ئې‎=ﯶ‎=ﯷ‎=ﯸ\n"
u8"  ‎&ئە‎=ﯬ‎=ﯭ\n"
u8"  ‎&\\u064B‎=ﹰ\n"
u8"  ‎&\\u064C‎=ﹲ\n"
u8"  ‎&\\u064C\\u0651‎=ﱞ\n"
u8"  ‎&\\u064D‎=ﹴ\n"
u8"  ‎&\\u064D\\u0651‎=ﱟ\n"
u8"  ‎&\\u064E‎=ﹶ\n"
u8"  ‎&\\u064E\\u0651‎=ﱠ\n"
u8"  ‎&\\u064F‎=ﹸ\n"
u8"  ‎&\\u064F\\u0651‎=ﱡ\n"
u8"  ‎&\\u0650‎=ﹺ\n"
u8"  ‎&\\u0650\\u0651‎=ﱢ\n"
u8"  ‎&\\u0651‎=ﹼ\n"
u8"  ‎&\\u0651\\u0670‎=ﱣ\n"
u8"  ‎&\\u0652‎=ﹾ\n"
u8"  ‎&ٱ‎=ﭐ‎=ﭑ\n"
u8"  ‎&ٹ‎=ﭦ‎=ﭧ‎=ﭨ‎=ﭩ\n"
u8"  ‎&ٺ‎=ﭞ‎=ﭟ‎=ﭠ‎=ﭡ\n"
u8"  ‎&ٻ‎=ﭒ‎=ﭓ‎=ﭔ‎=ﭕ\n"
u8"  ‎&پ‎=ﭖ‎=ﭗ‎=ﭘ‎=ﭙ\n"
u8"  ‎&ٿ‎=ﭢ‎=ﭣ‎=ﭤ‎=ﭥ\n"
u8"  ‎&ڀ‎=ﭚ‎=ﭛ‎=ﭜ‎=ﭝ\n"
u8"  ‎&ڃ‎=ﭶ‎=ﭷ‎=ﭸ‎=ﭹ\n"
u8"  ‎&ڄ‎=ﭲ‎=ﭳ‎=ﭴ‎=ﭵ\n"
u8"  ‎&چ‎=ﭺ‎=ﭻ‎=ﭼ‎=ﭽ\n"
u8"  ‎&ڇ‎=ﭾ‎=ﭿ‎=ﮀ‎=ﮁ\n"
u8"  ‎&ڈ‎=ﮈ‎=ﮉ\n"
u8"  ‎&ڌ‎=ﮄ‎=ﮅ\n"
u8"  ‎&ڍ‎=ﮂ‎=ﮃ\n"
u8"  ‎&ڎ‎=ﮆ‎=ﮇ\n"
u8"  ‎&ڑ‎=ﮌ‎=ﮍ\n"
u8"  ‎&ژ‎=ﮊ‎=ﮋ\n"
u8"  ‎&ڤ‎=ﭪ‎=ﭫ‎=ﭬ‎=ﭭ\n"
u8"  ‎&ڦ‎=ﭮ‎=ﭯ‎=ﭰ‎=ﭱ\n"
u8"  ‎&ک‎=ﮎ‎=ﮏ‎=ﮐ‎=ﮑ\n"
u8"  ‎&ڭ‎=ﯓ‎=ﯔ‎=ﯕ‎=ﯖ\n"
u8"  ‎&گ‎=ﮒ‎=ﮓ‎=ﮔ‎=ﮕ\n"
u8"  ‎&ڱ‎=ﮚ‎=ﮛ‎=ﮜ‎=ﮝ\n"
u8"  ‎&ڳ‎=ﮖ‎=ﮗ‎=ﮘ‎=ﮙ\n"
u8"  ‎&ں‎=ﮞ‎=ﮟ\n"
u8"  ‎&ڻ‎=ﮠ‎=ﮡ‎=ﮢ‎=ﮣ\n"
u8"  ‎&ھ‎=ﮪ‎=ﮫ‎=ﮬ‎=ﮭ\n"
u8"  ‎&ہ‎=ﮦ‎=ﮧ‎=ﮨ‎=ﮩ\n"
u8"  ‎&ۅ‎=ﯠ‎=ﯡ\n"
u8"  ‎&ۆ‎=ﯙ‎=ﯚ\n"
u8"  ‎&ۇ‎=ﯗ‎=ﯘ\n"
u8"  ‎&ۇٴ‎=ﯝ\n"
u8"  ‎&ۈ‎=ﯛ‎=ﯜ\n"
u8"  ‎&ۉ‎=ﯢ‎=ﯣ\n"
u8"  ‎&ۋ‎=ﯞ‎=ﯟ\n"
u8"  ‎&ی‎=ﯼ‎=ﯽ‎=ﯾ‎=ﯿ\n"
u8"  ‎&ې‎=ﯤ‎=ﯥ‎=ﯦ‎=ﯧ\n"
u8"  ‎&ے‎=ﮮ‎=ﮯ\n"
u8"  ‎&ۓ‎=ﮰ‎=ﮱ\n"
u8"  ‎&ۀ‎=ﮤ‎=ﮥ\n"
u8"  \n");
}


}}}}

#endif
