////////////////////////////////////////////////////////////////////////////////
/// DISCLAIMER
///
/// Copyright 2022 ArangoDB GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is ArangoDB GmbH, Cologne, Germany
///
/// @author Andrei Lobov
////////////////////////////////////////////////////////////////////////////////
#pragma once

#include <array>

// We must enforce UTF-8 "valid" output.
// By default ICU SortKey is just arbitrary bytes in range 0x00 - 0xFF
// so in general SortKey is not valid UTF-8 sequence.
// To achieve "validity" we split each byte in range 0x80 - 0xFF
// in two bytes UTF-8 character. We don't care about "sanity" of this
// UTF-8 string as SortKey was never intended to be human redable. And this
// split still leaves the binary sorting order of modified SortKeys

namespace {

// static array of offsets and lengths in kBytesRecalcMap
constexpr inline std::array<std::pair<uint16_t, uint8_t>, 256> kRecalcMap{
  {{0, 1},   {1, 1},   {2, 1},   {3, 1},   {4, 1},   {5, 1},   {6, 1},
   {7, 1},   {8, 1},   {9, 1},   {10, 1},  {11, 1},  {12, 1},  {13, 1},
   {14, 1},  {15, 1},  {16, 1},  {17, 1},  {18, 1},  {19, 1},  {20, 1},
   {21, 1},  {22, 1},  {23, 1},  {24, 1},  {25, 1},  {26, 1},  {27, 1},
   {28, 1},  {29, 1},  {30, 1},  {31, 1},  {32, 1},  {33, 1},  {34, 1},
   {35, 1},  {36, 1},  {37, 1},  {38, 1},  {39, 1},  {40, 1},  {41, 1},
   {42, 1},  {43, 1},  {44, 1},  {45, 1},  {46, 1},  {47, 1},  {48, 1},
   {49, 1},  {50, 1},  {51, 1},  {52, 1},  {53, 1},  {54, 1},  {55, 1},
   {56, 1},  {57, 1},  {58, 1},  {59, 1},  {60, 1},  {61, 1},  {62, 1},
   {63, 1},  {64, 1},  {65, 1},  {66, 1},  {67, 1},  {68, 1},  {69, 1},
   {70, 1},  {71, 1},  {72, 1},  {73, 1},  {74, 1},  {75, 1},  {76, 1},
   {77, 1},  {78, 1},  {79, 1},  {80, 1},  {81, 1},  {82, 1},  {83, 1},
   {84, 1},  {85, 1},  {86, 1},  {87, 1},  {88, 1},  {89, 1},  {90, 1},
   {91, 1},  {92, 1},  {93, 1},  {94, 1},  {95, 1},  {96, 1},  {97, 1},
   {98, 1},  {99, 1},  {100, 1}, {101, 1}, {102, 1}, {103, 1}, {104, 1},
   {105, 1}, {106, 1}, {107, 1}, {108, 1}, {109, 1}, {110, 1}, {111, 1},
   {112, 1}, {113, 1}, {114, 1}, {115, 1}, {116, 1}, {117, 1}, {118, 1},
   {119, 1}, {120, 1}, {121, 1}, {122, 1}, {123, 1}, {124, 1}, {125, 1},
   {126, 1}, {127, 1}, {128, 2}, {130, 2}, {132, 2}, {134, 2}, {136, 2},
   {138, 2}, {140, 2}, {142, 2}, {144, 2}, {146, 2}, {148, 2}, {150, 2},
   {152, 2}, {154, 2}, {156, 2}, {158, 2}, {160, 2}, {162, 2}, {164, 2},
   {166, 2}, {168, 2}, {170, 2}, {172, 2}, {174, 2}, {176, 2}, {178, 2},
   {180, 2}, {182, 2}, {184, 2}, {186, 2}, {188, 2}, {190, 2}, {192, 2},
   {194, 2}, {196, 2}, {198, 2}, {200, 2}, {202, 2}, {204, 2}, {206, 2},
   {208, 2}, {210, 2}, {212, 2}, {214, 2}, {216, 2}, {218, 2}, {220, 2},
   {222, 2}, {224, 2}, {226, 2}, {228, 2}, {230, 2}, {232, 2}, {234, 2},
   {236, 2}, {238, 2}, {240, 2}, {242, 2}, {244, 2}, {246, 2}, {248, 2},
   {250, 2}, {252, 2}, {254, 2}, {256, 2}, {258, 2}, {260, 2}, {262, 2},
   {264, 2}, {266, 2}, {268, 2}, {270, 2}, {272, 2}, {274, 2}, {276, 2},
   {278, 2}, {280, 2}, {282, 2}, {284, 2}, {286, 2}, {288, 2}, {290, 2},
   {292, 2}, {294, 2}, {296, 2}, {298, 2}, {300, 2}, {302, 2}, {304, 2},
   {306, 2}, {308, 2}, {310, 2}, {312, 2}, {314, 2}, {316, 2}, {318, 2},
   {320, 2}, {322, 2}, {324, 2}, {326, 2}, {328, 2}, {330, 2}, {332, 2},
   {334, 2}, {336, 2}, {338, 2}, {340, 2}, {342, 2}, {344, 2}, {346, 2},
   {348, 2}, {350, 2}, {352, 2}, {354, 2}, {356, 2}, {358, 2}, {360, 2},
   {362, 2}, {364, 2}, {366, 2}, {368, 2}, {370, 2}, {372, 2}, {374, 2},
   {376, 2}, {378, 2}, {380, 2}, {382, 2}}};

constexpr inline uint8_t kBytesRecalcMap[] = {
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c,
  0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
  0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26,
  0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33,
  0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
  0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d,
  0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a,
  0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
  0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74,
  0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0xd0, 0x80,
  0xd0, 0x81, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x86, 0xd0,
  0x87, 0xd1, 0x80, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x83, 0xd1, 0x84, 0xd1, 0x85,
  0xd1, 0x86, 0xd1, 0x87, 0xd2, 0x80, 0xd2, 0x81, 0xd2, 0x82, 0xd2, 0x83, 0xd2,
  0x84, 0xd2, 0x85, 0xd2, 0x86, 0xd2, 0x87, 0xd3, 0x80, 0xd3, 0x81, 0xd3, 0x82,
  0xd3, 0x83, 0xd3, 0x84, 0xd3, 0x85, 0xd3, 0x86, 0xd3, 0x87, 0xd4, 0x80, 0xd4,
  0x81, 0xd4, 0x82, 0xd4, 0x83, 0xd4, 0x84, 0xd4, 0x85, 0xd4, 0x86, 0xd4, 0x87,
  0xd5, 0x80, 0xd5, 0x81, 0xd5, 0x82, 0xd5, 0x83, 0xd5, 0x84, 0xd5, 0x85, 0xd5,
  0x86, 0xd5, 0x87, 0xd6, 0x80, 0xd6, 0x81, 0xd6, 0x82, 0xd6, 0x83, 0xd6, 0x84,
  0xd6, 0x85, 0xd6, 0x86, 0xd6, 0x87, 0xd7, 0x80, 0xd7, 0x81, 0xd7, 0x82, 0xd7,
  0x83, 0xd7, 0x84, 0xd7, 0x85, 0xd7, 0x86, 0xd7, 0x87, 0xd8, 0x80, 0xd8, 0x81,
  0xd8, 0x82, 0xd8, 0x83, 0xd8, 0x84, 0xd8, 0x85, 0xd8, 0x86, 0xd8, 0x87, 0xd9,
  0x80, 0xd9, 0x81, 0xd9, 0x82, 0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x86,
  0xd9, 0x87, 0xda, 0x80, 0xda, 0x81, 0xda, 0x82, 0xda, 0x83, 0xda, 0x84, 0xda,
  0x85, 0xda, 0x86, 0xda, 0x87, 0xdb, 0x80, 0xdb, 0x81, 0xdb, 0x82, 0xdb, 0x83,
  0xdb, 0x84, 0xdb, 0x85, 0xdb, 0x86, 0xdb, 0x87, 0xdc, 0x80, 0xdc, 0x81, 0xdc,
  0x82, 0xdc, 0x83, 0xdc, 0x84, 0xdc, 0x85, 0xdc, 0x86, 0xdc, 0x87, 0xdd, 0x80,
  0xdd, 0x81, 0xdd, 0x82, 0xdd, 0x83, 0xdd, 0x84, 0xdd, 0x85, 0xdd, 0x86, 0xdd,
  0x87, 0xde, 0x80, 0xde, 0x81, 0xde, 0x82, 0xde, 0x83, 0xde, 0x84, 0xde, 0x85,
  0xde, 0x86, 0xde, 0x87, 0xdf, 0x80, 0xdf, 0x81, 0xdf, 0x82, 0xdf, 0x83, 0xdf,
  0x84, 0xdf, 0x85, 0xdf, 0x86, 0xdf, 0x87};
}  // namespace
