# Official builds

The official builds of this app are generated by Github Actions

## Code signing

macOS and Windows builds are code signed, and require some [electron-builder environment variables](https://github.com/electron-userland/electron-builder/wiki/Code-Signing)
to be set.

These are encrypted using CI server tools.

### macOS

`CSC_LINK` is base64 encoded data of the .p12 file, e.g.

```
base64 -i cert.p12 -o cert.p12.b64
```

`CSC_KEY_PASSWORD` is the passphrase used to export the .p12 and can't be empty.

On macOS, the .p12 file is exported from Keychain Access. Make sure to expand the
Developer ID Application cert and select it along with its key before exporting.

Environment variables are encrypted repository secrets

### Windows

For windows we use Azure Key Vault and define credentials with the following env vars:

```
AZURE_KEY_VAULT_URL
AZURE_KEY_CLIENT_ID
AZURE_KEY_CLIENT_SECRET
AZURE_KEY_VAULT_CERTIFICATE
```

IMPORTANT: For local dev, put these in an env file in codesign and source it to avoid ever commiting secrets, e.g.
```
# codesign/codesign.env contents
export AZURE_KEY_VAULT_URL="blah..."
...

# source it when running local signed builds
. codesign/codesign.env
```

The signing procedure is scripted in scripts/sign.js

Our setup for key vault is as described here https://natemcmaster.com/blog/2018/07/02/code-signing/

The AzureSignTool can be installed with the following command after installing .NET Core SDK https://dotnet.microsoft.com/download

```
dotnet tool install --global AzureSignTool --version 2.0.17
```

Environment variables are encrypted repository secrets
