import { EMOTIONS_BODY } from '../../../types/types';

// This maps the full list of BehaviorCodes to EMOTIONS_BODY, the ones currently supported for
// Innequin's body expressions

export const InnequinBehaviorToBody: { [key: string]: EMOTIONS_BODY } = {
  NEUTRAL: EMOTIONS_BODY.NEUTRAL,
  DISGUST: EMOTIONS_BODY.ANGRY,
  CONTEMPT: EMOTIONS_BODY.ANGRY,
  BELLIGERENCE: EMOTIONS_BODY.ANGRY,
  DOMINEERING: EMOTIONS_BODY.ANGRY,
  CRITICISM: EMOTIONS_BODY.ANGRY,
  ANGER: EMOTIONS_BODY.ANGRY,
  TENSION: EMOTIONS_BODY.FEAR,
  TENSE_HUMOR: EMOTIONS_BODY.ANGRY,
  DEFENSIVENESS: EMOTIONS_BODY.FEAR,
  WHINING: EMOTIONS_BODY.SAD,
  SADNESS: EMOTIONS_BODY.SAD,
  STONEWALLING: EMOTIONS_BODY.NEUTRAL,
  INTEREST: EMOTIONS_BODY.HAPPY,
  VALIDATION: EMOTIONS_BODY.HAPPY,
  AFFECTION: EMOTIONS_BODY.HAPPY,
  HUMOR: EMOTIONS_BODY.HAPPY,
  SURPRISE: EMOTIONS_BODY.HAPPY,
  JOY: EMOTIONS_BODY.HAPPY,
};
