#!/bin/bash
#
# This file is part of ABCDK.
#  
# MIT License
#



# 以下代码来自于网友，启动基本的子系统，但未配置DNS解析。
# 
# 1：子系纺启动后，可以通过下面的方法安装或更新软件包。
# #apt update
# #apt install net-tools vim  
#
# 2：子系统启动后，可以编辑下面的文件配置DNS解析。
# #vim /etc/resolv.conf
# #echo "nameserver 8.8.8.8" >> /etc/resolv.conf
#


mnt() {
	echo "MOUNTING"
	sudo mount -t proc /proc ${2}proc
	sudo mount -t sysfs /sys ${2}sys
	sudo mount -o bind /dev ${2}dev
	sudo mount -o bind /dev/pts ${2}dev/pts
	sudo chroot ${2}
}
umnt() {
	echo "UNMOUNTING"
	sudo umount ${2}proc
	sudo umount ${2}sys
	sudo umount ${2}dev/pts
	sudo umount ${2}dev
}

if [ "$1" == "-m" ] && [ -n "$2" ] ;
then
	mnt $1 $2
elif [ "$1" == "-u" ] && [ -n "$2" ];
then
	umnt $1 $2
else
	echo ""
	echo "Either 1'st, 2'nd or both parameters were missing"
	echo ""
	echo "1'st parameter can be one of these: -m(mount) OR -u(umount)"
	echo "2'nd parameter is the full path of rootfs directory(with trailing '/')"
	echo ""
	echo "For example: ch-mount -m /media/sdcard/"
	echo ""
	echo 1st parameter : ${1}
	echo 2nd parameter : ${2}
fi

