# Contributing to Intentional

Intentional is still in its very early stages of development, so it's very unstable and major design decision can be made suddenly. If you're building an app on top of Intentional and you are worried about its stability, reach out to [me](mailto:github@zansara.dev) and let's talk about it first.

## Rules

### Open an issue

Before contributing, **[always open an issue](https://github.com/intentional-ai/intentional/issues/new)** before writing any code!

Make sure I am aware of what you're working on and that I am willing to include your changes **before** working on them. I am committed to reply to each issue promptly to let you know if it's worth working on a feature or not, but I also reserve the right to close unprompted PRs, however well-made, that for any reason don't match the current aim and design goals of the project.

### Code Reviews

I will only merge PRs after doing a code review.

### CI must be green

PRs with a failing CI check won't be merged. If CI is failing and you believe it's not your code's fault, tag me and I'll check what's wrong.

### Contributor License Agreement (CLA)

All contributors must sign a Contributor License Agreement (CLA). A GitHub bot will take care of making sure you sign it when you open your first PR.

You can review the content of the CLA [here](https://intentional-ai.github.io/intentional/docs/cla/).
