/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.wrappers;

import com.intellijava.core.model.BaseRemoteModel;
import com.intellijava.core.model.OpenaiChatResponse;
import com.intellijava.core.model.OpenaiImageResponse;
import com.intellijava.core.model.OpenaiLanguageResponse;
import com.intellijava.core.utils.Config2;
import com.intellijava.core.utils.ConnHelper;
import com.intellijava.core.wrappers.ImageModelInterface;
import com.intellijava.core.wrappers.LanguageModelInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class OpenAIWrapper
implements LanguageModelInterface,
ImageModelInterface {
    private final String API_BASE_URL = Config2.getInstance().getProperty("url.openai.base");
    private String API_KEY;

    public OpenAIWrapper(String apiKey) {
        this.API_KEY = apiKey;
    }

    @Override
    public BaseRemoteModel generateText(Map<String, Object> params) throws IOException {
        String url = this.API_BASE_URL + Config2.getInstance().getProperty("url.openai.completions");
        String json = ConnHelper.convertMaptToJson(params);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + this.API_KEY);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            String errorMessage = ConnHelper.getErrorMessage(connection);
            throw new IOException(errorMessage);
        }
        OpenaiLanguageResponse resModel = ConnHelper.convertSteamToModel(connection.getInputStream(), OpenaiLanguageResponse.class);
        return resModel;
    }

    public BaseRemoteModel generateChatText(Map<String, Object> params) throws IOException {
        String url = this.API_BASE_URL + Config2.getInstance().getProperty("url.openai.chatgpt");
        String json = ConnHelper.convertMaptToJson(params);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + this.API_KEY);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            String errorMessage = ConnHelper.getErrorMessage(connection);
            throw new IOException(errorMessage);
        }
        OpenaiChatResponse resModel = ConnHelper.convertSteamToModel(connection.getInputStream(), OpenaiChatResponse.class);
        return resModel;
    }

    @Override
    public BaseRemoteModel generateImages(Map<String, Object> params) throws IOException {
        String url = this.API_BASE_URL + Config2.getInstance().getProperty("url.openai.imagegenerate");
        String json = ConnHelper.convertMaptToJson(params);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + this.API_KEY);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            String errorMessage = ConnHelper.getErrorMessage(connection);
            throw new IOException(errorMessage);
        }
        OpenaiImageResponse resModel = ConnHelper.convertSteamToModel(connection.getInputStream(), OpenaiImageResponse.class);
        return resModel;
    }
}

