/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.wrappers;

import com.intellijava.core.model.BaseRemoteModel;
import com.intellijava.core.model.CohereLanguageResponse;
import com.intellijava.core.utils.Config2;
import com.intellijava.core.utils.ConnHelper;
import com.intellijava.core.wrappers.LanguageModelInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class CohereAIWrapper
implements LanguageModelInterface {
    private final String API_BASE_URL = Config2.getInstance().getProperty("url.cohere.base");
    private final String COHERE_VERSION = Config2.getInstance().getProperty("url.cohere.version");
    private String API_KEY;

    public CohereAIWrapper(String apiKey) {
        this.API_KEY = apiKey;
    }

    @Override
    public BaseRemoteModel generateText(Map<String, Object> params) throws IOException {
        String url = this.API_BASE_URL + Config2.getInstance().getProperty("url.cohere.completions");
        String json = ConnHelper.convertMaptToJson(params);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + this.API_KEY);
        connection.setRequestProperty("Cohere-Version", this.COHERE_VERSION);
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            String errorMessage = ConnHelper.getErrorMessage(connection);
            throw new IOException(errorMessage);
        }
        CohereLanguageResponse resModel = ConnHelper.convertSteamToModel(connection.getInputStream(), CohereLanguageResponse.class);
        return resModel;
    }
}

