/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.model.input;

public class Text2SpeechInput {
    private String text;
    private Gender gender;

    public Text2SpeechInput(String text, Gender gender) {
        this.text = text;
        this.gender = gender;
    }

    private Text2SpeechInput(Builder builder) {
        this.text = builder.text;
        this.gender = builder.gender;
    }

    public String getText() {
        return this.text;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static class Builder {
        private String text;
        private Gender gender = Gender.FEMALE;

        public Builder(String text) {
            this.text = text;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setGender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public Text2SpeechInput build() {
            return new Text2SpeechInput(this);
        }
    }
}

