/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.model.input;

public class LanguageModelInput {
    private String model;
    private String prompt;
    private float temperature;
    private int maxTokens;
    private int numberOfOutputs = 1;

    private LanguageModelInput(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
        this.numberOfOutputs = builder.numberOfOutputs;
    }

    public LanguageModelInput(String model, String prompt, float temperature, int maxTokens, int numberOfOutputs) {
        this.model = model;
        this.prompt = prompt;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.numberOfOutputs = numberOfOutputs;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public int getNumberOfOutputs() {
        return this.numberOfOutputs;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setNumberOfOutputs(int numberOfOutputs) {
        this.numberOfOutputs = numberOfOutputs;
    }

    public static class Builder {
        private String model;
        private String prompt;
        private float temperature;
        private int maxTokens;
        private int numberOfOutputs = 1;

        public Builder(String prompt) {
            this.prompt = prompt;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder setTemperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder setNumberOfOutputs(int numberOfOutputs) {
            if (this.numberOfOutputs < 0) {
                this.numberOfOutputs = 0;
            }
            this.numberOfOutputs = numberOfOutputs;
            return this;
        }

        public LanguageModelInput build() {
            return new LanguageModelInput(this);
        }
    }
}

