/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.model.input;

import com.intellijava.core.model.input.ChatGPTMessage;
import com.intellijava.core.model.input.ChatModelInput;
import java.util.ArrayList;
import java.util.List;

public class ChatGPTInput
extends ChatModelInput {
    private List<ChatGPTMessage> messages = new ArrayList<ChatGPTMessage>();
    private String model = "gpt-3.5-turbo";
    private float temperature = 1.0f;
    private int numberOfOutputs = 1;
    private int maxTokens;

    public ChatGPTInput(ChatGPTMessage systemMessage) {
        if (!systemMessage.isSystemRol()) {
            throw new IllegalArgumentException("The input type should be system to define the chatbot theme or instructions.");
        }
        this.messages.add(systemMessage);
    }

    public ChatGPTInput(String systemPrompt) {
        this.messages.add(new ChatGPTMessage(systemPrompt, ChatGPTMessage.Role.system));
    }

    private ChatGPTInput(Builder builder) {
        this.messages = builder.messages;
        this.temperature = builder.temperature;
        this.numberOfOutputs = builder.numberOfOutputs;
        this.maxTokens = builder.maxTokens;
        this.model = builder.model;
    }

    public void addMessage(ChatGPTMessage message) {
        this.messages.add(message);
    }

    public void addUserMessage(String prompt) {
        this.messages.add(new ChatGPTMessage(prompt, ChatGPTMessage.Role.user));
    }

    public void cleanMessages() {
        if (this.messages.size() > 1) {
            ChatGPTMessage firstMessage = this.messages.get(0);
            this.messages.clear();
            this.messages.add(firstMessage);
        }
    }

    public boolean deleteLastMessage(ChatGPTMessage message) {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            ChatGPTMessage currentMessage = this.messages.get(i);
            if (!currentMessage.getContent().equals(message.getContent()) || currentMessage.getRole() != message.getRole()) continue;
            this.messages.remove(i);
            return true;
        }
        return false;
    }

    public List<ChatGPTMessage> getMessages() {
        return this.messages;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public int getNumberOfOutputs() {
        return this.numberOfOutputs;
    }

    public void setNumberOfOutputs(int numberOfOutputs) {
        this.numberOfOutputs = numberOfOutputs;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public static class Builder {
        private List<ChatGPTMessage> messages = new ArrayList<ChatGPTMessage>();
        private String model = "gpt-3.5-turbo";
        private float temperature = 1.0f;
        private int numberOfOutputs = 1;
        private int maxTokens;

        public Builder(ChatGPTMessage systemMessage) {
            if (!systemMessage.isSystemRol()) {
                throw new IllegalArgumentException("The input type should be system to define the chatbot theme or instructions.");
            }
            this.messages.add(systemMessage);
        }

        public Builder(String systemPrompt) {
            this.messages.add(new ChatGPTMessage(systemPrompt, ChatGPTMessage.Role.system));
        }

        public Builder addMessage(ChatGPTMessage message) {
            this.messages.add(message);
            return this;
        }

        public Builder setTemperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setNumberOfOutputs(int numberOfOutputs) {
            this.numberOfOutputs = numberOfOutputs;
            return this;
        }

        public Builder setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder addUserMessage(String prompt) {
            this.messages.add(new ChatGPTMessage(prompt, ChatGPTMessage.Role.user));
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public ChatGPTInput build() {
            return new ChatGPTInput(this);
        }
    }
}

