/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.function;

import com.intellijava.core.model.OpenaiChatResponse;
import com.intellijava.core.model.SupportedChatModels;
import com.intellijava.core.model.input.ChatGPTInput;
import com.intellijava.core.model.input.ChatModelInput;
import com.intellijava.core.wrappers.OpenAIWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Chatbot {
    private SupportedChatModels keyType;
    private OpenAIWrapper openaiWrapper;

    public Chatbot(String keyValue, String keyTypeString) {
        List<String> supportedModels;
        if (keyTypeString.isEmpty()) {
            keyTypeString = SupportedChatModels.openai.toString();
        }
        if (!(supportedModels = this.getSupportedModels()).contains(keyTypeString)) {
            String models = String.join((CharSequence)" - ", supportedModels);
            throw new IllegalArgumentException("The received keyValue not supported. Send any model from: " + models);
        }
        this.initiate(keyValue, SupportedChatModels.valueOf(keyTypeString));
    }

    public Chatbot(String keyValue, SupportedChatModels keyType) {
        this.initiate(keyValue, keyType);
    }

    public List<String> getSupportedModels() {
        SupportedChatModels[] values = SupportedChatModels.values();
        ArrayList<String> enumValues = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            enumValues.add(values[i].name());
        }
        return enumValues;
    }

    private void initiate(String keyValue, SupportedChatModels keyType) {
        this.keyType = keyType;
        if (keyType.equals((Object)SupportedChatModels.openai)) {
            this.openaiWrapper = new OpenAIWrapper(keyValue);
        }
    }

    public List<String> chat(ChatModelInput modelInput) throws IOException {
        if (this.keyType.equals((Object)SupportedChatModels.openai)) {
            return this.chatGPT((ChatGPTInput)modelInput);
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    private List<String> chatGPT(ChatGPTInput modelInput) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", modelInput.getModel());
        params.put("messages", modelInput.getMessages());
        if (modelInput.getNumberOfOutputs() >= 0) {
            params.put("n", modelInput.getNumberOfOutputs());
        }
        if (modelInput.getTemperature() >= 0.0f) {
            params.put("temperature", Float.valueOf(modelInput.getTemperature()));
        }
        if (modelInput.getMaxTokens() >= 1) {
            params.put("max_tokens", modelInput.getMaxTokens());
        }
        OpenaiChatResponse resModel = (OpenaiChatResponse)this.openaiWrapper.generateChatText(params);
        ArrayList<String> outputs = new ArrayList<String>();
        for (OpenaiChatResponse.Choice item : resModel.getChoices()) {
            outputs.add(item.getMessage().getContent());
        }
        return outputs;
    }
}

