/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.controller;

import com.intellijava.core.model.AudioResponse;
import com.intellijava.core.model.SpeechModels;
import com.intellijava.core.model.input.Text2SpeechInput;
import com.intellijava.core.utils.AudioHelper;
import com.intellijava.core.wrappers.GoogleAIWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RemoteSpeechModel {
    private SpeechModels keyType;
    private GoogleAIWrapper wrapper;

    public RemoteSpeechModel(String keyValue, String keyTypeString) {
        List<String> supportedModels;
        if (keyTypeString.isEmpty()) {
            keyTypeString = SpeechModels.google.toString();
        }
        if (!(supportedModels = this.getSupportedModels()).contains(keyTypeString)) {
            String models = String.join((CharSequence)" - ", supportedModels);
            throw new IllegalArgumentException("The received keyValue not supported. Send any model from: " + models);
        }
        this.initiate(keyValue, SpeechModels.valueOf(keyTypeString));
    }

    public RemoteSpeechModel(String keyValue, SpeechModels keyType) {
        this.initiate(keyValue, keyType);
    }

    private void initiate(String keyValue, SpeechModels keyType) {
        this.keyType = keyType;
        this.wrapper = new GoogleAIWrapper(keyValue);
    }

    public List<String> getSupportedModels() {
        SpeechModels[] values = SpeechModels.values();
        ArrayList<String> enumValues = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            enumValues.add(values[i].name());
        }
        return enumValues;
    }

    public byte[] generateEnglishText(Text2SpeechInput input) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), "en-GB");
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    public byte[] generateMandarinText(Text2SpeechInput input) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), "cmn-CN");
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    public byte[] generateArabicText(Text2SpeechInput input) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), "ar-XA");
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    public byte[] generateTurkishText(Text2SpeechInput input) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), "tr-TR");
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    public byte[] generateText(Text2SpeechInput input, String langCode) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), langCode);
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    public byte[] generateGermanText(Text2SpeechInput input) throws IOException {
        if (this.keyType == SpeechModels.google) {
            return this.generateGoogleText(input.getText(), input.getGender(), "de-de");
        }
        throw new IllegalArgumentException("the keyType not supported");
    }

    private byte[] generateGoogleText(String text, Text2SpeechInput.Gender gender, String language) throws IOException {
        byte[] decodedAudio = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("text", text);
        params.put("languageCode", language);
        language = language.toLowerCase();
        if (language.equals("en-gb")) {
            if (gender == Text2SpeechInput.Gender.FEMALE) {
                params.put("name", "en-GB-Standard-A");
                params.put("ssmlGender", "FEMALE");
            } else {
                params.put("name", "en-GB-Standard-B");
                params.put("ssmlGender", "MALE");
            }
        } else if (language.equals("tr-tr")) {
            if (gender == Text2SpeechInput.Gender.FEMALE) {
                params.put("name", "tr-TR-Standard-A");
                params.put("ssmlGender", "FEMALE");
            } else {
                params.put("name", "tr-TR-Standard-B");
                params.put("ssmlGender", "MALE");
            }
        } else if (language.equals("cmn-cn")) {
            if (gender == Text2SpeechInput.Gender.FEMALE) {
                params.put("name", "cmn-CN-Standard-A");
                params.put("ssmlGender", "FEMALE");
            } else {
                params.put("name", "cmn-CN-Standard-B");
                params.put("ssmlGender", "MALE");
            }
        } else if (language.equals("de-de")) {
            if (gender == Text2SpeechInput.Gender.FEMALE) {
                params.put("name", "de-DE-Standard-A");
                params.put("ssmlGender", "FEMALE");
            } else {
                params.put("name", "de-DE-Standard-B");
                params.put("ssmlGender", "MALE");
            }
        } else if (language.equals("ar-xa")) {
            if (gender == Text2SpeechInput.Gender.FEMALE) {
                params.put("name", "ar-XA-Wavenet-A");
                params.put("ssmlGender", "FEMALE");
            } else {
                params.put("name", "ar-XA-Standard-B");
                params.put("ssmlGender", "MALE");
            }
        } else {
            throw new IllegalArgumentException("Unsupported language code: " + language);
        }
        AudioResponse resModel = (AudioResponse)this.wrapper.generateSpeech(params);
        decodedAudio = AudioHelper.decode(resModel.getAudioContent());
        return decodedAudio;
    }
}

