/*
 * Decompiled with CFR 0.152.
 */
package com.intellijava.core.controller;

import com.intellijava.core.model.OpenaiImageResponse;
import com.intellijava.core.model.SupportedImageModels;
import com.intellijava.core.model.input.ImageModelInput;
import com.intellijava.core.wrappers.OpenAIWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RemoteImageModel {
    private SupportedImageModels keyType;
    private OpenAIWrapper openaiWrapper;

    public RemoteImageModel(String keyValue, String keyTypeString) {
        List<String> supportedModels;
        if (keyTypeString.isEmpty()) {
            keyTypeString = SupportedImageModels.openai.toString();
        }
        if (!(supportedModels = this.getSupportedModels()).contains(keyTypeString)) {
            String models = String.join((CharSequence)" - ", supportedModels);
            throw new IllegalArgumentException("The received keyValue not supported. Send any model from: " + models);
        }
        this.initiate(keyValue, SupportedImageModels.valueOf(keyTypeString));
    }

    public RemoteImageModel(String keyValue, SupportedImageModels keyType) {
        this.initiate(keyValue, keyType);
    }

    public List<String> getSupportedModels() {
        SupportedImageModels[] values = SupportedImageModels.values();
        ArrayList<String> enumValues = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            enumValues.add(values[i].name());
        }
        return enumValues;
    }

    private void initiate(String keyValue, SupportedImageModels keyType) {
        this.keyType = keyType;
        if (keyType.equals((Object)SupportedImageModels.openai)) {
            this.openaiWrapper = new OpenAIWrapper(keyValue);
        }
    }

    public List<String> generateImages(ImageModelInput imageInput) throws IOException {
        if (this.keyType == SupportedImageModels.openai) {
            return this.generateOpenaiImage(imageInput.getPrompt(), imageInput.getNumberOfImages(), imageInput.getImageSize());
        }
        throw new IllegalArgumentException("This version support openai keyType only");
    }

    private List<String> generateOpenaiImage(String prompt, int numberOfImages, String imageSize) throws IOException {
        ArrayList<String> images = new ArrayList<String>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prompt", prompt);
        params.put("n", numberOfImages);
        params.put("size", imageSize);
        OpenaiImageResponse resModel = (OpenaiImageResponse)this.openaiWrapper.generateImages(params);
        List<OpenaiImageResponse.Data> responseImages = resModel.getData();
        for (OpenaiImageResponse.Data data : responseImages) {
            images.add(data.getUrl().toString());
        }
        return images;
    }
}

