import React from 'react';
import { useEnterOptions } from 'taro-hooks';

import DemoContent from '@src/components/DemoContent';
import { Cell } from '@taroify/core';

export default () => {
  const enterOptions = useEnterOptions();

  return (
    <DemoContent>
      {Object.keys(enterOptions).length ? (
        <Cell.Group clickable>
          {Object.entries(enterOptions).map(([key, value]) => (
            <Cell key={key} title={key}>
              {JSON.stringify(value)}
            </Cell>
          ))}
        </Cell.Group>
      ) : (
        <Cell>暂无信息</Cell>
      )}
    </DemoContent>
  );
};
