import React from 'react';
import { useToast } from 'taro-hooks';
import DemoContent from '@src/components/DemoContent';
import { Button } from '@taroify/core';

export default () => {
  const { show, hide } = useToast({ title: 'initial title' });

  const handleChangeOption = () => {
    show({
      icon: 'error',
      title: '点击隐藏按钮进行隐藏',
      duration: 3000000,
    });
  };

  return (
    <DemoContent>
      <Button
        block
        color="primary"
        className="gap"
        onClick={() => show()}
        shape="square"
      >
        展示带初始配置的Toast
      </Button>
      <Button
        block
        color="primary"
        className="gap"
        onClick={handleChangeOption}
        shape="square"
      >
        展示新配置的Toast
      </Button>
      <Button block color="primary" onClick={hide} shape="square">
        隐藏新配置的Toast
      </Button>
    </DemoContent>
  );
};
