﻿//
// GermanSpecialDayKey.cs
//
// Author: responsive kaysta
//
// Copyright (c) 2017 responsive kaysta
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

namespace PowerUpDateTimeUtils
{
    /// <summary>
    /// Aufzählung für die Schlüssel der speziellen deutschen Tage
    /// </summary>
    public enum GermanSpecialDayKey
    {
        /// <summary>
        /// The neujahr.
        /// </summary>
        Neujahr,
        /// <summary>
        /// The heilige drei könige.
        /// </summary>
        HeiligeDreiKönige,
        /// <summary>
        /// The valentinstag.
        /// </summary>
        Valentinstag,
        /// <summary>
        /// The maifeiertag.
        /// </summary>
        Maifeiertag,
        /// <summary>
        /// The maria himmelfahrt.
        /// </summary>
        MariaHimmelfahrt,
        /// <summary>
        /// The tag der deutschen einheit.
        /// </summary>
        TagDerDeutschenEinheit,
        /// <summary>
        /// The reformationstag.
        /// </summary>
        Reformationstag,
        /// <summary>
        /// The allerheiligen.
        /// </summary>
        Allerheiligen,
        /// <summary>
        /// The heiliger abend.
        /// </summary>
        HeiligerAbend,
        /// <summary>
        /// The erster weihnachtstag.
        /// </summary>
        ErsterWeihnachtstag,
        /// <summary>
        /// The zweiter weihnachtstag.
        /// </summary>
        ZweiterWeihnachtstag,
        /// <summary>
        /// The rosenmontag.
        /// </summary>
        Rosenmontag,
        /// <summary>
        /// The aschermittwoch.
        /// </summary>
        Aschermittwoch,
        /// <summary>
        /// The gründonnerstag.
        /// </summary>
        Gründonnerstag,
        /// <summary>
        /// The karfreitag.
        /// </summary>
        Karfreitag,
        /// <summary>
        /// The ostersonntag.
        /// </summary>
        Ostersonntag,
        /// <summary>
        /// The ostermontag.
        /// </summary>
        Ostermontag,
        /// <summary>
        /// The christi himmelfahrt.
        /// </summary>
        ChristiHimmelfahrt,
        /// <summary>
        /// The pfingstsonntag.
        /// </summary>
        Pfingstsonntag,
        /// <summary>
        /// The pfingstmontag.
        /// </summary>
        Pfingstmontag,
        /// <summary>
        /// The fronleichnam.
        /// </summary>
        Fronleichnam,
        /// <summary>
        /// The erster advent.
        /// </summary>
        ErsterAdvent,
        /// <summary>
        /// The zweiter advent.
        /// </summary>
        ZweiterAdvent,
        /// <summary>
        /// The dritter advent.
        /// </summary>
        DritterAdvent,
        /// <summary>
        /// The vierter advent.
        /// </summary>
        VierterAdvent,
        /// <summary>
        /// The totensonntag.
        /// </summary>
        Totensonntag,
        /// <summary>
        /// The buss und bettag.
        /// </summary>
        BussUndBettag
    }

}