import React from "react";
import { Link, withRouter } from "react-router-dom";

function Navigation(props) {
  return (
    <div className="navigation">
      <nav className="navbar navbar-expand navbar-dark bg-dark">
        <div className="container">
          <Link className="navbar-brand" to="/">
            Decentralized LoRa infrastructure using blockchain
          </Link>

          <div>
            <ul className="navbar-nav ml-auto">
              <li
                className={`nav-item  ${
                  props.location.pathname === "/" ? "active" : ""
                }`}
              >
                <Link className="nav-link" to="/">
                  Devices
                  <span className="sr-only">(current)</span>
                </Link>
              </li>
              <li
                className={`nav-item  ${
                  props.location.pathname === "/messages" ? "active" : ""
                }`}
              >
                <Link className="nav-link" to="/messages">
                  Messages
                </Link>
              </li>
              <li
                className={`nav-item  ${
                  props.location.pathname === "/down" ? "active" : ""
                }`}
              >
                <Link className="nav-link" to="/down">
                  Down
                </Link>
              </li>
            </ul>
          </div>
        </div>
      </nav>
    </div>
  );
}

export default withRouter(Navigation);
