﻿// Copyright (c) SDV Code Project. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

using System;

namespace SdvCode.Constraints
{
    public static class SuccessMessages
    {
        public const string SuccessfullyAddedUserInRole = "{0} is added in role \"{1}\" successfully.";

        public const string SuccessfullyAddedRole = "Success added \"{0}\" role.";

        public const string SuccessfullyRemoveActionByName = "Successfully removed all \"{0}\" actions.";

        public const string SuccessfullyRemoveAllActions = "Successfully removed all users actions ({0} users actions).";

        public const string SuccessfullyRemoveUserImages = "Successfully removed {0} profile and cover images.";

        public const string SuccessfullyRemoveAllUsersImages = "Successfully removed all users images ({0} users images).";

        public const string SuccessfullySyncFollowUnfollow = "Successfully synchronize Follow-Unfollow relations.";

        public const string SuccessfullyConfirmedPhoneNumberAndRegisteredContributorRole =
            "Successfully confirmed phone number. You are added in \"{0}\" role.";

        public const string SuccessfullyBlockedUser = "Successfully blocked user {0}.";

        public const string SuccessfullyUnblockedUser = "Successfully unblocked user {0}.";

        public const string SuccessfullyBlockedAllUsers = "Successfully blocked all users ({0} users) - except Administrators.";

        public const string SuccessfullyUnblockedAllUsers = "Successfully unblocked all users ({0} users).";

        public const string SuccessfullyRemoveUserRole = "User {0} was successfully removed from \"{1}\" role.";

        public const string SuccessfullyFollowedUser = "You successfully follow {0}.";

        public const string SuccessfullyUnfollowedUser = "You successfully unfollow {0}.";

        public const string SuccessfullyDeleteAllActivity = "You successfully delete all of your activity.";

        public const string SuccessfullyDeletedActivityById = "You successfully delete your single \"{0}\" activity.";

        public const string SuccessfullyConfirmedPhoneNumberInContributorRole =
            "Successfully confirmed phone number. You are already in \"{0}\" role.";

        public const string SuccessfullyAddedCategory = "Successfully added \"{0}\" category.";

        public const string SuccessfullyAddedTag = "Successfully added \"{0}\" tag.";

        public const string SuccessfullyCreatedPost = "Successfully created a new post.";

        public const string SuccessfullyLikePost = "You successfully like post.";

        public const string SuccessfullyUnlikePost = "You successfully unlike post.";

        public const string SuccessfullyDeletePost = "You successfully delete the post";

        public const string SuccessfullyEditedPost = "You successfully edit your blog post.";

        public const string SuccessfullyEditCategory = "You successfully edit \"{0}\" category.";

        public const string SuccessfullyAddedToFavorite = "You successfully added the post to your favorite list.";

        public const string SuccessfullyRemoveFromFavorite = "You successfully remove the post from your favorite list.";

        public const string SuccessfullyApprovedBlogPost = "You successfully approved the blog post.";

        public const string SuccessfullyBannedBlogPost = "You successfully banned the blog post.";

        public const string SuccessfullyUnannedBlogPost = "You successfully unbanned the blog post.";

        public const string SuccessfullyAddedPostComment = "You successfully posted a new blog post comment.";

        public const string SuccessfullyDeletePostComment = "You successfully delete the blog post comment.";

        public const string SuccessfullyApprovedComment = "You successfully approved the blog post comment.";

        public const string SuccessfullyRemovedTag = "Successfully removed \"{0}\" tag.";

        public const string SuccessfullyEditedComment = "You successfully edit blog post comment";

        public const string SuccessfullyAddedProductCategory = "\"{0}\" category was successfully created.";

        public const string SuccessfullyAddedProduct = "\"{0}\" product was successfully created.";

        public const string SuccessfullyEditedProduct = "You successfully edit shop product";

        public const string SuccessfullyEditedProductCategory = "You successfully edit shop product category.";

        public const string SuccessfullySubmitedContactForm = "{0}, your message has been sent. Be patient you will receive a reply within 1 day.";

        public const string SuccessfullyAddedEmoji = "You successfully add \"{0}\" emoji.";

        public const string SuccessfullyEditedEmoji = "You successfully edit \"{0}\" emoji.";

        public const string SuccessfullyDeleteEmoji = "Successfully delete \"{0}\" emoji.";

        public const string SuccessfullyEditEmojisPosition = "Successfully edit \"{0}\" emojis positions.";

        public const string SuccessfullyAddedChatTheme = "Successfully add \"{0}\" chat theme.";

        public const string SuccessfullyDeleteChatTheme = "Successfully delete \"{0}\" chat theme.";

        public const string SuccessfullyEditChatTheme = "Successfully edit \"{0}\" chat theme.";

        public const string SuccessfullyAddedEmojis =
            "Successfully add \"{0}\" emojis, \"{1}\" of them already exist.";

        public const string SuccessfullyAddedEmojiWithSkins =
            "Successfully add \"{0}\" emoji with \"{1}\" skins.";

        public const string SuccessfullyDeletedEmojisByType =
            "Successfully delete \"{0}\" emojis of type \"{1}\".";

        public const string SuccessfullyAddedStickerType = "Successfully add \"{0}\" sticker type.";

        public const string SuccessfullyAddedSticker = "Successfully add \"{0}\" sticker.";

        public const string SuccessfullyEditChatStickerType = "Successfully edit \"{0}\" chat sticker type.";

        public const string SuccessfullyEditChatSticker = "Successfully edit \"{0}\" chat sticker.";

        public const string SuccessfullyDeleteChatSticker = "Successfully delete \"{0}\" chat sticker.";
        public const string SuccessfullyDeleteChatStickerType =
            "Successfully delete \"{0}\" chat sticker type with \"{1}\" stickers.";

        public const string SuccessfullyAddedStickers =
            "Successfully add \"{0}\" stickers, \"{1}\" of them already exist.";

        public const string SuccessfullyAddedHolidayTheme = "Successfully add \"{0}\" holiday theme.";

        public const string SuccessfullyEditHolidayThemeStatus =
            "Successfully change \"{0}\" holiday theme status to \"{1}\"";

        public const string SuccessfullyDeleteHolidayTheme = "Successfully delete \"{0}\" holiday theme.";
    }
}