﻿// Copyright (c) SDV Code Project. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

namespace SdvCode.Constraints
{
    public static class GlobalConstants
    {
        public const string NotificationsArea = "UserNotifications";

        public const string ShopArea = "SdvShop";

        public const string PrivateChatArea = "PrivateChat";

        public const string AdministratorRole = "Administrator";

        public const string AdministrationArea = "Administration";

        public const string EditorArea = "Editor";

        public const string EditorRole = "Editor";

        public const string AuthorRole = "Author";

        public const string ContributorRole = "Contributor";

        public const string SubscriberRole = "Subscriber";

        public const string CloudinaryUserProfilePictureName = "{0}ProfilePicture";

        public const string CloudinaryUserCoverImageName = "{0}CoverPicture";

        public const int UsersCountOnPage = 3;

        public const int UsersActivitiesCountOnPage = 6;

        public const int FollowersCountOnPage = 1;

        public const int FollowingCountOnPage = 1;

        public const int CollectStickersOnPage = 6;

        public const string CloudinaryPostCoverImageName = "{0}_PostCoverImage";

        public const string CloudinaryPostImageName = "{0}_PostImage";

        public const int PasswordRequiredLength = 7;

        public const int BlogPostsOnPage = 4;

        public const int BlogCategoriesOnPage = 4;

        public const int FavoritesCountOnPage = 6;

        public const int BannedPostsCountOnPage = 6;

        public const int PendingPostsCountOnPage = 6;

        public const int SavedChatMessagesCount = 200;

        public const string NoAvatarImageLocation = "/images/NoAvatarProfileImage.png";

        public const string ChatGroupNameSeparator = "->";

        public const string NoCoverImageLocation = "/images/userProfileCityBackgroundImage.jpg";

        public const string ProductImageName = "{0}ProductImage{1}";

        public const int ProductCommentsOnPage = 4;

        public const int PaginationRadius = 4;

        public const int ReviewsOnPage = 4;

        public const int FavoriteProductsOnPage = 9;

        public const int LatestLayoutPostsCount = 9;

        public const int NotificationOnClick = 5;

        public const int MaxChatNotificationsPerUser = 4;

        public const string ChatThemeName = "{0}-ChatTheme";

        public const string EmojiName = "{0}-ChatEmoji";

        public const string EmojiSkin = "{0}-ChatEmojiSkin";

        public const string ChatThemesFolderName = "Private Chat Themes";

        public const string EmojisFolder = "Emojis";

        public const string PostBaseImageFolder = "Blog Posts/Wallpapers";

        public const string UserProfilePicturesFolder = "Users Pictures/{0}";

        public const string ShopProductsFolder = "Shop Products";

        public const string PostBaseImagesFolder = "Blog Posts/Post Images";

        public const string BlogPostImageNameTemplate = "Blog Post Image {0}";

        public const string ChatFileName = "{0}-PrivateChatFile";

        public const string PrivateChatImagesFolder = "Private Chat Files";

        public const string StickerTypeName = "{0}-StickerType";

        public const string StickerTypeFolder = "Stickers Types";

        public const string StickerName = "{0}-StickerName";

        public const string StickersFolder = "Private Chat Stickers";

        public const string HolidayIconName = "{0}-Holiday Theme Icon";

        public const string HolidayThemesFolder = "Holiday Theme Icon";

        public const int MessagesCountPerScroll = 10;

        public const int RoldeDescriptionMaxLength = 250;

        public const int RecentCommentsCount = 35;

        public const int RecentPostsCount = 20;

        public const int TopCategoriesCount = 10;

        public const int TopPostsCount = 10;

        public const int TopTagsCount = 10;

        public const int BlogPostShortContentMaxLength = 347;
    }
}