## :eyeglasses: Project Introduction

**SDV Code Website** is my defense project for **ASP.NET Core MVC** course at [SoftUni](https://softuni.bg/ "SoftUni") (February-April 2020). The website is part of a major **"SDV PROJECT"** project, and it consists of 2 parts (**SdvCode** and **SdvFitness**). Each of two parts have an online **store which is a Single Page Application (SPA)**.

## &copy; SdvCode&trade; Logo
![](https://res.cloudinary.com/dvlw1ehpa/image/upload/v1605256646/SDV_Logo_fkpahd.png)

## :pencil2: Overview

**SDV Code** is a website where software engineers can share their experience, give advices one to other. The site has one on one private chat where they can discuss privately. In the private chat users have a possibility to change their chat themes, write messages, use emojis which are images and also have the chance to upload images and send them one to another at real-time. The main idea is to improve and sort all of the information in the internet in one place, the website has Editor and Administrators, they will follow for uncorrectly information and some kind of spamming content. Users which are rude and don't respect the site rules will be blocked for some days or permenantly.

**SDV CodeShop** is for saleing any kind of softaware gadgets. Only Administators will have chance to add a new products, not authrized and authorized people will have chance to order, comment and gave reviews to all products.

## :hammer: Built With
- ASP.NET [CORE 3.1](https://dotnet.microsoft.com/download/dotnet-core/3.1 "CORE 3.1") MVC
- Server-Side [Blazor](https://dotnet.microsoft.com/apps/aspnet/web-apps/blazor "Blazor")
- Comunication between Blazor components based on EventHandlers("click", "drag", ...)
- Blazored.SessionStorage
- Blazored.LocalStorage
- ASP.NET CORE view components
- ASP.NET Core areas
- Customize Data Field Validation in the Data Model Using Custom Attributes
- MSSQL full text searching
- MSSQL Server
- ML.NET
- SignalR
- Real-time notification based on SignalR connection
- Real-time user status(online-offline) based on SignalR connection
- [HangFire](https://www.hangfire.io/ "HangFire")
- Easy migration to Blazor on a WebAssembly
- [X.PagedList.Mvc](https://www.nuget.org/packages/X.PagedList.Mvc/ "X.PagedList.Mvc")
- [BlazorStrap](https://blazorstrap.io/ "BlazorStrap")
- EPPlus for exportd data reports in Excel files
- SendGrid
- Cloudinary
- TinyMCE
- Twilio SMS
- CodePen resources
- Bootstrap
- SVG
- AJAX real-time Requests
- jQuery and any kind of jQuery plugins ([DataTables](https://datatables.net/ "DataTables"))
- JavaScript and JS animations
- Facebook for developers
- Twitter for developers
- Google+ for developers
- Moq

## :wrench: DB Diagram
![](https://res.cloudinary.com/dvlw1ehpa/image/upload/v1608847967/Diagram_jnhxvz.png)

## :dash: Road To
- WebRTC vide chat
- Integrate MasterCard and any kind of payment methods
- Work on shop section(logic, user access, Fron-End....)
- Host the product(of course, when done, we don't do bullshits :grinning:)