/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.Version;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import picocli.CommandLine;

@CommandLine.Command(name="pdftoimage", header={"Converts a PDF document to image(s)"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class PDFToImage
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-password"}, description={"the password to decrypt the document"}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-format"}, description={"the image file format (default: ${DEFAULT-VALUE})"})
    private String imageFormat = "jpg";
    @CommandLine.Option(names={"-prefix", "-outputPrefix"}, description={"the filename prefix for image files"})
    private String outputPrefix;
    @CommandLine.Option(names={"-page"}, description={"the only page to extract (1-based)"})
    private int page = -1;
    @CommandLine.Option(names={"-startPage"}, description={"the first page to start extraction (1-based)"})
    private int startPage = 1;
    @CommandLine.Option(names={"-endPage"}, description={"the last page to extract (inclusive)"})
    private int endPage = Integer.MAX_VALUE;
    @CommandLine.Option(names={"-color"}, description={"the color depth (valid: ${COMPLETION-CANDIDATES}) (default: ${DEFAULT-VALUE})"})
    private ImageType imageType = ImageType.RGB;
    @CommandLine.Option(names={"-dpi", "-resolution"}, description={"the DPI of the output image, default: screen resolution or 96 if unknown"})
    private int dpi;
    @CommandLine.Option(names={"-quality"}, description={"the quality to be used when compressing the image (0 <= quality <= 1) (default: 0 for PNG and 1 for the other formats)"})
    private float quality = -1.0f;
    @CommandLine.Option(names={"-cropbox"}, arity="4", description={"the page area to export"})
    private int[] cropbox;
    @CommandLine.Option(names={"-time"}, description={"print timing information to stdout"})
    private boolean showTime;
    @CommandLine.Option(names={"-subsampling"}, description={"activate subsampling (for PDFs with huge images)"})
    private boolean subsampling;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF files to convert."}, required=true)
    private File infile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new PDFToImage()).execute(args);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        if (this.outputPrefix == null) {
            this.outputPrefix = FilenameUtils.removeExtension(this.infile.getAbsolutePath());
        }
        if (PDFToImage.getImageFormats().indexOf(this.imageFormat) == -1) {
            SYSERR.println("Error: Invalid image format " + this.imageFormat + " - supported are: " + PDFToImage.getImageFormats());
            return 2;
        }
        if (this.quality < 0.0f) {
            float f = this.quality = "png".equals(this.imageFormat) ? 0.0f : 1.0f;
        }
        if (this.dpi == 0) {
            try {
                this.dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException e) {
                this.dpi = 96;
            }
        }
        try (PDDocument document = Loader.loadPDF(this.infile, this.password);){
            String fileName;
            BufferedImage image;
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            if (acroForm != null && acroForm.getNeedAppearances()) {
                acroForm.refreshAppearances();
            }
            if (this.cropbox != null) {
                PDFToImage.changeCropBox(document, this.cropbox[0], this.cropbox[1], this.cropbox[2], this.cropbox[3]);
            }
            long startTime = System.nanoTime();
            boolean success = true;
            this.endPage = Math.min(this.endPage, document.getNumberOfPages());
            PDFRenderer renderer = new PDFRenderer(document);
            renderer.setSubsamplingAllowed(this.subsampling);
            for (int i = this.startPage - 1; i < this.endPage; success &= ImageIOUtil.writeImage(image, fileName, this.dpi, this.quality), ++i) {
                image = renderer.renderImageWithDPI(i, this.dpi, this.imageType);
                fileName = this.outputPrefix + "-" + (i + 1) + "." + this.imageFormat;
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            int count = 1 + this.endPage - this.startPage;
            if (this.showTime) {
                SYSERR.printf("Rendered %d page%s in %dms%n", count, count == 1 ? "" : "s", duration / 1000000L);
            }
            if (success) return 0;
            SYSERR.println("Error: no writer found for image format '" + this.imageFormat + "'");
            Integer n = 1;
            return n;
        }
        catch (IOException ioe) {
            SYSERR.println("Error converting document [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
    }

    private static String getImageFormats() {
        StringBuilder retval = new StringBuilder();
        String[] formats = ImageIO.getWriterFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equalsIgnoreCase(formats[i])) continue;
            retval.append(formats[i]);
            if (i + 1 >= formats.length) continue;
            retval.append(", ");
        }
        return retval.toString();
    }

    private static void changeCropBox(PDDocument document, float a, float b, float c, float d) {
        for (PDPage page : document.getPages()) {
            PDRectangle rectangle = new PDRectangle();
            rectangle.setLowerLeftX(a);
            rectangle.setLowerLeftY(b);
            rectangle.setUpperRightX(c);
            rectangle.setUpperRightY(d);
            page.setCropBox(rectangle);
        }
    }
}

