/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;

final class GlyphCache {
    private static final Log LOG = LogFactory.getLog(GlyphCache.class);
    private final PDVectorFont font;
    private final Map<Integer, GeneralPath> cache = new HashMap<Integer, GeneralPath>();

    GlyphCache(PDVectorFont font) {
        this.font = font;
    }

    public GeneralPath getPathForCharacterCode(int code) {
        GeneralPath path = this.cache.get(code);
        if (path != null) {
            return path;
        }
        try {
            if (!this.font.hasGlyph(code)) {
                String fontName = ((PDFontLike)((Object)this.font)).getName();
                if (this.font instanceof PDType0Font) {
                    int cid = ((PDType0Font)this.font).codeToCID(code);
                    String cidHex = String.format("%04x", cid);
                    LOG.warn("No glyph for code " + code + " (CID " + cidHex + ") in font " + fontName);
                } else if (this.font instanceof PDSimpleFont) {
                    LOG.warn("No glyph for code " + code + " in " + this.font.getClass().getSimpleName() + " " + fontName + " (embedded or system font used: " + ((PDSimpleFont)((Object)this.font)).getFontBoxFont().getName() + ")");
                    PDSimpleFont simpleFont = (PDSimpleFont)((Object)this.font);
                    if (code == 10 && simpleFont.isStandard14()) {
                        path = new GeneralPath();
                        this.cache.put(code, path);
                        return path;
                    }
                } else {
                    LOG.warn("No glyph for code " + code + " in font " + fontName);
                }
            }
            path = this.font.getNormalizedPath(code);
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            String fontName = ((PDFontLike)((Object)this.font)).getName();
            LOG.error("Glyph rendering failed for code " + code + " in font " + fontName, e);
            return new GeneralPath();
        }
    }
}

