/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.SettingsManager;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class Main
extends JPanel {
    private static SettingsManager SETTINGS_MGR;
    private static final int FRAME_WIDTH = 725;
    private static final int FRAME_HEIGHT = 485;
    private static JFrame APP_FRAME;
    private final JButton JBTN_CHOOSE_FILE = new JButton("\ud83d\udcc2 Choose File");
    private final JButton JBTN_RESET_ALL = new JButton("\ue14a Reset All");
    private final JButton JBTN_RUN = new JButton("Run \u226b");
    private JFileChooser SELECT_FILE_CHOOSER;
    private JFileChooser SAVE_FILE_CHOOSER;
    private final FileNameExtensionFilter PDF_FILE_FILTER = new FileNameExtensionFilter("Pdf file (*.pdf)", "pdf");
    private final FileNameExtensionFilter ZIP_FILE_FILTER = new FileNameExtensionFilter("ZIP File (*.zip)", "zip");
    private final JLabel PAGE_COUNT_CAPTION = new JLabel("\ue132 Page Count:");
    private final JLabel NO_OF_PAGES_DISPLAY = new JLabel("\ud835\udff6");
    private final JLabel FILENAME_CAPTION = new JLabel("\ue1a5 File Name:");
    private final JLabel FILENAME_DISPLAY = new JLabel("-");
    private String destinationFileName = null;
    private ZipOutputStream zipos = null;
    private InputStream fontStream = null;
    private File outputZipArchive = null;
    private ByteArrayOutputStream bos = null;
    private ZipEntry zipEntry = null;
    private File selectedFile = null;
    private String outputFilepath = null;
    private final JTextField JTEXT_FIELD_FILEPATH;
    private String absPath = null;
    private JLabel thumbnail = null;
    private ImageIcon imgIcon = null;
    private static final HashMap<String, Boolean> FONTNAME_MAPPER;
    private static final JLabel TITLE_DISPLAY;
    private static final JLabel SUBTITLE_DISPLAY;
    private final HashMap<String, String> UPLOAD_DOC_DETAILS = new HashMap();
    private final String[] MONOSPACE_DIGITS = new String[]{"\ud835\udff6", "\ud835\udff7", "\ud835\udff8", "\ud835\udff9", "\ud835\udffa", "\ud835\udffb", "\ud835\udffc", "\ud835\udffd", "\ud835\udffe", "\ud835\udfff"};

    public Main() {
        JButton[] mainButtonsArr;
        JTextField[] tfs;
        this.add(this.FILENAME_CAPTION);
        this.add(this.FILENAME_DISPLAY);
        this.FILENAME_CAPTION.setFont(SETTINGS_MGR.getBoldFont(12));
        this.FILENAME_DISPLAY.setFont(SETTINGS_MGR.getPlainFont(12));
        this.add(this.PAGE_COUNT_CAPTION);
        this.add(this.NO_OF_PAGES_DISPLAY);
        this.PAGE_COUNT_CAPTION.setFont(SETTINGS_MGR.getBoldFont(12));
        this.NO_OF_PAGES_DISPLAY.setFont(SETTINGS_MGR.getPlainFont(15));
        this.FILENAME_DISPLAY.setHorizontalTextPosition(2);
        this.FILENAME_DISPLAY.setHorizontalAlignment(2);
        this.NO_OF_PAGES_DISPLAY.setHorizontalTextPosition(2);
        this.NO_OF_PAGES_DISPLAY.setHorizontalAlignment(2);
        this.thumbnail = new JLabel();
        this.thumbnail.setIcon(null);
        this.thumbnail.setHorizontalTextPosition(0);
        this.thumbnail.setHorizontalAlignment(0);
        this.thumbnail.setVerticalTextPosition(0);
        this.thumbnail.setVerticalAlignment(0);
        this.thumbnail.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\ue11a\ud835\uddaf\ud835\uddcb\ud835\uddbe\ud835\uddcf\ud835\uddc2\ud835\uddbe\ud835\uddd0 \ud835\uddb4\ud835\uddc9\ud835\uddc5\ud835\uddc8\ud835\uddba\ud835\uddbd", 1, 2));
        this.add(this.thumbnail);
        TITLE_DISPLAY.setFont(SETTINGS_MGR.getPlainFont(20));
        SUBTITLE_DISPLAY.setFont(SETTINGS_MGR.getPlainFont(12));
        this.add(TITLE_DISPLAY);
        this.add(SUBTITLE_DISPLAY);
        this.JTEXT_FIELD_FILEPATH = new JTextField("");
        this.JTEXT_FIELD_FILEPATH.setEditable(false);
        this.JTEXT_FIELD_FILEPATH.setEnabled(false);
        this.add(this.JTEXT_FIELD_FILEPATH);
        for (JTextField tf : tfs = new JTextField[]{this.JTEXT_FIELD_FILEPATH}) {
            tf.setFont(SETTINGS_MGR.getPlainFont(12));
            tf.setForeground(SETTINGS_MGR.getWhiteColor());
            tf.setDisabledTextColor(SETTINGS_MGR.getGrayColor());
        }
        for (JButton iconButton : mainButtonsArr = new JButton[]{this.JBTN_CHOOSE_FILE, this.JBTN_RESET_ALL, this.JBTN_RUN}) {
            iconButton.setCursor(SETTINGS_MGR.getPointerCursor());
            iconButton.setHorizontalAlignment(0);
            iconButton.setHorizontalTextPosition(0);
            iconButton.setVerticalTextPosition(0);
            iconButton.setHorizontalAlignment(0);
            this.add(iconButton);
        }
        this.JBTN_RUN.setEnabled(false);
        int btnHeight = 30;
        int btnWidth = 130;
        int gapBetweenBtn = 5;
        int topmostVerticalMargin = 10;
        int startBottomBtnXPos = 20;
        int mainPanelWidth = 255;
        int mainPanelHeight = 430;
        int verticalGapBetweenButtonsAndForm = 10;
        TITLE_DISPLAY.setBounds(startBottomBtnXPos + 2, topmostVerticalMargin + 2, 3 * btnWidth + 2 * gapBetweenBtn + (mainPanelWidth - btnWidth), btnHeight + verticalGapBetweenButtonsAndForm);
        SUBTITLE_DISPLAY.setBounds(startBottomBtnXPos + 2, topmostVerticalMargin + 2 + btnHeight + verticalGapBetweenButtonsAndForm, 3 * btnWidth + 2 * gapBetweenBtn + (mainPanelWidth - btnWidth), btnHeight);
        this.JBTN_CHOOSE_FILE.setBounds(startBottomBtnXPos + 2, topmostVerticalMargin + 2 + btnHeight + verticalGapBetweenButtonsAndForm + verticalGapBetweenButtonsAndForm + btnHeight, btnWidth, btnHeight);
        this.JTEXT_FIELD_FILEPATH.setBounds(startBottomBtnXPos + btnWidth + 3 * gapBetweenBtn, topmostVerticalMargin + 2 + btnHeight + verticalGapBetweenButtonsAndForm + verticalGapBetweenButtonsAndForm + btnHeight, 3 * btnWidth + 2 * gapBetweenBtn + (mainPanelWidth - btnWidth), btnHeight);
        this.FILENAME_CAPTION.setBounds(startBottomBtnXPos + 2 + 2 * btnWidth + 2 * gapBetweenBtn, topmostVerticalMargin + 2 + 3 * verticalGapBetweenButtonsAndForm + 3 * btnHeight, btnWidth - 30, btnHeight);
        this.FILENAME_DISPLAY.setBounds(startBottomBtnXPos + 2 + 2 * btnWidth + 2 * gapBetweenBtn + btnWidth + gapBetweenBtn - 30, topmostVerticalMargin + 2 + 3 * verticalGapBetweenButtonsAndForm + 3 * btnHeight, btnWidth + btnWidth, btnHeight);
        this.PAGE_COUNT_CAPTION.setBounds(startBottomBtnXPos + 2 + 2 * btnWidth + 2 * gapBetweenBtn, topmostVerticalMargin + 2 + 3 * verticalGapBetweenButtonsAndForm + 3 * btnHeight, btnWidth - 30, btnHeight + btnHeight + verticalGapBetweenButtonsAndForm);
        this.NO_OF_PAGES_DISPLAY.setBounds(startBottomBtnXPos + 2 + 2 * btnWidth + 2 * gapBetweenBtn + btnWidth + gapBetweenBtn - 30, topmostVerticalMargin + 2 + 3 * verticalGapBetweenButtonsAndForm + 3 * btnHeight, btnWidth + btnWidth, btnHeight + btnHeight + verticalGapBetweenButtonsAndForm);
        this.thumbnail.setBounds(startBottomBtnXPos + 2, topmostVerticalMargin + 2 + 3 * verticalGapBetweenButtonsAndForm + 3 * btnHeight, 2 * btnWidth + 2 * gapBetweenBtn, 8 * btnHeight + 6 * verticalGapBetweenButtonsAndForm);
        this.JBTN_RUN.setBounds(startBottomBtnXPos + 255 + 4 * gapBetweenBtn + btnWidth, topmostVerticalMargin + mainPanelHeight - btnHeight - 2, btnWidth, btnHeight);
        this.JBTN_RESET_ALL.setBounds(startBottomBtnXPos + 255 + 3 * gapBetweenBtn + 2 * (gapBetweenBtn + btnWidth), topmostVerticalMargin + mainPanelHeight - btnHeight - 2, btnWidth, btnHeight);
        this.setPreferredSize(new Dimension(725, 485));
        this.setLayout(null);
        this.JBTN_CHOOSE_FILE.addActionListener(evt -> this.chooseFileAction());
        this.JBTN_RESET_ALL.addActionListener(evt -> this.resetAllAction());
        this.JBTN_RUN.addActionListener(evt -> this.extractEmbeddedFontsAction());
    }

    private String convertToMonospace(String str) {
        String[] strArr;
        String monospaceStr = "";
        for (String c : strArr = str.split("")) {
            monospaceStr = monospaceStr + this.MONOSPACE_DIGITS[Integer.parseInt(c)];
        }
        return monospaceStr;
    }

    private void chooseFileAction() {
        SwingWorker<Boolean, HashMap<String, String>> worker = new SwingWorker<Boolean, HashMap<String, String>>(){

            @Override
            protected Boolean doInBackground() throws IOException {
                Main.this.selectedFile = null;
                PDDocument document = null;
                FONTNAME_MAPPER.clear();
                Main.this.UPLOAD_DOC_DETAILS.clear();
                Main.this.SELECT_FILE_CHOOSER = new JFileChooser();
                Main.this.SELECT_FILE_CHOOSER.setCurrentDirectory(SETTINGS_MGR.getDefaultDir());
                Main.this.SELECT_FILE_CHOOSER.setDialogTitle("Choose");
                Main.this.SELECT_FILE_CHOOSER.setMultiSelectionEnabled(false);
                Main.this.SELECT_FILE_CHOOSER.setAcceptAllFileFilterUsed(false);
                Main.this.SELECT_FILE_CHOOSER.addChoosableFileFilter(Main.this.PDF_FILE_FILTER);
                int result = Main.this.SELECT_FILE_CHOOSER.showOpenDialog(APP_FRAME);
                if (result == 0) {
                    Main.this.selectedFile = Main.this.SELECT_FILE_CHOOSER.getSelectedFile();
                    Main.this.absPath = Main.this.selectedFile.getAbsolutePath();
                    document = Loader.loadPDF(Main.this.selectedFile);
                    int noOfPages = document.getNumberOfPages();
                    Main.this.UPLOAD_DOC_DETAILS.put("name", Main.this.selectedFile.getName());
                    Main.this.UPLOAD_DOC_DETAILS.put("pages", noOfPages + "");
                    this.publish(Main.this.UPLOAD_DOC_DETAILS);
                    Splitter splitter = new Splitter();
                    PDDocument indexPage = splitter.split(document).get(0);
                    Main.this.imgIcon = Main.this.getThumbnailIcon(indexPage);
                    return true;
                }
                return false;
            }

            @Override
            protected void done() {
                try {
                    boolean status = (Boolean)this.get();
                    if (status) {
                        Main.this.JTEXT_FIELD_FILEPATH.setText(Main.this.absPath);
                        Main.this.JTEXT_FIELD_FILEPATH.setToolTipText(Main.this.absPath);
                        SETTINGS_MGR.setDefaultDir(Main.this.SELECT_FILE_CHOOSER.getCurrentDirectory());
                        String message = "\ue10b \ud835\udde8\ud835\udde3\ud835\udddf\ud835\udde2\ud835\uddd4\ud835\uddd7 \ud835\udde6\ud835\udde8\ud835\uddd6\ud835\uddd6\ud835\uddd8\ud835\udde6\ud835\udde6\u2757\n\ue0c2\n\ud835\uddaf\ud835\uddcb\ud835\uddc8\ud835\uddbc\ud835\uddbe\ud835\uddcc\ud835\uddcc \ud835\uddc2\ud835\uddcc \ud835\uddc8\ud835\uddc7 \ud835\uddcc\ud835\uddcd\ud835\uddba\ud835\uddc7\ud835\uddbd\ud835\uddbb\ud835\uddd2 \ud835\uddba\ud835\uddc7\ud835\uddbd \ud835\uddcb\ud835\uddbe\ud835\uddba\ud835\uddbd\ud835\uddd2 \ud835\uddcd\ud835\uddc8 \ud835\uddcb\ud835\uddce\ud835\uddc7.\n";
                        JOptionPane.showMessageDialog(APP_FRAME, message, "\ue132 PDF Data Input Status", -1);
                        Main.this.JBTN_RUN.setEnabled(true);
                        Main.this.thumbnail.setIcon(Main.this.imgIcon);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void process(List<HashMap<String, String>> chunks) {
                HashMap<String, String> mostRecentValue = chunks.get(chunks.size() - 1);
                String filename = mostRecentValue.get("name");
                Main.this.FILENAME_DISPLAY.setText(filename);
                Main.this.FILENAME_DISPLAY.setToolTipText(filename);
                String pages = mostRecentValue.get("pages");
                int pageCount = Integer.parseInt(pages);
                Main.this.NO_OF_PAGES_DISPLAY.setText(Main.this.convertToMonospace(pageCount + ""));
                Main.this.thumbnail.setIcon(Main.this.imgIcon);
            }
        };
        worker.execute();
    }

    private void extractEmbeddedFontsAction() {
        SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){

            @Override
            protected Boolean doInBackground() throws IOException {
                Main.this.destinationFileName = null;
                Main.this.zipos = null;
                Main.this.fontStream = null;
                Main.this.outputZipArchive = null;
                Main.this.bos = null;
                Main.this.zipEntry = null;
                Main.this.destinationFileName = Main.this.getCurrentTimeStamp() + "_extractedFonts.zip";
                Main.this.bos = new ByteArrayOutputStream();
                Main.this.zipos = new ZipOutputStream(Main.this.bos);
                PDDocument document = Loader.loadPDF(Main.this.selectedFile);
                for (PDPage page : document.getPages()) {
                    PDResources resources = page.getResources();
                    Main.this.processResources(resources);
                }
                if (Main.this.zipos != null) {
                    Main.this.zipos.close();
                }
                Main.this.SAVE_FILE_CHOOSER = new JFileChooser();
                Main.this.SAVE_FILE_CHOOSER.setDialogType(1);
                Main.this.SAVE_FILE_CHOOSER.setCurrentDirectory(SETTINGS_MGR.getDefaultDir());
                Main.this.SAVE_FILE_CHOOSER.setDialogTitle("Save");
                Main.this.SAVE_FILE_CHOOSER.setMultiSelectionEnabled(false);
                Main.this.SAVE_FILE_CHOOSER.setAcceptAllFileFilterUsed(false);
                Main.this.SAVE_FILE_CHOOSER.addChoosableFileFilter(Main.this.ZIP_FILE_FILTER);
                Main.this.SAVE_FILE_CHOOSER.setSelectedFile(new File(Main.this.destinationFileName));
                int option = Main.this.SAVE_FILE_CHOOSER.showSaveDialog(APP_FRAME);
                if (option == 0) {
                    Main.this.outputZipArchive = Main.this.SAVE_FILE_CHOOSER.getSelectedFile();
                    return true;
                }
                return false;
            }

            @Override
            protected void done() {
                try {
                    boolean status = (Boolean)this.get();
                    if (status) {
                        SETTINGS_MGR.setDefaultDir(Main.this.SAVE_FILE_CHOOSER.getCurrentDirectory());
                        Main.this.outputFilepath = Main.this.outputZipArchive.getAbsolutePath();
                        if (Main.this.bos != null) {
                            int read;
                            File resultFile = null;
                            FileOutputStream fos = null;
                            ByteArrayInputStream is = new ByteArrayInputStream(Main.this.bos.toByteArray());
                            resultFile = new File(Main.this.outputFilepath);
                            fos = new FileOutputStream(resultFile);
                            byte[] bytes = new byte[1024];
                            while ((read = is.read(bytes)) != -1) {
                                fos.write(bytes, 0, read);
                            }
                            fos.close();
                            System.out.println("Output has been saved at: " + Main.this.outputFilepath);
                            Desktop.getDesktop().open(Main.this.outputZipArchive);
                        }
                    } else {
                        System.out.println("Cancellation/Error.");
                    }
                }
                catch (IOException | InterruptedException | ExecutionException ex) {
                    ex.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        try {
            SETTINGS_MGR = new SettingsManager();
            UIManager.setLookAndFeel(new FlatLightLaf());
            UIManager.put("Component.arrowType", "triangle");
            UIManager.put("ScrollBar.showButtons", true);
            UIManager.put("ScrollPane.foreground", SETTINGS_MGR.getGrayDarkColor());
            UIManager.put("ScrollPane.font", SETTINGS_MGR.getPlainFont(12));
            UIManager.put("ScrollPane.border", SETTINGS_MGR.getPanelPaddingBorder());
            UIManager.put("Button.foreground", SETTINGS_MGR.getGrayDarkColor());
            UIManager.put("Button.font", SETTINGS_MGR.getPlainFont(12));
            UIManager.put("Button.arc", 5);
            UIManager.put("Label.foreground", SETTINGS_MGR.getDarkColor());
            UIManager.put("Label.font", SETTINGS_MGR.getBoldFont(12));
            UIManager.put("OptionPane.foreground", SETTINGS_MGR.getGrayDarkColor());
            UIManager.put("OptionPane.messageFont", SETTINGS_MGR.getPlainFont(12));
            UIManager.put("TextField.foreground", SETTINGS_MGR.getGrayDarkColor());
            UIManager.put("TextField.caretForeground", SETTINGS_MGR.getLightColor());
            UIManager.put("Spinner.buttonArrowColor", SETTINGS_MGR.getGrayDarkColor());
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> {
            APP_FRAME = new JFrame(" PDF Fonts Extractor ");
            APP_FRAME.setDefaultCloseOperation(3);
            APP_FRAME.setSize(725, 485);
            APP_FRAME.getRootPane().putClientProperty("JRootPane.titleBarBackground", SETTINGS_MGR.getLightColor());
            APP_FRAME.getRootPane().putClientProperty("JRootPane.titleBarForeground", SETTINGS_MGR.getGrayDarkColor());
            try {
                byte[] fileBytes = Base64.getDecoder().decode(SETTINGS_MGR.getAppIconURI());
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(fileBytes));
                ImageIcon imgIcon = new ImageIcon(img);
                APP_FRAME.setIconImage(imgIcon.getImage());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Container appContentPane = APP_FRAME.getContentPane();
            appContentPane.add(new Main());
            APP_FRAME.setResizable(false);
            APP_FRAME.setLocationRelativeTo(null);
            APP_FRAME.setVisible(true);
        });
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_hhmmss");
        Date date = new Date();
        String timestamp = sdf.format(date);
        return timestamp;
    }

    private ImageIcon getThumbnailIcon(PDDocument document) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        BufferedImage tempPageImg = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
        ImageIcon tempPageImgIcon = new ImageIcon(tempPageImg);
        ImageIcon tempScaledPageImgIcon = this.getScaledImageIcon(tempPageImgIcon, 250, 250);
        return tempScaledPageImgIcon;
    }

    private ImageIcon getScaledImageIcon(ImageIcon imgIcon, int maxImgWidth, int maxImgHeight) {
        ImageIcon icon = null;
        try {
            int iconWidth = imgIcon.getIconWidth();
            int iconHeight = imgIcon.getIconHeight();
            Image tmpImage = imgIcon.getImage();
            BufferedImage bImg = new BufferedImage(iconWidth, iconHeight, 1);
            bImg.getGraphics().drawImage(tmpImage, 0, 0, null);
            tmpImage.flush();
            int iconLength = iconWidth;
            int maxImgLength = maxImgWidth;
            if (iconHeight > iconWidth) {
                iconLength = iconHeight;
                maxImgLength = maxImgHeight;
            }
            double ratio = (double)maxImgLength * 1.0 / ((double)iconLength * 1.0);
            long newWidth = Math.round(ratio * (double)iconWidth);
            long newHeight = Math.round(ratio * (double)iconHeight);
            Image outputImg = bImg.getScaledInstance((int)newWidth, (int)newHeight, 4);
            icon = new ImageIcon(outputImg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return icon;
    }

    private void processResources(PDResources resources) throws IOException {
        if (resources == null) {
            return;
        }
        for (COSName key : resources.getFontNames()) {
            int len;
            PDCIDFont descendantFont;
            PDFontDescriptor fd = null;
            String name = null;
            PDFont font = resources.getFont(key);
            if (font instanceof PDTrueTypeFont) {
                fd = font.getFontDescriptor();
                name = font.getName();
            } else if (font instanceof PDType0Font && (descendantFont = ((PDType0Font)font).getDescendantFont()) instanceof PDCIDFontType2) {
                fd = descendantFont.getFontDescriptor();
                name = font.getName();
            }
            if (fd == null) continue;
            String fontFilename = name + ".ttf";
            PDStream ff2Stream = fd.getFontFile2();
            if (ff2Stream == null || FONTNAME_MAPPER.containsKey(fontFilename)) continue;
            byte[] buffer = ff2Stream.toByteArray();
            this.fontStream = new ByteArrayInputStream(buffer);
            this.zipEntry = new ZipEntry(fontFilename);
            this.zipos.putNextEntry(this.zipEntry);
            byte[] bytes = new byte[1024];
            while ((len = this.fontStream.read(bytes)) >= 0) {
                this.zipos.write(bytes, 0, len);
            }
            this.zipos.closeEntry();
            FONTNAME_MAPPER.put(fontFilename, true);
        }
        for (COSName name : resources.getXObjectNames()) {
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject)) continue;
            PDFormXObject xObjectForm = (PDFormXObject)xobject;
            PDResources formResources = xObjectForm.getResources();
            this.processResources(formResources);
        }
    }

    private void resetAllAction() {
        SwingWorker<Boolean, String> worker = new SwingWorker<Boolean, String>(){

            @Override
            protected Boolean doInBackground() {
                Main.this.destinationFileName = null;
                Main.this.zipos = null;
                Main.this.fontStream = null;
                Main.this.outputZipArchive = null;
                Main.this.bos = null;
                Main.this.absPath = null;
                Main.this.zipEntry = null;
                FONTNAME_MAPPER.clear();
                Main.this.UPLOAD_DOC_DETAILS.clear();
                return true;
            }

            @Override
            protected void done() {
                try {
                    boolean status = (Boolean)this.get();
                    if (status) {
                        Main.this.NO_OF_PAGES_DISPLAY.setText("\ud835\udff6");
                        Main.this.FILENAME_DISPLAY.setText("-");
                        Main.this.FILENAME_DISPLAY.setToolTipText("");
                        Main.this.JBTN_RUN.setEnabled(false);
                        Main.this.thumbnail.setIcon(null);
                        Main.this.JTEXT_FIELD_FILEPATH.setText("");
                        Main.this.JTEXT_FIELD_FILEPATH.setToolTipText("");
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    ex.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    static {
        FONTNAME_MAPPER = new HashMap();
        TITLE_DISPLAY = new JLabel("\ud835\ude74\ud835\udea1\ud835\ude9d\ud835\ude9b\ud835\ude8a\ud835\ude8c\ud835\ude9d\ud835\ude9c \ud835\ude74\ud835\ude96\ud835\ude8b\ud835\ude8e\ud835\ude8d\ud835\ude8d\ud835\ude8e\ud835\ude8d \ud835\ude75\ud835\ude98\ud835\ude97\ud835\ude9d\ud835\ude9c \ud835\ude75\ud835\ude9b\ud835\ude98\ud835\ude96 \ue160 \ud835\ude7f\ud835\ude73\ud835\ude75");
        SUBTITLE_DISPLAY = new JLabel("\ue2c0 \ud835\ude81\ud835\ude8e\ud835\ude9d\ud835\ude9e\ud835\ude9b\ud835\ude97\ud835\ude9c \ud835\ude8a\ud835\ude95\ud835\ude95 \ud835\ude8f\ud835\ude98\ud835\ude97\ud835\ude9d \ud835\ude8f\ud835\ude92\ud835\ude95\ud835\ude8e\ud835\ude9c (.\ud835\ude9d\ud835\ude9d\ud835\ude8f) \ud835\ude92\ud835\ude97 \ud835\ude8a  \ue197 \ud835\ude89\ud835\ude78\ud835\ude7f \ud835\ude8a\ud835\ude9b\ud835\ude8c\ud835\ude91\ud835\ude92\ud835\ude9f\ud835\ude8e (.\ud835\udea3\ud835\ude92\ud835\ude99)");
    }
}

