; This file is a part of the IncludeOS unikernel - www.includeos.org
;
; Copyright 2015 Oslo and Akershus University College of Applied Sciences
; and Alfred Bratterud
;
; Licensed under the Apache License, Version 2.0 (the "License");
; you may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
;     http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
USE32
global unused_interrupt_handler:function
global modern_interrupt_handler:function
global cpu_sampling_irq_entry:function
global blocking_cycle_irq_entry:function

extern current_eoi_mechanism
extern current_intr_handler
extern cpu_sampling_irq_handler
extern blocking_cycle_irq_handler

unused_interrupt_handler:
  cli
  pusha
  call DWORD [current_eoi_mechanism]
  popa
  sti
  iret

modern_interrupt_handler:
  cli
  pusha
  call DWORD [current_intr_handler]
  popa
  sti
  iret

cpu_sampling_irq_entry:
  cli
  pusha
  call cpu_sampling_irq_handler
  call DWORD [current_eoi_mechanism]
  popa
  sti
  iret

blocking_cycle_irq_entry:
  cli
  pusha
  call blocking_cycle_irq_handler
  call DWORD [current_eoi_mechanism]
  popa
  sti
  iret
