#include <stddef.h>
#include <stdint.h>
#include "hanastd.hpp"
#include "asmfunc.hpp"
#include "task.hpp"
#include "graphics.hpp"
#include "fifo.hpp"
#include "heap.hpp"
#include "apps.hpp"
#include "apps_api.hpp"
#include "dwm.hpp"
using namespace hanastd;

#define NYAN_WIDTH 34
#define NYAN_HEIGHT 21
#define NYAN_SCALE 8
#define OTHER_EDGE 8
#define TOP_EDGE 32
#define FRAME_INTERVAL 10

const uint32_t nyan_platte[8]={
	0,0xff000000,0xffffcc99,0xffff99ff,0xffff3399,0xff999999,0xffffffff,0xffff9999
};

const char nyan_frames[12][21*34]={
{0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,1,3,3,4,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,3,2,1,1,5,5,1,0,0,
0,1,1,1,1,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,1,5,5,1,1,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
0,1,1,5,5,1,1,1,2,3,3,3,4,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,1,1,5,5,1,1,2,3,3,3,3,3,3,3,4,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,0,1,1,1,1,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,0,1,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,0,1,5,5,1,1,0,1,5,5,1,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,
0,0,0,0,0,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,1,1,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,1,5,5,1,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,1,5,5,1,1,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,1,5,5,5,5,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,0,0,1,1,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,
0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,0,0,0,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,0,1,1,1,1,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,1,1,5,5,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,1,5,5,5,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,0,1,1,1,1,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,0,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,
0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,0,1,5,5,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,1,5,5,1,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,1,5,5,1,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,1,1,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,
0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,1,3,3,4,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,3,2,1,1,5,5,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,1,1,1,1,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
1,5,5,5,1,1,1,1,2,3,3,3,4,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
1,1,5,5,5,5,1,1,2,3,3,3,3,3,3,3,4,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,1,1,1,1,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,1,1,2,2,2,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,1,1,3,3,3,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,4,3,3,2,1,1,5,5,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,0,1,1,0,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
0,1,5,5,1,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,1,5,5,1,1,1,1,2,3,3,3,4,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,1,5,5,5,5,1,2,3,3,3,3,3,3,3,4,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,0,1,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,0,1,5,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,0,0,0,0,0,0,
0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,1,3,3,4,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,3,2,1,1,5,5,1,0,0,
0,1,1,1,1,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,1,5,5,1,1,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
0,1,1,5,5,1,1,1,2,3,3,3,4,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,1,1,5,5,1,1,2,3,3,3,3,3,3,3,4,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,0,1,1,1,1,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,0,1,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,0,1,5,5,1,1,0,1,5,5,1,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,
0,0,0,0,0,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,1,1,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,1,5,5,1,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,1,5,5,1,1,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,1,5,5,5,5,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,0,0,1,1,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,
0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,0,0,0,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,0,1,1,1,1,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,1,1,5,5,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,1,5,5,5,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,0,1,1,1,1,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,0,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,
0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,1,1,3,4,3,3,2,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,2,1,0,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,3,1,5,5,5,1,3,3,2,1,1,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,4,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,4,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,
0,0,1,5,5,5,5,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,
0,1,5,5,1,1,1,1,2,3,3,3,3,3,4,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,
0,1,5,5,1,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,
0,0,1,1,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,0,0,0,0,0,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,
0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,1,1,3,3,4,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,3,3,3,2,1,1,5,5,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,1,1,1,1,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
1,5,5,5,1,1,1,1,2,3,3,3,4,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
1,1,5,5,5,5,1,1,2,3,3,3,3,3,3,3,4,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,1,1,1,1,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,1,1,2,2,2,3,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0
},{
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,4,3,3,4,3,3,3,3,3,2,2,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,1,1,3,3,3,3,3,2,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,1,3,4,3,3,2,1,1,5,5,1,0,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,1,3,3,3,2,1,5,5,5,1,0,0,
0,0,1,1,0,0,0,1,2,3,3,3,3,3,3,4,3,3,1,5,5,5,5,1,1,1,1,5,5,5,5,1,0,0,
0,1,5,5,1,0,0,1,2,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,
0,1,5,5,1,1,1,1,2,3,3,3,4,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,
0,0,1,5,5,5,5,1,2,3,3,3,3,3,3,3,4,1,5,5,5,6,1,5,5,5,5,5,6,1,5,5,1,0,
0,0,0,1,1,5,5,1,2,3,4,3,3,3,3,3,3,1,5,5,5,1,1,5,5,5,1,5,1,1,5,5,1,0,
0,0,0,0,0,1,1,1,2,3,3,3,3,3,3,3,3,1,5,7,7,5,5,5,5,5,5,5,5,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,3,3,3,3,3,4,3,3,1,5,7,7,5,1,5,5,1,5,5,1,5,7,7,1,0,
0,0,0,0,0,0,0,1,2,2,3,4,3,3,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,5,5,1,0,0,
0,0,0,0,0,0,1,1,2,2,2,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,1,0,0,0,
0,0,0,0,0,1,5,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,0,0,0,0,0,0,
0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,1,5,5,1,0,1,5,5,1,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0
}};

void task_nyancat(void *arg) {
	SHEET *sht=init_window(2*OTHER_EDGE+NYAN_SCALE*NYAN_WIDTH,
						   OTHER_EDGE+TOP_EDGE+NYAN_SCALE*NYAN_HEIGHT,"NYAN!NYAN!NYAN!");
	int frame=0,lastframe=11;
	auto put_block=[&](char x,char y){
		uint32_t color=nyan_platte[nyan_frames[frame][y*NYAN_WIDTH+x]];
		if(color==0)
			color=sht->graphics->bgcolor;
		sht->graphics->setcolor(color);
		sht->graphics->boxfill(OTHER_EDGE+x*NYAN_SCALE,TOP_EDGE+y*NYAN_SCALE,
			OTHER_EDGE+(x+1)*NYAN_SCALE-1,TOP_EDGE+(y+1)*NYAN_SCALE-1);
		sht->refresh(OTHER_EDGE+x*NYAN_SCALE,TOP_EDGE+y*NYAN_SCALE,
			OTHER_EDGE+(x+1)*NYAN_SCALE-1,TOP_EDGE+(y+1)*NYAN_SCALE-1);
	};
	for(char y=0;y<NYAN_HEIGHT;y++)
		for(char x=0;x<NYAN_WIDTH;x++)
			put_block(x,y);
	auto loop=[&]{
		frame=(frame+1)%12;
		lastframe=(lastframe+1)%12;
		for(char y=0;y<NYAN_HEIGHT;y++)
			for(char x=0;x<NYAN_WIDTH;x++)
				if(nyan_frames[frame][y*NYAN_WIDTH+x]!=nyan_frames[lastframe][y*NYAN_WIDTH+x])
					put_block(x,y);
	};
	api_loopforever(loop,FRAME_INTERVAL);
}

void *app_nyancat(char *buffer, uint32_t *cbuffer, char *param) {
	auto task=createTask("nyancat",&task_nyancat,NULL);
	task_run(task,2,1);
}
