import { defineConfig } from "vite"
import react from "@vitejs/plugin-react-swc"
import typescript from "@rollup/plugin-typescript"

const path = require("path")

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    react({
      jsxImportSource: "@emotion/react",
    }),
  ],
  build: {
    sourcemap: true,
    minify: "esbuild",
    lib: {
      entry: path.resolve(__dirname, "src/index.ts"),
      name: "@illa-design/react",
      fileName: (format) => `${format}/index.js`,
    },
    rollupOptions: {
      plugins: [
        typescript({
          tsconfig: path.resolve(__dirname, "tsconfig.json"),
          compilerOptions: {
            rootDir: path.resolve(__dirname, "src"),
            outDir: path.resolve(__dirname, "dist", "types"),
            declaration: true,
          },
          include: path.resolve(__dirname, "src/**"),
          exclude: path.resolve(__dirname, "node_modules/**"),
        }),
      ],
      external: [
        "react",
        "react-dom",
        "@emotion/react",
        "framer-motion",
        "@illa-design/system",
        "@illa-design/theme",
        "@illa-design/config-provider",
        "@illa-design/avatar",
        "@illa-design/breadcrumb",
        "@illa-design/icon",
        "@illa-design/image",
        "@illa-design/tag",
        "@illa-design/divider",
        "@illa-design/space",
        "@illa-design/button",
        "@illa-design/radio",
        "@illa-design/typography",
        "@illa-design/trigger",
        "@illa-design/popover",
        "@illa-design/checkbox",
        "@illa-design/list",
        "@illa-design/link",
        "@illa-design/progress",
        "@illa-design/empty",
        "@illa-design/badge",
        "@illa-design/statistic",
        "@illa-design/input",
        "@illa-design/switch",
        "@illa-design/alert",
        "@illa-design/input-tag",
        "@illa-design/grid",
        "@illa-design/popconfirm",
        "@illa-design/pagination",
        "@illa-design/spin",
        "@illa-design/notification",
        "@illa-design/input-number",
        "@illa-design/message",
        "@illa-design/select",
        "@illa-design/comment",
        "@illa-design/description",
        "@illa-design/timeline",
        "@illa-design/card",
        "@illa-design/rate",
        "@illa-design/calendar",
        "@illa-design/time-picker",
        "@illa-design/modal",
        "@illa-design/steps",
        "@illa-design/back-top",
        "@illa-design/drawer",
        "@illa-design/collapse",
        "@illa-design/table",
        "@illa-design/date-picker",
        "@illa-design/result",
        "@illa-design/page-header",
        "@illa-design/slider",
        "@illa-design/menu",
        "@illa-design/loading",
        "@illa-design/tabs",
        "@illa-design/skeleton",
        "@illa-design/dropdown",
        "@illa-design/affix",
        "@illa-design/cascader",
        "@illa-design/upload",
      ],
      output: {
        globals: {
          react: "React",
          "react-dom": "ReactDom",
          "@emotion/react": "@emotion/react",
          "framer-motion": "framer-motion",
          "@illa-design/system": "@illa-design/system",
          "@illa-design/theme": "@illa-design/theme",
          "@illa-design/config-provider": "@illa-design/config-provider",
          "@illa-design/avatar": "@illa-design/avatar",
          "@illa-design/breadcrumb": "@illa-design/breadcrumb",
          "@illa-design/icon": "@illa-design/icon",
          "@illa-design/image": "@illa-design/image",
          "@illa-design/tag": "@illa-design/tag",
          "@illa-design/divider": "@illa-design/divider",
          "@illa-design/space": "@illa-design/space",
          "@illa-design/button": "@illa-design/button",
          "@illa-design/radio": "@illa-design/radio",
          "@illa-design/typography": "@illa-design/typography",
          "@illa-design/trigger": "@illa-design/trigger",
          "@illa-design/popover": "@illa-design/popover",
          "@illa-design/checkbox": "@illa-design/checkbox",
          "@illa-design/list": "@illa-design/list",
          "@illa-design/link": "@illa-design/link",
          "@illa-design/progress": "@illa-design/progress",
          "@illa-design/empty": "@illa-design/empty",
          "@illa-design/badge": "@illa-design/badge",
          "@illa-design/statistic": "@illa-design/statistic",
          "@illa-design/input": "@illa-design/input",
          "@illa-design/switch": "@illa-design/switch",
          "@illa-design/alert": "@illa-design/alert",
          "@illa-design/input-tag": "@illa-design/input-tag",
          "@illa-design/grid": "@illa-design/grid",
          "@illa-design/popconfirm": "@illa-design/popconfirm",
          "@illa-design/pagination": "@illa-design/pagination",
          "@illa-design/spin": "@illa-design/spin",
          "@illa-design/notification": "@illa-design/notification",
          "@illa-design/input-number": "@illa-design/input-number",
          "@illa-design/message": "@illa-design/message",
          "@illa-design/select": "@illa-design/select",
          "@illa-design/comment": "@illa-design/comment",
          "@illa-design/description": "@illa-design/description",
          "@illa-design/timeline": "@illa-design/timeline",
          "@illa-design/card": "@illa-design/card",
          "@illa-design/rate": "@illa-design/rate",
          "@illa-design/calendar": "@illa-design/calendar",
          "@illa-design/time-picker": "@illa-design/time-picker",
          "@illa-design/modal": "@illa-design/modal",
          "@illa-design/steps": "@illa-design/steps",
          "@illa-design/back-top": "@illa-design/back-top",
          "@illa-design/drawer": "@illa-design/drawer",
          "@illa-design/collapse": "@illa-design/collapse",
          "@illa-design/table": "@illa-design/table",
          "@illa-design/date-picker": "@illa-design/date-picker",
          "@illa-design/result": "@illa-design/result",
          "@illa-design/page-header": "@illa-design/page-header",
          "@illa-design/slider": "@illa-design/slider",
          "@illa-design/menu": "@illa-design/menu",
          "@illa-design/loading": "@illa-design/loading",
          "@illa-design/tabs": "@illa-design/tabs",
          "@illa-design/skeleton": "@illa-design/skeleton",
          "@illa-design/dropdown": "@illa-design/dropdown",
          "@illa-design/affix": "@illa-design/affix",
          "@illa-design/cascader": "@illa-design/cascader",
          "@illa-design/upload": "@illa-design/upload",
        },
      },
    },
  },
})
