
<div align="center">
    <img alt="ILLA Design Logo" width="120px" height="120px" src="./.github/assets/images/logo.svg"/>
</div>

<h1 align="center">ILLA Design</h1>

<p align="center">Accelerate your internal tools development.</p>

<div align="center">
  <p>Create with ❤︎ by <a href="https://github.com/illacloud/illa-design/graphs/contributors">contributors</a></p>
</div>

![cover](./.github/assets/images/design-cover.png)

[![Chat on Discord](https://img.shields.io/badge/chat-Discord-7289DA?logo=discord)](https://discord.gg/illacloud)
[![storybook](./.github/assets/images/storybook.svg)](https://design.illafamily.com)
[![codecov](https://codecov.io/gh/illacloud/illa-design/branch/main/graph/badge.svg?token=GR2SOLBWQN)](https://codecov.io/gh/illacloud/illa-design)
[![license](https://img.shields.io/github/license/illacloud/illa-design)](./LICENSE)
[![contributing](https://badgen.net/badge/PRs/Welcome/green?icon=storybook)](./CONTRIBUTING.md)

## ✨ Features

1. 🛠 **Made for React:** Ready-to-use component library for React.
2. 📝 **TypeScript Friendly:** Come with TypeScript typings out of the box and support with predictable static typings.
3. 📦 **High Productivity:** Easy and fast, import in 5 seconds.
4. 🎨 **Vibrant Design:** Beautifully designed components and powerful theming system supports custom themes to match
   your brand, including light and dark mode.
5. 🌍 **Internationalization:** Each component was designed with i18n in mind and multiple languages are supported.
6. 📱 **Fully Responsive:** Perfectly adaptable with all the devices, desktops to mobiles.

## 💡 Components

You can review all components in Storybook.

[![storybook](./.github/assets/images/storybook.svg)](https://design.illafamily.com)

## 🖥 Fast Try

You can quickly use ILLA Design on codesandbox.

[![Edit illa-design-demo](https://codesandbox.io/static/img/play-codesandbox.svg)](https://codesandbox.io/s/illa-design-demo-r1qyy2?fontsize=14&hidenavigation=1&theme=dark)

## 🚀 Get Started

Step 1: Install

```bash
$ pnpm add @illa-design/react @emotion/react framer-motion

# or

$ npm i @illa-design/react @emotion/react framer-motion
```

Step 2: Use

```tsx
import { Tag } from '@illa-design/react';

const App = () => (
  <div>
    <Tag>Hello ILLA</Tag>
  </div>
);
```

## ⌨️ Development

Step 1: Clone locally.

```bash
$ git clone https://github.com/illacloud/illa-design.git
$ cd illa-design
$ pnpm install
```

Step 2: Run.

```bash
$ pnpm storybook
```

Then your can open storybook in your browser.

## 💬 Community

Join ILLA Community to share your ideas, suggestions or questions and connect with other users and contributors.

<b>Discussion</b>

[![Discuss on GitHub](https://img.shields.io/badge/discussions-GitHub-333333?logo=github)](https://github.com/orgs/illacloud/discussions)

<b>Hangout together!</b>

[![Chat on Discord](https://img.shields.io/badge/chat-Discord-7289DA?logo=discord)](https://discord.gg/illacloud)

## 🌱 Contributing

Thinking about contributing? All kinds of contributions to ILLA are greatly appreciated and welcomed! Check
out [Contributing Guide](./CONTRIBUTING.md) for details about how you can get involved.

## 🔥 We're Hiring

Looking for a passionate and creative team? We are actively hiring engineers for the following positions:

- Frontend Engineer
- Golang Engineer

Contact Us: hr@illasoft.com

## License

This project is [Apache License 2.0](./LICENSE).
