# Contributing
Contributions are welcome!

## Types of Contributions
### Report Bugs
Report bugs at https://github.com/ikegami-yukino/neologdn/issues.

If you are reporting a bug, please include:

- Your operating system name and version.
- Your Python verison and 32-bit/64-bit
- Using Anaconda/Miniconda: yes or no
- Error log
- Any details about your local setup that might be helpful in troubleshooting.
- Detailed steps to reproduce the bug.

### Fix Bugs
Look through the GitHub issues for bugs. Anything tagged with "bug" and "help wanted" is open to whoever wants to implement it.

### Implement Features
Look through the GitHub issues for features. Anything tagged with "enhancement" and "help wanted" is open to whoever wants to implement it.

### Typo
If you find typo, I would appreciate if you could submit pull request.

### Revise Document
If you find mistake/missing in `README.rst` or docstrings, I would appreciate if you could submit pull request.

### Submit Feedback
The best way to send feedback is to file an issue at https://github.com/ikegami-yukino/neologdn/issues.

If you are proposing a new feature:

- Explain in detail how it would work.
- Explain your motivation/hypothesis about a new feature.
- Keep the scope as narrow as possible, to make it easier to implement.

## Get Started!
Here's how to set up neologdn for local development.

1. Fork the neologdn repo on GitHub.
2. Clone your fork locally:
```
$ git clone git@github.com:your_name_here/neologdn.git
```

3. Create a branch for local development:

```
$ git checkout -b name-of-your-bugfix-or-feature
```
Now you can make your changes locally.

4. When you're done making changes, check that your changes pass the tests:

```
$ python test_neologdn.py
```

5. Commit your changes and push your branch to GitHub:

```
$ git add .
$ git commit -m "Your detailed description of your changes."
$ git push origin name-of-your-bugfix-or-feature
```

6. Submit a pull request through the GitHub website.

## Pull Request Guidelines
Before you submit a pull request, check that it meets these guidelines:

- The pull request should include tests.
- If the pull request adds functionality, the docs should be updated. Put your new functionality into a function with a docstring, and add example about the feature to the `README.rst`.
- The pull request should work for Python 3.6, 3.7, 3.8, and 3.9. Check https://travis-ci.org/ikegami-yukino/neologdn/pull_requests and make sure that the tests pass for all supported Python versions.
- The title of pull request should be written in English.
- The message/comment about pull request should be written in English or Japanese.
