# ASP.NET MVC Core User Management

This is an ASP.NET MVC Core project that allows you to manage user details using Entity Framework. It provides a set of CRUD (Create, Read, Update, Delete) operations for user records.

## Features

- **User Listing**: View a list of all user records.
- **User Details**: View detailed information for a specific user.
- **User Creation**: Create a new user record with input validation.
- **User Editing**: Update an existing user's information with input validation.
- **User Deletion**: Delete a user record with confirmation.

## Getting Started

1. **Prerequisites**: Ensure you have ASP.NET Core and Entity Framework set up in your development environment.

2. **Clone the Repository**: Clone this repository to your local machine.

   ```sh
   git clone https://github.com/ideepakpg/mvc-core.git

3. **Database Setup**: Make sure to set up your database connection in the appsettings.json file.

4. **Run the Application**: Use the following command to run the application:
   ```sh
   dotnet run
5. **Access the Application**: Open a web browser and navigate to http://localhost:7208 or the appropriate URL.

## Usage
- Visit the application in your web browser to manage user records.
- You can create, edit, and delete user records through the web interface.

## Acknowledgments
- This project is based on [ASP.NET MVC Core](https://learn.microsoft.com/en-us/aspnet/core/tutorials/first-mvc-app/start-mvc?view=aspnetcore-7.0&tabs=visual-studio) and [Entity Framework](https://learn.microsoft.com/en-us/aspnet/entity-framework).


