<div class="github-widget" data-repo="vaticle/typedb-awesome"></div>
[![TypeDB](https://github.com/typedb/typedb/blob/2c5e3114cb4d19085a329b379eef590d7a3e9eda/docs/banner.png)](https://typedb.com)

## Awesome TypeDB [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

A curated list of TypeDB resources.

TypeDB is a [polymorphic](https://typedb.com/features#polymorphic-queries) database with a [conceptual](https://typedb.com/features#conceptual-modeling) data model, a strong [subtyping](https://typedb.com/features#strong-type-system) system, a symbolic [reasoning](https://typedb.com/features#symbolic-reasoning) engine, and a beautiful and elegant [type-theoretic](https://typedb.com/features#modern-language) language TypeQL.

## Contributing

Want to contribute to the list? Let us know on [Discord](https://typedb.com/discord) and open a pull request!



## Open source projects using TypeDB

- [`TypeDB Studio - IDE for TypeDB`](https://github.com/vaticle/typedb-studio) - TypeDB Studio is an Integrated Development Environment for TypeDB for performing knowledge engineering.
- [`Blitz-ORM`](https://github.com/Blitzapps/blitz-orm) - Blitz-ORM is an Object Relational Mapper written in TypeScript and compatible with TypeDB.
- [`TypeDB-ML`](https://github.com/vaticle/typedb-ml) - TypeDB-ML provides tools to enable graph algorithms and machine learning with TypeDB.
- [`TypeDB Loader`](https://github.com/typedb-osi/typedb-loader) - An open-source data migrator for loading data into TypeDB at scale.
- [`TypeDB OSI - Cyber Threat Intelligence`](https://github.com/typedb-osi/typedb-cti) - TypeDB CTI is an open source threat intelligence platform enabling threat intel professionals to bring together their disparate CTI information into one database 
and find new insights about cyber threats.
- [`TypeDB OSI - Biomedical Knowledge Graph`](https://github.com/typedb-osi/typedb-bio) - TypeDB Bio is an open source biomedical knowledge graph providing biomedical researchers an intuitive way to query interconnected and heterogeneous biomedical 
data in one single place.
- [`Source++`](https://github.com/sourceplusplus/Assistant) - Open-source automated programming assistant with runtime-aware and context-aware functionality.
- [`Rasa`](https://github.com/RasaHQ/rasa) - Open-source machine learning framework to automate text-and voice-based conversations.

## Conferences

- [Orbit](https://www.youtube.com/playlist?list=PLtEF8_xCPklY3P5NLSQb1SyIYLhQssxfY)

## Documentation

- [TypeDB Documentation Portal](https://typedb.com/docs)

## Example projects

- [`TypeDB Driver Examples`](https://github.com/vaticle/typedb-driver-examples) - This repository includes examples that showcase usage of TypeDB Drivers in reading from and writing to a TypeDB database.

## Blog posts

- [The need for subtyping and polymorphism in databases](https://typedb.com/blog/the-need-for-subtyping-and-polymorphism-in-databases)
- [Accelerating drug discovery with applied knowledge engineering and TypeDB](https://typedb.com/blog/accelerating-drug-discovery-with-applied-knowledge-engineering-and-typedb)
- [Modeling collections in databases: Relational/SQL vs TypeDB](https://typedb.com/blog/modeling-collections-in-databases-relational-sql-vs-typedb)
- [The age of AI is upon us - where are the smart databases?](https://typedb.com/blog/the-age-of-ai-is-upon-us-where-are-the-smart-databases)
- [Building a Cyber Threat Intelligence database with TypeDB](https://typedb.com/blog/building-a-cyber-threat-intelligence-database-with-typedb)
- [Inheritance and polymorphism: where the cracks in SQL begin to show](https://typedb.com/blog/inheritance-and-polymorphism-where-the-cracks-in-sql-begin-to-show)
- [Identity and access management with TypeDB: Part I, polymorphism](https://typedb.com/blog/identity-and-access-management-with-typedb-part-i-polymorphism)
- [A New Era for TypeDB](https://typedb.com/blog/a-new-era-for-typedb)
- [Inference in TypeDB](https://typedb.com/blog/inference-in-typedb)

## Videos

- [Introduction to TypeDB and TypeQL](https://www.youtube.com/watch?v=e0lmTSb-rzY)
- [TypeDB 2.0: A Database Evolution](https://www.youtube.com/watch?v=DbnS1feTyOs)
- [Building an Open Source Threat Intelligence Platform with STIX](https://www.youtube.com/watch?v=xuiYorG8-1Q)
- [TypeDB Community Project - NodeLab: An Advanced TypeDB GUI](https://www.youtube.com/watch?v=ESupDcw70kQ)
- [Pandora Paper Leaks with TypeDB](https://www.youtube.com/watch?v=9EaxwUG9vAg)
- [Building a Distributed Database With the Raft Replication Algorithm](https://www.youtube.com/watch?v=oS42lN4qSJ4)

## Client Drivers (official)

- [`Rust, Python, Java, Node.js and C`](https://github.com/vaticle/typedb-driver)

## Client Drivers (community)

- [`Julia`](https://github.com/Humans-of-Julia/TypeDBClient.jl)

## IDE and editor support

- [`Emacs - TypeQL Plugin`](https://github.com/typedb-osi/typeql-plugin-emacs)
- [`Visual Studio Code - TypeQL Plugin`](https://github.com/typedb-osi/typeql-plugin-vscode)
- [`JetBrains / IntelliJ - TypeQL Plugin`](https://github.com/typedb-osi/typeql-plugin-jetbrains)

## Community

- [Discussion Forum](https://forum.typedb.com)
- [Discord](https://typedb.com/discord)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/vaticle-typedb%20vaticle-typeql?sort=Newest&edited=true)
- [Meetup](https://www.meetup.com/pro/typedb/)
- [Twitter](https://twitter.com/typedb_)
- [YouTube](https://www.youtube.com/c/vaticle)
- [LinkedIn](https://www.linkedin.com/groups/13657731/)
- [Blog](https://typedb.com/blog)
