<div class="github-widget" data-repo="dreikanter/sublime-bookmarks"></div>
## Sublime Text Bookmarks [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> [Sublime Text](http://www.sublimetext.com/) is a cross-platform text and source code editor, with a Python application programming interface. Its functionality is extendable with plugins. Most of the extending packages have free-software licenses and are community-built and maintained. — [Wikipedia](https://en.wikipedia.org/wiki/Sublime_Text)

This tiny project follows [GitHub community trend](https://github.com/sindresorhus/awesome) to aggregate the most essential bookmarks for specific subject in the form of a handy well-structured collection. Here you will find tutorials and learning materials for Sublime Text, general purpose extensions for coding and text editing, and specialized extensions grouped by usage profiles.

This list not supposed to include absolutely all Sublime Text plugins, due we already have [Package Control](https://packagecontrol.io/) for this. It is intended to be a starting point helping to setup working environment, or check out for new extensions to make your existing Sublime setup more awesome. You may find ★ here and there in the list. It stands for Editors' Choice. Sharing and pull requests are very much appreciated!

**[Fork and edit](https://github.com/dreikanter/sublime-bookmarks/edit/master/README.md)** (or [propose something](https://github.com/dreikanter/sublime-bookmarks/issues/new) to add).

## Things to Start From

- [Sublime Text home page](https://www.sublimetext.com/)
- [Package Control](https://packagecontrol.io/) — the first thing to do after the ST installation is to setup the package manager.
- [Unofficial Documentation](https://docs.sublimetext.io/) — is a first link inside the [official documentation TOC](https://www.sublimetext.com/docs/). It's a good starting point for noobs, as well as a detailed reference for proficient users.
- [Shortcut Cheat Sheet](https://sweetme.at/2013/08/08/sublime-text-keyboard-shortcuts/) for Linux, Mac OSX, and Windows versions of Sublime Text 3.
- [ShortcutFoo](https://www.shortcutfoo.com/app/tutorial/sublimetext) — shortcut usage training.

## Books

- [Mastering Sublime Text](https://www.packtpub.com/application-development/mastering-sublime-text) by Dan Peleg (PACKT).
- [Instant Sublime Text Starter](https://www.packtpub.com/product/instant-sublime-text-starter/9781849693929) by Eric Haughee (PACKT).

## News and Tips

- [Sublime Blog](https://www.sublimetext.com/blog/) — official news.
- [Sublime Text Tips](https://sublimetexttips.com) — tips and tricks for mastering Sublime Text.

## Community

- [Official Forum](https://forum.sublimetext.com/) — general discussion, technical support, ideas and feature requests.
- [Sublime Reddit](https://www.reddit.com/r/SublimeText) — user-generated news links and discussions.
- SuperUser: [version 2](https://superuser.com/questions/tagged/sublime-text-2), [version 3](https://superuser.com/questions/tagged/sublime-text-3), and [version-agnostic](https://superuser.com/questions/tagged/sublime-text) questions.

## Screencasts

- [The Complete Visual Guide to Sublime Text 3](https://scotch.io/bar-talk/the-complete-visual-guide-to-sublime-text-3-getting-started-and-keyboard-shortcuts): Getting Started and Keyboard Shortcuts (free course).
- [Sublime Text 3 From Scratch](https://www.pluralsight.com/courses/sublime-text-3-from-scratch) by  Jesse Liberty (Pluralsight).
- [Sublime Text 2](https://pragprog.com/screencasts/v-mrst2/sublime-text-2) by Mike Riley (Pragmatic Studio).
- [Perfect Workflow in Sublime Text 2](https://code.tutsplus.com/courses/perfect-workflow-in-sublime-text-2) — 34 video free lessons at Nettuts+.

## Extensions

Alive projects only, with Sublime Text version 3 support.

### General Purpose

- [All Autocomplete](https://github.com/alienhard/SublimeAllAutocomplete) — extends the default autocomplete to find matches in all open files.
- [ApplySyntax](https://github.com/facelessuser/ApplySyntax) — a plugin that allows to detect and apply the syntax of files that might not otherwise be detected properly. For example, files with the .rb extension are usually Ruby files, but when they are found in a Rails project, they could be RSpec spec files, Cucumber step files, Ruby on Rails files (controllers, models, etc), or just plain Ruby files.
- [EditorConfig](https://github.com/sindresorhus/editorconfig-sublime) — .editorconfig support.
- [File Navigator](https://github.com/csch0/SublimeText-File-Navigator) — keyboard-friendly file navigator and manager.
- [FindKeyConflicts](https://github.com/skuroda/FindKeyConflicts) — identify conflicting key mappings.
- [GitGutter](https://github.com/jisaacks/GitGutter) — a plugin to see git diff in gutter.
- [GitSavvy](https://packagecontrol.io/packages/GitSavvy) — git and GitHub integration.
- [Glue](https://github.com/chrissimpkins/glue) — a cross-platform, extensible plug-in for Sublime Text 2 and 3 that connects your favorite editor to your shell.
- [LSP](https://packagecontrol.io/packages/LSP) — Language Server Protocol support for Sublime Text 3 that gives you IDE features.
- [Origami](https://github.com/SublimeText/Origami) — split the window however you like! Create new panes, delete panes, move and clone views from pane to pane.
- [PackageResourceViewer](https://github.com/skuroda/PackageResourceViewer) — View and Edit Sublime package resources. Helpful for extensions and themes development.
- [PlainTasks](https://packagecontrol.io/packages/PlainTasks) — an opinionated todo-list.
- [Sidebar Enhancements](https://github.com/titoBouzout/SideBarEnhancements) — provides enhancements to the operations on Sidebar of Files and Folders.
- [StyleToken](https://github.com/vcharnahrebel/style-token) — allows to highlight certain pieces of text with different colors (similar to Notepad++ "Style token" functionality).
- [Sublime Alignment](https://github.com/wbond/sublime_alignment) — a simple key-binding for aligning multi-line and multiple selections.
- [Sublime Worksheet](https://github.com/jcartledge/sublime-worksheet) — an inline REPL for JavaScript, PHP, Ruby and more.
- [SublimeFileBrowser](https://github.com/aziz/SublimeFileBrowser) - Ditch the sidebar and browse your files in a normal tab with your keyboard, like a pro! Also, [Dired](https://en.wikipedia.org/wiki/Dired) lets you modify your directory structure using the powerful text editing feature that ST provides.
- [SublimeLinter](https://github.com/SublimeLinter/SublimeLinter3) — a plugin that provides a framework for linting code. Whatever language you code in, SublimeLinter can help you write cleaner, better, more bug-free code. SublimeLinter has been designed to provide maximum flexibility and usability for users and maximum simplicity for linter authors.
- [SublimeREPL](https://github.com/wuub/SublimeREPL) — runs an interpreter inside ST2 (Clojure, CoffeeScript, F#, Groovy, Haskell, Lua, MozRepl, NodeJS, Python, R, Ruby, Scala, shell or configure one yourself).
- [Sync Settings](https://github.com/mfuentesg/SyncSettings) - The cross-platform solution to keep Sublime Text configuration synchronized
- [Synesthesia](https://github.com/dariusf/synesthesia) — a plugin for highlighting text with pretty colours.
- [Trailing Spaces](https://github.com/SublimeText/TrailingSpaces) — highlight trailing spaces and delete them in a flash.

### Ruby Profile

Helpful notes:

- [ChangeQuotes](https://github.com/colinta/SublimeChangeQuotes) — converts single to double or double to single quotes.
- [Setting up Sublime Text for Ruby development](http://zhuravel.biz/setting-up-sublime-text-for-ruby-development)
- [Sublime Text setup](https://github.com/mhartl/rails_tutorial_sublime_text) used in the [Ruby on Rails Tutorial](https://www.railstutorial.org/)

Plugins:

- [BeautifyRuby](https://github.com/CraigWilliams/BeautifyRuby) — beautifies Ruby code.
- [ProductiveSnippetsRuby](https://github.com/janlelis/productive-sublime-snippets-ruby/) — consistent set of alternative snippets, focusing on core and stdlib ([Cheatsheet](https://github.com/janlelis/productive-sublime-snippets-ruby/blob/master/CHEATSHEET.md))
- [RSpec plugin](https://github.com/SublimeText/RSpec)
- [Sublime Ruby Debugger](https://github.com/shuky19/sublime_debugger) — a debugger plugin for interactive ruby and RoR debugging on Sublime Text.

### Python Profile

Notes:

- [Setting up Sublime Text for Python development](https://dbader.org/blog/setting-up-sublime-text-for-python-development)
- [Sublime Text 3 for Python development](http://piotr.banaszkiewicz.org/blog/2013/08/24/sublime-text-3-for-python-development/)
- [Sublime Text 3 for Python, JavaScript and web developers](http://opensourcehacker.com/2014/03/10/sublime-text-3-for-python-javascript-and-web-developers/)

Plugins:

- [Anaconda](https://github.com/DamnWidget/anaconda) — autocompletion, code linting, IDE features, autopep8 formating, McCabe complexity checker and Vagrant for Sublime Text 3 using Jedi, PyFlakes, pep8, PyLint, pep257 and McCabe that will never freeze your Sublime Text.
- [Djaneiro](https://github.com/squ1b3r/Djaneiro) — Django support.
- [MagicPython](https://github.com/MagicStack/MagicPython) — Syntax highlighter for cutting edge Python for Sublime Text and Atom.
- [Rope](https://github.com/python-rope/rope) — a Python refactoring library.
- [SublimeJEDI](https://github.com/srusskih/SublimeJEDI) — Python autocompletion.
- [SublimeLinter PEP 257](https://github.com/SublimeLinter/SublimeLinter-pep257) — an interface to [PEP 257](https://github.com/GreenSteam/pep257#pep-257-docstring-style-checker) (docstring style checker).
- [SublimePythonTidy](https://github.com/witsch/SublimePythonTidy) — [PythonTidy](https://pypi.python.org/pypi/PythonTidy/) integration.

### JavaScript Profile

- [Bump](https://github.com/yavorsky/Bump) — plugin to keep package.json dependencies fresh. Shows latest npm/yarn dependency version in the neat tooltip on package hover.
- [CoffeeScript](https://github.com/Xavura/CoffeeScript-Sublime-Plugin) — syntax highlighting and checking, commands, shortcuts, snippets, compilation and more.
- [JavaScript Enhancements](https://github.com/pichillilorenzo/JavaScriptEnhancements) — plugin that offers smart javascript autocomplete, real-time errors and, also, a lot of features about creating, developing and managing javascript projects (such as Cordova, Ionic, React, etc.). It uses [Flow](https://github.com/facebook/flow) (javascript static type checker from Facebook) under the hood.
- [JsFormat](https://github.com/jdc0589/JsFormat) — a JavaScript formatting plugin. It uses the command-line/python-module JavaScript formatter from http://jsbeautifier.org to format whole js or json files, or the selected portion(s).
- [TernJS](https://github.com/ternjs/tern_for_sublime) — a JavaScript type inference engine integration.

### Client Side Profile

- [Emmet](http://emmet.io) — a plugin for many popular text editors which greatly improves HTML & CSS workflow.
- [GutterColor](https://github.com/ggordan/GutterColor) — displays color sample in the gutter for each line in CSS containing color code.
- [Hayaku](http://hayakubundle.com) — fuzzy abbreviations, support for preprocessors (Sass, Less, Stylus) and a lot of other features in easily configurable set of tools for writing CSS faster.
- [HTMLPrettify](https://github.com/victorporof/Sublime-HTMLPrettify)

### LaTeX Profile

- [LaTeXing](https://github.com/LaTeXing/LaTeXing) — an extension for which makes your life easier and more comfortable while creating your documents.
- [LaTeXTools](https://github.com/SublimeText/LaTeXTools) — an open-source plugin that simplifies working with LaTeX files.

### Markdown Editing Profile

- [Markdown Preview](https://github.com/revolunet/sublimetext-markdown-preview) — preview and build your markdown files quickly in your web browser from Sublime Text.
- [MarkdownEditing](https://github.com/SublimeText-Markdown/MarkdownEditing) — powerful Markdown package for Sublime Text with better syntax understanding and good color schemes.

### Documentation and Help Systems

- [DashDoc](https://github.com/farcaller/DashDoc) — [Dash](https://kapeli.com/dash) integration for Sublime Text.
- [GotoDocumentation](https://github.com/kemayo/sublime-text-2-goto-documentation) — a plugin to jump to documentation for the current word.
- [HowDoI](https://github.com/azac/sublime-howdoi-direct-paste) — integration for instant [coding answers search tool](https://github.com/gleitz/howdoi).

## Integration

- [Alfred Workflow](https://github.com/franzheidl/alfred-workflows/tree/master/open-with-sublime-text) to open files and folders in Sublime Text.
- [Associating text editors with Git](https://help.github.com/articles/associating-text-editors-with-git/)
- [Command line usage](http://www.sublimetext.com/docs/2/osx_command_line.html) (for OS X).
- [LiveReload](https://github.com/alepez/LiveReload-sublimetext3) — a web browser page reloading plugin.

## Fun stuff

### Themes

- [Ayu](https://github.com/dempfi/ayu) — A simple theme with bright colors and comes in three versions — dark, mirage and light for all day long comfortable work.
- [Ciapre](https://github.com/vinhnx/Ciapre.tmTheme/) - An easy-on-the-eyes Sublime Text/TextMate color scheme.
- [Cobalt2](https://github.com/wesbos/cobalt2) — A full featured Sublime Text blue theme.
- [Comfort](https://github.com/devanshdalal/Comfort) — A wonderful theme for sublime Text!.
- [Cyanide](https://github.com/lefoy/cyanide-theme) — A minimal dark theme.
- [Flatland](https://github.com/thinkpixellab/flatland) — A simple theme and accompanying color scheme for Sublime Text 2 & 3. It is mostly derived from Soda, the right place to start for any custom theme development for Sublime.
- [Material theme](https://github.com/equinusocio/material-theme) — This theme brings the Material Design visual language. http://equinsuocha.io/material-theme
- [Predawn](https://github.com/jamiewilson/predawn) — Dark interface and syntax theme for Sublime Text and Atom. http://jamiewilson.io/predawn
- [Soda](http://buymeasoda.github.io/soda-theme/) — Dark and light custom UI themes.
- [Spacegray](http://kkga.github.io/spacegray/) — A set of custom UI themes for Sublime Text 2/3. It's all about hype and minimal. Comes in different flavors with accompanying Base16 color schemes. http://kkga.github.io/spacegray

Related extensions:

- [Sublime Theme Switcher](https://github.com/chmln/sublime-text-theme-switcher-menu) — Painless theme selection.

### Color Schemes

- [colorsublime.com](http://colorsublime.com) - huge collection of color schemes for Sublime Text.
- [Schemr](https://github.com/benweier/Schemr) — allows you to quickly change your color scheme using the command palette and keyboard shortcuts.
- [Themer](https://themer.mjswensen.com) - tool for generating color schemes (and matching themes for your other development tools, including wallpaper) from your favorite colors.
- http://tmtheme-editor.herokuapp.com — online editor for `tmTheme` format, with large gallery of Sublime Text/Textmate color schemes. GitHib project page: https://github.com/aziz/tmTheme-Editor

Some of the most popular schemes:

- [Base 16](https://github.com/chriskempson/base16) — carefully chosen syntax highlighting and a default set of sixteen colors.
- [Dracula](https://github.com/dracula/sublime) - spooky color scheme, perfect for Halloween.  Also available for terminal and [several other applications](https://draculatheme.com/).
- [Solarized](http://ethanschoonover.com/solarized) — balanced dark and light themes.

### Alternative Icons

There is a LOT of unofficial icon alternatives for Sublime Text. Here are a little collection of the most noticeable ones:

- [By Chris Lee](https://dribbble.com/shots/382409-Sublime-Text-2-Icon)
- [By Daniel Matarazzo](https://github.com/dbmzzo/Sublime-Text-2-Icon)
- [By Ernest Ojeh](https://dribbble.com/shots/1027361-Sublime-Text-icon-replacement-for-Flatland-Theme)
- [By Jon-Paul Lunney](https://dribbble.com/shots/382465-Sublime-Text-2-update-Replacement-Icon)
- [By Matheus Falcão](https://www.behance.net/gallery/22168387/Sublime-Text-Icon)
- [By Shi Yan Hui](https://github.com/shiyanhui/Sublime-Text-Icon)
- [By Tomas Sykora](https://github.com/syky27/Sublime-Text-Icon)

### Monospace Fonts

- [Adobe Source Code Pro](https://github.com/adobe-fonts/source-code-pro)
- [Anonymous Pro](http://www.marksimonson.com/fonts/view/anonymous-pro)
- [Bitstream Vera Sans Mono](http://www.dafont.com/bitstream-vera-mono.font)
- [Consolas](http://www.fonts.com/font/microsoft-corporation/consolas) (goes with Microsoft Office)
- [Deja Vu Sans Mono](http://dejavu-fonts.org)
- [Droid Sans Mono](http://damieng.com/blog/2007/11/14/droid-font-family-courtesy-of-google-ascender)
- [Fira Mono](https://fonts.google.com/specimen/Fira+Mono)
- [Hack](http://sourcefoundry.org/hack/)
- [Inconsolata](http://levien.com/type/myfonts/inconsolata.html)
- [Input](http://input.fontbureau.com) from Font Bureau
- [Monaco](https://en.wikipedia.org/wiki/Monaco_%28typeface%29)
- [PT Mono](http://www.paratype.com/public/)

See also:

- [Progamming Fonts](http://blog.codinghorror.com/progamming-fonts/) and [Revisiting Programming Fonts](http://blog.codinghorror.com/revisiting-programming-fonts/) at [CodingHorror](http://blog.codinghorror.com).
- [Recommended Fonts for Programming?](http://stackoverflow.com/questions/4689/recommended-fonts-for-programming) at StackOverflow.
- [What are the best programming fonts?](http://www.slant.co/topics/67/~programming-fonts)

## Other Bookmark Lists

There are a lot of other bookmarks collections on GitHub. Take a look at metabookmarks list: https://github.com/sindresorhus/awesome

## License

Licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.
