<div class="github-widget" data-repo="davidtheclark/scalable-css-reading-list"></div>
## A Scalable CSS Reading List [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

解决以下两个问题的阅读或观看清单：**什么是可伸缩 CSS？**和**我们如何创建可伸缩 CSS？**

通过 *scalable CSS*，我的意思是 CSS
- 随着项目的不断发展，能够保持有效、连贯、可扩展和可维护
- 能够以一致、系统的方式被任何数量的不同人理解和使用

其中包括阐明关键原则和实践的资源. 该列表仅限于我认为最*重要*值得阅读的文章——也就是说，对问题的不同方法的最佳解释（据我所知）.

 **如果您知道应该添加的资源，请分享！ 提交问题或拉取请求.**

（还有很多与 CSS 相关的其他问题：了解它的工作原理、使用特定属性、完成特定样式、实现响应式设计、提升性能等.此列表严格关注创建可伸缩 CSS 的问题.）

 *所有部分均未提供任何类型的“排名”或“建议的阅读顺序”. 全部阅读. *

## Articles

最新的在上，最旧的在下.  （给美国以外的你的注意事项：我的日期是月/日/年格式.）

- [8 rules for a robust, scalable CSS architecture](https://github.com/jareware/css-architecture/blob/master/README.md), 亚诺·兰塔宁 (Jarno Rantanen) (10/16/2016)
- [More Meaningful CSS](http://snook.ca/archives/html_and_css/more-meaningful-css), 乔纳森·斯努克 (5/17/16)
- [CSS and Scalability](http://mrmrs.io/writing/2016/03/24/scalable-css/), 亚当·莫尔斯 (3/24/16)
- [Can CSS Be Too Modular?](http://csswizardry.com/2015/03/can-css-be-too-modular/), 哈里·罗伯茨 (Harry Roberts) (3/8/15)
- [Side Effects in CSS](http://philipwalton.com/articles/side-effects-in-css/), 菲利普沃尔顿 (3/3/15)
- [Used and Abused -- CSS Inheritance and Our Misuse of the Cascade](http://www.phase2technology.com/blog/used-and-abused-css-inheritance-and-our-misuse-of-the-cascade/?utm_source=CSS-Weekly&utm_campaign=Issue-127&utm_medium=RSS), 作者：Micah Godbolt (8/25/14)
- [Enduring CSS: writing style sheets for rapidly changing, long-lived projects](http://benfrain.com/enduring-css-writing-style-sheets-rapidly-changing-long-lived-projects), 本·弗雷恩 (8/7/14)
- [Challenging CSS Best Practices](http://www.smashingmagazine.com/2013/10/21/challenging-css-best-practices-atomic-approach/) -- 建议作者称之为 Atomic CSS 的独特方法（所有实用程序类）-- Thierry Koblentz (10/21/13)
- [Atomic Design](http://bradfrostweb.com/blog/post/atomic-web-design/) , 作者 Brad Frost (6/10/13) —— 确切地说，这与 *CSS 代码* 无关； 但是很多人发现它是一种很有价值的思考前端组件架构的方式，它非常适合这个列表.
- [MindBEMding - getting your head around BEM syntax](http://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/), 哈里·罗伯茨 (Harry Roberts) (1/25/13)
- [CSS Architecture](http://philipwalton.com/articles/css-architecture/), 菲利普·沃尔顿 (Philip Walton) (11/16/12)
- [SOLID CSS](http://blog.millermedeiros.com/solid-css/), 米勒·梅代罗斯 (Miller Medeiros) (9/10/12)
- [Shoot to kill: CSS selector intent](http://csswizardry.com/2012/07/shoot-to-kill-css-selector-intent/), 哈里·罗伯茨 (Harry Roberts) (7/17/12)
- [The open/closed principle applied to CSS](http://csswizardry.com/2012/06/the-open-closed-principle-applied-to-css/), 哈里·罗伯茨 (Harry Roberts) (6/21/12)
- [Keep your CSS selectors short](http://csswizardry.com/2012/05/keep-your-css-selectors-short/), 哈里·罗伯茨 (Harry Roberts) (5/15/12)
- [The single responsibility principle applied to CSS](http://csswizardry.com/2012/04/the-single-responsibility-principle-applied-to-css/), 哈里·罗伯茨 (Harry Roberts) (4/28/12)
- [About HTML semantics and frontend architecture](http://nicolasgallagher.com/about-html-semantics-front-end-architecture/), 尼古拉斯·加拉格尔 (Nicolas Gallagher) (3/15/12)
- [An Introduction to Object Oriented CSS (OOCSS)](http://www.smashingmagazine.com/2011/12/12/an-introduction-to-object-oriented-css-oocss/), 路易斯·拉扎里斯 (12/12/11)

## Authoring Frameworks & Longer Readings

- [Atomic CSS](http://acss.io/) , 雅虎！ 公司
- [CSS Modules](http://glenmaddern.com/articles/css-modules), 格伦·马登
- [CSS Guidelines](http://cssguidelin.es/), 哈里·罗伯茨
- [Scalable and Modular Architecture for CSS](https://smacss.com/), 乔纳森·斯努克
- [SUIT CSS Documentation](https://github.com/suitcss/suit/blob/master/doc/README.md), 尼古拉斯·加拉格尔 (Nicolas Gallagher)
- [Multilayer CSS](http://operatino.github.io/MCSS/en/), 罗伯特·哈里托诺夫
- [Object Oriented CSS Wiki](https://github.com/stubbornella/oocss/wiki) 通过妮可沙利文

## CSS Styleguides

这些样式指南阐明了编写可伸缩 CSS 的约定和指南.

（我将 *styleguides* 与我所说的 *pattern libraries* 区分开来，后者是为记录和举例说明现有样式而创建的参考，而不是用于编写样式的指南.其他人经常使用术语 *styleguide* 来指代这两种或其中一种参考类型.我认为模式库不太具体地涉及可扩展的 CSS，更多的是关于可扩展的前端设计和开发工作流程；所以我不包括与模式库相关的资源.）

- [Trello](https://gist.github.com/bobbygrace/9e961e8982f42eb91b80)
- [Bootstrap](http://mdo.github.io/code-guide/#css)
- [SUIT](https://github.com/suitcss/suit/blob/master/doc/STYLE.md#4-css)
- [Github](https://github.com/styleguide/css)
- [Medium](https://gist.github.com/fat/a47b882eb5f84293c4ed)
- [Google](https://google.github.io/styleguide/htmlcssguide.xml#CSS_Style_Rules)

## Workflow Overviews

&gt; 我们如何在 [blank] 做 CSS ...

文章概述了生产站点和大规模应用程序的实际 CSS 方法. 尽管这些文章通常不包含在上面的文章和更长的阅读中没有更好解释的原则，但它们是如此务实和具体，以至于它们本身就是重要的读物. 新的先来.

- [Refining the Way We Structure Our CSS at Trello](http://blog.trello.com/refining-the-way-we-structure-our-css-at-trello/), 鲍比·格雷斯 (11/11/14)
- [How we do CSS at Ghost](http://dev.ghost.org/css-at-ghost), 保罗·戴维斯 (11/4/14)
- [Medium's CSS is actually pretty f\*\*\*ing good](https://medium.com/@fat/mediums-css-is-actually-pretty-fucking-good-b8e2a6c78b06), 作者：雅各布·桑顿 (8/28/14)
- [Codepen's CSS](http://codepen.io/chriscoyier/blog/codepens-css), 克里斯·科耶 (Chris Coyier) (7/30/14)
- [CSS at Lonely Planet](http://ianfeather.co.uk/css-at-lonely-planet/), 伊恩·费瑟 (Ian Feather) (7/24/14)
- [Github's CSS](http://markdotto.com/2014/07/23/githubs-css/), 马克奥托 (7/23/14)


## Talks

最新的第一，我想.

- [Atomic CSS](https://www.youtube.com/watch?v=bokjM0ZaizQ) ([Slides](https://www.haikudeck.com/atomic-css-science-and-technology-presentation-dJ0xlFjhBQ)), 蒂埃里·科布伦茨 (2015)
- [Managing CSS Projects with ITCSS](https://speakerdeck.com/dafed/managing-css-projects-with-itcss), 哈里·罗伯茨 (2014)
- [React: CSS in JS](http://blog.vjeux.com/2014/javascript/react-css-in-js-nationjs.html), Christopher Chedeau，又名 Vjeux (2014)
- [Thinking Beyond "Scalable CSS"](http://www.thedotpost.com/2014/11/nicolas-gallagher-thinking-beyond-scalable-css), 尼古拉斯·加拉格尔 (2014)
- [Adaptation and Components](https://www.youtube.com/watch?v=m0oMHG6ZXvo) ([slides](https://speakerdeck.com/necolas/adaptation-and-components)), 尼古拉斯·加拉格尔 (2014)
- [CSS is a Mess](https://www.youtube.com/watch?v=C4z_9F6nfS8), 乔纳森·斯努克 (2013)
- [Architecting Scalable CSS](http://vimeo.com/67544231) ([slides](https://speakerdeck.com/csswizardry/architecting-scalable-css)), 哈里·罗伯茨 (2013)
- [CSS for Grownups](https://www.youtube.com/watch?v=ZpFdyfs03Ug) ([slides](https://speakerdeck.com/andyhume/css-for-grown-ups-maturing-best-practises-sxsw-2012)), 安迪·休姆 (2013)
- [CSS module system in Google+](https://github.com/davidtheclark/scalable-css-reading-list/issues/3) ([slides](https://docs.google.com/presentation/d/1_LpRI2_grOgTKyqodgg8yWGDhStgZHxnvjFOTJ6Jb3g/edit#slide=id.p)Shubhie 恐慌 (2013)
- [Object-Oriented CSS](https://www.youtube.com/watch?v=BjAdHyA9nIY) ([slides](http://www.slideshare.net/stubbornella/object-oriented-css)), 妮可沙利文 (2009)
