<div class="github-widget" data-repo="papers-we-love/papers-we-love"></div>
## ![Papers We Love](http://paperswelove.org/images/logo-top.svg)

 [![Discord](https://img.shields.io/static/v1?label=Discord&message=join%20us!&color=mediumslateblue)](https://discord.gg/Tu2VynkRWV)

**Papers We Love** (*PWL*) is a community built around reading, discussing and learning more about academic computer science papers. This repository serves as a directory of some of the best papers the community can find, bringing together documents scattered across the web. You can also visit the [Papers We Love site](http://paperswelove.org/) for more info.

Due to [licenses](https://github.com/papers-we-love/papers-we-love/blob/master/.github/CONTRIBUTING.md#respect-content-licenses) we cannot always host the papers themselves (when we do, you will see a :scroll: emoji next to its title in the directory README) but we can provide links to their locations.

If you enjoy the papers, perhaps stop by a local chapter meetup and join in on the vibrant discussions around them. You can also discuss *PWL* events, the content in this repository, and/or anything related to *PWL* on our [Discord](https://discord.gg/Tu2VynkRWV) server.

### Chapters

Let us know if you are interested in [starting one](https://github.com/papers-we-love/organizers) in your city!

All of our meetups follow our [Code of Conduct](https://github.com/papers-we-love/papers-we-love/blob/master/CODE_OF_CONDUCT.md).

### Past Presentations

Check out our [YouTube](https://www.youtube.com/user/PapersWeLove) channel for videos and video playlists.

## Info

We're looking for pull requests related to papers we should add, better organization of the papers we do have, and/or links to other paper-repos we should point to.

### Other Good Places to Find Papers

* [2 Minute Papers](https://www.youtube.com/user/keeroyz)
* [Bell System Technical Journal, 1922-1983](https://www.bell-labs.com/our-research/technical-journal/)
* [Best Paper Awards in Computer Science](http://jeffhuang.com/best_paper_awards.html)
* [Facebook](https://research.facebook.com/publications/)
* [Google Scholar](http://scholar.google.com/citations?view_op=top_venues&hl=en&vq=eng) (choose a subcategory)
* [Microsoft Research](https://www.microsoft.com/en-us/research/publications/)
* [Functional Programming Books Review](http://alexott.net/en/fp/books/)
* [MIT's Artificial Intelligence Lab Publications](http://dspace.mit.edu/handle/1721.1/39813)
* [MIT's Distributed System's Reading Group](http://dsrg.pdos.csail.mit.edu/)
* [arXiv Paper Repository](http://arxiv.org/)
* [SciRate](https://scirate.com/)
* [cat-v.org](http://doc.cat-v.org/)
* [y-archive](http://yarchive.net/comp/index.html)
* [netlib](http://www.netlib.org/)
* [Services Engineering Reading List](https://github.com/mmcgrana/services-engineering)
* [Readings in Distributed Systems](http://christophermeiklejohn.com/distributed/systems/2013/07/12/readings-in-distributed-systems.html)
* [Gradual Typing Bibliography](http://samth.github.io/gradual-typing-bib/)
* [Security Data Science Papers](http://www.covert.io/the-definitive-security-datascience-and-machinelearning-guide/)
* [Research Papers from Robert Harper, Carnegie Mellon University](https://www.cs.cmu.edu/~rwh/papers/index.html)
* [Lobste.rs tagged as PDF](https://lobste.rs/t/pdf)
* [The Morning Paper](http://blog.acolyer.org/)
* [eugeneyan/applied-ml GitHub repository](https://github.com/eugeneyan/applied-ml)

Please check out our [wiki-page](https://github.com/papers-we-love/papers-we-love/wiki/Other-Good-Sources-of-Reading-Material) for links to blogs, books, exchanges that are worth a good read.

### How To Read a Paper

Reading a paper is not the same as reading a blogpost or a novel. Here are a few handy resources to help you get started.

* [How to read an academic article](http://organizationsandmarkets.com/2010/08/31/how-to-read-an-academic-article/)
* [Advice on reading academic papers](https://userpages.umbc.edu/~akmassey/posts/2012-02-15-advice-on-reading-academic-papers.html)
* [How to read and understand a scientific paper](http://violentmetaphors.com/2013/08/25/how-to-read-and-understand-a-scientific-paper-2/)
* [Should I Read Papers?](http://michaelrbernste.in/2014/10/21/should-i-read-papers.html)
* [The Refreshingly Rewarding Realm of Research Papers](https://www.youtube.com/watch?v=8eRx5Wo3xYA)
* [How to read a paper](http://ccr.sigcomm.org/online/files/p83-keshavA.pdf)

### Applications/Ideas built around Papers We Love

* Love a Paper - [@loveapaper](https://twitter.com/loveapaper)

### Download papers

Open your favourite terminal and run:

```bash
$ ./scripts/download.sh
```

This will scrape markdown files for links to PDFs and download papers to their respective directories.

See [README.md](https://github.com/papers-we-love/papers-we-love/blob/master/./scripts/README.md) for more options.

## Contributing Guidelines

Please take a look at our [CONTRIBUTING.md](https://github.com/papers-we-love/papers-we-love/blob/master/.github/CONTRIBUTING.md) file.

## Copyright

The name "Papers We Love" and the logos for the organization are copyrighted, and under the ownership of Papers We Love Ltd, all rights reserved. When starting a chapter, please review [our guidelines](https://github.com/papers-we-love/papers-we-love/wiki/Creating-a-PWL-chapter) and ask us about using the logo.
