<div class="github-widget" data-repo="pazguille/offline-first"></div>
## Offline-First [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 用于创建离线优先网络应用程序的有用资源

 &gt; “Web”和“online”是两个密切相关的术语，对许多人来说完全是同义词. 那么我们到底为什么要谈论“离线”网络技术，这个术语到底是什么意思呢？

灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情.


## W3C Specification

[Offline Web Applications](http://www.w3.org/TR/offline-webapps/)
&gt; 本规范重点介绍了 HTML5 的特性（SQL、离线应用程序缓存 API 以及在线/离线事件、状态和本地存储 API），并提供了有关如何使用这些特性创建离线工作的 Web 应用程序的简短教程.

[Service Workers](http://www.w3.org/TR/service-workers/)
&gt; 本规范描述了一种使应用程序能够利用持久后台处理的方法，包括在离线时启用 Web 应用程序引导的挂钩.

[IndexedDB](http://www.w3.org/TR/IndexedDB/)
 &gt; 本规范为包含简单值和分层对象的记录数据库定义了 API. 每条记录都包含一个键和一些值. 此外，数据库维护它存储的记录的索引. 应用程序开发人员直接使用 API 通过键或使用索引来定位记录. 可以在此 API 上分层查询语言. 索引数据库可以使用持久的 B 树数据结构来实现.


## Newsletter
[The Offline First Reader](http://offlinefirst.us4.list-manage1.com/subscribe?u=12d36bbe9418ed6a43127cd62&id=7fc00bfaef) . 月刊，以离线优先的所有内容为特色，涵盖新离线用例的理论、技术和用户体验.

## Posts

[Design Patterns for Offline First Web Apps](https://blog.bitsrc.io/design-patterns-for-offline-first-web-apps-5891a4b06f3a)
（拉维杜·佩雷拉 - 2022 年 9 月 20 日）

[Making PWAs work offline with Service workers](https://developer.mozilla.org/en-US/docs/Web/Progressive_web_apps/Offline_Service_workers)
（MDN - 2022 年 9 月 9 日）

[Why Would a Web App Need Encryption-at-Rest?](https://levelup.gitconnected.com/why-would-a-web-app-need-encryption-at-rest-3efd10c145e1)
（Erik Hermansen - 2022 年 5 月 31 日）

[Offline UX design guidelines](https://web.dev/offline-ux-design-guidelines/)
（Mustafa Survived，Thomas Steiner - 2022 年 6 月 13 日）

[How to design for slow networks and offline](https://uxplanet.org/youre-not-connected-to-internet-50a46ee016a7)
（尼克·巴比奇 - 2022 年 2 月 17 日）

[Downsites of Offline First](https://rxdb.info/downsides-of-offline-first.html)
（丹尼尔迈耶 - 2021 年 10 月 3 日）

[About Offline First](https://rxdb.info/offline-first.html)
（丹尼尔迈耶 - 2021 年 10 月 1 日）

[Create an offline fallback page](https://web.dev/offline-fallback-page/)
（Thomas Steiner，Pete LePage - 2020 年 9 月 24 日）

[A Design Guide for Building Offline First Apps](https://hasura.io/blog/design-guide-to-offline-first-apps)
（高塔姆英国电信 - 2020 年 2 月 13 日）

[The challenges of making a true Offline First app](https://medium.com/idea-growr/rebuilding-idea-growr-offline-first-using-react-native-graphql-docker-during-our-hackaton-576b6f7a8b90)
（Julius Huijnk - 2019 年 6 月 4 日）

[Accessibility Testing for Offline First Applications](https://medium.com/ibm-watson-data-lab/accessibility-testing-for-offline-first-applications-d8d2bfd24a6e)
（Maureen McElaney - 2017 年 11 月 6 日）

[How to add an “Offline” notification to your PWA](https://medium.com/@argo49/how-to-add-an-offline-notification-to-your-pwa-c11ee640822b)
（泰勒·阿尔戈 - 2017 年 10 月 28 日）

[Building Offline-First App using MVVM, RxJava, Room and Priority Job Queue](https://proandroiddev.com/offline-apps-its-easier-than-you-think-9ff97701a73f)
（James Shvarts - 2017 年 10 月 8 日）

[Supporting Offline Users — What Happens When it Breaks?](https://medium.com/offline-camp/supporting-offline-users-what-happens-when-it-breaks-562f7dcea0a9)
（John Kleinschmidt - 2017 年 9 月 27 日）

[Using React and Preact to Build My First Offline First Apps](https://medium.com/offline-camp/using-react-and-preact-to-build-my-first-offline-first-apps-8df4a1e5471b)
（尼克·卡斯滕 - 2017 年 9 月 5 日）

[Offline-Friendly Forms](https://mxb.at/blog/offline-forms/)
（Max Boeck - 2017 年 8 月 23 日）

[Service Worker: One fallback offline image for any aspect ratio](https://hackernoon.com/service-worker-one-fallback-offline-image-for-any-aspect-ratio-b427c0f897fb)
（Sebastian Eberlein - 2017 年 8 月 14 日）

[You're Offline](https://mxb.at/blog/youre-offline/)
（Max Böck - 2017 年 7 月 12 日）

[[第 2 部分] 使用 Service Worker 在 Angular 应用程序中获得快速离线功能](https://medium.com/onehourcode/part-2-get-rapid-offline-capability-in-your-angular-app-with-服务工作者 954f17109dd0)
（雨果·多兰 - 2017 年 6 月 28 日）

[Persistent Storage API: Building for the offline web](https://deanhume.com/Home/BlogPost/persistent-storage-api--building-for-the-offline-web/10161)
（Dean Hume - 2017 年 6 月 26 日）

[[第 1 部分] 使用 Service Worker 在 Angular 应用程序中获得快速离线功能](https://medium.com/onehourcode/part-1-get-rapid-offline-capability-in-your-angular-app-with-服务人员 762a889a503d)
（雨果·多兰 - 2017 年 6 月 21 日）

[Building an offline Web App that works in very low internet conditions using ServiceWorkers](https://medium.com/progressive-web-apps/building-offline-webapp-using-serviceworkers-8939a694cc5)
（Hari Krishna - 2017 年 6 月 16 日）

[Offline POSTs in Progressive Web Apps](https://medium.com/@nitish404/offline-post-in-progressive-web-apps-3d02f893b223)
（Nitish Thakur - 2017 年 6 月 23 日）

[Offline First Design Patterns : Engineering](https://medium.com/offline-camp/offline-first-design-patterns-engineering-1c66821137d3)
（Anirudha Bedre - 2017 年 3 月 28 日）

[Introducing Redux Offline: Offline-First Architecture for Progressive Web Applications and React Native](https://hackernoon.com/introducing-redux-offline-offline-first-architecture-for-progressive-web-applications-and-react-68c5167ecfe0)
（Jani Eväkallio - 2017 年 3 月 28 日）

[Rethinking Offline First sync for Service Workers](https://medium.com/offline-camp/rethinking-offline-first-sync-for-service-workers-da4727b6dee)
（诺兰劳森 - 2017 年 3 月 16 日）

[Offline support: "Try again, later", no more.](https://medium.com/@yonatanvlevin/offline-support-try-again-later-no-more-afc33eba79dc)
（Yonathan V. Levin - 2017 年 3 月 2 日）

[Optimize with HTTP/2 Server Push and Service Workers!](https://blog.yld.io/2017/03/01/optimize-with-http-2-server-push-and-service-workers)
（Daniela Matos de Carvalho - 2017 年 3 月 1 日）

[Understand offline first and offline last in Android](https://medium.com/@coreflodev/understand-offline-first-and-offline-last-in-android-71191e92b426)
（Florent Guillemot - 2017 年 2 月 27 日）

[Why Offline First?](https://medium.com/buildit/why-offline-first-20470604ee36)
（扎卡里·史密斯 - 2017 年 2 月 22 日）

[Send messages when you’re back online with Service Workers and Background Sync](https://www.twilio.com/blog/2017/02/send-messages-when-youre-back-online-with-service-workers-and-background-sync.html)
（菲尔纳什 - 2017 年 2 月 17 日）

[Easy Offline First Apps With Webpack's Offline Plugin](https://dev.to/kayis/easy-offline-first-apps-with-webpacks-offline-plugin)
（Kay Plößer - 2017 年 2 月 12 日）

[Offline First React Native + Meteor Apps](https://hackernoon.com/offline-first-react-native-meteor-apps-2bee8e976ec7)
(Spencer Carli - Feb 8, 2017)

[Offline-First Web Application Using Redux and PouchDB](https://stories.jotform.com/offline-first-web-applications-d2d321444510)
（Berkay Aydın - 2017 年 1 月 30 日）

[Implementing "Save For Offline" with Service Workers.](https://una.im/save-offline)
（Una Kravets - 2017 年 1 月 26 日）

[Moving beyond localStorage](https://journal.standardnotes.org/moving-beyond-localstorage-991e3695be15#.wqzo3mpuz)
（Mo Bitar - 2017 年 1 月 17 日）

[How much data should my Service Worker put upfront in the offline cache?](https://nicolas-hoizey.com/2017/01/how-much-data-should-my-service-worker-put-upfront-in-the-offline-cache.html)
（Nicolas Hoizey- 2017 年 1 月 12 日）

[Making Resilient Web Design work offline](https://medium.com/@adactio/making-resilient-web-design-work-offline-a5854781b75b#.8khh8bnio)
（杰里米·基思 - 2017 年 1 月 11 日）

[Using Service Workers and Cache to Take Web Performance to a New Level](https://calendar.perfplanet.com/2016/service-workers-cache-web-performance-new-level/)
（克里斯·洛夫 - 2016 年 12 月 23 日）

[Faking progress (service worker edition)](https://medium.com/remys-blog/faking-progress-service-worker-edition-4c3fa16e5b32#.coya1w3ki)
（雷米·夏普 - 2016 年 12 月 22 日）

[Introduction to Progressive Web Apps (Offline First)](https://auth0.com/blog/introduction-to-progressive-apps-part-one/)
（Prosper Otemuyiwa - 2016 年 12 月 19 日）

[Won’t Get Fooled Again: Lessons in Lie-Fi](https://medium.com/outsystems-engineering/wont-get-fooled-again-lessons-in-lie-fi-9097052ea66e#.texx2j9pd)
（里卡多·费雷拉 - 2016 年 12 月 15 日）

[Designing for Accidental Disconnects: Our first attempt at an offline approach](http://blog.getchop.io/2016/12/14/designing-for-accidental-disconnects-our-first-attempt-at-an-offline-approach/)
（薇薇安·克伦威尔 - 2016 年 12 月 14 日）

[Offline Patterns: There are many jobs to be done](https://medium.com/offline-camp/offline-patterns-there-are-many-jobs-to-be-done-9f97f7e89304#.54tbekzbf)
（史蒂夫·特雷瓦坦 - 2016 年 12 月 13 日）

[Writing offline web apps is easy](https://medium.com/@aliafshar/writing-offline-web-apps-is-easy-bc5ece2ed16e#.26kewn4dd)
（Ali Afshar - 2016 年 12 月 9 日）

[Architecting a web app to “just work” offline](https://blog.superhuman.com/architecting-a-web-app-to-just-work-offline-part-1-8697f316c0eb#.i6y75or3v)
（伊斯兰沙拉巴什 - 2016 年 12 月 6 日）

[Offline App Architecture: how to build for the next billion](https://hackernoon.com/so-you-want-to-develop-for-the-next-billion-9eb072c26bc8#.30ev0831v)
（Arun Sasidharan - 2016 年 12 月 4 日）

[Cross-origin Service Workers: Experimenting with Foreign Fetch](https://developers.google.com/web/updates/2016/09/foreign-fetch)
（杰夫波斯尼克 - 2016 年 12 月）

[Service Worker, what are you?](https://medium.com/@kosamari/service-worker-what-are-you-ca0f8df92b65#.wc6eggecd)
（Mariko Kosaka - 2016 年 12 月 1 日）

[Designed to be offline-first](https://medium.com/hypertrack/designed-to-be-offline-first-def41a3668b8#.a0u11gp4j)
（Arjun Attam - 2016 年 11 月 29 日）

[Hack Time: Service Workers, Background Sync, and PouchDB](https://medium.com/offline-camp/hack-time-service-workers-background-sync-and-pouchdb-3c8b71535823#.qlqbjm6dw)
（John Kleinschmidt - 2016 年 11 月 29 日）

[Offline UX Considerations](https://developers.google.com/web/fundamentals/instant-and-offline/offline-ux)
（穆斯塔法幸存 - 2016）

[Storing Sensitive Data Offline](https://medium.com/offline-camp/storing-sensitive-data-offline-cec851df95e3#.g78qucejz)
（Paul Frazee - 2016 年 11 月 17 日）

[Building Offline First React Native Apps](https://medium.com/differential/building-offline-first-react-native-apps-b958acac0009#.94hfszbig)
（Spencer Carli - 2016 年 11 月 16 日）

[Building a simple offline-capable Notepad app using ServiceWorker](https://hackernoon.com/building-a-simple-offline-capable-notepad-app-using-serviceworker-97b9b50767a5#.k9zhvs3ep)
（Amit Merchant - 2016 年 11 月 15 日）

[Instant Loading Web Apps with an Application Shell Architecture by Google](https://developers.google.com/web/updates/2015/11/app-shell)
（阿迪·奥斯马尼和马特·冈特 - 2016 年）

[My biggest takeaway from the second Offline Camp in Santa Margarita, CA — plus toast!](https://medium.com/@jessebeach/my-biggest-takeaway-from-the-second-offline-camp-in-santa-margarita-ca-d0dd930cd02b#.di93bftj9)
（J. Renée Beach - 2016 年 11 月 8 日）

[The offline experience in 2016](https://medium.com/@leofle/the-offline-experience-in-2016-83b1f00d7bfa#.nk8910brf)
（Lio Fleishman - 2016 年 10 月 27 日）

[I Was Wrong About Offline](https://medium.com/outsystems-engineering/i-was-wrong-about-offline-fe5426894740#.yb9hhitn0)
（Tiago Simões - 2016 年 10 月 20 日）

[Offline strategies come to the Service Worker Cookbook](https://hacks.mozilla.org/2016/10/offline-strategies-come-to-the-service-worker-cookbook/)
（保存 - 2016 年 10 月 19 日）

["Instant Loading" with IndexedDB (Building a PWA, Part 2)](https://bitsofco.de/bitsofcode-pwa-part-2-instant-loading-with-indexeddb/)
（Ire Aderinokun - 2016 年 10 月 18 日）

[The Service Worker Lifecycle](https://developers.google.com/web/fundamentals/instant-and-offline/service-worker/lifecycle)
（杰克·阿奇博尔德 - 2016 年 10 月 13 日）

["Offline First" with Service Worker (Building a PWA, Part 1)](https://bitsofco.de/bitsofcode-pwa-part-1-offline-first-with-service-worker/)
（Ire Aderinokun - 2016 年 10 月 11 日）

[Do you need Service Worker in your web app?](https://codingbox.io/do-you-need-service-worker-in-your-web-app-d68131d65e2c?gi=666f4385e803)
（Valerii Iatsko - 2016 年 10 月 9 日）

[Progressive Web Apps with React.js: Part 3 — Offline support and network resilience](https://medium.com/@addyosmani/progressive-web-apps-with-react-js-part-3-offline-support-and-network-resilience-c84db889162c?source=userActivityShare-136a881c591e-1475748613)
（阿迪·奥斯马尼 - 2016 年 10 月 5 日）

[Offline Reading List](https://chrisruppel.com/blog/service-worker-offline-content-list/)
（克里斯·鲁佩尔 - 2016 年 10 月 5 日）

[Almost any web page can work offline](https://github.com/homam/service-workers-example) 
（Homam Hosseini - 2016 年 9 月 24 日）

[Enabling Offline First Experiences on the Web with Service Workers](https://medium.com/offline-camp/enabling-offline-first-experiences-on-the-web-with-service-workers-e4bc8c773dae#.c6ui0i9cs)
（Dan Zajdband - 2016 年 9 月 12 日）

[Build More Reliable Web Apps with Offline](http://thenewstack.io/build-better-customer-experience-applications-using-offline-first-principles/)
（佩德罗·特谢拉 - 2016 年 9 月 7 日）

[Songsearch – using ServiceWorker to make a 4 MB CSV easily searchable in a browser](https://www.christianheilmann.com/2016/08/26/songsearch-using-serviceworker-to-make-a-4-mb-csv-easily-searchable-in-a-browser/)
（克里斯蒂安·海尔曼 - 2016 年 8 月 26 日）

[Offline Storage for Progressive Web Apps](https://medium.com/dev-channel/offline-storage-for-progressive-web-apps-70d52695513c#.ryrpvq43r)
（阿迪·奥斯马尼 - 2016 年 8 月 15 日）

[Add offline support to any Web app](https://medium.com/google-developer-experts/add-offline-support-to-any-web-app-c20edc4bea0e#.jeseb4ovf)
（Wassim Chegham - 2016 年 7 月 23 日）

[ServiceWorker: A Basic Guide to BackgroundSync](https://ponyfoo.com/articles/backgroundsync)
（Dean Hume - 2016 年 7 月 19 日）

[Offline First, the Decentralized Web, and Peer-to-Peer Technologies](https://medium.com/offline-camp/offline-first-the-decentralized-web-and-peer-to-peer-technologies-b05b7fb3bcdd#.6xdfvy6on)
（佩德罗·特谢拉 - 2016 年 7 月 15 日）

[Offline Google Analytics Made Easy](https://developers.google.com/web/updates/2016/07/offline-google-analytics)
（Jeff Posnick - 圣诞节，2016 年）

[Security in Offline First Apps](https://medium.com/offline-camp/offline-first-security-59bf4800e82a)
（卡尔文·梅特卡夫 - 2016 年 7 月 8 日）

[My blog's Service Worker and Caching Strategy](https://paul.kinlan.me/my-blogs-service-worker-and-caching-strategy/)
(Paul Kinlan - Jun 15, 2016)

[Offline/Low-bandwidth UX Design Patterns](https://medium.com/offline-camp/offline-low-bandwidth-ux-design-patterns-51391230a79e#.sctlcxk4e)
（史蒂夫·特雷瓦坦 - 2016 年 7 月 8 日）

[Offline Content with Service Worker](https://chrisruppel.com/blog/service-worker-offline-content/)
（克里斯·鲁佩尔 - 2016 年 6 月 6 日）

[Taking an online book offline](https://adactio.com/journal/10754)
（杰里米·基思 - 2016 年 6 月 3 日）

[Service Workers — Gotchas](https://medium.com/@boopathi/service-workers-gotchas-44bec65eab3f#.4q0ncllos)
（Boopathi Rajaa - 2016 年 5 月 9 日）

[Offline-first QR-code Badge Scanner](https://developer.ibm.com/clouddataservices/2016/05/05/offline-first-qr-code-badge-scanner/)
（格林伯德 - 2016 年 5 月 5 日）

[Service Workers and PWAs: It’s About Reliable Performance, Not “Offline”](https://infrequently.org/2016/05/service-workers-and-pwas-its-about-reliable-performance-not-offline/)
（Alex Russell- 2016 年 5 月 4 日）

[Progressive Web Apps: Eating your Cake](https://medium.com/@torgo/progressive-web-apps-eating-your-cake-c0a79797220f#.jp6qup8xg)
（Daniel Appelquist - 2016 年 4 月 27 日）

[Progressive Web Apps with Service Workers](http://blog.booking.com/progressive-web-apps-with-service-workers.html)
（杰西·杨 - 2016 年 4 月 21 日）

[How To Use PouchDB + SQLite For Local Storage In Ionic 2](http://gonehybrid.com/how-to-use-pouchdb-sqlite-for-local-storage-in-ionic-2/)
（Ashteya Biharisingh - 2016 年 4 月 18 日）

[Offline-First, Document Sharing, Templates: Monod is Back (not in Black)](https://tailordev.fr/blog/2016/04/15/le-lab-2-offline-first-document-sharing-templates-monod-is-back/)
（2016 年 4 月 15 日）

[Issue 4: Offline badging, DevTools, Testing, Travis, Web Storage, Service Worker Scopes, Data-driven Development, Compute Engine](https://medium.com/totally-tooling-tears/issue-4-offline-badging-testing-travis-devtools-issues-web-storage-data-driven-development-8dd1cfbc410a#.mgur8g8n3)
（阿迪·奥斯马尼 - 2016 年 4 月 15 日）

[The New Builders Ep. 1: Craft Beer and Progressive Web Apps](https://developer.ibm.com/tv/untappd-web-apps/)
（道格拉斯·弗洛拉 - 2016 年 4 月 14 日）

[Service Workers replacing AppCache: a sledgehammer to crack a nut](https://medium.com/@firt/service-workers-replacing-appcache-a-sledgehammer-to-crack-a-nut-5db6f473cc9b#.sdp7iqxc3)
（Maximiliano Firtman - 2016 年 4 月 11 日）

[Progressive Web Apps — Offline And Add To Home Screen](https://medium.com/@greenido/progressive-web-apps-offline-and-add-to-home-screen-2187a2487a5c#.7m52kq892)
（Ido Green - 2016 年 3 月 28 日）

[The web on my phone](https://adactio.com/journal/10410)
（杰里米·基思 - 2016 年 3 月 23 日）

[The copy & paste guide to your first Service Worker](https://remysharp.com/2016/03/22/the-copy--paste-guide-to-your-first-service-worker)
（雷米·夏普 - 2016 年 3 月 22 日）

[Service Workers: Save your User's Data using the Save-Data Header](http://www.deanhume.com/Home/BlogPost/service-workers--save-your-users-data-using-the-save-data-header/10139)
(Dean Hume - Mar 8, 2016)

[Service Worker notes](https://adactio.com/journal/10186)
（杰里米·基思 - 2016 年 2 月 4 日）

[Making A Service Worker: A Case Study](https://www.smashingmagazine.com/2016/02/making-a-service-worker/)
（Lyza Danger Gardner - 2016 年 2 月 1 日）

[Create a really, really simple offline page using Service Workers](http://deanhume.com/home/blogpost/create-a-really--really-simple-offline-page-using-service-workers/10135)
（Dean Hume - 2016 年 1 月 25 日）

[Offline Web Applications: Using IndexedDB & Service Worker](https://www.udacity.com/course/offline-web-applications--ud899)
（Michael Wales - 2016 年 1 月 20 日）

[Building Offline Sites with ServiceWorkers and UpUp](https://dev.opera.com/articles/offline-with-upup-service-workers/)
（Tal Ater - 2016 年 1 月 19 日）

[Instant Web Application](https://glebbahmutov.com/blog/instant-web-application/)
（Gleb Bahmutov - 2015 年 12 月 24 日）

[Introducing Background Sync](https://developers.google.com/web/updates/2015/12/background-sync)
（杰克·阿奇博尔德 - 2015）

[Beyond Offline](https://hacks.mozilla.org/2015/12/beyond-offline/)
（Salvador de la Puente González - 2015 年 12 月 21 日）

[Getting started with the Service Worker Toolbox ](http://deanhume.com/Home/BlogPost/getting-started-with-the-service-worker-toolbox/10134)
（Dean Hume - 2015 年 12 月 17 日）

[ServiceWorker Cookbook](https://serviceworke.rs/)
（由 Mozilla 提供）

[Offline Web Applications with CouchDB, PouchDB and Ember CLI](https://teamgaslight.com/blog/offline-web-applications-with-couchdb-pouchdb-and-ember-cli)
（克里斯·摩尔 - 2015 年 12 月 10 日）

[A Hoodie Case Study: How minutes.io does offline](http://hood.ie/blog/minutes-offline-case-study)
（Alex Feyerke - 2015 年 12 月 1 日）

[Reducing Single Point of Failure using Service Workers](http://calendar.perfplanet.com/2015/reducing-single-point-of-failure-using-service-workers/)
（Dean Hume - 2015 年 12 月 1 日）

[Building realtime collaborative offline-first apps with React, Redux, PouchDB and WebSockets](https://blog.yld.io/2015/11/30/building-realtime-collaborative-offline-first-apps-with-react-redux-pouchdb-and-web-sockets/)
（佩德罗·特谢拉 - 2015 年 11 月 30 日）

[Cache-limiting in Service Workers …again](https://adactio.com/journal/9888)
（杰里米·基思 - 2015 年 11 月 29 日）

[Introducing Pokedex.org: a progressive webapp for Pokémon fans](http://www.pocketjavascript.com/blog/2015/11/23/introducing-pokedex-org)
（诺兰劳森 - 2015 年 11 月 23 日）

[Cache-limiting in Service Workers](https://adactio.com/journal/9844)
（杰里米·基思 - 2015 年 11 月 19 日）

[Offline Recipes for Service Workers](https://hacks.mozilla.org/2015/11/offline-service-workers/)
（大卫沃尔什 - 2015 年 11 月 19 日）

[Instant Loading Web Apps With An Application Shell Architecture](https://medium.com/google-developers/instant-loading-web-apps-with-an-application-shell-architecture-7c0c2f10c73)
（Addy Osmani - 2015 年 11 月 17 日）

[An Offline Experience with Service Workers](http://brandonrozek.tumblr.com/post/135657690564/service-workers)
（Brandon Rozek - 2015 年 11 月 14 日）

[Building Flipkart Lite: A Progressive Web App](https://medium.com/@AdityaPunjani/building-flipkart-lite-a-progressive-web-app-2c211e641883)
（Aditya Punjani - 2015 年 11 月 11 日）

[Your first offline web app](https://developers.google.com/web/fundamentals/getting-started/codelabs/offline/)
（Chrome 开发团队 - 2015）

[Making a Simple Site Work Offline with ServiceWorker](https://css-tricks.com/serviceworker-for-offline/)
（Nicolas Bevacqua - 2015 年 11 月 10 日）

[My first Service Worker](https://medium.com/@adactio/my-first-service-worker-5e5af0b1bdbb#.tsjcjzk2n)
（杰里米·基思 - 2015 年 11 月 7 日）

[Building an offline page for theguardian.com](https://www.theguardian.com/info/developer-blog/2015/nov/04/building-an-offline-page-for-theguardiancom)
（Oliver Joseph Ash - 2015 年 11 月 4 日）

[Creating Offline-First Web Apps with Service Workers](https://auth0.com/blog/2015/10/30/creating-offline-first-web-apps-with-service-workers/)
（Ryan Chenkie - 2015 年 10 月 30 日）

[Cache sandboxed HTTP requests with Service Worker](https://medium.com/@roman01la/cache-sandboxed-http-requests-with-service-worker-6bb3801237d1#.3jjklzohz)
（Roman Liutikov - 2015 年 10 月 26 日）

[The offline experience (or, saying goodbye to imperative data fetching)](https://medium.com/@d.gieselaar/the-offline-experience-or-saying-goodbye-to-imperative-data-fetching-9b2fa487eea7)
（Dario Gieselaar - 2015 年 10 月 25 日）

[ServiceWorker: Revolution of the Web Platform](https://ponyfoo.com/articles/serviceworker-revolution)
（Nicolas Bevacqua - 2015 年 10 月 21 日）

[Taking the web offline with service workers](https://mobiforge.com/design-development/taking-web-offline-service-workers)
（Rudhan O&#39;Donoghue - 2015 年 10 月 21 日）

[Using Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers)
（MDN - 2015 年 10 月 18 日）

[Don’t Wait for ServiceWorker: Adding Offline Support with One-Line](https://davidwalsh.name/dont-wait-serviceworker-adding-offline-support-oneline)
（肯尼思·奥曼迪 - 2015 年 10 月 14 日）

[Service Workers in Production](https://developers.google.com/web/showcase/2015/service-workers-iowa)
（Jeff Posnick - 2015 年 10 月 1 日）

[How Do We Get It Done, Now?](http://alistapart.com/column/how-do-we-get-it-done-now)
（Lyza Danger Gardner - 2015 年 9 月 30 日）

[The Role of Workers and Offline Cache](https://unoyunodiez.wordpress.com/2015/08/23/modern-mobile-web-development-01/)
（2015 年 9 月 7 日）

[Let's make Offline Web Applications secure!](http://sakurity.com/blog/2015/07/28/appcache.html)
（Egor Homakov - 2015 年 7 月 28 日）

[Service Worker Meeting Highlights](https://blog.wanderview.com/blog/2015/07/28/service-worker-meeting-highlights/)
（本·凯利 - 2015 年 7 月 28 日）

[Q&A: Offline first, not just mobile first says Couchbase](http://www.cbronline.com/news/mobility/apps/qa-offline-first-not-just-mobile-first-says-couchbase-4609613)
（詹姆斯·努恩斯 - 2015 年 6 月 26 日）

[Why offline-first matters, and what developers should know about it](https://logbook.hanno.co/offline-first-matters-developers-know/)
（Marcel Kalveram - 2015 年 6 月 2 日）

[Getting Appcache’s Fallback to work, crossbrowser](https://www.iandevlin.com/blog/2015/06/html5/getting-appcaches-fallback-to-work-crossbrowser)
（伊恩·德夫林 - 2015 年 6 月 1 日）

[Mobile Apps Offline Support](https://www.infoq.com/articles/mobile-apps-offline-support)
（古斯塔沃·马查多 - 2015 年 5 月 29 日）

[Making react-europe.org work offline with Service Workers and free SSL from Cloudflare](https://medium.com/@patcito/making-react-europe-org-work-offline-with-service-workers-f54fb0457048)
（Patrick Aljord - 2015 年 5 月 14 日）

[Offline Data Synchronization in Ionic](https://frontmag.no/artikler/utvikling/offline-data-synchronization-ionic)
（马可·费尔南德斯 - 2015 年 4 月 29 日）

[Offline Data in the Browser](http://www.levvel.io/blog-post/offline-data-in-the-browser/)
（阿萨夫温伯格 - 2015 年 3 月）

[Offline: When Your Apps Can’t Connect to the Internet](https://uxdesign.cc/offline-93c2f8396124)
（Daniel Sauble - 2015 年 3 月 29 日）

[Offline is not just another mobile feature](http://betanews.com/2015/03/04/offline-is-not-just-another-mobile-feature/)
（Chuck Ganapathi - 2015 年 3 月 4 日）

[Offline-first, fast, with the sw-precache module](https://developers.google.com/web/updates/2015/02/offline-first-with-sw-precache)
（杰夫·波斯尼克 - 2015 年 2 月 23 日）

[Offline is Not a Feature](http://www.formotus.com/17221/blog-mobility/offline-is-not-a-feature)
（2015 年 2 月 16 日）

[The Right and Wrong Strategies When Taking Your App Offline](http://appdevelopermagazine.com/2356/2015/2/9/The-Right-and-Wrong-Strategies-When-Taking-Your-App-Offline/)
（马丁·海勒 - 2015 年 2 月 9 日）

[Three takeaways for web developers after two weeks of painfully slow internet](https://byrslf.co/three-takeaways-for-web-developers-after-two-weeks-of-painfully-slow-internet-9e7f6d47726e)
（嘉宝·莱纳德 - 2015 年 1 月 25 日）

[Offline first: as simple as unplug & play?](http://www.ae.be/blog-en/offline-first-simple-unplug-play/)
（Thomas Anciaux - 2015 年 1 月 15 日）

[A simple ServiceWorker app](http://blog.lamplightdev.com/2015/01/06/A-Simple-ServiceWorker-App/)
（克里斯·海恩斯 - 2015 年 1 月 6 日）

[ServiceWorker is available in Chrome 40 beta](https://plus.google.com/+IlyaGrigorik/posts/WPZsWr4QGqR)
（Ilya Grigorik - 2014 年 12 月 11 日）

[PSA: Service Workers are Coming](http://infrequently.org/2014/12/psa-service-workers-are-coming/)
（Alex Russell - 2014 年 12 月 11 日）

[The offline cookbook](https://jakearchibald.com/2014/offline-cookbook/)
（杰克·阿奇博尔德 - 2014 年 12 月 9 日）

[The next UX challenge on the web: gaining offline trust](https://www.christianheilmann.com/2014/12/08/the-next-ux-challenge-on-the-web-gaining-offline-trust/)
（克里斯蒂安·海尔曼 - 2014 年 12 月 8 日）

[Service Worker Recipes](https://github.com/GoogleChrome/samples/tree/gh-pages/service-worker)
（Cesar William Alvarenga - 2014 年 12 月 8 日）

[Introduction to Service Worker](https://developers.google.com/web/fundamentals/getting-started/primers/service-workers)
（马特·冈特 - 2014 年 12 月 1 日）

[offline decentralized single sign-on in the browser](http://substack.net/offline_decentralized_single_sign_on_in_the_browser)
（James &#39;substack&#39; Halliday - 2014 年 11 月 27 日）

[Offline Web Apps with Meteor](https://subvisual.co/blog/posts/45-offline-web-apps-with-meteor)
（Gabriel Poça，2014 年 11 月 26 日）

[How to build web applications that can work offline with PouchDB?](http://www.theodo.fr/blog/2014/11/how-to-build-web-applications-work-offline-pouchdb/)
（Yann Jacquot - 2014 年 11 月 25 日）

[Making Your App Work Offline: Tips and Cautionary Tales](https://quickleft.com/blog/making-your-app-work-offline-tips-and-cautionary-tales/)
（大卫阿拉贡 - 2014 年 11 月 11 日）

[How Google and Mozilla are aiming to make web apps shine offline](http://www.techrepublic.com/article/how-google-and-mozilla-are-aiming-to-make-web-apps-work-as-well-offline-as-on/)
（尼克希思 - 2014 年 10 月 30 日）

[Offline-first is people-first](https://nolanlawson.com/2014/10/03/offline-first-is-people-first/)
（诺兰劳森 - 2014 年 10 月 3 日）

[Introducing Hoodie: Full Stack App Development for Front-End Developers](https://www.toptal.com/front-end/introducing-hoodie-full-stack-app-development-for-front-end-developers)
（阿尔瓦罗·奥利维拉 - 2014 年 9 月 24 日）

[Offline-first: a new paradigm in web development](https://github.com/pazguille/offline-first/blob/master/ttps://translate.google.com/translate?hl=en&sl=nl&tl=en&u=http%3A%2F%2Fwww.e-sites.nl%2Fblog%2F400-offline-first-een-nieuw-paradigma-in-web-development.html)
（Boye Oomens - 2014 年 9 月 16 日）

[Building A Simple Cross-Browser Offline To-Do List With IndexedDB And WebSQL](https://www.smashingmagazine.com/2014/09/building-simple-cross-browser-offline-todo-list-indexeddb-websql/)
（马特·安德鲁斯 - 2014 年 9 月 2 日）

[Introducing MakeDrive](http://blog.humphd.org/introducing-makedrive/)
（大卫·汉弗莱 - 2014 年 8 月 25 日）

[Worklight Authentication done right with AngularJs](https://medium.com/@papasimons/worklight-authentication-done-right-with-angularjs-768aa933329c)
（吉迪恩·西蒙斯 - 2014 年 8 月 22 日）

[Taking your Worklight apps offline](https://medium.com/@papasimons/taking-your-worklight-apps-offline-e8c2c2d8533a)
（吉迪恩·西蒙斯 - 2014 年 8 月 19 日）

[Working offline](https://developer.mozilla.org/en-US/Apps/Fundamentals/Offline)
（2014 年 8 月 12 日）

[Offline First - the new paradigm in web development done Neptune style](http://scn.sap.com/community/developer-center/front-end/blog/2014/08/05/offline-first--the-new-paradigm-in-web-development-done-neptune-style) （Njål Stabell - 2014 年 8 月 5 日）

[Breaking Development: Offline First is the new Mobile First](http://www.lukew.com/ff/entry.asp?1902)
（Luke Wroblewski - 2014 年 7 月 29 日）

[Offline Patterns](https://www.ibm.com/developerworks/community/blogs/worklight/entry/offline_patterns?lang=en)
（卡洛斯·安德鲁 - 2014 年 7 月 3 日）

[Offline Web Apps,Web Storage,IndexedDB,AppCache,File API Futures](https://www.youtube.com/watch?v=pklpK55uQmE&feature=youtu.be)
（阿里·阿拉巴斯 - 2014 年 5 月 21 日）

[Service Workers: Offline Now(ish)!](https://www.youtube.com/watch?v=BKD7ZLRi9HI)
（Alex Russell - 2014 年 5 月 21 日）

[Service Worker - first draft published](https://jakearchibald.com/2014/service-worker-first-draft/)
（杰克·阿奇博尔德 - 2014 年 5 月 8 日）

[The BMEAN Stack and Offline-First Design](http://dailyjs.com/2014/04/10/bmean/)
（加藤大师 - 2014 年 4 月 11 日）

[Do HTML5 apps have to be online all the time?](https://www.christianheilmann.com/2014/03/23/do-html5-apps-have-to-be-online-all-the-time/)
（Christian Heilmann - 2014 年 3 月 23 日）

[Building an Offline First App with PouchDB](https://www.sitepoint.com/building-offline-first-app-pouchdb/)
（蒂芙尼布朗 - 2014 年 3 月 10 日）

[Introduction to Offline Web Apps on the Kindle Fire](https://developer.amazon.com/public/community/post/Tx21KG2QC7O71S9/Introduction-to-Offline-Web-Apps-on-the-Kindle-Fire.html)
（罗素比蒂 - 2014 年 1 月 30 日）

[Designing Offline-First Web Apps](http://alistapart.com/article/offline-first)
（Alex Feyerke - 2013 年 12 月 4 日）

[Offline First: Learning from native experiences](https://medium.com/@dalmaer/offline-first-learning-from-native-experiences-4a778ce8a445)
（Dion Almaer - 2013 年 12 月 4 日）

[Offline First](http://www.kryogenix.org/days/2013/11/06/offline-first/)
（Stuart Langridge - 2013 年 11 月 6 日）

[Making the web work offline first](http://marcelkalveram.com/2013/11/developing-for-offline-first/)
（Marcel Kalveram - 2013 年 11 月 20 日）

[Say Hello to Offline First](http://hood.ie/blog/say-hello-to-offline-first.html)
（丹拉什 - 2013 年 11 月 5 日）

[Offline First: Your Next Progressive Enhancement Technique?](https://www.sitepoint.com/offline-first-next-progressive-enhancement-technique/)
（克雷格·巴克勒 - 2013 年 10 月 30 日）

[Appcache, not so much a douchebag as a complete pain in the #$%^](http://www.webdirections.org/blog/appcache-not-so-much-a-douchebag-as-a-complete-pain-in-the/)
（约翰·奥尔索普 - 2013 年 7 月 19 日）

[Using HTML5 AppCache with Single Page Applications](https://techblog.dorogin.com/2013/03/using-html5-appcache-with-single-page-apps.html)
（Sergey Dorogin - 2013 年 3 月 29 日）

[Application Cache is a Douchebag](http://alistapart.com/article/application-cache-is-a-douchebag)
（杰克·阿奇博尔德 - 2012 年 5 月 8 日）

[Appcache Facts](http://mmariani.github.io/appcachefacts/)

[Chrome Offline Apps](https://developer.chrome.com/apps/offline_apps)

[Offline Support is Valuable, and You Can’t Add it Later](http://aanandprasad.com/articles/offline/)
（Aanand Prasad - 2011 年 8 月 13 日）

[Offline-first web app design](https://unhosted.org/practice/29/Offline-first-web-app-design.html)
（米歇尔·B·德容 - 2011）

[5 Reasons Why There are no Killer Offline Web Applications](https://www.sitepoint.com/killer-offline-web-applications/)
（克雷格·巴克勒 - 2010 年 2 月 16 日

[Offline Web Applications](https://hacks.mozilla.org/2010/01/offline-web-applications/)
（Paul Rouget - 2010 年 1 月 7 日）

[Let's take this offline](http://diveintohtml5.info/offline.html)
（马克朝圣者）


## Presentations

### Videos

[Introduction to Offline First web applications](https://www.youtube.com/watch?v=2zyAX9J8Diw)
（Max Gfeller - 2022 年 5 月 30 日）

[Designing for 24/7 Use: Offline-First Mobile App Development](https://www.mendix.com/videos/designing-for-24-7-use-offline-first-mobile-app-development/)
（丹尼·罗斯特 - 2020 年 10 月 1 日）

[Offline-first for Your Static Site](https://www.youtube.com/watch?v=_kJMjJ1tm6o)
（杰夫波斯尼克 - 2017 年 1 月 30 日）

[Service Worker and the Appification of the Web](http://www.thedotpost.com/2016/12/nolan-lawson-service-worker-and-the-appification-of-the-web)
（诺兰劳森 - 2016 年 12 月 5 日）

[Future App Model: Advanced Service Worker](https://www.youtube.com/watch?v=J2dOTKBoTL4)
（杰克·阿奇博尔德 - 2016 年 11 月 11 日）

[Offline is the new black](https://vimeo.com/171317290)
（Max Stoiber - 2016 年 6 月 19 日）

[Service workers at scale with Facebook and Flipkart](https://www.youtube.com/watch?v=fGTUIlEM0m8&feature=youtu.be&t=2200)
（Owen Campbell-Moore、Aditya Punjani 和 Nate Schloss - 2016 年 5 月 20 日）

[Instant Loading: Building offline-first Progressive Web Apps](https://www.youtube.com/watch?v=cmGr0RszHc8)
（杰克·阿奇博尔德 - 2016 年 5 月 20 日）

[Offline First – the good parts](https://www.youtube.com/watch?v=NEferkZOGV4&feature=youtu.be)
（Gregor Martynus - 2016 年 5 月 12 日）

[Offline Web Applications: Using IndexedDB & Service Worker](https://www.udacity.com/course/offline-web-applications--ud899)

[Totally Tooling Tips: Offline Support](https://www.youtube.com/watch?v=OBfLvqA_E4A)
（Addy Osmani 和 Matt Gaunt - 2016 年 4 月 27 日）

[Using Service Workers in Ember](http://confreaks.tv/videos/emberconf2016-using-service-workers-in-ember)
（John Kleinschmidt - 2016 年 3 月 29 日）

[Offline-First Apps with PouchDB](https://www.youtube.com/watch?v=7L7esHWAjSU)
（布拉德利霍尔特 - 2015 年 12 月 11 日）

[Worker as a Service](https://www.youtube.com/watch?v=5LAMbIlwilc)
（Ola Gasidlo - 2015 年 11 月 19 日）

[Taking Your Web Apps Offline](https://www.youtube.com/watch?v=EZF1EfjQlbo)
（迈克·尼奇 - 2015 年 11 月 16 日）

[There is a client-side proxy (ServiceWorker) in your browser!](https://www.youtube.com/watch?v=etACK2qbHfc)
（Ilya Grigorik - 2015 年 11 月 16 日）

[OnConnectionLost: The life of an offline web application](https://www.youtube.com/watch?v=rw8Q9ZLDkEs)
（Stefanie Grewenig - 2015 年 10 月 12 日）

[Offline First and Service Workers](https://www.youtube.com/watch?v=TGwjgmAqNRo)
（Maximilian Stoiber - 2015 年 10 月 5 日）

[Offline First Podcast](https://www.youtube.com/watch?v=tilH8jgLrXQ)
（网络平台播客 - 2015 年 9 月 8 日）

[The Once & Future Web](https://www.youtube.com/watch?v=RQQNNP8tFro)
（杰克·阿奇博尔德 - 2015 年 7 月 28 日）

[Go Offline](https://www.youtube.com/watch?v=BucGrYACJdQ)
（罗伯·多德森 - 2015 年 6 月 29 日）

[Taking Ember Offline](https://www.youtube.com/watch?t=20&v=VhZS4n2DMyU)
（John Kleinschmidt - 2015 年 6 月 16 日）

[Holy sync](https://www.youtube.com/watch?v=Yp1h3cd8dsg)
（Eugenio Marletti - 2015 年 5 月 5 日）

[Making Offline Suck Less with Service Workers](https://www.youtube.com/watch?v=nqecpa6MtZ0)
（Bret Little - 2015 年 3 月 28 日）

[Say Hello to Offline First](https://www.youtube.com/watch?v=ZsMS_sviJs0)
（Ola Gasidlo - 2015 年 3 月 26 日）

[The UX Of Offline-First](https://vimeo.com/125479288)
（杰克·阿奇博尔德 - 2015 年 3 月 18 日）

[The Web's Future is Offline](https://vimeo.com/120474703)
（约翰·奥尔索普 - 2015 年 2 月 24 日）

[Building Offline First Applications with Backbone](https://www.youtube.com/watch?v=Zb01eNS6-no)
（Gregor Martynus - 2014 年 12 月 17 日）

[Working connected to create offline](https://www.youtube.com/watch?v=fj49cSQ986k)
（Christian Heilmann - 2014 年 11 月 24 日）

[The ServiceWorker is coming, look busy!](https://www.youtube.com/watch?v=Rr2vXDIVerI)
（杰克·阿奇博尔德 - 2014 年 9 月 21 日）

[The Next Challenge of the Web is Us](https://www.youtube.com/watch?v=QPRqQH_30hU&t=22m53s)
（克里斯蒂安·海尔曼 - 2014 年 8 月 1 日）

[Offline First](https://www.youtube.com/watch?v=dPz_5-MEvcg)
（Alex Feyerke - 2014 年 7 月 17 日）

[The ServiceWorker: The network layer is yours to own](https://www.youtube.com/watch?v=4uQMl7mFB6g)
（杰克·阿奇博尔德 - 2014 年 6 月 25 日）

[Offline Web Applications](https://www.youtube.com/watch?v=AbixY3W8ayo)
(Jan Jongboom - 2014 年 5 月 23 日)

[The Offline Web](https://www.youtube.com/watch?v=nnLBdFLo2fc)
（戴尔·哈维 - 2014 年 6 月 20 日）

[Bring NoSQL to your mobile](https://www.youtube.com/watch?v=qfC90DQEoeY)
（Patrick Heneise - 2013 年 12 月 16 日）

[Network connectivity: optional](https://www.youtube.com/watch?v=Z7sRMg0f5Hk)
（杰克·阿奇博尔德 - 2013 年 12 月 4 日）

[Surviving the Offline Apocalypse](https://www.youtube.com/watch?v=Qg75x08Mtcs)
（John Kleinschmidt - 2014 年 11 月 29 日）

[Offline First](https://www.youtube.com/watch?v=7mdG-iAizVc)
（Jan Lehnardt - 2013 年 5 月 27 日）

[Offline rules: Bleeding edge web standards at the Financial Times](https://vimeo.com/64201695)
（安德鲁·贝茨 - 2013 年 4 月）

[What's the right way to build offline into a web application?](https://www.youtube.com/watch?v=Oic22dQMRXQ)
（Jake Archibald、Mark Christian、Alex Russell 和 Jonas Sicking - 2013 年 2 月 9 日）

[AppCache: Douchebag](https://www.youtube.com/watch?v=cR-TP6jOSQM)
（杰克·阿奇博尔德 - 2013 年 1 月 20 日）

[Application Cache And Local Storage](https://www.youtube.com/watch?v=ceODU6z4-yc)
（斯科特·戴维斯 - 2012 年 12 月 7 日）

[Offline Rules](https://www.youtube.com/watch?v=RrGo1Sz4IgQ)
（安德鲁·贝茨 - 2012 年 12 月 4 日）

[Building Web Apps of the future. Tomorrow, today and yesterday.](https://www.youtube.com/watch?v=O3AukCYymEU)
（保罗金兰 - 2012 年 11 月 12 日）

[Taking Web Apps Offline](https://www.youtube.com/watch?v=ejcJmeewtd4)
（凯文马克曼 - 2012 年 11 月 5 日）

[Building Offline Web Apps with HTML5](https://www.youtube.com/watch?v=W41mvarupH0)
（乔纳森·斯塔克 - 2012 年 7 月 25 日）

[Getting off(line): appcache, localStorage for HTML5 apps that work offline](https://www.youtube.com/watch?v=dN8e-QdYyCk)
（约翰·奥尔索普 - 2012 年 7 月 3 日）

### Slides

[Offline, progressive, and multithreaded](https://nolanlawson.github.io/fronteers-2016/#/)
（诺兰劳森 - 2016 年 10 月 10 日）

[Rise of the Web Workers](http://blog.nparashuram.com/2016/09/rise-of-web-workers-nationjs.html)
（Parashuram N - 2016 年 9 月 16 日）

[Building an Offline Page for theguardian.com](https://speakerdeck.com/oliverjash/building-an-offline-page-for-theguardian-dot-com-jsconf-budapest-may-2016)
（奥利弗·约瑟夫·阿什 - 2016 年 5 月 14 日）

[Go offline with Service Workers](https://docs.google.com/presentation/d/1crh5m2aDdZPAL07Zo1FtuAliwwghW6FMOEtXviA_BZo/edit#slide=id.p)
（伊曼纽尔克鲁格 - 2016）

[Building an Offline Page for theguardian.com](https://speakerdeck.com/oliverjash/building-an-offline-page-for-theguardian-dot-com-london-web-perf-march-2016)
（奥利弗·约瑟夫·阿什 - 2016 年 3 月）

[Insanely fast rendering w/ Service Workers and Early Flushing](https://speakerdeck.com/mstuart/service-workers-and-early-flushing)
（马克·斯图尔特 - 2015 年 12 月 14 日）

[Offline-First Apps with PouchDB at Node.js Interactive](https://speakerdeck.com/bradleyholt/offline-first-apps-with-pouchdb-at-node-dot-js-interactive)
（布拉德利霍尔特 - 2015 年 12 月 9 日）

[Developing for Offline First Mobile Experiences](http://www.slideshare.net/NicRaboy/developing-for-offline-first-mobile-experiences)
（尼克·拉博伊 - 2015 年 12 月 2 日）

[At your service! - More than appcache uses for Service Workers](http://delapuente.github.io/presentations/at-your-service/index.html)
（Salvador de la Puente González - 2015 年 10 月 21 日）

[Offline First (Web) Apps](https://speakerdeck.com/espylaub/offline-first-web-apps-beuth-hochschule-berlin)
（Alex Feyerke - 2015 年 10 月 20 日）

[Offline-First Web Applications](https://docs.google.com/presentation/d/1gDGIyGtXMSmtT8WsyXj7ADyUjNV679T1BF5QGEKqooc/mobilepresent)
（彼得·穆勒 - 2015）

[Server in your Client - Service Workers' rise to fame](http://slides.com/flaki/server-in-the-client#/)
（István Szmozsánszky - 2015 年 10 月 7 日）

[Offline-First Web Applications](https://docs.google.com/presentation/d/1gDGIyGtXMSmtT8WsyXj7ADyUjNV679T1BF5QGEKqooc/mobilepresent?slide=id.gb7f243163_0_53)
（彼得·穆勒 - 2015 年 6 月 27 日）

[Offline-first mobile web apps with PouchDB, IBM Cloudant, and IBM Bluemix](http://www.slideshare.net/IBMBluemix/offlinefirst-mobile-web-apps-with-pouchdb-ibm-cloudant-and-ibm-bluemix)
（布拉德利霍尔特 - 2015 年 6 月 22 日）

[Building Offline-Enabled Apps with PouchDB](https://speakerdeck.com/bradleyholt/building-offline-enabled-apps-with-pouchdb-at-php-tek-2015)
（布拉德利霍尔特 - 2015 年 5 月 20 日）

[Naked and afraid Offline Mobile](http://www.slideshare.net/ColdFusionConference/naked-and-afraid-48288396)
（马特伍德沃德 - 2015 年 5 月 18 日）

[Offline first, the painless way](http://de.slideshare.net/MarcelKalveram/offline-first-the-painless-way)
（Marcel Kalveram - 2015 年 5 月 17 日）

[noBackend e Offline First: focusing on creating experiences (pt-br)](https://speakerdeck.com/joselitojunior1/nobackend-e-offline-first-foque-em-criar-experiencias-number-frontinfortaleza)
（小何塞 - 2015 年 5 月 16 日）

[HOLY SYNC: a sane approach to offline-first cross-platform data syncing](https://speakerdeck.com/takhion/holy-sync-a-sane-approach-to-offline-first-cross-platform-data-syncing)
（Eugenio Marletti - 2015 年 4 月 10 日）

[Service Worker and the Offline Web](https://slidr.io/lewiscowper/service-worker-and-the-offline-web-lightning-talk)
（刘易斯考珀 - 2015 年 3 月 7 日）

[Service Workers on vacay...](https://docs.google.com/presentation/d/1LUuMYDi1ssmslQKnnX3cwrdLVy2YCqyww3PBtqEP0q8/edit)
（娜塔莎·鲁尼 - 2015 年 3 月 6 日）

[TGIF - Offline-first](http://codekult.github.io/tgif-offline-first/)
（迭戈·卡尔德隆 - 2015 年 1 月 30 日）

[ServiceWorkers and High Performance Offline Apps](https://huffduffer.com/AlanDalton/202718)
（AlanDalton - 2015 年 1 月 13 日）

[Leveraging hood.ie to build for the offline state](http://de.slideshare.net/MarcelKalveram/codemotion-talk-41932602)
（Marcel Kalveram - 2014 年 11 月 24 日）

[Let's Take Drupal Offline!](http://www.slideshare.net/dickolsson/lets-take-drupal-offline-41650712)
（迪克·奥尔森 - 2014 年 11 月 17 日）

[Offline-first web apps - Velocity EU 2014](http://www.slideshare.net/andrewsmatt/velocity-eu-2014)
（马特·安德鲁斯 - 2014 年 11 月 17 日）

[Discover ServiceWorker](http://www.slideshare.net/sandropaganotti/discover-serviceworker)
（桑德罗·帕加诺蒂 - 2014 年 11 月 16 日）

[Offline first <3](https://speakerdeck.com/zoepage/ayb14-offline-first-1)
（Ola Gasidlo - 2014 年 10 月 17 日）

[Scaling Down: The Offline First Story](https://speakerdeck.com/wohali/scaling-down-the-offline-first-story)
（琼·图泽 - 2014 年 9 月 16 日）

[Status Web Offline](https://www.infoq.com/presentations/status-web-offline)
（Kelan McMahon - 2014 年 8 月 21 日）

[Look Ma, No Connections! Building Offline-capable Web Apps with HTML5](https://www.infoq.com/presentations/html5-offline-storage)
（Bijan Vaez - 2014 年 8 月 1 日）

[Say hello to offline first!](https://speakerdeck.com/zoepage/say-hello-to-offline-first)
（Ola Gasidlo - 2014 年 5 月 19 日）

[Offline First (Web) Apps](https://speakerdeck.com/espylaub/offline-first-web-apps)
（Alex Feyerke - 2014 年 5 月 2 日）

[Offline First – Made Simple!](https://speakerdeck.com/gr2m/offline-first-made-simple)
（Gregor Martynus - 2014 年 4 月 24 日）

[Offline First Re-Imagining Web Development For The Real World](https://qconlondon.com/london-2014/dl/qcon-london-2014/slides/CaolanMcMahon_OfflineFirstReImaginingWebDevelopmentForTheRealWorld.pdf)
（Kelan McMahon - 2014 年 3 月）

## Tools

[offline-plugin](https://github.com/NekR/offline-plugin/): 用于 webpack 的离线插件 (ServiceWorker, AppCache).

[Pinterest Service Workers](https://github.com/pinterest/service-workers)：用于创建/测试/试验服务工作者的实用程序集合.

[Kinto](http://www.kinto-storage.org/)：在几秒钟内为您的 Web 应用程序添加同步和共享功能.

[bottle-service](https://github.com/bahmutov/bottle-service)：从 ServiceWorker 缓存中恢复的即时 Web 应用程序.

[react-boilerplate](https://github.com/mxstbr/react-boilerplate)：快速设置以性能为导向、离线优先的 React.js 应用程序.

[Haywire](https://github.com/omnia-salud/haywire)：用于网络问题检测的最小 javascript 库.

[sw-toolbox](https://github.com/GoogleChrome/sw-toolbox)：服务人员工具的集合.

[UpUp](https://www.talater.com/upup/)：离线优先库旨在成为向站点添加离线功能的最简单方法.

[simple-serviceworker-tutorial](https://github.com/jakearchibald/simple-serviceworker-tutorial)：一个非常简单的 ServiceWorker 示例，旨在作为 ServiceWorker 的交互式介绍.

[Hyperboot](https://github.com/substack/hyperboot): 离线 webapp 引导加载程序.

[MakeDrive](https://github.com/mozilla/makedrive) ：基于云的 Dropbox® 等同于浏览器文件系统. 专为与 Mozilla Webmaker 工具和服务一起使用而设计.
见 [Mozilla MakeDrive Wiki page](https://wiki.mozilla.org/Webmaker/MakeDrive) 了解背景信息.

[ApplicationCache](https://developer.mozilla.org/en-US/docs/Web/HTML/Using_the_application_cache): HTML5 提供了一种应用程序缓存机制，可以让基于 Web 的应用程序离线运行.

[IndexedDB](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API)：IndexedDB 是一种 API，用于在客户端存储大量结构化数据，并使用索引对该数据进行高性能搜索.

[ServiceWorkers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) ：Service Worker 就像客户端上的代理一样. 对于页面请求和页面发出的请求，您会收到一个可以自行响应的获取事件，从而创建离线体验.

[localForage](https://github.com/localForage/localForage) : 离线存储，改进. 使用简单但功能强大的 API 包装 IndexedDB、WebSQL 或 localStorage.

[remoteStorage](https://remotestorage.io/)：支持 remoteStorage 的应用程序会自动在您的所有设备上同步您的数据，从台式机到平板电脑再到智能手机，甚至您的电视.

[pouchdb](https://pouchdb.com/)：PouchDB 是一个开源 JavaScript 数据库，其灵感来自 Apache CouchDB，旨在在浏览器中良好运行.

[Offline.js](http://github.hubspot.com/offline/docs/welcome/)：一个很棒的 JavaScript 库，可在您的用户失去连接时改善您的应用程序体验.

[Hoodie](http://hood.ie/): Hoodie 是一种离线优先和无后端架构，适用于 Web 和 iOS 上的仅前端 Web 应用程序.

[Offline States](http://offlinestat.es/): 当我们没有互联网连接时显示应用程序的内容.

[appCache Nanny](https://github.com/gr2m/appcache-nanny): 用于 appCache 的 JavaScript API

[bro-fs](https://github.com/vitalets/bro-fs): 基于承诺的包装器 [HTML5 Filesystem API](https://www.w3.org/TR/file-system-api/) 允许在 Chrome 中使用沙盒文件系统.

[Orbit.js](http://orbitjs.com/)：用于协调数据源之间的访问、转换和同步的框架.

[workbox](https://github.com/GoogleChrome/workbox): 用于离线缓存的 JavaScript 库

[rxdb](https://github.com/pubkey/rxdb)


## Books

[The Offline First Book](https://neighbourhood.ie/offline-first/book/)
（来自 Neighbourhoodie）

[Offline First Web Development](https://www.packtpub.com/web-development/offline-first-web-development)
（丹尼尔·索布尔）

[Building Progressive Web Apps](http://shop.oreilly.com/product/0636920052067.do)
（塔尔·阿特）

[Client-Side Data Storage](http://shop.oreilly.com/product/0636920043676.do)
（作者：雷蒙德·卡姆登）

[Offline First: The book (draft)](http://www.webdirections.org/offlineworkshop/ibooksDraft.pdf)
（约翰·奥尔索普）

[Pro HTML5 Programming - Chapter 12: Creating HTML5 Offline Web Applications](http://apress.jensimmons.com/v5/pro-html5-programming/ch12.html)
（Peter Lubbers、Brian Albers 和 Frank Salim 着）

## Showcase
[Minutes.io](https://minutes.io)：很棒的离线第一分钟服用应用程序内置 [Hoodie](http://hood.ie/).

[2048](https://gabrielecirulli.github.io/2048/)：最初的 2048 是一款很棒的游戏，可以固定到您的主屏幕上. 

[hospitalrun.io](http://hospitalrun.io/)：用于发展中国家医院的开源软件.

[pokedex.org](https://www.pokedex.org/) ：神奇宝贝的索引，构建为客户端 JavaScript 网络应用程序. 由 ServiceWorker、PouchDB、virtual-dom 和 web worker 提供支持.

[Soundslice](https://www.soundslice.com/)：通过交互式记谱法更好地学习和教授音乐 [offline mode](https://www.soundslice.com/blog/29/introducing-soundslice-offline-mode/).

## Who to Follow
- [Matthew Riley](https://github.com/tofumatt): 在 mozilla 工作，localForage（localstroage、IndexedDb 和 WebSQL Wrapper）的创建者
- [Jake Archibald](https://github.com/jakearchibald)：自称服务工作者狂热者，在谷歌工作，帮助制作离线网络应用程序.

## Contributing
随时欢迎分享、建议和贡献！ 如果您想做出贡献，我们强烈建议您这样做. 请阅读 [contribution guidelines](https://github.com/pazguille/offline-first/blob/master/CONTRIBUTING.md).

谢谢大家 [contributors](https://github.com/pazguille/offline-first/graphs/contributors).

## Maintained by
- Guille Paz（前端 Web 开发人员和 Web 标准爱好者）
- 电子邮件： [guille87paz@gmail.com](https://github.com/pazguille/offline-first/blob/master/mailto:guille87paz@gmail.com)
- 推特： [@pazguille](https://twitter.com/pazguille)
- 网页： [https://pazguille.me/](https://pazguille.me/)


## License
[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)
