<div class="github-widget" data-repo="fliptheweb/motion-ui-design"></div>
## Motion UI Design [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
什么是动态设计？ 这是一种让您的界面充满活力的魔力，让用户对 UI 更改感到舒服.
它是与运动 UI 设计、UI 动画和过渡相关的资源、软件、库、视频和文章的精选集合.
随意地 [add something interesting](https://github.com/fliptheweb/motion-ui-design/blob/master/contributing.md) （内部待办事项）通过拉取请求！


## Resources for inspiration
### Sites
* [Tympanus codrops](http://tympanus.net/codrops/) – 交互式演示和实验.
* [Codyhouse](http://codyhouse.co/library/) – 交互式演示和实验.
* [Dribbble](http://dribbble.com/shots?list=animated) – Dribbble 上的动画镜头类别.
* [Codepen](http://codepen.io/) – HTML/CSS/JS 沙箱.
* [Give ’n’ Go](http://give-n-go.co/) – 一个精心策划的 Dribbble 镜头库被改造成交互式 CodePen 笔.
* [capptivate.co](http://capptivate.co/) – 一系列很棒的移动界面.
* [Awwwards](http://awwwards.com/websites/animation/) – 带有动画设计的网站示例.
* [cssanimation.rocks](http://cssanimation.rocks/) – CSS 动画演示.
* [michaelvillar.com](http://michaelvillar.com/motion/) – @michaelvillar (Stripe) 的实验.
* [hakim.se](http://hakim.se/) – @hakimel 的实验.
* [ui-animations.tumblr.com](http://ui-animations.tumblr.com/) – 软件用户界面中的动画.
* [hoverstat.es](http://hoverstat.es/) – 由 Animade 工作室策划的一系列有趣的网站.
* [appealing.](http://app-ealing.com/) – 移动过渡和动画的集合.
* [UI Movement](https://uimovement.com/) - 动画界面和时事通讯.
 
### Pinterest boards
* [Gestures, transitions, animations](http://pinterest.com/jvetrau/gestures-transitions-animations/) 由尤里·维特罗夫 (Yuri Vetrov) 着.
* [Web UI animation](http://pinterest.com/JRMYLFBV/web-ui-animation/) 通过 JRMY LFBV.
* [UX/UI interaction & Motion design](http://pinterest.com/matthieuLrt/ux-ui-interaction-motion-design/) 马蒂厄·勒拉特着.
* [Animated UX/UI](http://pinterest.com/julient/animated-uxui/) 朱利安·提利 (Julien Tilly) 着.
* [Motion UI](http://pinterest.com/CodeDesignIO/motion-ui/) 通过代码设计.

### Processing and other weird, but funny stuff
* [Bees & bombs](http://beesandbombs.tumblr.com/) – Dave Whyte 的处理实验.
* [PATAKK](http://patakk.tumblr.com/) – Paolo Zagreb 的处理实验.
* [dvdp](http://dvdp.tumblr.com/) – davidope 的视觉唐人街.
* [bigblueboo](http://bigblueboo.tumblr.com/) – Charlie Deck 的 3d 和处理实验.
* [Misha Kvakin](http://misha-kvakin.tumblr.com/) – Cinema4D 和 UI 实验.

## Articles
* [How fast should your UI animations be?](http://valhead.com/2016/05/05/how-fast-should-your-ui-animations-be/) 通过@valhead.
* [Getting started with UI motion design](https://medium.com/this-also/getting-started-with-ui-motion-design-d82d4a625801) 通过@Molly Lafferty.
* [A Designer’s Guide to Perceived Performance](https://medium.com/@lukejones/a-designers-guide-to-the-perception-of-performance-fedb4bd102b) 由@Luke Jones 撰写.
* [How to Use Animation to Improve UX](https://uxplanet.org/how-to-use-animation-to-improve-ux-338819e93bdb) 通过@Nick Babich.
* [How To Use Animations and Motion in Web Design](https://blog.prototypr.io/how-to-use-animations-and-motion-in-web-design-2fd1f68e6e02) 通过@PageCloud
* [UI Animation: Eye-Pleasing, Problem-Solving](https://uxplanet.org/ui-animation-eye-pleasing-problem-solving-a8b27013f55c) 通过@Tubik 工作室.
* [UI Motion Design — The Compendium](https://blog.prototypr.io/ui-motion-design-the-compendium-d8b478357fa3) 通过@Thalion.
* [Creating Usability with Motion: The UX in Motion Manifesto](https://medium.com/ux-in-motion/creating-usability-with-motion-the-ux-in-motion-manifesto-a87a4584ddc) 通过@Issara Willenskomer.
* [Jedi Principles of UI Animation](https://medium.com/@adaptivepath/jedi-principles-of-ui-animation-2b88423b1dac) @自适应路径.
* [Micro Interaction; great experience for user engagement](https://uxplanet.org/micro-interaction-great-experience-for-user-engagement-b37446bf6306) @SnehaMunot.
* [UI Animation. Microinteraction for Macroresult](https://uxplanet.org/ui-animation-microinteraction-for-macroresult-668cd9e71101) @图比克工作室.
* [The Principles of UX Choreography](https://medium.freecodecamp.org/the-principles-of-ux-choreography-69c91c2cbc2a) @RebeccaUssaiHenderson.

## Software
可以生成 UI 动画的所有可能软件的列表，这些软件通过使用技术和结果格式（视频、原型、代码等）与必看教程和插件的链接分开.

### Video, gif, presentation
* [Adobe After Effects](https://www.adobe.com/products/aftereffects.htm) – 行业标准的动画和创意合成应用程序让您可以为电影、电视、视频和网络设计和交付专业的动态图形和视觉效果：
  * [Using After Effects for UI Animation Prototypes](https://www.youtube.com/watch?v=w67z1YhPFKM&feature=youtu.be) （：movie_camera：视频）.
  * [UI Animation tutorials](https://uxinmotion.net/).
  * [How to Use After Effects for Web Animation Prototypes](http://webdesign.tutsplus.com/tutorials/how-to-use-after-effects-for-web-animation-prototypes--cms-21451) （：movie_camera：视频）.
  * [MtMograph summits](http://mtmograph.com/summits/) （：movie_camera：视频）.
  * [30 days of AE](http://schoolofmotion.com/project/30dae_01_writeon/) （：movie_camera：视频）.
  * [After Effects CC Essential Training on Lynda](http://www.lynda.com/After-Effects-tutorials/After-Effects-CC-Essential-Training/122431-2.html) （：movie_camera：视频）.
  * [BodyMovin](https://github.com/bodymovin/bodymovin) - 从 AE 到 SVG/canvas 的转换器.
  * [Squall](http://www.marcuseckert.com/squall/) – 从 AE 到 iOS 的转换器.
* [Apple Motion](https://www.apple.com/sg/final-cut-pro/motion/) – 用于创建和编辑动态图形、用于视频制作和电影制作的字幕以及用于视觉效果的 2D 和 3D 合成的 MacOS 应用程序.
* [Adobe Photoshop](http://www.adobe.com/sea/products/photoshop.html)– 还可以生成 gif UI 动画的光栅图形编辑器：
  * [9 Photoshop UI Animation Tutorials](http://bashooka.com/photoshop/photoshop-ui-animation-tutorials/).
* [Adobe Flash](http://www.adobe.com/products/flash.html) – 用于创建矢量图形、动画、游戏等的软件.
* [Apple Keynote](https://www.apple.com/ru/mac/keynote/) – 用于演示的 MacOS 应用程序，也非常适合制作高保真动画和原型：
	* [How To Prototype UI Animations In Keynote](http://www.smashingmagazine.com/2015/08/animating-in-keynote/).

### Visual programming
* [Quartz Composer](https://developer.apple.com/downloads/) – 具有基于节点的可视化编程语言的 MacOS 应用程序，用于对 MacOS/iOS 应用程序进行原型设计：
  * [The 4 Minute Guide to Quartz Composer](https://vimeo.com/88468610) （：movie_camera：视频）.
  * [Introducing Origami for QC](https://medium.com/the-year-of-the-looking-glass/introducing-origami-for-quartz-composer-f1173d0bd181).
  * [Origami](https://facebook.github.io/origami/) – 用于创建 Facebook 现代用户界面的工具.
  * [Avocado](https://labs.ideo.com/2014/05/27/avocado/) – 交互设计师的工具箱.
* [Form](http://www.relativewave.com/form/) – 具有基于节点的可视化编程语言的应用程序，用于 Google 的应用程序原型制作.
* [Principle For Mac](http://principleformac.com/) – 用于创建动画和交互式用户界面设计的 MacOS 应用程序.
* [Floid](https://floid.io/) – 适用于任何平台和设备（Web、iOS、Android）的 MacOS 交互设计工具.

### HTML, CSS and JavaScript
* [Framer studio](https://framerjs.com/) – 用于通过 CoffeeScript 编程语言制作动画原型的 MacOS 应用程序.
  * [Your first prototype with framer](https://medium.com/@kennycheny/creating-your-first-prototype-with-framer-c39221da7668).
* [Tumult Hype](http://tumult.com/hype/) – 用于创建 HTML/CSS 网站、横幅、演示文稿等的 MacOS 应用程序.
* [Adobe Edge Animation](https://creative.adobe.com/products/animate) – 用于创建 HTML/CSS 网站、横幅、演示文稿等的应用程序：
  * [Prototyping UI Animation](https://medium.com/the-thinkmill/prototyping-ui-animation-2fe08e3a7932).
* [Adobe Experience Design (ex-Project Comet)](http://www.adobe.com/products/experience-design.html) – 用于创建网站和移动应用程序的设计、原型和动画的应用程序（预览版）.
* [Google web designer](https://www.google.com/webdesigner/) – 基于 HTML 的设计和动态图形.
* [Animatron](http://animatron.com/) – 用于创建动画、横幅和信息图表的 Web 应用程序.
* [Pixate](http://pixate.com/) – 原型制作平台.
* [SpiritJS](https://spiritjs.io/) – 网络动画工具（尚未实现）.
* 任何 HTML/CSS 编辑器， [libraries](#libraries) ;)

显而易见你的秘密武器——笔和纸！

## Helpers
* [easings.net](http://easings.net/) – 缓动函数备忘单.
* [cubic-bezier.com](http://cubic-bezier.com/) – 三次贝塞尔视觉工具.
* [csstriggers.com](http://csstriggers.com/) – 触发重绘、回流或合成的 CSS 属性列表.

## Libraries
* [Web Animation Infographics](http://www.awwwards.com/web-animation-infographics-a-map-of-the-best-animation-libraries-for-javascript-and-css3-plus-performance-tips.html) – 很棒（但很旧）的信息图表，其中包含使用过的技术的图书馆.
* [Bouncy Ball](https://sparkbox.github.io/bouncy-ball/) – 通过展示如何用每个球弹跳来比较动画技术.

### CSS
* [Animate.css](http://daneden.github.io/animate.css/) – CSS 动画集合.
* [Effeckt.css](http://h5bp.github.io/Effeckt.css/) – Collections of UI animations.
* [Bounce.js](http://bouncejs.com/) - 从 js 缓动函数生成漂亮的 CSS 关键帧动画的工具.
* [Animations.css](http://justinaguilar.com/animations/) - 收藏.
* [Magic animations](http://www.minimamente.com/example/magic_animations/) - 收藏.
* [UI buttons](http://uibuttons.com/) – 按钮集合.
* [Hover.css](http://ianlunn.github.io/Hover/) – 悬停效果.
* [Morf](http://www.joelambert.co.uk/morf/) - 带有自定义缓动功能的过渡.
* [Awesome CSS3 animations](http://pavlyukpetr.com/awesome/) – 动画库.
* [All Animation](http://all-animation.github.io/) – 一组有趣的动画，让您的项目更性感.
* [CSS Animate](http://cssanimate.com/) – 用于轻松快速创建 CSS3 关键帧动画的工具.
* [Mantra](http://jeremyckahn.github.io/mantra/) - 用于创建关键帧动画的工具.

### JavaScript
* [GreenSock](http://greensock.com/) – 适用于现代网络的超高性能、专业级动画.
* [Velocity.js](http://julian.com/research/velocity/) – 加速的 JavaScript 动画.
* [Impulse](http://impulse.luster.io/) – 移动网络的高性能交互.
* [AniJS](http://anijs.github.io/) – 声明的数据属性的动画.
* [Snabbt.js](http://daniel-lundin.github.io/snabbt.js/) – JavaScript 中的简约动画库.
* [Famo.us](http://famous.org/) – 用于动画和界面的高性能 JavaScript 库.
* [Processing.js](http://processingjs.org/) – 用于处理可视化编程语言的 JavaScript 库.
* [Framer.js](https://github.com/koenbok/Framer) – 用于设计 UI、交互和动画的原型制作工具.
* [Dynamics.js](http://dynamicsjs.com/) – 用于创建基于物理的动画的 JavaScript 库.
* [Mo.js](https://github.com/legomushroom/mojs) – 用于网络的动态图形工具带.
* [AnimateTransition](http://rapid-application-development-js.github.io/AnimateTransition/) - 用于块和弹出窗口转换的库.
* [Animate Plus](https://github.com/bendc/animateplus) – 适用于现代浏览器的 CSS 和 SVG 动画库，高性能且轻量级（gzipped 3KB），使其特别适合移动设备.
* [Gravitas.js](https://github.com/iamralpht/gravitas.js) – JavaScript 的超快速物理模拟​​.
* [Popmotion](https://popmotion.io/guides/basics/get-started/) – JavaScript 运动引擎，可以快速简单地创建引人入胜的用户交互.
* [anime.js](http://animejs.com/) - 轻量级 JavaScript 动画库.
* [useAnimations](https://useanimations.com/) - 微动画图标库；

### SVG
* [SnapSVG](http://snapsvg.io/) — JavaScript 库使处理 SVG 资源就像 jQuery 使处理 DOM 一样容易.
	* [How to Manipulate and Animate SVG With Snap.svg](http://webdesign.tutsplus.com/articles/how-to-manipulate-and-animate-svg-with-snapsvg--cms-21323)
* [BonsaiJS](https://bonsaijs.org/) – 具有直观图形 API 和 SVG 渲染器的轻量级图形库.
* [Vivus.js](http://maxwellito.github.io/vivus/) – 允许您为 SVG 设置动画，使它们看起来像是被绘制的.
* [Walkway.js](http://connoratherton.com/walkway) - 简单的动画 SVG 图像的方法，包括线、路径和多段线元素.
* [Transformicons](http://www.transformicons.com/) – 使用 SVG 和 CSS 的动画图标、符号和按钮.

## Web animation performance
* [Jankfree.org](http://jankfree.org/) – 关于浏览器性能的文章和演示文稿集.
* [High performance animations](http://www.html5rocks.com/en/tutorials/speed/high-performance-animations/).
* [How to Create Smoother Animations and Transitions in the Browser](http://blog.teamtreehouse.com/create-smoother-animations-transitions-browser).
* [CSS animations and transitions performance: looking inside the browser](http://blogs.adobe.com/webplatform/2014/03/18/css-animations-and-transitions-performance/).

## Speeches, presentations, videos
* [Interface Animations (Mark Geyer)](http://markgeyer.com/pres/interface-animations/) – BlendConf 2014 研讨会.
* [The future of UX – Animation on the Brain (Rachel Nabors)](http://www.slideshare.net/CrowChick/animation-and-the-future-of-ux-33573726).
* [Designing Complex SVG Animations (Sarah Drasner, Trulia)](http://slides.com/sdrasner/cssdevconf).
* [Designing with animation (Pasquale D'Silva)](https://www.youtube.com/watch?v=TMe0WnkF1Lc&feature=youtu.be&list=UURx1y52pfeMwbuer9Vh2u-A&html5=1) （：movie_camera：视频）.
* [Animating Web Experiences (John Allsopp)](https://www.youtube.com/watch?v=66Kf8fMfh1M&list=UURx1y52pfeMwbuer9Vh2u-A&index=47) （：movie_camera：视频）.
* [Putting Your UI in Motion (Val Head)](http://aneventapart.com/news/post/putting-your-ui-in-motion-with-css-by-val-head-an-event-apart-video) （：movie_camera：视频）.
* [Motion design with CSS (Val Head)](https://www.youtube.com/watch?v=TjsXqt-UxLo&list=PLUS3uVC08ZaqVEGFkl_dS_3FUzILkOIzA) （：movie_camera：视频）.
* [Lets move! (Benjamin De Cock, Stripe)](https://www.youtube.com/watch?v=J6wUmQDQBkw) （：movie_camera：视频）.
* [Animating Your UX (Rachel Nabors)](https://futureinsights-1.wistia.com/medias/k62k980uo7) （：movie_camera：视频）.
* [Styling and Animating Scalable Vector Graphics with CSS (Sara Soueidan)](https://www.youtube.com/watch?v=lf7L8X6ZBu8&list=PLUS3uVC08ZaqVEGFkl_dS_3FUzILkOIzA) （：movie_camera：视频）.
* [Animating the User Experience (Rachel Nabors)](https://www.youtube.com/watch?v=bM4qJpg7KhI) （：movie_camera：视频）.
* [Designing meaningful animation (Val Head)](https://vimeo.com/165995133) （：movie_camera：视频）.
* [Functional Animation (Sarah Drasner)](https://www.youtube.com/watch?v=HaD5z2KqcGk&feature=youtu.be) （：movie_camera：视频）.
* [Animations anew - laziness, arrogance and intolerance (Andrey Sitnik)](http://ai.github.io/anim2012/) （：ru：俄语）.

## Newsletters, podcasts, screencasts
* [The UI Animation Newsletter](http://valhead.com/newsletter/) – 包含资源的时事通讯以及有关如何让网络动画为您工作的有用建议，每月由@valhead 直接发送到您的收件箱.
* [Web Animation Weekly](http://webanimationweekly.com/) – 包含文章、视频、书评和其他与 Rachel Nabors 精彩的网络动画和动作设计世界相关的时事通讯.
* [Motion and meaning](http://motionandmeaning.io/) – @valhead 和 Cennydd Bowles 为数字设计师制作的关于运动的播客.
* [All The Right Moves](https://vimeo.com/channels/alltherightmoves/) – @valhead 的动画评论.
* [UI Movement](https://uimovement.com/) - 本周最佳 UI 动画时事通讯.

## Guidelines
* 安卓
  * [Material design guidelines: Motion](https://material.io/design/motion/)
* 苹果系统
  * [OS X Human Interface Guidelines: Animation](https://developer.apple.com/library/mac/documentation/UserExperience/Conceptual/OSXHIGuidelines/Animation.html#//apple_ref/doc/uid/20000957-CH11-SW1)
* iOS
  * [User Interface Design for iOS 7 Apps](https://developer.apple.com/tech-talks/videos/?id=2) (:movie_camera: 视频)
  * [iPhoto for iOS: UI Progression and Animation Design](https://developer.apple.com/videos/wwdc/2012/?id=243) (:movie_camera: 视频)
* 苹果手表
  * [Specifications: Animations](https://developer.apple.com/watch/human-interface-guidelines/specifications/#animations)
* 窗户
	* [Guidelines for animations](https://msdn.microsoft.com/en-us/library/windows/apps/dn611854.aspx)
	* [Microsoft web framework: Motion](http://getmwf.com/styles/motion.html)
* IBM
	* [IBM Design Language – Animation design guidelines](http://www.ibm.com/design/language/framework/animation/introduction)
* [SalesForce Lightning](https://www.lightningdesignsystem.com/design/motion/)

## Books
* [The Web In Motion: Practical Considerations For Designing With Animation](https://shop.smashingmagazine.com/products/the-web-in-motion-practical-considerations-for-designing-with-animation) 由粉碎杂志.
* [Motion Design for iOS](https://designthencode.com/) 迈克·朗德尔.
* [Animation in HTML, CSS, and JavaScript](http://www.kirupa.com/book/animation_in_html_css_and_javascript.htm).
* [Futureproof Web Design Techniques. Interaction Design & Complex Animations](http://www.uxpin.com/curated-interaction-design-animations.html) 通过@UXPin.
* [CSS animations](http://cssanimationspocketguide.com/) 通过@valhead.
* [Designing Interface Animations](http://rosenfeldmedia.com/books/designing-interface-animations/) 作者 @valhead（尚未发布）.

## How to Share :star::star::star::star::star:
* <a href="https://twitter.com/intent/tweet?text=https://github.com/fliptheweb/motion-ui-design%20Motion%20UI%20Design%20collection" target="_blank">在推特上分享</a>
* <a href="https://www.facebook.com/sharer/sharer.php?s=100&p[url]=https://github.com/fliptheweb/motion-ui-design&p[images][0]=&p[title]=Motion%20UI%20Design%20Collection&p[summary]=" target="_blank">在脸书上分享</a>

## License

[![CC0](https://upload.wikimedia.org/wikipedia/commons/6/69/CC0_button.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

** 与 :heart: 合集，由 Artur Kornakov 和 [these awesome guys](https://github.com/fliptheweb/motion-ui-design/graphs/contributors)**
