<div class="github-widget" data-repo="ellisonleao/magictools"></div>
<h1 align="center">
    <img width="900" src="https://cdn.rawgit.com/ellisonleao/magictools/7d8012bc/magicbg.jpg" alt="logo"/>
</h1>
<hr/>

<p align="center">
    <a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="Awesome"/></a>
    <a href="#"><img src="https://raw.githubusercontent.com/ellisonleao/magictools/actions/workflows/validate-links.yml/badge.svg" alt="build"/></a>
</p>

A curated list of game development resources to make **magic** happen.

### License Legends

- :free: - Free
- :tada: - Open Source
- :moneybag: - Paid
- :money_with_wings: - Partially Free



## Graphics

_Great graphics placeholders and tools to turn that squared game into a picasso painting_

#### Assets/Placeholders

- :free: [2D Cartoon Mobile Game UI Pack](http://graphicburger.com/mobile-game-gui/) - cartoon user interface asset pack. It comes as a layered psd file.
- :free: [420 Pixel Art Icons for RPGs](http://7soul1.deviantart.com/art/420-Pixel-Art-Icons-for-RPG-129892453) - Set of 420 RPG icons, free for commercial use.
- :free: [Blender 3D models](https://www.blender-models.com/) - 3D models, particle systems/effects
- :money_with_wings: [CGTextures](http://www.textures.com) - A large collection of textures.
- :money_with_wings: [GameDev Market](https://www.gamedevmarket.net/) - a community-driven marketplace that connects indie game developers with talented asset creators.
- :free: [Games-Icons Set](http://game-icons.net/) - free icons for your games.
- :free: [Iconmonstr](http://iconmonstr.com/) - Another free icons resource for your games.
- :money_with_wings: [Kenney Assets](http://kenney.nl/assets) - Royalty free assets
- :free: [Liberated Pixel Cup assets](http://lpc.opengameart.org) - Free graphic assets of the Liberated Pixel Cup (LPC) held by the OpenGameArt forums
- :free: [Matcaps](https://github.com/nidorx/matcaps#matcaps) - A Huge library of matcap textures in PNG and ZMT, organized by color.
- :free: [OpenGameArt](http://opengameart.org/) - a media repository intended for use with free software game projects.
- :moneybag: [Oryx Design Lab](http://oryxdesignlab.com/) - Cheap high quality royalty free sprites
- :money_with_wings: [PlainTextures](http://www.plaintextures.com/) - Free high resolution textures, brushes and photos
- :free: [Pixelicious](https://www.pixelicious.xyz/) - Image-to-Pixel Art converter.
- :free: [Poly Pizza](https://poly.pizza) - 6000+ free low poly models
- :free: [Reiner's Tilesets](http://www.reinerstilesets.de/) - A blog with free 2D and 3D graphics.
- :free: [Sketchfab](https://sketchfab.com/) - Publish & embed interactive 3D models.
- :free: [SpriteLib](http://www.widgetworx.com/spritelib/) - a collection of static and animated graphic objects (also commonly known as sprites).
- :free: [StickyPNG](http://www.stickpng.com/) - Free transparent PNG images.
- :free: [TextureHaven](https://texturehaven.com/) - Free textures with additional maps like displacement and bump maps. Also HDRIs.
- :free: [TextureKing](http://www.textureking.com/) - Free material stock textures
- :money_with_wings: [Vecteezy](http://www.vecteezy.com/) - Free Vector Art.

#### Spritesheet Tools

- :tada: [Cheetah-Texture-Packer](https://github.com/scriptum/Cheetah-Texture-Packer) - High efficient and fast 2D bin packing tool
- :tada: [EzSpriteSheet](https://github.com/z64me/EzSpriteSheet) - Creates sprite sheets from animated GIFs and more
- :tada: [Libgdx Texture Packer](https://github.com/libgdx/libgdx/wiki/Texture-packer) - Texture Packer built into Libgdx
- :free: [Littera](http://kvazars.com/littera) - Bitmap font generator
- :tada: [SnowB Bitmap Font](https://snowb.org/) - Bitmap font generator
- :free: [ShoeBox](http://renderhjs.net/shoebox/) - Adobe Air based app with game and ui related tools.
- :money_with_wings: [TexturePacker](https://www.codeandweb.com/texturepacker) - Great spritesheet creation editor.
- :tada: [Tilesplit](https://github.com/AlexPoulsen/tilesplit) - CLI text-based tilesheet splitter and namer. Turn a spritesheet into many separate files with names you pick, or not if you don't care. Support templates and textures that are not all the same size.

#### Bitmap Compression

- :tada: [ImageAlpha](http://pngmini.com/) — Mac OS X GUI for pngquant and other tools
- :free: [PNGGauntlet](http://pnggauntlet.com/) - Smash PNGs for faster sites
- :free: [PNGoo](https://pngquant.org/PNGoo.0.1.1.zip) - Windows GUI for batch conversion.
- :tada: [Pngyu](http://nukesaq88.github.io/Pngyu/) - simple PNG image file compression tool.
- :money_with_wings: [TinyPNG](https://tinypng.com/) - Advanced lossy compression for PNG images that preserves full alpha transparency.

#### Texture Tools

- :moneybag: [FilterForge](https://www.filterforge.com/) - A plugin for Adobe Photoshop that allows you to build your own filters.
- :free: [Live Normal](https://tenebrislab.github.io/livenormal/) - An Android and iOS app for generating seamless materials on the go. You take a photo, and Live Normal creates a tile-able texture and generates texture maps ready for a PBR engine of your choice.
- :moneybag: [PixPlant](http://www.pixplant.com/) - PixPlant is a smart 3D texturing tool that creates high quality normal, displacement, specular maps and seamless textures from photos.

#### Character Generators

- :free: [Charas](http://charas-project.net/index.php) - Charas is a charset generator for RPG Maker.

#### Tile/Level Editors

- :moneybag: [AutoTileGen](http://pixelatto.com) - AutoTileGen is an automatic tileset generator for 2D game terrains.
- :tada: [LDtk](https://deepnight.net/tools/ldtk-2d-level-editor/) - LDtk is an open-source 2D level editor for indie devs, with a strong focus on user-friendliness.
- :money_with_wings: [MapperMate](https://mappermate.com/) - A cloud based tile map editor used to create 2D levels directly in the browser.
- :tada: [Material Maker](https://github.com/RodZill4/material-maker) - procedural texture creator made in Godot
- :tada: [OGMO Editor](https://ogmo-editor-3.github.io/)- generic level editor.
- :tada: [Overlap2D](https://github.com/UnderwaterApps/overlap2d/) - a 2D level and UI editor with an engine agnostic philosophy.
- :free: [Sprite Fusion](https://spritefusion.com/) - A free level design tool to craft beautiful 2D tilemaps right in your browser using any tileset.
- :tada: [Tiled](http://www.mapeditor.org/) - free, easy to use and flexible tile map editor.

#### Animation

- :money_with_wings: [Cascadeur](https://cascadeur.com/) - Powerful physics-based 3D character animation
- :tada: [LWF](http://gree.github.io/lwf/) - Lightweight SWF. LWF is an animation engine which can play animation data converted from FLASH contents in HTML5, Unity, Cocos2d-x, iOS UIKit, and more.
- :moneybag: [Fusion Character Animator](http://loopengo.free.fr/) - small tool for Clickteam Fusion 2.5 to facilitate the animation of 2D character sprites for developers.
- 🆓 [GraphicsDale](https://graphicsgale.com/us/) - Powerful tool for spriting and pixel art.
- :moneybag: [Mixamo](https://www.mixamo.com/#/) - tool for auto auto rigging and animation of 3D humanoid models,
- :tada: [Pixel Composer](https://github.com/Ttanasart-pt/Pixel-Composer) - Powerful node-based VFX editor for pixel art
- :moneybag: [Spine](http://esotericsoftware.com/) - Spine is dedicated to 2D animation, providing an efficient workflow both for creating amazing animation and for integrating it into your games.
- :moneybag: [Spriter Pro](https://brashmonkey.com/download-spriter-pro/) - Modern tool for sprite animation.

#### Vector/Image Editor

- :moneybag: [Affinity Designer](https://affinity.serif.com/de/designer) - Vector graphics editor with a bunch of features which also supports Adobe file formats
- :moneybag: [Affinity Photo](https://affinity.serif.com/de/photo) - Photo and raster graphics editor which works together with Adobe file formats and Affinity Designer
- :money_with_wings: [Aseprite](http://www.aseprite.org/) - animated sprite editor & pixel art tool.
- :tada: [Gimp](http://www.gimp.org/) - GNU Image Manipulation Program. It is a freely distributed piece of software for such tasks as photo retouching, image composition and image authoring.
- :tada: [Inkscape](https://inkscape.org/en/) - An open-source vector graphics editor similar to Adobe Illustrator, Corel Draw, Freehand, or Xara X.
- :tada: [Krita](https://krita.org/) - Krita is a professional FREE and open source painting program. It is made by artists that want to see affordable art tools for everyone.
- :tada: [LibreSprite](https://libresprite.github.io/) - LibreSprite is an open source fork of Aseprite.
- :moneybag: [Lightcube](https://www.lightcube.art/) - Pixel Art Editor for Windows, supposed PSD files in addition to JPEG, PNG, BMP, GIF.
- :free: [Multipaint](http://multipaint.kameli.net) - A cross-platform (Win, Linux, Mac) image editor/painter which covers the color limitations of 8-bit machines (like C64, ZX Spectrum etc.)
- :money_with_wings: [Paint.NET](http://www.getpaint.net/) - Paint.NET is free image and photo editing software for PCs that run Windows.
- :moneybag: [Pickle](http://www.pickleeditor.com/) - Another Pixel art Editor.
- :tada: [PiskelApp](http://www.piskelapp.com/) - Free Online Pixel Art and Animated Sprite Tool.
- :moneybag: [Pixelmator](http://www.pixelmator.com) - Full-featured image editing app for the Mac
- :moneybag: [Pixelator](http://pixelatorapp.com) - Turn any image into fancy pixel-art
- :moneybag: [Pixen](https://github.com/Pixen/Pixen) - Pixel Art Editor for OSX
- :free: [project one](http://p1.untergrund.net) - A picture converter and editor for the Commodore 64 covering different graphics mode of this computer. Windows only
- :moneybag: [PyxelEdit](http://pyxeledit.com/) - Pixel art editor designed to make it fun and easy to make tilesets, levels and animations.
- :free: [REXPaint](https://www.gridsagegames.com/rexpaint/) - a powerful and user-friendly ASCII art editor.
- :tada: [rx](https://rx.cloudhead.io/) - a modern & minimalist pixel editor
- :free: [Tilemancer](https://led.itch.io/tilemancer) - A quick procedural tile creator designed for pixel-art games.
- :free: [Timanthes](http://csdb.dk/release/?id=75871) - A pixel art editor for the Commodore 64 computer running on Windows
- :free: [Charas](http://charas-project.net/index.php) - Charas is a charset generator for RPG Maker.
- :free: [Spritemate](http://www.spritemate.com) - Online Editor for Commodore 64 Sprites
- :tada: [SVGcode](https://svgco.de/) - SVGcode is a Progressive Web App that lets you convert raster images like JPG, PNG, GIF, WebP, AVIF, etc. to vector graphics in SVG format.
- :money_with_wings: [Vector Magic](https://vectormagic.com/) - Free Raster to Vector Graphics Converter
- :tada: [VTracer](https://www.visioncortex.org/vtracer/) - Raster to Vector Graphics Converter built on top of visioncortex

#### Modeling

- :moneybag: [3ds Max](http://www.autodesk.com/products/3ds-max/overview)
- :money_with_wings: [Besel](https://www.bezel.it/hq) - Make a 3d real-time collaboration design and prototype in your VR headset or mobile AR.
- :tada: [Blender](http://www.blender.org/) - The free software and open-source 3D grate of the world
- :free [Canvascript](https://github.com/VBproDev/Canvascript) - A tool for creating HTML canvas graphics without writing code.
- :free: [Clara.io](https://clara.io/)
- :money_with_wings: [Daz 3D](https://www.daz3d.com/) - A 3D software allows you to easily create custom scenes and characters in seconds.
- :free: [MakeHuman](http://www.makehumancommunity.org/)
- :moneybag: [Maya](http://www.autodesk.com/products/maya/overview)
- :moneybag: [modo](https://www.foundry.com/products/modo)
- :free: [sculptris](https://sculptris.br.uptodown.com/windows) - A version by Pixologic and the original [1.01](https://www.moddb.com/downloads/sculptris)
- :money_with_wings: [Spline](https://spline.design/) - A 3d collaborative real-time
- :free: [Womp](https://womp.com/) - A 3D intuitive and easy to use for create right in your browser
- :moneybag: [ZBrush](https://pixologic.com/)
- :free: [ZBRUSHCOREMINI](https://www.maxon.net/en/zbrushcoremini) - The new version of sculptris by MAXON

#### Terrain Generators

- :free: [Canyon Terrain Editor](https://entardev.wordpress.com/other-projects/canyon-terrain-editor/) - Create quality, realistic terrain quickly and intuitively
- :tada: [DEM Net Elevation API](https://elevationapi.com) - Live 3D textured terrain generation from real data - export height/normal maps, glTF, OBJ, STL
- :tada: [Fracplanet](https://sourceforge.net/projects/fracplanet/) - Fractal planet and terrain generator
- :moneybag: [World Creator](https://www.world-creator.com/) - Procedural terrain and landscape generation on the GPU in real time, simulation of erosion and sediment, beautiful editor. much more
- :moneybag: [World Machine](http://www.world-machine.com/) - Procedural terrain creation, simulations of nature, and interactive editing

#### Voxel Editors

- :tada: [goxel](https://github.com/guillaumechereau/goxel)
- :free: [MagicaVoxel](https://ephtracy.github.io/)
- :free: [Sproxel](http://sproxel.blogspot.com.br/)

## Code

_Set of game frameworks, engines and platforms_

### Engines and Frameworks

- :tada: [6502 Unit Test executor](https://github.com/AsaiYusuke/6502_test_executor) - A cross-platform unit testing tool for MOS 6502 assembly. (i.e. NES)
- :tada: [Allegro](http://liballeg.org/) - Allegro 4 & 5 are cross-platform, open source, game programming libraries, primarily for C and C++ developers.
- :tada: [amulet](http://www.amulet.xyz/) - A free Lua-based audio/visual toolkit suitable for small games and experimentation. It runs on Windows, Mac, Linux, HTML5 and iOS.
- :tada: [asimov-ts](https://github.com/pedrozaalex/asimov-ts) - A type safe (as much as possible) engine for the web written in TypeScript.
- :tada: [Astera](https://github.com/tek256/astera) - 2D C99 Cross Platform Game Library / Framework
- :tada: [axys](https://github.com/axys1/axys) - A fork of Cocos2d-x-4.0, it has Full Support OpenAL for all platforms, single texture multi GPU texture handler and C++ 17.
- :tada: [Azul3D](http://azul3d.org/) - A 3D engine written in Go.
- :tada: [Babylon.js](https://www.babylonjs.com/) - Javascript 3D Library.
- :tada: [Bevy](https://bevyengine.org/) - A refreshingly simple data-driven game engine built in Rust
- :tada: [bgfx](https://github.com/bkaradzic/bgfx) - Cross-platform, graphics API agnostic, "Bring Your Own Engine/Framework" style rendering library.
- :tada: [bitsy](https://ledoux.itch.io/bitsy) - A little editor for little games or worlds. The goal is to make it easy to make games where you can walk around and talk to people and be somewhere.
- :tada: [Bladecoder](https://github.com/bladecoder/bladecoder-adventure-engine) - Classic point and click adventure game engine and editor.
- :money_with_wings: [Blend4Web](http://www.blend4web.com/) - A Javascript framework for creating and displaying interactive 3D computer graphics in web browsers.
- :tada: [Blitz3D](https://github.com/blitz-research/blitz3d) 3D basic-like programming language for fast 3D desktop games.
- :tada: [boardgame.io](https://github.com/boardgameio/boardgame.io) - State management and multiplayer networking for turn-based games.
- :tada: [Box2D](http://box2d.org/) - A 2D Physics Engine for Games.
- :tada: [Bullet](http://bulletphysics.org/wordpress/) - Real-time physics simulation.
- :tada: [Chipmunk C#](https://github.com/netonjm/ChipmunkSharp) - C# implementation of the Chipmunk2D lib.
- :tada: [Chipmunk2D](https://chipmunk-physics.net/) - A fast and lightweight 2D game physics library.
- :tada: [Cinder](https://libcinder.org/) - Cinder is a community-developed, free and open source library for professional-quality creative coding in C++.
- :free: [Cocos Creator](https://www.cocos.com/en/creator) - Cocos Creator, a free cross-platform game development editor supporting Cocos2d-js, helps developers build 2D and 3D game scenes, edit game UI and other game resources quickly and efficiency.
- :tada: [Cocos2D](https://github.com/los-cocos/cocos) - graphic library for games and multimedia, for python language
- :tada: [Cocos2d-x](http://cocos2d-x.org/) - a C++ OpenGL 2D and 3D game engine. Uses C++ but has JS and Lua bindings. Target all the major mobile platforms and operating systems. Additional tools CocoStudio and Cocos Code IDE.
- :moneybag: [Construct](https://www.scirra.com/) - an HTML5 game maker, meaning you are not actually writing JavaScript. Instead, you use actions, events and conditions to do the heavy lifting.
- :money_with_wings: [CopperCube](http://www.ambiera.com/coppercube/) - CopperCube is an all-in-one 3D game engine.Very easy to use.
- :tada: [Coquette](http://coquette.maryrosecook.com/) - A micro framework for JavaScript games. Handles collision detection, the game update loop, canvas rendering, and keyboard and mouse input.
- :tada: [ct.js](https://ctjs.rocks/) — this 2D game engine makes learning programming fun and game development easy by its visual tools, good docs, and flexible, modular library.
- :tada: [Dash](https://github.com/Circular-Studios/Dash) - A free and open 3D game engine written in D.
- :tada: [Dear Imgui](https://github.com/ocornut/imgui/) - A bloat-free immediate mode GUI for C++ with minimal dependencies.
- :tada: [Defold](http://www.defold.com/) - Free 2D Game Engine for Cross-Platform Publishing
- :tada: [DEM Net Elevation API C#](https://github.com/dem-net/DEM.Net) - Terrain generation from real data with textures, normal maps, glTF, OBJ, STL support
- :tada: [Diligent Engine](https://github.com/DiligentGraphics/DiligentEngine) - A modern cross-platform low-level graphics library that supports Direct3D11, Direct3D12, OpenGL/GLES, and Vulkan.
- :tada: [DotRecast](https://github.com/ikpil/DotRecast) - A port of Recast & Detour, navigation mesh toolset for games, Unity3D, servers, C#.
- :tada: [E.B.U.R.P](http://pents90.github.io/eburp/) - The Eight-Bit Universal Role Playing Engine
- :tada: [ENGi](https://github.com/ajhager/engi) - A multi-platform 2D game library for Go.
- :tada: [engo](https://engoengine.github.io/) - Engo is an open-source 2D game engine written in Go.
- :tada: [Ebiten](https://ebiten.org/) - A dead simple 2D game library in Go.
- :tada: [ecs-lib](https://github.com/nidorx/ecs-lib#readme) - **ecs-lib** is a tiny and easy to use ECS (Entity Component System) library for game programming. It's written in Typescript but you can use on node.js and web browser too.
- :tada: [Ejecta](http://impactjs.com/ejecta) - A Fast, Open Source JavaScript, Canvas & Audio Implementation for iOS.
- :tada: [EnTT](https://github.com/skypjack/entt) - Gaming meets modern C++, a fast and reliable entity-component system (ECS) and much more
- :tada: [FXGL](https://github.com/AlmasB/FXGL) - A JavaFX/Kotlin game engine for Win/Mac/Linux.
- :tada: [Farseer](https://github.com/VelcroPhysics/VelcroPhysics) - a collision detection system with realistic physics responses.
- :tada: [Flame](https://github.com/flame-engine/flame) - a minimalist game engine for Flutter
- :tada: [FlashPunk](http://useflashpunk.net/) - free ActionScript 3 library designed for developing 2D Flash games.
- :tada: :money_with_wings: [Flax Engine](https://flaxengine.com/) - multi-platform 3D game engine
- :tada: [Foster](https://github.com/FosterFramework/Foster) - A small cross-platform 2D game framework in C#.
- :money_with_wings: [GameMaker](https://gamemaker.io/) - GameMaker accommodates the creation of cross-platform video games using drag and drop or a scripting language known as Game Maker Language, which can be used to develop more advanced games that could not be created just by using the drag and drop features.
- :tada: [gameplay](http://gameplay3d.io/) - A free, open-source, cross-platform, 2D + 3D game framework written in C++. It is aimed towards indie game developers who are creating desktop and mobile games.
- :money_with_wings: [GameSalad](https://gamesalad.com/) - Game Creation Engine for Mac and Windows.
- :tada: [GB Studio](https://www.gbstudio.dev/) - A free and easy to use retro adventure game creator for your favourite handheld video game system.
- :tada: [GDevelop](https://gdevelop-app.com/) - An open-source, cross-platform 2D game engine designed for everyone - it's extensible, fast and easy to learn.
- :tada: [ggez](http://ggez.rs/) - A Rust library to create Good Games Easily.
- :tada: [Gideros](http://giderosmobile.com/) - A Cross-Platform framework to create Mobile Apps and games for iOS, Android using Lua programming language.
- :tada: [Glide Engine](https://github.com/cocoatoucher/Glide) - Engine for making 2d games on iOS, macOS and tvOS in Swift programming language, with practical examples and tutorials.
- :tada: [Godot](http://www.godotengine.org/) - An advanced, feature-packed, multi-platform 2D and 3D open-source game engine.
- :tada: [Gorgon](https://www.tape-worm.net/) - A 2D rendering API for .NET, written in C#.
- :tada: [Grid](https://github.com/Planimeter/game-engine-2d) - A multiplayer-first game engine for Lua.
- :tada: [HaxeFlixel](http://haxeflixel.com/) - Create cross-platform games easier and free.
- :tada: [Heaps](https://heaps.io/) - Cross platform graphics for high performance games.
- :tada: [Horde3D](http://www.horde3d.org/) - small open source 3D rendering engine.
- :tada: [iio.js](https://github.com/iioinc/iio.js) - A javascript library that speeds the creation and deployment of HTML5 Canvas applications
- :tada: [ImpactJS](http://impactjs.com/) - Impact is a JavaScript Game Engine that allows you to develop stunning HTML5 Games for desktop and mobile browsers.
- :free: [Inform7](http://inform7.com/) - A design system for interactive fiction based on natural language.
- :tada: [Ink](http://www.inklestudios.com/ink/) - Scripting language for writing interactive narrative.
- :tada: [Irrlicht](http://irrlicht.sourceforge.net/) - open source high performance realtime 3D engine written in C++.
- :tada: [Jitter](https://github.com/mattleibow/jitterphysics) - a fast and lightweight physics engine written in C#.
- :tada: [jMonkeyEngine 3](http://jmonkeyengine.org/) - a 3D open-source game engine for adventurous Java developers.
- :tada: [JNGL](https://github.com/jhasse/jngl) - a 2D open-source game engine. Develop on Linux, Windows, OS X. Deploy to Nintendo Switch, Xbox, Linux, Windows, OS X, Web, Android, iOS and more.
- :free: [JPCT](https://www.jpct.net/) - jPCT is a 3D engine for desktop Java and Google's Android.
- :tada: [Juno](https://github.com/digitsensitive/juno) - Clean and lightweight 2D game framework written in TypeScript
- :tada: [Juno](https://github.com/rxi/juno) - Framework for making 2D games with chunky pixels in Lua
- :tada: [Kivent](http://kivent.org/) - A 2D game framework for Kivy.
- :tada: [Kivy](http://kivy.org) - Cross platform Python framework for creating apps and games for Linux, Windows, OS X, Android and iOS
- :tada: [KogGE](https://korge.soywiz.com) - Modern Multiplatform Game Engine for Kotlin. Write games for the JVM, JavaScript, Android and iOS in no time using Kotlin.
- :money_with_wings: [Leadwerks](https://www.leadwerks.com/) - Easy-to-learn game engine for 3D and VR.
- :tada: [LibGDX](https://libgdx.com/) - Powerful (totally free) library for Java, code once and run the game on desktop, Android, Web, and iOS.
- :tada: [LimeJS](http://www.limejs.com/) - HTML5 game framework for building fast, native-experience games for all modern touchscreens and
- :tada: [LITIengine](http://litiengine.com/) - 2D Java Game Engine. It provides all the infrastructure to create tile based 2D games with plain java
- :free: [Lumberyard](https://aws.amazon.com/lumberyard/) - Amazon Lumberyard is a free AAA game engine deeply integrated
- :tada: [LumixEngine](https://github.com/nem0/LumixEngine) - 3D Game engine built on C++.
- :tada: [Lums](https://github.com/lums-proj/Lums) - A 2D / 3D framework written in C++11. Very efficient and modern. Still under heavy development.
- :tada: [LÖVE](http://love2d.org) - Lua 2D Game Engine.
- :tada: [MINX](https://github.com/GearChicken/MINX) - Open Source 2D game framework written in C++ (to the style of XNA)
- :tada: [macroquad](https://github.com/not-fl3/macroquad) - The cross-platform game engine in Rust.
- :tada: [mach](https://machengine.org/) - game engine & graphics toolkit build in zig.
- :tada: [Magnum](http://magnum.graphics/) - a lightweight and modular 2D/3D graphics/game engine written in C++11
- :tada: [Matter.js](http://brm.io/matter-js/) - a 2D physics engine for the web.
- :tada: [MelonJS](http://melonjs.org) - open source light-weight HTML5 game engine.
- :free: [Mini Micro](https://miniscript.org/MiniMicro/) - Mini Micro is a fantasy computer for making, playing and sharing 2D games and programs written in the modern [MiniScript](https://miniscript.org) language.
- :tada: [Monogame](http://www.monogame.net/) - Open Source implementation of the Microsoft XNA 4 Framework.
- :tada: [Nakama](https://github.com/heroiclabs/nakama) - Distributed server for social and realtime games and apps.
- :tada: [nCine](https://ncine.github.io/) - A cross-platform 2D game engine with an emphasis on performance, written in C++11 and optionally scriptable in Lua.
- :free: [NodeBox](https://www.nodebox.net/) - a family of Python tools to create generative design.
- :tada: [nuklear](https://github.com/Immediate-Mode-UI/Nuklear) - A single-header ANSI C immediate mode cross-platform GUI library.
- :tada: [ÖbEngine](https://github.com/Sygmei/ObEngine) - 2D Game Engine with Lua Scripting made on top of SFML !
- :tada: [ODE](http://www.ode.org/) - ODE is an open source, high performance library for simulating rigid body dynamics.
- :tada: [Ogre3D](http://www.ogre3d.org/) - is a scene-oriented, real-time, flexible 3D rendering engine (as opposed to a game engine) written in C++.
- :tada: [OpenFL](http://www.openfl.org/) - Open Source Haxe Engine for making multi-platform games.
- :tada: [openFrameworks](https://openframeworks.cc/) - An open source and free C++ toolkit for creative coding.
- :tada: [OpenRA](http://www.openra.net/) - OpenRA is a Libre/Free Real Time Strategy Game Engine.
- :tada: [OpenXRay](https://github.com/OpenXRay/xray-16) - a community-modified X-Ray engine used in S.T.A.L.K.E.R. game series.
- :tada: [ORX](https://orx-project.org/) - ORX is a 2.5D Data-driven C/C++ open source & multi-platform game development engine.
- :moneybag: [PICO-8](http://www.lexaloffle.com/pico-8.php) - A fantasy console for making, sharing and playing tiny games and other computer programs.
- :tada: [p2.js](http://schteppe.github.io/p2.js/) - JavaScript 2D physics library
- :tada: [Panda3D](https://www.panda3d.org/) - a framework for 3D rendering and game development for Python and C++ programs.
- :tada: [Phaser](http://phaser.io/) - free and fast 2D game framework for making HTML5 games for desktop and mobile web browsers, supporting Canvas and WebGL rendering.
- :tada: [Piston](http://www.piston.rs/) - a modular open source game engine written in Rust.
- :tada: [Pixel Vision 8](https://github.com/PixelVision8/PixelVision8) - Pixel Vision 8's core philosophy is to teach retro game development with streamlined workflows. PV8 is also a platform that standardizes 8-bit fantasy console limitations built on top of the open-source C# game engine based on MonoGame.
- :tada: [PixiJS](http://www.pixijs.com/) - is a newcomer HTML5 game renderer - first released in early 2013. A main appeal of the engine is its use of WebGL for faster performance. If WebGL isn't supported, the engine falls back to standard canvas.
- :tada: [Planck.js](http://piqnt.com/planck.js/) - 2D JavaScript physics engine for cross-platform HTML5 game development.
- :money_with_wings: [PlayCanvas](https://playcanvas.com/) - A WebGL Game Engine.
- :tada: [Processing](https://www.processing.org/) - Processing is a programming language, development environment for artists, designers, researchers.
- :tada: [PuzzleScript](http://www.puzzlescript.net/) - open-source HTML5 puzzle game engine.
- :tada: [PyGame](http://pygame.org/hifi.html) - a 2D game engine in Python.
- :tada: [Pyxel](https://github.com/kitao/pyxel) - a retro game engine for Python.
- :moneybag: [RPGMaker](http://www.rpgmakerweb.com/) - series of programs for the development of role-playing games.
- :tada: [Rajawali](https://github.com/Rajawali/Rajawali) - Android OpenGL ES 2.0/3.0 Engine
- :tada: [raylib](https://www.raylib.com/) - a simple and easy-to-use library to enjoy videogames programming, hardware accelerated with OpenGL (1.1, 2.1, 3.3 or ES 2.0)
- :tada: [Ren'Py](http://www.renpy.org/) - An open-source visual novel engine using the Python language in simplified form. It supports Windows, Mac OS X, Linux, Android and iOS.
- :tada: [RGFW](https://github.com/ColleagueRiley/RGFW) - Lightweight multi-platform single-header library for creating windows, supports many graphics contexts and software rendering.
- :tada: [Rpgboss](http://rpgboss.com) - A 2d rpg game engine and editor based on scala and libgdx. Ease of use, with no programming knowledge.
- :free: [SceneKit](https://developer.apple.com/documentation/scenekit) - Apple proprietary 3D game engine (available on macOS, iOS, iPadOS, tvOS and watchOS).
- :tada: [Screen 13](https://github.com/attackgoat/screen-13) - An easy-to-use Vulkan rendering engine. Provides a render graph for Rust.
- :tada: [SDL](http://libsdl.org/) - SDL is a cross-platform library designed to provide low level access to audio, keyboard, mouse, joystick, and graphics hardware via OpenGL and Direct3D.
- :tada: [SFML](http://www.sfml-dev.org/) - Simple and Fast Multimedia Library.
- :tada: [Solar2D](https://solar2d.com/) - A Lua based game engine with focus on ease of iterations and usage.
- :tada: [Solarus](https://www.solarus-games.org/) - Cross-platform 2D Action/Adventure C++ game engine with Lua API and game editor.
- :tada: [Spring](http://springrts.com/) - A powerful free cross-platform RTS engine.
- :free: [SpriteKit](https://developer.apple.com/documentation/spritekit) - Apple proprietary 2D game engine (available on macOS, iOS, iPadOS, tvOS and watchOS).
- :tada: [Stage.js](http://piqnt.com/stage.js/) - Lightweight and fast 2D HTML5 rendering and layout engine for cross-platform game development.
- :tada: [Starling](http://gamua.com/starling/) - The GPU powered 2D Flash API
- :money_with_wings: [Stencyl](http://www.stencyl.com/) - a game creation platform that allows users to create 2D video games for computers, mobile devices, and the web.
- :tada: [Stride](https://stride3d.net/) - Open Source C# Game Engine.
- :tada: [Supernova Engine](https://supernovaengine.org/) - Cross-platform game engine for 2D and 3D projects with entity component system (ECS) and data-oriented design in C++ and Lua.
- :tada: [Superpowers](https://sparklinlabs.itch.io/superpowers) - HTML5 Collaborative 2D/3D Game Maker
- :tada: [TIC-80](https://tic.computer/) - TIC-80 is a fantasy computer for making, playing and sharing tiny games.
- :tada: [Tiny Physics Engine](https://codeberg.org/drummyfish/tinyphysicsengine/) - TPE is a small, completely public domain fixed point physically inaccurate pure C header-only 3D physics engine built to run on tiny computers such as embedded and even bare metal.
- :tada: [Three.js](http://threejs.org/) - Javascript 3D Library.
- :tada: [Turbulenz](http://biz.turbulenz.com/developers) - Turbulenz offers the ability to build, publish, iterate and monetise high-quality games that react like no others, with immersive 3D effects and real-time physics that open up a whole new world of unprecedented and extraordinary web content.
- :tada: [Twine](http://twinery.org/) - Downloadable or browser-based game development platform that allows users to create linked story paths. Not just text-based, Twine supports music, images, and sound effects. Very little coding knowledge required for basic text adventure games.
- :money_with_wings: [Unity 3D](http://unity3d.com/) - A development engine for the creation of 2D and 3D games and interactive content.
- :money_with_wings: [Unreal Engine 4](https://www.unrealengine.com/) - the new game engine technology developed by Epic Games.
- :tada: [Urho3D](http://urho3d.github.io/) - Cross-platform rendering and game engine.
- :tada: [ursina](https://www.ursinaengine.org/) - A game engine powered by python and panda3d.
- :tada: [Vassal](http://www.vassalengine.org/) - Vassal is a game engine for building and playing online adaptations of board games and card games. Play live on the Internet or by email. Vassal runs on all platforms, and is free, open-source software.
- :tada: [voxel.js](http://voxeljs.com/) - voxel.js is a collection of projects that make it easier than ever to create 3D voxel games like Minecraft all in the browser.
- :tada: [Wave](http://waveengine.net/) - Cross-platform engine written in C#.
- :tada: [Wolf RPG Editor English](https://widderune.wixsite.com/widderune/wolf-rpg-editor-english) - open source editor for RPG Maker style gamesl
- :tada: [WhiteStorm.js](https://github.com/WhitestormJS/whitestorm.js) - 3d javacript framework for building apps and games

### AI

- :tada: [Fluent Behaviour Tree](https://github.com/codecapers/Fluent-Behaviour-Tree) - C# behaviour tree library with a fluent API released under MIT.
- :tada: [SimpleAI](https://github.com/mgerhardy/simpleai/) - C++11 behaviour tree based library with a QT5 based remote debugger (and with optional LUA bindings) released under MIT.

## Audio

_Audio editors, sounds collections and more._

### Collections

- :free: [Free Game Sounds](https://gamesounds.xyz/) - Archive of all kinds of royalty-free game sounds.
- :free: [Freesound](http://www.freesound.org/) - collaborative database of Creative Commons Licensed sounds.
- :free: [Musopen](https://musopen.org/) - Royalty free music.
- :free: [Octave](http://raisedbeaches.com/octave/index.html) - free library of UI sounds.
- :free: [PacDV](http://www.pacdv.com/sounds/index.html) - royalty free sounds collection.
- :free: [SoundBible.com](http://soundbible.com/) - Royalty-free, searchable archive of sound effects under various licenses.

### Music and Audio Editors

- :tada: [Audacity](http://sourceforge.net/projects/audacity/) - open source, cross-platform software for recording and editing sounds.
- :free: [Audiosauna](http://www.audiosauna.com/) - transforms your web browser into a fast and flexible music production studio with built in synthesizers and live effects.
- :free: [Audiotool](http://www.audiotool.com/app) - Online music producer.
- :free: [Bfxr](https://www.bfxr.net/) - A tool to make sound effects for computer games.
- :free: [Bosca Ceoil](http://boscaceoil.net/) - Online (and also desktop) music producer made by Terry Cavanagh. Simple, intuitive, has a distinctive retro-ish sound.
- :free: [ChipTone](http://sfbgames.com/chiptone/) - Online sound effect generator
- :free: [Famistudio](https://github.com/BleuBleu/FamiStudio) - FamiStudio NES Music Editor.
- :free: [FamiTracker](https://github.com/Dn-Programming-Core-Management/Dn-FamiTracker) - free windows tracker for producing music for the NES/Famicom-systems.
- :tada: [jfxr](http://jfxr.frozenfractal.com) - A JavaScript port of the Bfxr sound effect generator.
- :tada: [LMMS](https://lmms.io/) - Cross-platform music production software.
- :free: [MadTracker](http://www.madtracker.org/main.php) - a powerful and efficient approach to making music. Versatility and compatibility are guaranteed due to full VST™, ASIO™ and ReWire™ support.
- :tada: [MilkyTracker](https://github.com/milkytracker/MilkyTracker) - open source tracker for Mac/Linux/Windows platforms.
- :tada: [musagi](http://www.drpetter.se/project_musagi.html) - open source, fairly large and sophisticated music editor and synthesizer
- :moneybag: [Resemble](https://www.resemble.ai/unity) - Resemble's voice cloning engine within Unity
- :free: [Soundation](https://soundation.com/) - Online Professional music studio.
- :free: [SunVox](http://www.warmplace.ru/soft/sunvox/) - a small, fast and powerful modular synthesizer with pattern-based sequencer (tracker).

## Board Games

_Tools for making board games_

- :free: [Iterary](http://www.iterary.com) - Board Game Design Tool.
- :tada: [RPTools](http://www.rptools.net/) - a brand of open-source programs designed to enhance traditional pen-and-paper role playing games.

## Must see

_Blogs, portals, magazines and more_

### Blogs and Portals

- [Amit's Game Programming](http://www-cs-students.stanford.edu/~amitp/gameprog.html)
- [Designer Notes](http://www.designer-notes.com/)
- [Emanuele Feronato's Blog](http://www.emanueleferonato.com/)
- [GameIdea](https://gameidea.org)
- [Gamasutra](http://www.gamasutra.com/)
- [Game Development on StackExchange](http://gamedev.stackexchange.com/)
- [GameDevs.org](http://gamedevs.org/)
- [GameJolt](http://gamejolt.com/)
- [Greenlit Gaming](http://greenlitgaming.com/)
- [HTML5 Game Devs Forum](http://www.html5gamedevs.com/)
- [HobbyGameDev](http://www.hobbygamedev.com/)
- [Html5 Game Development](http://www.html5gamedevelopment.com/)
- [IndieDB](http://www.indiedb.com/)
- [Mod DB](http://www.moddb.com/)
- [Java Gaming](http://www.java-gaming.org/)
- [Lost Garden](http://www.lostgarden.com/)
- [Polygon](http://www.polygon.com/)
- [Real-Time Rendering](http://www.realtimerendering.com/)
- [Slidedb](http://www.slidedb.com/) - On Slide DB we give developers a community they can share their ideas with and showcase the work they are doing, beyond the basic app stores and the highly contested "top charts".
- [Superlevel](https://superlevel.de/)
- [TIGSource](http://www.tigsource.com/)
- [WhatGamesAre](http://www.whatgamesare.com/featured-posts.html)
- [iforce2d](http://www.iforce2d.net/)
- [indiegames](http://indiegames.com/index.html)

### Books

- :free: [2D Game Development: From Zero To Hero](https://gitlab.com/Penaz/2dgd_f0th)

* [3D Math Primer for Graphics and Game Development](http://www.amazon.com/Math-Primer-Graphics-Game-Development/dp/1568817231/)
* [Artificial Intelligence for Games](http://www.amazon.com/dp/0123747317?tag=game-prog-books-20)
* [Designing Games: A Guide to Engineering Experiences](https://www.amazon.com/Designing-Games-Guide-Engineering-Experiences/dp/1449337937)
* [Essential Mathematics for Games and Interactive Applications: A Programmer's Guide](http://www.amazon.com/Essential-Mathematics-Games-Interactive-Applications/dp/0123742978/)
* [Flow](http://www.amazon.com/Flow-The-Psychology-Optimal-Experience/dp/0061339202/)
* [Game Coding Complete](http://www.amazon.com/Game-Coding-Complete-Fourth-McShaffry/dp/1133776574/)
* [Game Development Essentials: Game Level Design](http://www.goodreads.com/book/show/1633392.Game_Development_Essentials)
* [Game Engine Architecture](http://www.gameenginebook.com/)
* [Game Mechanics: Advanced Game Design](http://www.goodreads.com/book/show/13705461-game-mechanics)
* [Game Programming Gems](http://www.amazon.com/Game-Programming-Gems-CD/dp/1584500492)
* [Game Programming Patterns](http://gameprogrammingpatterns.com/)
* [Game Scripting Mastery](http://www.amazon.com/Scripting-Mastery-Premier-Press-Development/dp/1931841578)
* [Geometry for Programmers (book)](https://www.manning.com/books/geometry-for-programmers)
* [Hello Scratch: Learn to Program by Making Arcade Games](https://www.manning.com/books/hello-scratch)
* [Level Up!](http://www.amazon.com/dp/047068867X?tag=game-prog-books-20)
* [Making Games with Python & Pygame](http://inventwithpython.com/pygame/)
* [Mathematics For 3D Game Programming And Computer Graphics](http://www.amazon.com/dp/1435458869?tag=game-prog-books-20)
* [Nature of Code](http://natureofcode.com/book/)
* [Physics for Game Developers](http://www.amazon.com/Physics-Game-Developers-David-Bourg/dp/0596000065)
* [Programming Game AI by Example](http://www.amazon.com/dp/1556220782?tag=game-prog-books-20)
* [Real-Time Rendering](http://www.amazon.com/Real-Time-Rendering-Third-Edition-Akenine-Moller/dp/1568814240/)
* [Rules of Play](http://www.amazon.com/Rules-Play-Game-Design-Fundamentals/dp/0262240459/)
* [The Art of Game Design](http://www.amazon.com/The-Art-Game-Design-lenses/dp/0123694965/)
* [The Ultimate Guide to Video Game Writing and Design](http://www.goodreads.com/book/show/391752.The_Ultimate_Guide_to_Video_Game_Writing_and_Design)
* [The Visual Story](http://www.amazon.com/The-Visual-Story-Creating-Structure/dp/0240807790/)
* [Theory of Fun](http://www.amazon.com/Theory-Game-Design-Raph-Koster/dp/1449363210/)
* [Tricks of the Windows Game Programming Gurus](http://www.amazon.com/Tricks-Windows-Game-Programming-Gurus/dp/0672313618)
* [Unity in Action (book)](https://www.manning.com/books/unity-in-action-second-edition)
* [Learn OpenGL: Beginner's guide to 3D rendering and game development with OpenGL and C++](https://www.amazon.de/Learn-OpenGL-Beginners-rendering-development/dp/1789340365/ref=sr_1_1_sspa?__mk_de_DE=%C3%85M%C3%85%C5%BD%C3%95%C3%91&keywords=OpenGl+3d+game&qid=1570646865&sr=8-1-spons&psc=1&spLa=ZW5jcnlwdGVkUXVhbGlmaWVyPUExTzM3UzZDT1ZYUzdCJmVuY3J5cHRlZElkPUEwMDIzMjkxMzJENlFTWkJNQzVCNCZlbmNyeXB0ZWRBZElkPUEwMzgyNTgzMUdUOElZTUtNUjlONCZ3aWRnZXROYW1lPXNwX2F0ZiZhY3Rpb249Y2xpY2tSZWRpcmVjdCZkb05vdExvZ0NsaWNrPXRydWU=)

### Magazines

- :free: [Game Developer Magazine](http://www.gdcvault.com/gdmag)
- :free: [IndieMag](https://www.indiemag.fr/)

### Videos/Podcasts

- [awesome-gametalks](https://github.com/hzoo/awesome-gametalks) - A curated list of game talks (GDC, youtube, etc).
- [Twitch GameDev](http://www.twitch.tv/directory/game/Game%20Development) - Twitch GameDev Streams

### Game Jams

- [Game jams on itch.io](https://itch.io/jams) - Listing of itch.io game jams
- [Game Off](https://gameoff.github.com) - GitHub's game jam :octocat:
- [GMTK Game Jam](https://itch.io/jam/gmtk-jam-2022) - Popular yearly game jam
- [Indie Game Jams](http://www.indiegamejams.com/) - Listing of game jams
- [Ludum Dare](http://ludumdare.com/) - very popular game jam
- [One Hour Game Jam](http://onehourgamejam.com/) - Weekly 1 hour game jam

### Project Management

- :moneybag: [Casual](https://casual.pm/) - Visual Project Management
- :money_with_wings: [Codecks](https://www.codecks.io) - Project Management Tool inspired by Collectible Card Games
- :money_with_wings: [HacknPlan](http://hacknplan.com/) - Project management for game developers
- :money_with_wings: [Taiga](https://taiga.io/) - Project management platform for agile developers & designers
- :money_with_wings: [Trello](https://trello.com/) - Organize and prioritize projects

### Complete Game Sources

- :tada: [Barotrauma](https://github.com/Regalis11/Barotrauma)
- :tada: [Canabalt iOS](https://github.com/ericjohnson/canabalt-ios)
- :tada: [Doom 3](https://github.com/id-Software/DOOM-3)
- :tada: [Doom](https://github.com/id-Software/DOOM)
- :tada: [Duke Nukem 3D: Atomic Edition](http://legacy.3drealms.com/duke3d/)
- :tada: [NetHack](https://github.com/NetHack/NetHack)
- :tada: [OpenRA](https://github.com/OpenRA/OpenRA)
- :tada: [OpenTTD](https://github.com/OpenTTD/OpenTTD)
- :tada: [Prince of Persia](https://github.com/jmechner/Prince-of-Persia-Apple-II)
- :tada: [Quake 2](https://github.com/id-Software/Quake-2)
- :tada: [Quake III Arena](https://github.com/id-Software/Quake-III-Arena)
- :tada: [Quake](https://github.com/id-Software/Quake)
- :tada: [SimCity](https://github.com/simhacker/micropolis)
- :tada: [Wolfenstein 3D](https://github.com/id-Software/wolf3d)
- :free: [VVVVVV](https://github.com/TerryCavanagh/VVVVVV)

### Communities

_Where to find other game developers_

- [Reddit r/gamedev](https://www.reddit.com/r/gamedev/)
- [Game Dev League](https://discord.com/invite/gamedev)
- [Reddit r/IndieGaming](https://www.reddit.com/r/IndieGaming/)
- [Brackeys Discord](https://discord.gg/brackeys)
- [Brackeys Forum](https://forum.brackeys.com/)
- [GameDev.tv](https://community.gamedev.tv/)

## Ads

_We still need to make some money, right?_

- [AdMob by Google](https://www.google.com/admob/) - Google's Ads and monetization service for mobile.
- [AdColony](http://www.adcolony.com/) - Mobile video Ads service.
- [Appodeal](http://www.appodeal.com/) - A programmatic ad mediation solution for mobile apps.
- [ChartBoost](https://www.chartboost.com/) - Monetization, analytics platform.
- [Unity Ads](https://unity.com/products/unity-ads) - Unity3D Official Ads SDK.
- [Vungle](https://vungle.com/) - Video Ads service.

## Learn

_Online courses, tutorials, screencasts_

### General Game Development

- :money_with_wings: [Chris Courses: Complete courses for an assortment of 2D games](https://chriscourses.com/)
- :moneybag: [Coursera: Introduction to interactive Python programming](https://www.coursera.org/course/interactivepython1)
- :free: [HandmadeHero: making 2D game from scratch](https://handmadehero.org/)
- :free: [Khan Academy: Advanced JS: Games & Visualizations](https://www.khanacademy.org/computing/cs/programming-games-visualizations)
- :free: [Simple HTML5 Canvas Game](http://www.lostdecadegames.com/how-to-make-a-simple-html5-canvas-game/)
- :free: [miloyip/game-programmer](https://github.com/miloyip/game-programmer) A Study Path for Game Programmer :octocat:
- :free: [TheChernoProject](https://www.youtube.com/user/TheChernoProject)
- :free: [Udacity: HTML5 Game Development](https://www.udacity.com/course/html5-game-development--cs255)

### Computer Graphics

- :free: [3D Game Shaders For Beginners](https://github.com/lettier/3d-game-shaders-for-beginners)
- :free: [Interactive 3D Graphics](https://www.udacity.com/course/interactive-3d-graphics--cs291)
- :moneybag: [Interactive Computer Graphics](https://www.coursera.org/learn/interactive-computer-graphics)
