<div class="github-widget" data-repo="karlhorky/learn-to-program"></div>
## Learn to Program [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

#### Foundation in Web Development

The Internet is filled with an ever-expanding number of courses, books and guides for programmers of all skill levels to improve their skills. Unfortunately, these resources are either hard to find or of low quality.

This list aims to be a curated set of high quality educational resources. The availability of free content on the platform is highlighted along with the primary topics covered.

## Beginner

#### [Codecademy](https://www.codecademy.com/)
**Freemium** platform for learning to code in many different programming languages\
*(HTML, CSS, JavaScript, jQuery, Python, Ruby, Rails, PHP, C++, Java)*

#### [Khan Academy's Hour of Code](https://www.khanacademy.org/hourofcode)
**Free** interactive 1-hour courses to learn the very basics of web development\
*(HTML, CSS, JavaScript, SQL)*

#### [UpLeveled Bootcamp Prep Course](https://learn.upleveled.io/)
**Freemium** platform for learning the basics of web development\
*(HTML, CSS, JavaScript, Node.js, Git, GitHub)*

#### [Treehouse](https://teamtreehouse.com/)
**Paid** platform for courses how to build websites & apps\
*(Web Design, Front End Web Development, Rails, iOS, Android, PHP)*

#### [Learn CSS Layout](https://learnlayout.com/)
**Free** tutorial for how to do layout with CSS\
*(CSS)*

#### Udemy [Programming](https://www.udemy.com/courses/search/?q=programming), [Development](https://www.udemy.com/courses/Development/)
**Freemium** marketplace of courses from third party providers - quality may vary\
*(HTML, CSS, JavaScript, Ruby, Rails, Python, iOS, Android)*

#### [Code Avengers](https://www.codeavengers.com/)
**Freemium** platform for basic web and app development courses\
*(HTML, CSS, JavaScript)*

#### [Shay Howe's Learn to Code HTML & CSS](https://learn.shayhowe.com/)
**Free** beginner to intermediate guides on web development\
*(HTML, CSS, JavaScript)*

#### [HTML Dog](https://www.htmldog.com/)
**Free** beginner and intermediate guides on web development\
*(HTML, CSS, JavaScript)*

#### [freeCodeCamp](https://www.freecodecamp.org/)
**Free** learn to code and help nonprofits at the same time\
*(HTML, CSS, JavaScript, Databases, Git & GitHub, Node.js, React.js, D3.js, Python)*

#### [Vertabelo Academy](https://academy.vertabelo.com/)
**Free** SQL courses with interactive exercises and quizzes\
*(SQL, database concepts)*

#### [The Odin Project](https://www.theodinproject.com)
**Free** beginner to intermediate full-stack courses with Ruby and JS learning paths\
*(HTML, CSS, JavaScript, Ruby, Rails)*

#### [MDN Learning Area](https://developer.mozilla.org/en-US/docs/Learn)
**Free** guides on fundamental web development concepts\
*(HTML, CSS, JavaScript, accessibility, performance, React, Ember, Vue, Svelte, Angular, Git, GitHub)*

#### [GitHub Skills](https://github.com/skills)
**Free** self paced, interactive projects to learn Git and GitHub, created and maintained by GitHub's training team\
*(Git, GitHub)*

#### [Grid Garden](https://cssgridgarden.com/)
**Free** game that teaches the CSS grid system created by [@thomaspark](https://github.com/thomaspark)\
*(CSS)*

#### [Flexbox Froggy](https://flexboxfroggy.com/)
**Free** game that teaches the CSS Flexbox\
*(CSS)*

#### [Hexlet.io](https://en.hexlet.io)
**Mixed** self paced, interactive projects to learn JavaScript, C, Regular Expressions and computer science in general\
*(JavaScript, Regular Expressions, Bash, computer science, Ansible)*

#### [Programming Historian](https://programminghistorian.org/en/lessons/)
**Free** peer reviewed introductory courses for digital humanists\
*(Python, R, Unity, QGIS, HTML, Regular Expressions)*

#### [Software Carpentry](https://software-carpentry.org/lessons/)
**Free** foundational coding and data science skills for researchers\
*(Python, R, OpenRefine, Unix Shell, Git)*

#### [Hyperskill by JetBrains Academy](https://hi.hyperskill.org)
**Freemium** wide range of tracks in popular programming languages and development frameworks\
*(Python, Java, Kotlin, SQL)*

#### [Cratecode](https://cratecode.com/)
**Free** online platform that teaches programming through interactive lessons\
*(JavaScript, TypeScript, HTML, p5.js, Backend Web Development)*

#### [DataCamp](https://www.datacamp.com/)
**Freemium** interactive platform for learning data science\
*(Python, R, SQL, Power BI, ChatGPT)*

#### [Developer Roadmaps](https://roadmap.sh/)
*(Fullstack, UX Design, Cyber Security, Computer Science, Blockchain, DevOps, PostgreSQL)*

## Intermediate

#### Khan Academy [Computer Programming](https://www.khanacademy.org/computing/computer-programming), [Computer Science](https://www.khanacademy.org/computing/computer-science)
**Free** intermediate to advanced courses on how to program drawings, animations, games and webpages and more advanced computer science topics\
*(HTML, CSS, JavaScript, SQL, algorithms, cryptography)*

#### [Udacity](https://www.udacity.com/)
**Free** platform for computer science and web development courses\
*(HTML, CSS, JavaScript, data science, Python, computer science topics)*

#### [Learn Python the Hard Way](https://learnpythonthehardway.org/book/)
**Paid** book and course for beginner through intermediate Python programming\
*(Python, object-oriented programming, web development)*

#### [Michael Hartl's Ruby on Rails Tutorial](https://www.railstutorial.org/book)
**Free** online book covering all stages of creating a Ruby on Rails application\
*(HTML, CSS, JavaScript, Ruby, Rails)*

#### LinkedIn Learning: [Web Development](https://www.linkedin.com/learning/topics/web-development), [Web Design](https://www.linkedin.com/learning/topics/web-design)
**Paid** platform for video courses on web development and design\
*(HTML, CSS, JavaScript, web development, web design)*

#### [Thinkful](https://www.thinkful.com/)
**Paid** platform for mentored web and mobile development courses from industry experts\
*(web development, frontend web development, AngularJS, Android, iOS)*

#### [exercism.io](https://exercism.io/)
**Free** crowdsourced mentorship platform of programming exercises and code reviews\
*(Clojure, CoffeeScript, C++, C#, Elixir, Erlang, F#, Go, Haskell, JavaScript, Common Lisp, Lua, Objective-C, OCaml, Perl 5, PL/SQL, Python, Ruby, Scala, Swift)*

#### [LabEx](https://labex.io)
**Freemium** hands-on tech skills labs in virtual environments, supported by an AI study assistant\
*(Linux, Docker, DevOps, Python, Data Science, Machine Learning, Go, Java, C, C++, HTML, CSS, JavaScript, React)*

#### [PluralSight](https://www.pluralsight.com/browse)
**Paid** platform for courses in web development, software development, security and more\
*(HTML, CSS, JavaScript, React, AngularJS, Java, SQL)*

#### [CodeChef Courses](https://www.codechef.com/learn)
**Freemium** platform with courses in web development and software development\
*(HTML, CSS, JavaScript, Python, Java, C++)*

#### [CodeChef Problems](https://www.codechef.com/problems/easy/)
**Freemium** intermediate to advanced programming problems\
*(programming)*

#### [CodingBat](https://codingbat.com/)
**Free** practice problems in Python and Java\
*(Python, Java)*

#### [Codewars](https://www.codewars.com/)
**Free** code challenges - compare your solution with those of others\
*(JavaScript, CoffeeScript, Ruby, Python, Clojure, Haskell, Java)*

#### [CodinGame](https://www.codingame.com/)
**Free** Learn to code and game at the same time\
*(C#, C++, Java, JavaScript, Python, Bash, C, Clojure, Dart, F#, Go, Groovy, Haskell, Lua, ObjectiveC, Pascal, Perl, PHP, Ruby, Rust, Scala, Swift, VB.NET)*

#### [1 Million Women To Tech Summer of Code](https://github.com/1millionwomentotech/toolkitten/tree/master/summer-of-code)
**Free** programming course material for beginner, intermediate and advanced levels\
*(Python, JavaScript, Data Science, artificial intelligence, machine learning, AR & VR)*

#### [Wes Bos](https://wesbos.com/courses/)
**Mixed** guided video courses to build products using new technologies\
*(JavaScript, CSS, React, Node.js, GraphQL, Redux)*

#### [Level Up Tutorials](https://levelup.video/library)
**Free** video tutorials for web developers and designers\
*(HTML, CSS, JavaScript, React, Svelte, Vue, Node.js, GraphQL, TypeScript, Deno, GitHub, Figma, Ruby, Drupal, Magento, Wordpress)*
 
## Advanced

#### [MIT OpenCourseWare](https://ocw.mit.edu/search/?t=Computer%20Science)
**Free** courses from MIT on advanced computer science topics\
*(varied and extensive computer science topics, C, C++)*

#### [edX](https://www.edx.org/learn/computer-programming)
**Free** courses from Harvard, MIT, and other universities\
*(varied computer science subjects including theory and programming, data science, algorithms, ...)*

#### [Coursera](https://www.coursera.org/courses?categories=cs-ai,cs-programming,cs-systems,cs-theory,infotech)
**Mixed** platform for courses from universities and organizations worldwide\
*(varied computer science subjects including theory and programming, data science, algorithms, ...)*

#### [Awesome CS Courses](https://github.com/prakhar1989/awesome-courses/blob/master/README.md)
**Free** university-level courses scoured from around the internet\
*(varied and extensive computer science topics, ...)*

#### Metacademy [Roadmaps](https://metacademy.org/roadmaps/), [Course Guides](https://metacademy.org/course_guides/)
**Free** graphs of interconnected topics required to master concepts\
*(programming, machine learning)*

#### [HackerRank](https://www.hackerrank.com/)
**Free** programming challenges and contests\
*(artificial intelligence, algorithms, functional programming, machine learning)*

#### [HackerEarth](https://www.hackerearth.com/)
**Free** programming challenges, hackathons and contests\
*(dynamic programming, artificial intelligence, algorithms, functional programming, machine learning)*

#### [Project Euler](https://projecteuler.net/)
**Free** mathematical/computer programming problems\
*(programming, mathematics)*

#### [CodeSignal](https://codesignal.com/)
**Free** programming challenges\
*(Java, C++, Python, JavaScript, Ruby, C#, PHP and Perl)*

#### [CodeCrafters](https://codecrafters.io/)
**Freemium** recreate programming tools from scratch in any language\
*(Go, Rust, Python, JavaScript, C++, Ruby, Haskell, C#, C, Java, PHP, Elixir, Crystal, Clojure, Zig, Nim)*

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Karl Horky](https://github.com/karlhorky) has waived all copyright and related or neighboring rights to this work.

## Contributing

In lieu of a formal style guide, take care to maintain the existing style of this list.
