<div class="github-widget" data-repo="gitfrage/guitarspecs"></div>
## Electric Guitar Specifications


这是实心电吉他组装的“自上而下的清单”.
它可以帮助您打造一把具有特定声音和演奏特性的吉他. 请阅读 [licence and the contribution guidelines](https://github.com/gitfrage/guitarspecs/blob/master/contributing.md) 在贡献之前. [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

![Electric Guitar Specifications](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/Sound-and-Playability.jpg)












---------------

## Sound and Playability Influencing Factors
![overview](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip8_general-pickup.jpg)

组件| 声音* | 可玩性*
------------|---------------------|---------------
[Guitar Neck](#guitar-necks) | + | ++++
[Guitar Body](#guitar-bodies) | + | ++++
[Guitar Electronics](#electronics) | +++ | -
[Strings](#strings) | ++ | ++
[Scale Length](#scale-length) | + | +
[Woods](#woods)  （琴体、琴颈和指板）|  + |  + |

*影响力（“-”代表很小，“++++”代表很强）

例如，要制作一把坚固的“爵士乐”吉他，您必须选择（按重要性从上到下）：

 - 复古或爵士拾音器，带有方便的电位计和电容值
 - 平绕弦
 - 粗大的琴颈，空心的琴体，采用桃木等木材
 - 较短的刻度长度


----------

## Guitar Necks
![Guitar Necks](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip2_neck.jpg)

琴颈厚度、琴颈宽度、琴颈轮廓和品丝尺寸都会影响演奏性能，并且是个人品味的问题. 对于良好的可玩性来说，重要的是这些组件的平衡交互. 较粗的琴颈通常会产生较温暖的音色.

>  [usacustomguitars.com/necks](http://www.usacustomguitars.com/necks) - 多种颈部形状和厚度组合    
>  [musikraft.com](https://musikraft.com/faq-2/) - 了解颈部特征的附加信息.   

### Neck Profile

颈部轮廓是轮廓（C、U、V、不对称）和厚度 (.0750&quot; - 1&quot;) 的组合

轮廓| 厚度| 温暖* | 挡泥板* | 吉布森*      
------------|-------------|---------------|---------------------------|--------------
 d | 薄| 向导|  D 形 |           
 C | 薄/中 | 标准薄|  C 形（AM 标准）| 传统C
 C | 中等|  59 回旋 | 深C |  C 轮（1959 年唱片）             
你| 厚| 肥背鱼 |  U 形（复古长焦）| 
 V | 厚| 船颈 |  V 形（复古 52 长焦）|             
不对称| 平均 | 沃尔夫冈 | 当代C |        

>  [*warmoth](http://www.warmoth.com/Guitar/Necks/BackContours.aspx) 温暖的颈部轮廓    
>  [*fender](https://shop.fender.com/de-DE/electric-guitars/) - 参见“颈部形状”过滤器     
>  [*gibson forum](https://forum.gibson.com/topic/74036-gibson-neck-profiles/?tab=comments#comment-1360076) - 吉布森琴颈轮廓    


### Neck Nut Width and Nut Slot Spacing

类别 | 颈部螺母宽度|  e1/E6
-----------------------|--------------------| -----------
许多来自日本的挡泥板|  41 毫米 (1-5/8&quot;) | 约 34 毫米
标准|  42.9 毫米 (1-11/16&quot;) | 约 35 毫米
声学模拟 |  44,5 毫米 (1-3/4&quot;) | 35 毫米至 37,5 毫米
超宽（温暖）|  48 毫米 (1-7/8&quot;) | 约 40 毫米

真正的 e1 至 E6 琴弦分布不仅可以通过琴枕宽度来控制，还可以通过琴枕上的槽分布来控制. 例如，44.5 毫米宽的螺母的 e1 到 E6 距离可以在 35 到 37.5 毫米之间.

类别 | 字符串间距 |  e1/E6 |  e1 到边缘 | 带颈螺母宽度  
---------------------|----------------|--------------|----------- |-----------------
窄弦展 |  7 毫米 |  35 毫米 |  4.75 毫米 |  44.5 毫米（1-3/4 英寸）
中等弦距 |  7.3 毫米 |  36.5 毫米 |  4 毫米 |  44.5 毫米（1-3/4 英寸）
宽弦传播 |  7.5 毫米 |  37.5 毫米 |  3.5 毫米 |  44.5 毫米（1-3/4 英寸）

> [graphtech - sizing guide and pre-slotted nuts](https://graphtech.com/collections/tusq-nuts-guitar)


### Neck Heel Width and Mounting

大多数吉他零件制造商采用 Fender&#39;s® 琴颈跟部和琴颈口袋尺寸：

 - 56 毫米（2-3/16 英寸） - 宽度
 - 76 毫米（3 英寸） - 长度
 - 16 毫米（5/8 英寸） - 口袋深度

这些尺寸不是标准. 只有仔细测量才能确保您的零件兼容.

Strat 琴颈的后跟处有一个圆形底座，而 Tele 琴颈的后跟处有一个方形底座，这使得两种类型的琴颈很难在不同的身体上互换.

![neck-heel-strat-vs-tele](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/neck-heel-strat-vs-tele.jpg)

标准 Fender 跟部安装通过 4 个螺栓孔完成 - 直径为 1/8 英寸（3 毫米）（分布范围为 2 英寸 x 1-1/2 英寸）.


### Fretboard's Radius

半径越小意味着形状越圆.

 - 7-1/4&quot; - “复古”Fender®
 - 9-1/2&quot; - “现代”Fender®
 - 10英寸 - Gibson®/PRS®
 12英寸-Ibanez®
 - 16英寸 - 杰克逊®
 - 复合材料 (10&quot; - 16&quot;) - Warmoth® 等

> [youtube.com](https://www.youtube.com/watch?v=-yiBbIzGjW8) - 下弦半径测量仪 - 用于吉他设置和回纹的三种不同测量仪的视频演示：标准、缺口和下弦测量仪.

### Fret Sizes

标题 | 宽度| 身高| 例子
-------------|---------|-----------| -----------
小| 窄 | 低| 复古挡泥板
中等| 窄 | 高| 许多马丁
中号特大号 | 宽 | 低| 许多吉布森
巨型 | 宽 | 高| 现代挡泥板
高巨型| 宽 | 非常高| 许多伊巴涅斯


> [lutherie.net](http://www.lutherie.net/fret.chart.html) - 提供优秀的制造商/尺寸概述.

### Common Neck Head Shapes

 - 6L - 挡泥板样式 - 左对齐
 - 6R - 适合左撇子
 - 3L/3R - “戈布森型”
 - 4L/2R - “音乐家风格”

### Tuner Holes

  - 大约.  8,7mm (11/32&quot;) - “复古挡泥板风格”
  - 大约.  10mm (25/64&quot; = 9,9mm) - “Sperzel 风格”，
  - 大约.  10mm (13/32&quot; = 10,3mm) - “行星波浪风格”
  - 大约. 顶部 10 毫米，底部 8.7 毫米 - “Schaller/Grover/Gotoh Slyle”
 
小孔可以用沉孔扩大. 大孔可以通过紧定衬套进行改造.

----------

## Guitar Bodies
![Guitar Bodies](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip1_body.jpg)

电吉他的声音主要取决于琴弦本身的振动行为和拾音器的再现特性. 琴弦的振动行为（很少）取决于木材. 与琴颈相比，琴体本身非常厚，这就是为什么琴体木材类型和形状对电吉他声音的影响非常有限.

> [music.stackexchange.com](http://music.stackexchange.com/questions/14019/how-much-does-an-electric-guitars-body-physics-affect-the-tone-playability-et) - 电吉他的物理特性对音色和可演奏性有多大影响.

### Body Shapes

电吉他的形状历史上可分为以下几类：

 - ST（层）
 - T（远程）
 - 单切 (LP)
 - 双切 (SG)
 - 空心体
 - 其他表格 

### Bridge And Pickup Routing Overview

 - 平装硬尾（Strat/Tele/Shaller）
 - 颤音（Strat）
 - Tune-O-Matic（吉森）
 - 其他（Jazzmaster®、Jaguar®、Bigsby®、Kahler®、6 号线等）

![Bridge Routing](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/egitarrenbau-body-standardstrat_vintagetele_tunomatic.jpg)

图片从左到右：
- 美国标准 Tremolo 路由和单线圈 Strat 拾音器， 
- 老式 Telcaster 路由和单线圈 Tele Pickup， 
- Tune-O-Matic 风格路由和 Habucker 拾音器

> [callahamguitar.com](http://www.callahamguitars.com/tech_compatibility.htm) - 一些定制零件的技术规格.



### Flat Mount Strat Routing

                   Strat 复古、窄版和标准版                   
    网站漏洞...ooooo..      
    桥洞..o.....o.....o..     

型号| 电子/电子| 站点孔 Ø | 站点洞距| 桥孔直径Ø | 桥孔距离
--------------------|------------------|-------------------|------------------|----------------|-------------------
 Strat 复古 |  57 毫米（2 1/4 英寸）| 3.18 毫米（0.125 英寸）|  10.5 毫米（0.413 英寸）| 3 毫米（1/8 英寸）|  21 毫米（0.827 英寸）
 Strat 复古窄款|  54 毫米（2 1/8 英寸）| 4.78 毫米（0.188 英寸）|  10.5 毫米（0.413 英寸）| 3 毫米（1/8 英寸）|  21 毫米（0.827 英寸）
战略标准|  52.83 毫米（2.08 英寸）| 3.18 毫米（0.125 英寸）|  11.3 毫米（0.446 英寸）| 3 毫米（1/8 英寸）|  22.6 毫米（0.89 英寸）

### Flat Mount Tele Routing

                 老式长焦标准长焦         
    桥洞..o...o...o...o.. 站点洞...oooooo.. 
    站点洞...oooooo..桥洞..o.....o.....o.. 

型号| 电子/电子| 站点孔 Ø | 站点洞距| 桥孔直径Ø | 桥孔距
--------------------|------------------|-------------------|----------------------|----------------|-------------
电视复古|  54 毫米（2 1/8 英寸）| 3.18 毫米（0.125 英寸）|  10.9 毫米（0.429 英寸）| 3 毫米（1/8 英寸）|  21.6 毫米（0.85 英寸）
电信标准|  54 毫米（2 1/8 英寸）| 3.18 毫米（0.125 英寸）|  10.5 毫米（0.413 英寸）| 3 毫米（1/8 英寸）|  32.4 毫米（1.267 英寸）

###  Flat Mount Schaller Routing

                 夏勒平面安装
    桥洞...o...o...o... 

型号| 电子/电子| 桥孔直径Ø | 桥孔距离| 尺寸（长x宽x高）
--------------------|------------------|-------------------|-----------------------|--- 
夏勒 47X |  51 毫米 - 55.5 毫米 |  3.18 毫米 (0.125 英寸) | 约 X | 73 x 49 x 12(15) 毫米


### Tremolo Routing

    颤音“复古”： 颤音“标准”：
    ..o..o..o..o..o...o... .....O.......O.....

型号| 电子/电子| 孔 | 孔距| 孔径Ø
-----------------------|-------------------|-----------|------------------|--------------
墨西哥海峡 |  52.4 毫米 (2 1/16) |  6 |  52.4 毫米 (2 1/16) |  3 毫米（1/8 英寸）
复古|  56,36 毫米 (2 7/32&quot;)| 6 | 55,9 毫米 (2.2&quot;) |  3 毫米（1/8 英寸）
美国标准|  52.83 毫米（2.08 英寸）| 2 | 55.9 毫米（2.2 英寸）|  9.5 毫米（0.375 英寸）
弗洛伊德·罗斯（“凹进”）|  53 毫米（2-3/32 英寸）| 2 | 74 毫米（2.913 英寸）|  9,91 毫米 (.390&quot;)
夏勒 2000 |  53.5 毫米 |  2 |  56 毫米 |  10毫米
夏勒复古|  53.5 毫米 |  2 |  74.3 毫米 |  10毫米
威尔金森（“凹进”）|  54 毫米（2-1/8 英寸）| 2 | 55.9 毫米（2.2 英寸）|  9.7 毫米（0.382 英寸）


### Tune-O-Matic Gibson Style Routing

                 Tune-O-Matic 嵌入式 Tune-O-Matic“琴弦贯穿身体”
    拉弦板…………o……
    拉弦板……o………………oooooo ..
    桥……o……o…………o……o……

型号| 电子/电子| 桥梁| 拉弦板| 拉弦板顶部| 拉弦板底部| 拉弦板直径
------------|------------|--------------|-------------------|-------------------|-------------------|------
调谐-O-Matic| 约 52 毫米* |  74 毫米（2.91 英寸）| 约 82 毫米* | 38 毫米（1.49 英寸）|  41 毫米（1.61 英寸）| 约 11 毫米（0.44 英寸）

相反，系弦板 - 可能有“穿过身体的弦”钻孔.


### Other Rare Bridge Variants

 - 环绕式（琴马拉弦板组合 - 琴弦通过前侧安装并环绕） 
 - 爵士大师®
 - 捷豹®
 - 比格比®
 - 卡勒®
  
### Pickup Routing

- 单线圈（Strat）
- 单线圈（长颈）
- 单线圈（远程桥）
- 双线圈
- 宽双线圈拾音器*
- 迷你双线圈拾音器
- P90
- 口红管
-爵士大师

 *Wide Humbucker（与 Seymourduncans“Trembucker”或 Dimarzios“F-spaced Hambucker”相同）可用于具有标准“Humbucker Routing”的较大弦距的吉他. 从拾音器正上方的高弦中部到低音弦中部进行测量. 如果距离大于 2 英寸或 50 毫米，请选择宽双线圈拾音器.

确切的规格可以在制造商的网站上找到，例如：
> [bareknucklepickups.co.uk](https://www.bareknucklepickups.co.uk/support#dimensions) - 方面


除了经典的 HH 路由（2X hambuckers）外，还有以下变体： - SSS（Strat、Nashville Tele）
 - HSS（琴桥上的 Strat Humbucker、Modern Player Tele）
 - HSH（战略），
 - HS（Strat，72 Tele）
 - SS（电话），
 - HP90（雅马哈太平洋），
 - S（《时尚先生》），
 - 以及其他一些奇异的组合

----------

## Tuning Machines
![tuning machine head](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip10_tuning-machine-head.jpg)

调音机选项：
 - 配置：3L+3R（Gibson 风格）、6 列（Fender 风格）、4L/2R（Musicman 风格）
 - 比率 - 绕轴头缠绕 1 圈 - 需要旋转 1 圈.
   较大的比例 (1:18 &gt; 1:14) 允许更精细的调整.
 - 标准与锁定 - 带锁定调音器的琴弦通过轴孔插入，并从外部用螺钉固定

## Bridges
![bridge](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip11_bridge.jpg)

吉他琴桥对可演奏性有很大的影响**（主要是通过琴弦间距）. 较宽的弦距更适合指弹风格，较窄的弦距在弹奏失真音调的主奏时更容易控制.  [Bridge and Pickup Routing](#bridge-and-pickup-routing-overview) 上面的章节描述了常见的桥梁类别和弦间距规格.

琴桥的形式和材料也对声音有一些**影响**.
好的制造商会在其页面上提供详细的产品信息：

>  [ABM - Aluminium, Bell Brass and Steel comparison](https://abm-guitarpartsshop.com/From-a-solid-Block-to-a-Bridge:_:206.html?language=en) - 表示贝尔铜管和钢管塑造了具有个性的吉他声音，而铝管在音调的传递中基本上起到中性的作用.
 

## Hardware Parts Checklist
![jackplate](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip9_jackplate.jpg)

以下列表总结了完成您自己的吉他制作项目所需的配件

 - 插孔和插孔板
 - 颈板（颈部到身体）
 - 护板或拾音器安装环
 - 上述所有零件的螺丝
 - 控制板（仅适用于标准长焦）
 - 线箍（线穿过顶部或底部 - 如果您使用“线穿过主体”而不是桥）
 - 字符串固定器. [see premierguitar.com article about design and construction](https://www.premierguitar.com/articles/24295-guitar-shop-101-happy-little-string-trees)  
 - 表带支架

对于每个螺钉，孔必须预先钻至芯径（而非外径）

----------------

## Electronics
![electronics](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip3_harness.jpg)


电子设备对实心电吉他的整体声音影响最大.

> [buildyourguitar.com -  The Secrets of Electric Guitar Pickups by Lemme](http://www.buildyourguitar.com/resources/lemme/index.htm) - “如果您知道谐振频率和谐振峰的高度，您就了解了拾音器大约 90% 的传输特性.其他一些效应无法使用此模型进行描述，但它们的影响不太重要”.

磁性拾音器的频率响应可能如下所示 ![resonant peak and frequency](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/resonant_peak_and_frequency.jpg)

声音组| 谐振频率| 共振峰| 取货示例
------------|--------------------|----------------|--------------
明亮|  3 - 6kHz | 高峰| 挡泥板单线圈
强大|  2 - 3kHz | 中高峰| 吉布森PAF
醇厚|  1.5 - 2kHz | 低峰 | 回滚音壶

以下主题会更改谐振频率和谐振峰值：

 - [Pickup Properties](#pickup-properties)  - 频率峰值的位置和高度因类型而异.     
 - [Sound Control With Switches](#sound-control-with-switches)  - Hambucker 线圈默认串联切换，并联切换或仅使用其中一个线圈会增加谐振频率，声音会有更多高音.    
 - [Potentiometer and Capacitor Values](#potentiometer-and-capacitor-values) 改变还提供了改变谐振频率和峰值的简单方法.     
 - Cable capacitance - longer cable will lead to lower resonant frequency.  
 - 放大器输入阻抗

### Pickup Properties
![pickup properties](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip5_hambucker.jpg)

- 接线：1、2、3 或 4 导线（4 导线允许最灵活的接线）*
- 位置：琴桥、琴颈、中部
- 对称与非对称连接类型
- 输出：低（复古）、中、高（爵士乐和布鲁斯经常使用的复古）
- 被动与主动（主动通常用于失真声音）
- 直流电阻：指示拾音器将有多少输出
- EQ 聊天：关于低音、中音和高音的一般概念.

>  [seymourduncan.com](http://www.seymourduncan.com/pickup-selector-step-1) - 拾音器选择器     
>  [dimarzio.com](http://www.dimarzio.com/pickup-picker) - 拾取器    

经典双线圈拾音器是不对称的. 它们内部串联（即串联 - 带来更多功率），反相（噪音更少）. 当前的多导体 PU 提供使用推/拉电位器、迷你开关、拨动开关、大型开关和旋转开关以不同方式切换线圈的选项，并允许直接在吉他上广泛控制声音.


导体| 连接类型 | 线圈分裂| 串行/并行| 相位开关| 例子
--------|---------------|------------------------------|---------------------|----------|------------
 1x | 不对称| 双线圈模式 | 连续剧 | 没有 | 影子AZ48
 2x | 对称| 双线圈模式 | 连续剧 | 是的 |  Fender 宽范围（墨西哥）
 2x | 不对称| 双线圈拾音器和单线圈模式 | 连续剧 | 没有 | 贝内代托 B6
 3x | 对称| 双线圈拾音器和单线圈模式 | 连续剧 | 是的 | 许多活跃的 PU
 3x | 不对称| 双线圈拾音器和单线圈模式 | 串并联| 没有 |  PRS 59
 4x | 对称| 双线圈拾音器和单线圈模式 | 串并联| 是的 | 所有 4 导体 PU


### Sound Control with Switches

![electronics wiring options](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip14_switch.jpg)

   开关| 线圈分裂| 串行/并行| 相位开关|  PU开关
-----------------------------|--------------|----------------|--------------|----------
拨动开关|  - |  - |  - |  y
刀片开关“Fender”|  - |  - |  - |  y
 X-Way-Blade“Megaswitch” |  y |  y |  y |  y
微型开关SPDT(ON/ON) |  y |  - |  - |  -
微型开关SPDT(ON/OFF/ON) |  y |  - |  - |  -
微型开关SPDT(ON/OFF/ON) |  y |  - |  y |  -
迷你开关双刀双掷(ON/ON) |  y |  y |  y |  -
推/拉电位器 DPDT(ON/OFF/ON)|  y |  y |  y |  - 
迷你开关双刀双掷(ON/ON/ON) |  y |  y |  y |  y
旋转开关|  y |  y |  y |  y

- 线圈分裂 - “单线圈声音”
- 串行/并行切换 - “双单线圈声音”
- 相位开关 - “异相声音”

SP = 单刀，DP = 双刀，DT = 双掷
	
	单刀双掷（开/关/开）： 单刀双掷（开/开）：     
     0 XX |  0 0 0 | 0 0 0  XX 0 0 XX |  XX 0     

	DPDT (ON/OFF/ON):     	DPDT (ON/ON):     DPDT (ON/ON/ON):
	 0 XX |  0 0 0 | 0 0 0  XX 0 0 XX |  XX 0 0 XX |  XX 0 |  XX 0
	 0 XX |  0 0 0 | 0 0 0  XX 0 0 XX |  XX 0 0 XX |  0 XX |  XX 0

示例：“同时串联/并联和线圈分割”可通过 4 个推/拉电位器、4 个迷你开关（即 Duncan Triple Shot）或 5 路刀片巨型开关实现

> [open.guitars (german)](https://open-guitars.de/egitarrenbau/pu-anschlussarten/) - Hambucker 导体/线圈切换选项.


### Potentiometer and Capacitor Values
![cap values](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip16_cap.jpg)

声音组| 锅| 帽| 例子
------------------------|------|---------|----
标准汉堡|  50万|  0.047mF | 大多数配备 Hambucker 的吉他
明亮|  50万|  0.022mF | 一些吉他（US FAT Tele）
更亮|  50万|  0.01mF | 一些定制模型
最亮|  1M |  0.01mF | 一些定制模型
标准单线圈|  25万 |  0.022mF | 大多数 strat 和 tele 型号
爵士乐|  25万 |  0.047mF | 一些电视（ASAT BluesBoy）

&gt; http://www.planetz.com/guitar-tone-capacitors-material-types - 音调电容器材料类型和电容值的比较.

### Volume and Tone Potentiometer Options
![volume and tone pot](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip15_pot.jpg)

集团| 锅体直径Ø | 衬套直径 | 衬套长度| 轴长| 例子
---------|-------------|-----------|----------------|--------------|------------
标准|  24 毫米 |  8 毫米 |  10 毫米 |  19 毫米 | 大多数挡泥板吉他
迷你|  17 毫米 |  7 毫米 |  10 毫米 |  &#39;&gt;&#39; 17 毫米 | 许多爵士吉他
长|  24 毫米 |  8 毫米 |  20 毫米 |  27.5 毫米 | 大多数 Gibson LP 吉他

 - 电阻：250K、300K、500K、1M
 - 锥度：音频、反向音频、线性、平衡
 - 轴类型：滚花、圆形和普通
 - 轴直径：6 毫米（0.236 英寸）、6.35 毫米（0.25 英寸）
 - 轴长：17毫米、19毫米（0.75英寸）、27.5毫米（1.125英寸）

### Potentiometer Knob Styles 
![knob](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip13_knob.jpg)

旋钮有 3 种常见样式：
 - 铃
 - 速度
 - 圆顶

> [philadelphialuthiertools.com](http://blog.philadelphialuthiertools.com/2013/05/16/choosing-the-correct-knob-for-your-guitar-or-bass/)  - 为您的吉他或贝斯选择正确的旋钮.

### Electronics Wiring Schemas
![electronics wiring schemas](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip4_wiring.jpg)

>- [Solder yourself - seymourduncan](http://www.seymourduncan.com/wiring-diagrams)
>- [Solder yourself - dimarzio](http://www.dimarzio.com/support/wiring-diagrams)
>- [Solder yourself - amplifiedparts](https://www.amplifiedparts.com/tech-corner/electric-guitar-wiring-diagrams)
>- [Solderless - EMG](https://www.emgpickups.com/parts/wiring-kits.html)
>- [Prewired Classic - mojotone](https://www.mojotone.com/guitar-parts/Prewired-Kits#/)
>- [Prewired Modern - toneshapers](https://toneshapers.com/wiring-products.html#cat=nextgen)

### Active Pickups Electronics
![active pickups](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/clip7_active-pickup.jpg)

Active Electronics tries to reduce dependency from the shielded cable and amp input impedance. However, that needs power to operate, and that's its biggest drawback.

> [Custom Buffers (german)](http://www.guitar-letter.de/Angebot/BufferUndAmps/Impedanzwandler.htm) - 用于将吉他电子设备与屏蔽电缆上的声音影响效果分离.    


## Strings
![strings](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/strings.jpg)

根据以下选项，您的声音会更明亮或更柔和：

 - 结构（平绕/圆绕）
 - 材料（钢/镍）和
 - 紧张

大多数制造商使用以下命名约定来描述弦组的张力：

名称 |  “e”站点大约.  |  “E”站点约.
------------|--------------- | --------
超轻|  .008|  .039
光|  .009|  .042
常规|  .010|  .046
中等|  .011|  .052
爵士乐 |  .012|  .054
男中音|  .013|  .056

还有其他混合套装可供选择 - 例如“轻顶部/重底部”和“平衡张力”组合.

> [daddario.com](https://www.daddario.com/products/guitar/electric-guitar/) - 您可以在声音明亮和柔和的电弦之间进行选择.      
> [ghsstrings.com](http://www.ghsstrings.com/products?categories=electric-guitar) - 还有明亮与柔和的概述，以及 [tension guide (pdf)](http://www.ghsrep.net/uploads/2/2/2/5/22258814/ghs_electric_guitar_string_guide.pdf)    
> [thomastik-infeld.com](https://www.thomastik-infeld.com/en/products/guitar-strings) - 良好的爵士乐和蓝调弦乐    


## Scale Length
![scale-length](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/scale-length-648-vs-628-mm-neck-web.jpg)

吉他的音阶长度是琴弦和琴桥之间的琴弦长度.

音阶对吉他的声音和可演奏性的影响相对较小.  （与其他参数（如琴弦或拾音器）相比）.

 较长音阶长度的声音和可玩性特征：
 - 反应敏捷，攻击干脆
 - 声音透明，低音和高音清晰
 - 更大的手指展开
 - 恒定规格下更高的琴弦张力

较短音阶长度的声音特征：
 - 更温暖
 - 更持久和更长的衰减
 
常用标尺长度：
 
 - 572 毫米（22.5 英寸）或更短 - 3/4 和一些旅行吉他
 - 596.9 毫米（23.50 英寸） - Fender Jazzmaster/Jaguar 吉他
 - 629 毫米（24.75 英寸） - 许多 Gibson 吉他
 - 635 毫米（25 英寸） - 许多 PRS 吉他
 - 648 毫米（25.5 英寸） - 许多 Fender 吉他
 - 650 毫米 (25.5) - 典型的古典吉他
 - 686 毫米（27 英寸）或更长 - 男中音吉他


## Woods
![strings](https://raw.githubusercontent.com/gitfrage/guitarspecs/master/./images/esche.png)

伍兹 | 声音1 | 重量²| 用于³| 看起来
------------|---------- |--------|----------|-------------------
桤木| 明亮| 中等| 电汇 | 明亮、简单
灰 | 明亮| 中等| 电汇 | 明亮、简单
椴木| 中立 | 光 | 乙| 明亮、简单
布宾加 | 明亮| 中等|  T/B/N/F | 红色，通常有颗粒状
乌木| 明亮| 重| 不适用 | 黑暗
枫木|非常明亮| 重|  T/B/N/F | 明亮，通常有颗粒感
相思木 | 温暖| 中等| 电/提/通知 | 深色、颗粒感、吸引力
科里娜 | 温暖| 中等| 电/提/通知 | 有颗粒感，有吸引力
桃花心木 | 温暖| 中等| 电/提/通知 | 红色
杨树| 中立 | 中等| 乙| 明亮、简单
红木 | 温暖| 中等|  T/B/N/F | 黑暗
西特卡云杉| 中立 | 光 | 电汇 | 明亮、简单
沼泽灰 | 中立 | 光 | 电汇 | 明亮、有吸引力
核桃 | 明亮| 中等| 电/提/通知 | 灰色, 有吸引力
文革| 明亮| 重|  T/B/N/F | 黑暗

 1 声音：音调影响图主要针对原声乐器，不适用于实心吉他，因为实心吉他中的其他组件对声音的影响要大得多. 因此，尽管有以下表述，桃花心木电吉他的声音仍然明亮. 
² 同一品种的重量可能会有所不同. 
 ³ 用于：T - 身体上衣 |  B-身体|  N-领|  F——指板

> [frudua.com](https://www.frudua.com/wood-tone-reference-diagram.htm) - 琴身和琴颈木材的图形示例显示了木材硬度、密度和色调之间的关系.
