<div class="github-widget" data-repo="NARKOZ/guides"></div>
## Guides

Guides for programmers who want to be awesome.  
The intent of this repository is to collect and distribute links to useful
coding style guides and development practices across the web.







## Styling

### CSS

+ [Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.html)
+ [Principles of writing consistent, idiomatic CSS](https://github.com/necolas/idiomatic-css#readme)
+ [HTML and CSS code guide](https://codeguide.co/)
+ [General CSS notes, advice and guidelines](https://github.com/csswizardry/CSS-Guidelines#readme)

### Sass

+ [Principles of writing idiomatic Sass](https://github.com/anthonyshort/idiomatic-sass#readme)
+ [Sass Style Guide](https://css-tricks.com/sass-style-guide/)
+ [Sass Guidelines](https://sass-guidelin.es/)

## Markup

### HTML

+ [Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.html)
+ [HTML and CSS code guide](https://github.com/mdo/code-guide#readme)

### XML

+ [Google XML Document Format Style Guide](https://google.github.io/styleguide/xmlstyle.html)

## Programming Languages

### C
+ [C Code Style Guidelines](https://www.cs.swarthmore.edu/~newhall/unixhelp/c_codestyle.html)
+ [ESA Style Guide for 'C' coding](https://www.maultech.com/chrislott/resources/cstyle/cstyle-ESA-OZ-v2.txt)

### C++

+ [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
+ [C++ Core Guidelines](https://github.com/isocpp/CppCoreGuidelines/blob/master/CppCoreGuidelines.md#readme)

### C&#35;

+ [C# Coding Conventions](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/coding-style/coding-conventions)
+ [Framework Design Guidelines](https://learn.microsoft.com/en-us/dotnet/standard/design-guidelines/)

### Clojure

+ [Clojure Style Guide](https://github.com/bbatsov/clojure-style-guide#readme)

### CoffeeScript

+ [CoffeeScript Style Guide](https://github.com/polarmobile/coffeescript-style-guide#readme)

### Elixir

+ [Elixir Style Guide](https://github.com/christopheradams/elixir_style_guide#readme)

### Go

+ [Go Code Review Comments](https://github.com/golang/go/wiki/CodeReviewComments)

### Haskell

+ [Haskell Programming Guidelines](https://wiki.haskell.org/Programming_guidelines)

### JavaScript

+ [Google JavaScript Style Guide](https://google.github.io/styleguide/javascriptguide.xml)
+ [UPDATED] [Google JavaScript Style Guide](https://google.github.io/styleguide/jsguide.html)
+ [Principles of Writing Consistent, Idiomatic JavaScript](https://github.com/rwaldron/idiomatic.js#readme)
+ [Airbnb JavaScript Style Guide](https://github.com/airbnb/javascript#readme)
+ [JavaScript: The Right Way](http://jstherightway.org/)
+ [ES6 Coding Style](https://github.com/elierotenberg/coding-styles/blob/master/es6.md#readme)
+ [JavaScript SDK Design Guide](https://github.com/hueitan/javascript-sdk-design#readme)
+ [Project Guidelines](https://github.com/elsewhencode/project-guidelines#readme)

### Java

+ [Google Java Style](https://google.github.io/styleguide/javaguide.html)

### Objective-C

+ [Google Objective-C Style Guide](https://google.github.io/styleguide/objcguide.xml)
+ [NYTimes Objective-C Style Guide](https://github.com/NYTimes/objective-c-style-guide#readme)
+ [The official raywenderlich.com Objective-C style guide](https://github.com/kodecocodes/objective-c-style-guide#readme)

### PHP

+ [PHP: The Right Way](https://phptherightway.com/)
+ [PHP Standard Recommendations](https://www.php-fig.org/psr/)

### Perl

+ [PDF] [Perl Best Practices Quick Reference Guide](https://www.squirrel.nl/pub/PBP_refguide-1.02.00.pdf)

### Python

+ [PEP 8 - Style Guide for Python Code](https://peps.python.org/pep-0008/)
+ [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html)

### Ruby

+ [Ruby Style Guide](https://github.com/rubocop/ruby-style-guide#readme)
+ [Ruby Style Guidelines](https://caliban.org/ruby/rubyguide.shtml#style)

### Rust

+ [Rust Style Guide](https://github.com/rust-lang/rust/tree/HEAD/src/doc/style-guide/src#rust-style-guide)

### Scala

+ [Scala Style Guide](https://docs.scala-lang.org/style/)
+ [Effective Scala](https://twitter.github.io/effectivescala/)

### Shell

+ [Google Shell Style Guide](https://google.github.io/styleguide/shell.xml)
+ [Scripting with style](https://wiki.bash-hackers.org/scripting/style)

### SQL

+ [SQL Style Guide](https://www.sqlstyle.guide/)

### Swift

+ [The Official Kodeco Swift Style Guide](https://github.com/kodecocodes/swift-style-guide#readme)

### Vimscript

+ [Google Vimscript Style Guide](https://google.github.io/styleguide/vimscriptguide.xml)

## Frameworks

### AngularJS

+ [AngularJS Style Guide](https://github.com/johnpapa/angular-styleguide#readme)
+ [An AngularJS Style Guide for Closure Users at Google](https://google.github.io/styleguide/angularjs-google-style.html)

### RSpec

+ [Better Specs { rspec guidelines with ruby }](https://www.betterspecs.org/)
+ [RSpec Style Guide](https://github.com/rubocop/rspec-style-guide#readme)
+ [Even Better Specs | Guidelines for Maintainable Tests](https://evenbetterspecs.github.io/)

### Rails

+ [Rails Style Guide](https://github.com/rubocop/rails-style-guide#readme)

### Vue

+ [The official style guide for Vue-specific code](https://vuejs.org/style-guide/)

## Other

### API

+ [HTTP API Design Guide](https://github.com/interagent/http-api-design#readme)
+ [Principles of good RESTful API
  Design](https://web.archive.org/web/20190315165355/https://www.codeplanet.io/principles-good-restful-api-design/)
+ [Microsoft REST API Guidelines](https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#readme)
+ [Building JSON-LD APIs: Best Practices](https://json-ld.org/spec/latest/json-ld-api-best-practices/)
+ [Zalando RESTful API and Event Scheme Guidelines](https://opensource.zalando.com/restful-api-guidelines/)

### Bots

+ [Principles of bot design](https://learn.microsoft.com/en-us/previous-versions/azure/bot-service/bot-service-design-principles?view=azure-bot-service-3.0)
+ [General Best Practices](https://developers.facebook.com/docs/messenger-platform/introduction/general-best-practices)

### CLI

+ [Command Line Interface Guidelines](https://clig.dev/#guidelines)

### Deployment

+ [Deployments Best Practices](http://guides.beanstalkapp.com/deployments/best-practices.html)

### Favicon

+ [favicon-cheat-sheet](https://github.com/audreyfeldroy/favicon-cheat-sheet#readme)

### iOS

+ [The iOS Design Guidelines](https://ivomynttinen.com/blog/ios-design-guidelines)

### Git

+ [Git Style Guide](https://github.com/agis/git-style-guide#readme)
+ [Commit messages guide](https://github.com/RomuloOliveira/commit-messages-guide#readme)

### JSON

+ [Google JSON Style Guide](https://google.github.io/styleguide/jsoncstyleguide.xml)

### Machine Learning

+ [Rules of Machine Learning](https://developers.google.com/machine-learning/guides/rules-of-ml/)

### Node.js

+ [Node.js Style Guide](https://github.com/felixge/node-style-guide#readme)
+ [Node.js Best Practices](https://github.com/goldbergyoni/nodebestpractices#readme)

### Security

+ [Security Principles](https://infosec.mozilla.org/fundamentals/security_principles.html)
+ [Web Security Guidelines](https://infosec.mozilla.org/guidelines/web_security)
+ [WebAppSec/Secure Coding Guidelines](https://wiki.mozilla.org/WebAppSec/Secure_Coding_Guidelines)
+ [Web Application Security Guide/Checklist](https://en.wikibooks.org/wiki/Web_Application_Security_Guide/Checklist)

### UI

+ [A Good User Interface](https://goodui.org/)
+ [Pagination 101](https://gist.github.com/mislav/622561)

### Writing

+ [Writing style](https://atlassian.design/content/writing-style/)
+ [Documentation Style Guide](https://web.archive.org/web/20150320233932/http://docs.basho.com/riak/latest/community/style-guide/)
+ [Apple Style Guide](https://help.apple.com/asg/mac/2013/)
+ [How To Ask Questions The Smart Way](http://www.catb.org/~esr/faqs/smart-questions.html)
+ [Google Developer Documentation Style Guide](https://developers.google.com/style/)

## Contributing

Any improvements or suggestions are welcome!
See [Contribution Guides](https://github.com/NARKOZ/guides/blob/master/CONTRIBUTING.md).

---

This work is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/).
