<div class="github-widget" data-repo="dypsilon/frontend-dev-bookmarks"></div>
## Frontend Development [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

**为前端 Web 开发人员手动精选的资源集合.**

您正在查看一个可浏览的版本，按类别分成许多小文件. 还有一个非常大的文件，每个资源都在一页上. 前往 [totally gigantic file](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/TOTALLY-GIGANTIC-FILE.md) 如果你喜欢这种事情.

这是当前版本，它接收持续更新. 如果你想要好的旧书签，请使用标签 v.1.0. 请记住，旧版本有许多过时的链接.

[![frontend.directory](https://img.shields.io/badge/frontend-directory-blue.svg?style=flat-square)](http://frontend.directory/)
[![Gitter](https://img.shields.io/gitter/room/dypsilon/frontend-dev-bookmarks.svg?style=flat-square&maxAge=2592000)](https://gitter.im/dypsilon/frontend-dev-bookmarks)
[![Twitter](https://img.shields.io/badge/follow-twitter-55acee.svg?style=flat-square)](https://twitter.com/FrontendDir)


---------------------------------------------------------

## Appearance

网站的外在或可见方面.

+ **[Animation](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/appearance/animation.md)**：创建运动和形状变化的过程.
+ **[Typography](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/appearance/typography.md)**：排版的样式、排列或外观很重要.
+ **[Visualization](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/appearance/visualization.md)**：将数据置于视觉环境中.

## Architecture

前端代码的高级结构和创建此类结构的规则.

+ **[Algorithms](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/algorithms.md) **：要执行的一组独立的分步操作. 算法执行计算、数据处理和/或自动推理任务.
+ **[Design Patterns](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/design-patterns.md)**：程序员在设计应用程序或系统时可以用来解决常见问题的最佳实践.
+ **[Designs](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/designs.md)**：准备好使用并有据可查的前端开发结构和框架.
+ **[Event-Driven Programming](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/event-driven-programming.md)**：事件驱动编程是一种编程范式，其中程序的流程由用户操作、传感器输出或来自其他程序/线程的消息等事件决定.
+ **[Functional Programming](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/functional-programming.md)**：函数式编程是一种编程范式，它将计算视为数学函数的评估，并避免改变状态和可变数据.
+ **[Functional Reactive Programming (FRP)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/architecture/functional-reactive-programming-frp.md)**：FRP 是一种使用函数式编程构建块进行异步数据流编程的编程范例.

## Compatibility

产品与不同输入/输出设备和渲染软件一起工作的能力. 包括打印机、电子邮件、移动设备和不同的浏览器.

+ **[Cross Browser](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/cross-browser.md)**：跨浏览器是指网站、Web 应用程序、HTML 构造或客户端脚本在提供其所需功能的环境中运行并在功能不存在或缺失时优雅地退出或降级的能力.
+ **[E-Mail](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/e-mail.md)**：准备基于 HTML 的电子邮件.
+ **[Keyboard](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/keyboard.md)**：在网络浏览器中使用键盘输入.
+ **[Mobile](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/mobile.md)**：开发针对在智能手机和平板设备上查看而优化的网站.
+ **[Printers](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/printers.md)**：通过 CSS 操作打印机输出.
+ **[Responsive Web Design (RWD)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/responsive-web-design-rwd.md) **：RWD 响应用户及其使用的设备的需求. 布局根据设备的大小和功能而变化.
+ **[Web Accessibility](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/compatibility/web-accessibility.md)**：Web 可访问性意味着残障人士可以感知、理解、浏览 Web 并与之交互，并且他们可以为 Web 做出贡献.

## Ecosystem

Important developers, companies, organizations and news sources.

+ **[Communities Around Projects](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/ecosystem/communities-around-projects.md) **：成功的开源项目吸引了许多开发者，他们生产插件、库、教程和其他资源. 本节收集此类资源.
+ **[News](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/ecosystem/news.md)**：提供与前端 Web 开发相关的每日和每周新闻的网站和时事通讯.
+ **[Notable Community Members](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/ecosystem/notable-community-members.md)**：重要的工程师、布道者、建筑师和其他名人.
+ **[Organizations](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/ecosystem/organizations.md)**：围绕网络开发的商业公司和非营利组织.
+ **[Podcasts](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/ecosystem/podcasts.md)**：播客是一种数字媒体形式，由一系列音频、视频、数字广播、PDF 或 ePub 文件组成，这些文件通过网络联合发布自动订阅和下载，或在线流式传输到计算机或移动设备.

## Languages, Protocols, Browser APIs

编程/标记语言和网络相关标准.

+ **[Cascading Style Sheets (CSS)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/cascading-style-sheets-css.md) **：CSS 是一种样式表语言，用于描述以 HTML 或 XML 编写的文档的呈现方式. 它描述了应如何在屏幕、纸张、语音或其他媒体上呈现元素.
+ **[Document Object Model (DOM)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/document-object-model-dom.md) **：DOM 是 HTML、XML 和 SVG 文档的编程接口. 它定义了允许访问树的方法，以便它们可以更改文档结构、样式和内容.
+ **[HyperText Markup Language (HTML)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/hypertext-markup-language-html.md)**：HTML 是用于创建网页的标准标记语言，其元素构成了所有网站的构建块.
+ **[Hypertext Transfer Protocol (HTTP)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/hypertext-transfer-protocol-http.md) **：超文本传输​​协议（HTTP）是分布式、协作、超媒体信息系统的应用协议.  HTTP 是万维网数据通信的基础.
+ **[JavaScript (EcmaScript)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/javascript-ecmascript.md) **：JavaScript 是一种成熟的动态编程语言，当应用于 HTML 文档时，可以在网站上提供动态交互性. 它由 ECMAScript 标准定义.
+ **[JavaScript Object Notation (JSON)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/javascript-object-notation-json.md) **：JSON（JavaScript 对象表示法）是一种轻量级数据交换格式. 人类很容易阅读和书写. 机器很容易解析和生成. 它基于 JavaScript 编程语言的一个子集.
+ **[Scalable Vector Graphics (SVG)](https://raw.githubusercontent.com/dypsilon/frontend-dev-bookmarks/master/languages-protocols-browser-apis/scalable-vector-graphics-svg?sanitize=true.md)**：一种基于 XML 的矢量图像格式，用于支持交互性和动画的二维图形.
+ **[Service Workers](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/service-workers.md)**：一种使应用程序能够利用持久后台处理的方法，包括挂钩以在离线时启用 Web 应用程序的引导.
+ **[Templating Languages and Engines](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/templating-languages-and-engines.md) **：模板引擎是将程序逻辑和表示分离为两个独立部分的工具. 这使得逻辑和表示的开发更容易，提高了灵活性并简化了修改和维护.
+ **[Transpiled Languages](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/transpiled-languages.md)**：抽象语言转换为原生的、浏览器支持的标准，如 JavaScript 或 CSS.
+ **[Uniform Resource Identifier (URI)](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/uniform-resource-identifier-uri.md) **：URI 是一串用于标识资源的字符.  URI 最常见的形式是统一资源定位符 (URL).
+ **[Web Animations API](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/animation/web-animations-api.md) **：Web Animations 是一种新的 JavaScript API，用于驱动 Web 上的动画内容. 通过统一 SVG 和 CSS 的动画特性，Web Animations 解锁了以前只能以声明方式使用的特性，并向开发人员展示了强大的高性能动画功能.
+ **[WebAssembly](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/languages-protocols-browser-apis/webassembly.md)**：WebAssembly 旨在填补 JavaScript 迄今为止被迫占据的一个位置：一种可以作为编译器目标的低级代码表示.

## User Interface Components

用于网站和应用程序的嵌入式 UI 组件.

+ **[Buttons](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/buttons.md)**：术语按钮指的是任何图形控制元素，它为用户提供一种触发事件的简单方法，例如在搜索引擎中搜索查询，或与对话框交互，例如确认操作.
+ **[Code](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/code.md)**：专为嵌入网站而设计的代码查看器和编辑器.
+ **[Forms](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/forms.md) **：网页上的 HTML 表单允许用户输入发送到服务器进行处理的数据.  Web 用户使用复选框、单选按钮或文本字段填写表单.
+ **[Galeries & Image Sliders](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/galeries-and-image-sliders.md)**：一种在您的网站上展示图像集合的复杂方式.
+ **[Grid](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/grid.md)**：CSS 网格布局系统.
+ **[Rich Text Editors](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/rich-text-editors.md) **：富文本编辑器是用于在 Web 浏览器中编辑富文本的界面. 目的是减少用户尝试将其格式直接表达为有效 HTML 标记的工作量.
+ **[Table Of Contents](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/table-of-contents.md)**：自动生成目录的组件.
+ **[UI Kits](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/ui-kits.md)**：即用型组件的集合.
+ **[Video & Audio](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/user-interface-components/video-and-audio.md)**：播放网站音视频文件的组件.

## Workflow

任务自动化和资产交付.

+ **[Automated Testing](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/automated-testing.md)**：自动化软件测试是一个过程，在该过程中，软件工具在软件应用程序发布到生产环境之前对其执行预先编写好的测试脚本.
+ **[Build Tools](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/build-tools.md)**：工具包及其生态系统，可帮助您自动执行痛苦且重复的任务.
+ **[CSS Tools](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/css-tools.md)**：CSS 文件的分析、预处理和后期处理工具.
+ **[Code Editors](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/code-editors.md)**：专为编辑网站源代码而设计的文本编辑器程序.
+ **[Documentation](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/documentation.md)**：为 Web 可交付成果编写、生成、发布和使用文档.
+ **[Fonts for Programmers](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/fonts-for-programmers.md)**：程序员需要特殊字体，这有助于对齐代码并区分看起来相似的字符.
+ **[Getting Started](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/getting-started.md)**：设置前端开发工作流程的分步指南.
+ **[HTML Tools](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/html-tools.md)**：HTML 源代码的前后处理工具.
+ **[Image Post Processing](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/image-post-processing.md)**：图像转换和优化工具.
+ **[JavaScript Tools](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/javascript-tools.md)**：用于静态分析、JavaScript 文件预处理和后处理的工具.
+ **[Package Management](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/package-management.md)**：包管理器或包管理系统是一组软件工具，它们以一致的方式自动执行安装、升级、配置和删除可重用库和组件的过程.
+ **[Sourcemaps](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/sourcemaps.md)**：Sourcemap 是一种将组合/缩小文件映射回未构建状态的方法.
+ **[Version Control](https://github.com/dypsilon/frontend-dev-bookmarks/blob/master/workflow/version-control.md)**：版本控制或源代码控制是一个系统，它记录一个文件或一组文件随时间的变化，以便您以后可以调用特定版本.


------------------

## License

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png" /><br />本作品根据<a rel="license" href="http://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>获得许可.

请提供返回此存储库的链接. 这对于 GitHub 分叉来说不是必需的.
