<div class="github-widget" data-repo="KimberlyMunoz/empathy-in-engineering"></div>
## Empathy in Engineering [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 用于建立和促进更具同情心的工程文化的精选资源清单




## Words

有关如何在工作中建立更具同理心的文化及其好处的文章 ()、书籍 () 和视频 ().


### Empathy for your users

-  [Too sensitive: About microaggressions in UX](https://medium.com/@sara_ann_marie/too-sensitive-9752a86a8382) - Sara Ann Marie 在 Medium 上讨论了 UX 中的小问题是如何疏远用户的.
- [The Fantasy and Abuse of the Manipulable User](https://modelviewculture.com/pieces/the-fantasy-and-abuse-of-the-manipulable-user) - Model View Culture 中的 Betsy Haibel 讨论了用户体验“灰色模式”和“黑暗模式”如何在网络中流行.
- [Empathy: The key to a successful software project](https://www.oreilly.com/ideas/empathy-the-key-to-a-successful-software-project) - O&#39;Reilly 的 Gregory Brown 讨论了如何识别最重要的利益相关者并提出问题来为他们打造最好的产品.
- [On Facebook's "Compassion Team"](http://www.nytimes.com/2016/03/13/fashion/facebook-breakup-compassion-team.html?_r=0) - 《纽约时报》关注 Facebook 的“同情团队”，其任务是让 Facebook 更加人性化.
- [Designing for Disaster](https://vimeo.com/148927676) - Eric Meyer 在 An Event Apart 告诉我们他生命中最艰难的一天，以及为那些可能也经历了生命中最糟糕日子的人设计是多么重要.
- [Design for Real Life](https://abookapart.com/products/design-for-real-life) - Eric Meyer 和 Sara Wachter-Boettcher 合着的这本书重点介绍了识别压力情况和富有同情心的设计的设计技巧.


### Empathy for your peers

- [We Invite Everyone at Etsy to Do an Engineering Rotation: Here’s why](https://codeascraft.com/2014/12/22/engineering-rotation/) - 在 Etsy 的 Code as Craft 博客上，他们讨论了为什么让他们的设计师和产品经理进行工程轮换.
- [On Empathy & Pull Requests at Slack](https://slack.engineering/on-empathy-pull-requests-979e4257d158) | [Followup](https://slack.engineering/how-about-code-reviews-2695fb10d034) - Slack Engineering 博客探讨了拉取请求如何成为我们队友的同理心行为.
- [Blameless PostMortems and a Just Culture](https://codeascraft.com/2012/05/22/blameless-postmortems/) - Etsy 的 Code as Craft 博客讨论了他们如何从无可指责的事后分析中学习的角度来看待错误.
- [What Google Learned From Its Quest to Build the Perfect Team](http://www.nytimes.com/2016/02/28/magazine/what-google-learned-from-its-quest-to-build-the-perfect-team.html) - 《纽约时报》综合了 Google 的数据驱动文化如何发现以沟通和同理心为中心的规范可以打造更好的团队.
- [Difficult Conversations: How to Discuss What Matters Most](http://smile.amazon.com/gp/product/B004CR6ALA/) - 哈佛谈判项目的 Douglas Stone、Bruce Patton 和 Sheila Heen 撰写了关于如何通过一系列考虑“第三个故事”的技巧来处理困难对话的文章.
- [Engineering Empathy: Fostering an Inclusive Culture at our Code School](http://www.alterconf.com/talks/engineering-empathy-fostering-inclusive-culture-our-code-school) - Lateesha Thomas 在 Alterconf SF 2016 讨论了为什么同理心是 DevBootcamp 课程的一部分.
- [Empathy Explainer](https://www.youtube.com/watch?v=1Evwgu369Jw) - Brené Brown 的快速动画，讲述什么是同理心以及它与同情有何不同.

### Empathy in Hiring

- [A Guide to Empathetic Hiring Process](https://medium.com/@fox/a-guide-to-empathetic-hiring-processes-c11c7ce0cd49) - @Fox on Medium 讨论雇主可以做的一些简单的事情来善待求职者.


## JavaScript

有时您需要代码示例来实施上述策略.

### Simulations
- [JS Simulation of Dyslexia](http://geon.github.io/programming/2016/03/03/dsxyliea) - 这是对阅读有阅读障碍的一段文字的模拟.

### Bookmarklets
- [JS Bookmarklet Simulating Colorblindness](https://github.com/Altreus/colourblind) - 这是一个 JS 小书签，它可以获取任何页面并模拟色盲浏览的情况.
- [NoCoffee: JS Bookmarklet Simulating Low Vision Scenarios](https://accessgarage.wordpress.com/2013/02/09/458/) - 这是一个 JS 小书签，可以在低视力场景中获取任何页面并进行模拟.
