<div class="github-widget" data-repo="hangtwenty/dive-into-machine-learning"></div>
* **[SupportUkraineNow.org — "Real ways you can help Ukraine"](https://supportukrainenow.org)**

----

### Initiatives

在我们之前 [dive in](#dive-into-machine-learning)，这里有一些您可能也会感兴趣的著名项目和计划.

#### Related to machine learning

* [AlgorithmWatch](https://algorithmwatch.org/en/) — [newsletter](https://algorithmwatch.org/en/newsletter/) —“一个非营利性研究和宣传组织，致力于观察、解压和分析自动决策 (ADM) 系统及其对社会的影响.”
* [`daviddao/awful-ai`](https://github.com/daviddao/awful-ai) — “Awful AI 是一个精选列表，用于跟踪当前 AI 的可怕用法——希望提高认识”
* [`humanetech-community/awesome-humane-tech`](https://github.com/humanetech-community/awesome-humane-tech) — “促进改善福祉、自由和社会的解决方案”

#### Code against climate change

* [`ProjectDrawdown/solutions`](https://github.com/ProjectDrawdown/solutions) — [Project Drawdown](https://www.drawdown.org/)  — “Project Drawdown 随着 2017 年书的出版而进入了气候对话.随着 2020 年的 The Drawdown Review，该项目继续其激发和交流解决方案的使命.”  Python 和 Jupyter 笔记本.
* [`philsturgeon/awesome-earth`](https://github.com/philsturgeon/awesome-earth)
* [`daviddao/code-against-climate-change`](https://github.com/daviddao/code-against-climate-change)
* [`protontypes/open-sustainable-technology`](https://github.com/protontypes/open-sustainable-technology)

----

[![Dive Into Machine Learning](https://raw.githubusercontent.com/hangtwenty/dive-into-machine-learning/master/./banner.png)](https://github.com/hangtwenty/dive-into-machine-learning/blob/master/#dive-into-machine-learning)

## Dive into Machine Learning

你好呀！ 如果出现以下情况，您可能会发现此资源有帮助：

* 你知道 Python 或 [you're](https://github.com/alexmojaki/futurecoder) [learning](https://nbviewer.org/github/jakevdp/WhirlwindTourOfPython/blob/master/Index.ipynb) [it](https://github.com/vinta/awesome-python#resources) [:snake:](https://github.com/ossu/computer-science#introduction-to-programming)
* 你是新来 [Machine Learning](https://en.wikipedia.org/wiki/Machine_learning)
* 你在乎 [the ethics of ML](https://github.com/EthicalML/awesome-artificial-intelligence-guidelines)
  * **[8 Responsible Machine Learning Principles](https://ethical.institute/principles.html)**
  * [Open Ethics Canvas](https://openethics.ai/canvas/)
* 你边做边学

对于一些很棒的选择， [jump to the end](https://github.com/hangtwenty/dive-into-machine-learning#m或者e-ways-to-dive-into-machine-learning) 或者 [check out Nam Vu's guide, Machine Learning f或者 Software Engineers](https://github.com/ZuzooVn/machine-learning-f或者-software-engineers).

当然，获得专业知识并非易事. 另外，_我不是专家！_我只是想为您提供_来自_专家的一些重要资源.  ML 的应用无处不在. 我认为让更多人更多地了解 ML 符合公众利益，尤其是动手实践，因为有许多不同的学习方式.

无论是什么促使_你_潜入机器学习，如果你了解一点 Python，现在你可以在几分钟内上手机器学习_“Hello World！”_.

## Let's get started

## Tools you'll need

### If you prefer local installation

* [Python](https://www.python.org/) .  Python 3 是最佳选择.
* [Jupyter Notebook](https://jupyter.org/) .  （以前称为 IPython Notebook.）
* 一些科学计算包：
  *麻木
  *熊猫
  * scikit-学习
  * matplotlib

只需点击几下，您就可以安装 Python 3 和所有这些包 [Anaconda Python distribution](https://www.anaconda.com/download/) .  Anaconda 在数据科学和机器学习社区中很受欢迎.  （使用适合您的工具. [If you're unsure or need more context about using conda/virtualenv/poetry/pipenv, here's a very helpful guide](https://web.archive.org/web/20211226071314/https://brainsteam.co.uk/2021/04/01/opinionated-guide-to-virtualenvs/))

### Cloud-based options

您可以从浏览器中使用的一些选项：

- **[Binder](https://mybinder.org/) 是 Jupyter Notebook 的官方选择 [try JupyterLab](https://jupyter.org/try)**
- [Deepnote](https://deepnote.com/) 允许实时协作
- [Google Colab](https://colab.research.google.com/) 提供“免费”GPU

有关其他选项，请参阅：

- [markusschanta/awesome-jupyter, "Hosted Notebook Solutions"](https://github.com/markusschanta/awesome-jupyter#hosted-notebook-solutions)
- [ml-tooling/best-of-jupyter, "Notebook Environments"](https://github.com/ml-tooling/best-of-jupyter)

## Let's go!

**[Learn how to use Jupyter Notebook](http://opentechschool.github.io/python-data-intro/core/notebook.html) （5-10 分钟）.**（您可以 [learn by screencast](https://www.youtube.com/watch?v=qb7FT68tcA8) 反而.）

现在，跟随这个简短的练习：**[An introduction to machine learning with scikit-learn](http://scikit-learn.org/stable/tutorial/basic/tutorial.html) **. 在“ipython”或 Jupyter Notebook 中执行此操作，在笔记本中编码并执行代码.

[![I'll wait.](https://user-images.githubusercontent.com/2420688/29441281-00eff0c4-837f-11e7-9666-d653a1cd2372.jpeg)](http://scikit-learn.org/stable/tutorial/basic/tutorial.html)

### What just happened?

您刚刚使用以下方法对一些手写数字进行了分类 [scikit-learn](http://scikit-learn.org/stable/index.html). Neat huh?

## Dive in

## A Visual Introduction to Machine Learning

让我们更多地了解机器学习，以及一些常见的想法和关注点. 读 ["A Visual Introduction to Machine Learning, Part 1"](http://www.r2d3.us/visual-intro-to-machine-learning-part-1/) 经过 [Stephanie Yee](https://twitter.com/stephaniejyee) 和 [Tony Chu](https://twitter.com/tonyhschu/).

[![A Visual Introduction to Machine Learning, Part 1](https://user-images.githubusercontent.com/2420688/29441234-a2028c98-837e-11e7-88f2-1ca5a94684f6.gif)](http://www.r2d3.us/visual-intro-to-machine-learning-part-1/)

用不了多久. 这是一个美丽的介绍......尽量不要流口水！

## "A Few Useful Things to Know about Machine Learning"

好的. 让我们深入探讨.

读 **["A Few Useful Things to Know about Machine Learning"](http://homes.cs.washington.edu/~pedrod/papers/cacm12.pdf)** 经过 [Prof. Pedro Domingos](https://homes.cs.washington.edu/~pedrod/) . 它挤满了有价值的信息，但并非不透明.  （如果您还不完全理解，请不要担心.）花一些时间来学习这个.

## Jargon note

* [What is the difference between Data Analytics, Data Analysis, Data Mining, Data Science, Machine Learning, and Big Data?](http://www.quora.com/What-is-the-difference-between-Data-Analytics-Data-Analysis-Data-Mining-Data-Science-Machine-Learning-and-Big-Data-1)
* 另一个方便的术语： ["Data Engineering."](https://www.coursera.org/articles/what-does-a-data-engineer-do-and-how-do-i-become-one)
  * ["MLOps"](https://ml-ops.org/) 与 Data Eng 重叠，并且有 [an introductory MLOps section later in this guide](#production-deployment-mlops).

----

## Explore another notebook

接下来，使用这些笔记本中的一个或多个编写代码.

- 笔记本系列：
  - **2022:** [`rasbt/machine-learning-book`](https://github.com/rasbt/machine-learning-book) ——笔记本来自 [_Machine Learning with PyTorch and Scikit-Learn_ by Sebastian Raschka, Yuxi (Hayden) Liu, and Vahid Mirjalili](https://sebastianraschka.com/blog/2022/ml-pytorch-book.html)
- [Dr. Randal Olson's Example Machine Learning notebook](https://github.com/rhiever/Data-Analysis-and-Machine-Learning-Projects/blob/master/example-data-science-notebook/Example%20Machine%20Learning%20Notebook.ipynb)：“让我们假设我们正在为一家刚刚获得资金的初创公司工作，以创建一个智能手机应用程序，该应用程序可以自动识别智能手机上拍摄的照片中的花卉种类.我们的数据科学负责人要求我们创建一个演示机器学习该模型对花朵进行四次测量（萼片长度、萼片宽度、花瓣长度和花瓣宽度），并仅根据这些测量值来识别物种.”
  - [Launch in Binder, no installation steps required](https://mybinder.org/v2/gh/rhiever/Data-Analysis-and-Machine-Learning-Projects/master?filepath=example-data-science-notebook%2FExample%20Machine%20Learning%20Notebook.ipynb)
- 各种专题笔记本：
  - [trekhleb/machine-learning-experiments](https://github.com/trekhleb/machine-learning-experiments)
  - [trekhleb/homemade-machine-learning](https://github.com/trekhleb/homemade-machine-learning)

准备就绪后查找更多出色的 Jupyter 笔记本：

* **[Jupyter's official Gallery of Interesting Jupyter Notebooks: Statistics, Machine Learning and Data Science](https://github.com/jupyter/jupyter/wiki)** ([permalink](https://github.com/jupyter/jupyter/wiki/A-gallery-of-interesting-Jupyter-Notebooks/ae03c01ed25024aa06a4479ea600895d59b38bc4))

----

## Immerse yourself

选择以下课程之一，开始您的旅程.

## [Prof. Andrew Ng's _Machine Learning_ on Coursera](https://www.coursera.org/learn/machine-learning)

**[Prof. Andrew Ng's](https://hai.stanford.edu/people/andrew-ng) [_Machine Learning_](https://www.coursera.org/learn/machine-learning) 是一个流行和受人尊敬的免费在线课程. 我已经看到了它 [recommended](https://www.quora.com/How-do-I-learn-machine-learning-1/answer/Cory-Hicks-1) [often.](https://www.quora.com/How-do-I-learn-machine-learning-1/answer/Xavier-Amatriain) [And emphatically.](https://www.forbes.com/sites/anthonykosner/2013/12/29/why-is-machine-learning-cs-229-the-most-popular-course-at-stanford/)**

建议拿一本教科书作为深入参考. 我看到最常推荐的两个是 _[Understanding Machine Learning](https://web.archive.org/web/20210717194345/http://www.cs.huji.ac.il/~shais/UnderstandingMachineLearning/copy.html)_
and _[Elements of Statistical Learning](https://web.stanford.edu/~hastie/Papers/ESLII.pdf)_. [You only need to use one of the two options as your main reference; here's some context/comparison to help you pick which one is right for you.](https://github.com/hangtwenty/dive-into-machine-learning/issues/29)

### Public datasets and pet projects

你可能喜欢在旁边玩一个宠物项目. 当你为此做好准备时，你
可以探索其中之一： [Awesome Public Datasets](https://github.com/caesar0301/awesome-public-datasets), [paperswithcode.com/datasets](https://paperswithcode.com/datasets), [datasetlist.com](https://www.datasetlist.com/), [`KKulma/climate-change-data`](https://github.com/KKulma/climate-change-data#open-data)

### Tips for this course

* [Study tips for Prof. Andrew Ng's course, by Ray Li](https://rayli.net/blog/data/coursera-machine-learning-review/)
* 如果您想知道_它仍然是一门相关课程吗？_ 或试图弄清楚它是否适合您个人，请查看这些评论：
  * [Review: Andrew Ng's Machine Learning Course](https://towardsdatascience.com/review-andrew-ngs-machine-learning-course-b905aafdb7d9)
  * [The user reviews on Coursera](https://www.coursera.org/learn/machine-learning/reviews)

### Tips for studying on a busy schedule

每周都很难抽出时间. 因此，您可以尝试在可用时间内更_有效_地学习. 以下是一些方法：

* ["Learning How to Learn" by Barbara Oakley](https://www.coursera.org/learn/learning-how-to-learn/) 由 Barbara Oakley 编写，Coursera 上的免费视频课程.
 * 喜欢书籍/有声读物？ 这些是很好的选择：
  * [Barbara Oakley's book _A Mind for Numbers: How to Excel at Math and Science_](https://barbaraoakley.com/books/a-mind-for-numbers) ([reviews](https://www.goodreads.com/book/show/18693655-a-mind-for-numbers)) — “我们都有能力在一开始似乎并不自然的领域中脱颖而出”
  * [_Make It Stick: the Science of Successful Learning_](https://www.retrievalpractice.org/make-it-stick) ([reviews](https://www.goodreads.com/book/show/18770267-make-it-stick))

### Take my tips with a grain of salt

我不是机器学习专家. 我只是一名软件开发人员，这些资源/技巧对我很有用，因为我在业余时间学习了一些 ML.

## Other courses

* **作为 Jupyter 笔记本的数据科学课程：**
  * [Practical Data Science](http://radimrehurek.com/data_science_python/)
  * [Python Data Science Handbook, as Jupyter Notebooks](https://jakevdp.github.io/PythonDataScienceHandbook/)
*  [`microsoft/Data-Science-For-Beginners`](https://github.com/microsoft/Data-Science-For-Beginners) — [added in 2021](https://dev.to/azure/free-data-science-for-beginners-curriculum-on-github-1hme) — “关于数据科学的为期 10 周、20 节课的课程.每节课包括课前和课后测验、完成课程的书面说明、解决方案和作业.我们基于项目的教学法让您学习在构建过程中，这是一种让新技能‘坚持’的行之有效的方法.”
* 也可以看看 [`microsoft/ML-For-Beginners`](https://github.com/microsoft/ML-For-Beginners)

<details>
<summary>更多我看过的免费在线课程推荐.  （机器学习、数据科学和相关主题.）</summary>

* Coursera  [Data Science Specialization](https://www.coursera.org/specializations/jhu-data-science)
* [Prof. Pedro Domingos's introductory video series](https://www.youtube.com/playlist?list=PLTPQEx-31JXgtDaC6-3HxWcp7fq4N8YGr). [Prof. Pedro Domingos](https://homes.cs.washington.edu/~pedrod/) 写了论文 ["A Few Useful Things to Know About Machine Learning"](https://homes.cs.washington.edu/~pedrod/papers/cacm12.pdf)，您可能还记得本指南前面的内容.
* [`ossu/data-science`](https://github.com/ossu/data-science) （也可以看看 [`ossu/computer-science`](https://github.com/ossu/computer-science))
* [Stanford CS229: Machine Learning](https://github.com/afshinea/stanford-cs-229-machine-learning)
* [Harvard CS109: Data Science](https://cs109.github.io/2015/)
* [Advanced Statistical Computing (Vanderbilt BIOS8366)](http://stronginference.com/Bios8366/lectures.html) . 交互的.
* Kevin Markham 的视频系列， [Intro to Machine Learning with scikit-learn](http://blog.kaggle.com/2015/04/08/new-video-series-introduction-to-machine-learning-with-scikit-learn/), 从我们已经涵盖的内容开始，然后在一个舒适的地方继续.
* [UC Berkeley's Data 8: The Foundations of Data Science](http://data8.org/) 课程和教科书 [Computational and Inferential Thinking](https://www.inferentialthinking.com/) 教授数据科学中的关键概念.
* Mark A. Girolami 教授 [Machine Learning Module (GitHub Mirror).](https://github.com/josephmisiti/machine-learning-module) “适合有很强数学背景的人.”
* [An epic Quora thread: How can I become a data scientist?](https://www.quora.com/How-can-I-become-a-data-scientist?redirected_qid=59455)
* [`ujjwalkarn/Machine-Learning-Tutorials`](https://github.com/ujjwalkarn/Machine-Learning-Tutorials)

</details>

## Getting Help: Questions, Answers, Chats

从与您正在学习的课程相关的支持论坛和聊天开始.

查看 [datascience.stackexchange.com](https://datascience.stackexchange.com/) 和 [stats.stackexchange.com – such as the tag, _machine-learning_.](https://stats.stackexchange.com/questions/tagged/machine-learning) 有一些 subreddits，比如 [/r/LearningMachineLearning](https://www.reddit.com/r/learningmachinelearning) 和 [/r/MachineLearning](https://www.reddit.com/r/machinelearning).

不要忘记聚会. 还可以在项目页面等上查找聊天邀请.

### Some communities to know about!

* [/r/LearnMachineLearning](https://www.reddit.com/r/learnmachinelearning/)
* [/r/MachineLearning](https://reddit.com/r/MachineLearning)
* [/r/DataIsBeautiful](https://reddit.com/r/DataIsBeautiful)
* [/r/DataScience](https://reddit.com/r/DataScience)
* [Cross-Validated: stats.stackexchange.com](https://stats.stackexchange.com/)
* [`ossu/data-science` has a Discord server and newsletter](https://github.com/ossu/data-science#:~:text=Discord%20server)

## Supplement: Learning Pandas well

<details><summary>您会想要更熟悉 Pandas.</summary>

* **基本的**： [Things in Pandas I Wish I'd Had Known Earlier](http://nbviewer.jupyter.org/github/rasbt/python_reference/blob/master/tutorials/things_in_pandas.ipynb) （作为 Jupyter Notebook）
* **基本的**： [10 Minutes to Pandas](http://pandas.pydata.org/pandas-docs/stable/10min.html)
* 另一个有用的教程： [Real World Data Cleanup with Python and Pandas](https://trendct.org/2016/08/05/real-world-data-cleanup-with-python-and-pandas/)
* [Video series from Data School, about Pandas](https://www.youtube.com/playlist?list=PL5-da3qGB5ICCsgW1MxlZ0Hq8LL5U3u9y) .  “30 个常见 pandas 任务的参考指南（加上 6 小时的支持视频）.”
* 以下是我在继续学习时发现特别有用的一些文档：
  * [Cookbook](http://pandas.pydata.org/pandas-docs/stable/cookbook.html)
  * [Data Structures](http://pandas.pydata.org/pandas-docs/stable/dsintro.html), 特别是 [DataFrame](http://pandas.pydata.org/pandas-docs/stable/dsintro.html#dataframe) 部分
  * [Reshaping by pivoting DataFrames](https://pandas.pydata.org/pandas-docs/stable/user_guide/reshaping.html)
  * [Computational tools](http://p和as.pydata.org/p和as-docs/stable/computation.html) 和 [StackExchange thread: "What is covariance in plain language?"](https://stats.stackexchange.com/questions/29713/what-is-covariance-in-plain-language)
  * [Group By (split, apply, and combine DataFrames)](http://pandas.pydata.org/pandas-docs/stable/groupby.html)
  * [Visualizing your DataFrames](https://pandas.pydata.org/pandas-docs/stable/user_guide/visualization.html)
* 用于缩放 `pandas` 和替代品的书签
  * [`dask`](https://dask.org/)：类似 Pandas 的界面，但用于大于内存的数据和“底层”并行性.
  * [`vaex`](https://vaex.io)：“用于 Python、ML 的核心外混合 Apache Arrow/NumPy DataFrame，以每秒十亿行的速度可视化和探索大表格数据”
</details>

## Supplement: Troubleshooting

这些调试工具可以在 Jupyter notebook 内部（或外部）使用：

* [`birdseye`](https://birdseye.readthedocs.io/en/latest/integrations.html#jupyter-ipython-notebooks),
  [`snoop`](https://github.com/alexmojaki/snoop)
* [`pandas-log`](https://github.com/eyaltrabelsi/pandas-log.git)

有比这更多的工具，但那些可能会让你开始，或者可能是
在你学习的时候特别有用. 学习之外，故障排除不止于此
日志或调试器，当然... [there's also some MLOps links, later in this guide](#production-deployment-mlops).

## Assorted Tips and Resources

### Risks - some starting points

 “机器学习系统自动从数据中学习程序.” 佩德罗·多明戈斯，在 ["A Few Useful Things to Know about Machine Learning."](http://homes.cs.washington.edu/~pedrod/papers/cacm12.pdf) 您生成的程序将需要维护. 就像任何更快地创建程序的方法一样，您可以 [technical debt](https://en.wikipedia.org/wiki/Technical_debt).

这是摘要 [Machine Learning: The High-Interest Credit Card of Technical Debt](https://research.google/pubs/pub43146/):

 &gt; 机器学习为快速构建复杂系统提供了一个非常强大的工具包. 本文认为，将这些速赢视为免费是危险的. 使用技术债务框架，我们注意到在应用机器学习时，在系统级别产生大量持续维护成本非常容易. 本文的目标是强调几个机器学习特定的风险因素和设计模式，以尽可能避免或重构. 其中包括边界侵蚀、纠缠、隐藏的反馈循环、未声明的消费者、数据依赖、外部世界的变化以及各种系统级反模式.

如果您正在阅读本指南，则应该阅读那篇论文. 你也可以 [listen to a podcast episode interviewing one of the authors of this paper](https://softwareengineeringdaily.com/2015/11/17/machine-learning-and-technical-debt-with-d-sculley/).

* **[Awesome Production Machine Learning](https://github.com/EthicalML/awesome-production-machine-learning)，“精选的开源库列表，用于部署、监控、版本控制和扩展您的机器学习.”** 它包括一个关于 [privacy-preserving ML](https://github.com/EthicalML/awesome-production-machine-learning#privacy-preserving-machine-learning)， 顺便一提！
* **[“机器学习规则：[可靠] ML 工程的最佳实践”](http://martin.zinkevich.org/rules_of_ml/rules_of_ml.pdf)** Martin Zinkevich 着，关于 ML 工程实践.
* [The High Cost of Maintaining Machine Learning Systems](http://www.kdnuggets.com/2015/01/high-cost-machine-learning-technical-debt.html)
* [Overfitting vs. Underfitting: A Conceptual Explanation](https://towardsdatascience.com/overfitting-vs-underfitting-a-conceptual-explanation-d94ee20ca7f9)
* [11 Clever Methods of Overfitting and How to Avoid Them](http://hunch.net/?p=22)
* ["So, you want to build an ethical algorithm?" An interactive tool to prompt discussions](https://cdt.info/ddtool/) [(source)](https://github.com/numfocus/algorithm-ethics)

当然，这不是一个完整的列表！ 它们只是一些入口和起点.  _知道一些其他资源吗？ 请分享它们，欢迎请求请求！_

### Peer review

**[OpenReview.net](https://openreview.net/about)** “旨在促进科学交流的开放性，尤其是同行评审过程.”

<details>
<summary><em>关于 OpenReview.net 的更多信息</em></summary>

 &gt; * **开放同行评审：**我们提供了一个可配置的同行评审平台，概括了许多微妙的开放等级，允许会议组织者、期刊和其他“评审实体”配置他们选择的特定政策. 我们打算充当不同政策的试验台，帮助科学界试验开放奖学金，同时解决有关保密性、归属和偏见的合理担忧.
&gt; * **Open Publishing：** 跟踪投稿，协调编辑、审稿人和作者的工作，并主持……分片和分发以提高速度和可靠性.
 &gt; * **开放获取：** 所有人免费获取论文，免费提交论文. 没有费用.
 &gt; * **公开讨论：** 接受论文的托管，以及他们的评论和评论. 继续讨论与论文接受后相关的论坛. 出版场所主席/编辑可以控制审阅/评论表格的结构、读/写访问及其时间安排.
&gt; * **开放目录：** 包含利益冲突信息的人员集合，包括机构和关系，例如共同作者、共同 PI、同事、顾问/顾问和家庭关系.
 &gt; * **公开建议：** 科学主题和专业知识的模型. 人员目录包括科学专业知识. 会议的审稿人-论文匹配有数千份提交，包括各种专业知识、投标、限制和审稿人平衡. 向用户推荐论文.
&gt; * **开放 API：**我们提供了一个简单的 REST API [...]
 &gt; * **开源：**我们致力于开源.  OpenReview 的许多部分已经在 [OpenReview organization on GitHub](https://github.com/openreview) . 一些进一步的版本正在等待对代码库进行专业的安全审查.

> * [OpenReview.net](https://openreview.net/) 由马萨诸塞大学阿默斯特分校信息与计算机科学学院 Andrew McCallum 的信息提取与综合实验室创建
>
> * [OpenReview.net](https://openreview.net/) 建立在论文中描述的早期版本之上 [Open Scholarship and Peer Review: a Time for Experimentation](https://openreview.net/forum?id=xf0zSBd2iufMg) 发表于 [ICML 2013 Peer Review Workshop](https://openreview.net/group?id=ICML.cc/2013/PeerReview).
>
 &gt; * OpenReview 是一个长期项目，旨在通过改进同行评审来推进科学发展，并通过《科学与社会规范》获得合法的非营利地位. 我们非常感谢各种各样的支持 [OpenReview Sponsors](https://openreview.net/sponsors)––科学同行评议是神圣不可侵犯的，不应由任何一个赞助商拥有.

</details>

### Production, Deployment, [MLOps](https://ml-ops.org/)

如果您正在学习 MLOps 但发现它不知所措，这些资源可能会帮助您找到方向：

* [MLOps Stack Template](https://valohai.com/blog/the-mlops-stack/) 通过亨里克斯科格斯特罗姆
* [Lessons on ML Platforms from Netflix, DoorDash, Spotify, and more](https://towardsdatascience.com/lessons-on-ml-platforms-from-netflix-doordash-spotify-and-more-f455400115c7) Ernest Chan 在*迈向数据科学*

推荐的 awesomelists 保存/明星/观看：

* **[EthicalML/awesome-artificial-intelligence-guidelines](https://github.com/EthicalML/awesome-artificial-intelligence-guidelines)**
* **[EthicalML/awesome-production-machine-learning](https://github.com/EthicalML/awesome-production-machine-learning#privacy-preserving-machine-learning)**
* **[visenger/awesome-ml-model-governance](https://github.com/visenger/Awesome-ML-Model-Governance)**
* **[visenger/awesome-MLOps](https://github.com/visenger/awesome-mlops)**
* **[eugeneyan/applied-ml](https://github.com/eugeneyan/applied-ml)**

### Easier sharing of deep learning models and demos

*  **[Replicate](https://replicate.com) “让共享正在运行的机器学习模型变得容易”**
  * 从您的浏览器轻松试用深度学习模型
  * 演示链接到 GitHub 上的论文/代码，如果您想深入了解并了解其工作原理
  * 模型在 ** 构建的容器中运行[`cog`](https://github.com/replicate/cog),** “用于机器学习的容器.” 
    * 它是一种开源工具，用于将模型放入可重现的 Docker 容器中. 
    * 您可以仅使用 Python 和 YAML 将模型放入容器中.
  * Replicate 有一个 API 可以为您运行预测

----

## Deep Learning

请注意：一些专家警告我们不要过于超前，并鼓励在进入深度学习之前先学习 ML 基础知识. 这是本指南中一些链接课程的解释——例如，Andrew Ng 教授鼓励在学习 DL 之前先在 ML 中打下基础. 也许您现在已经准备好，或者您可能想尽快开始并在学习其他 ML 知识的同时学习一些深度学习.

当您准备好深入学习时，这里有一些有用的资源.

* **[_Dive into Deep Learning_](https://d2l.ai/) - 一本关于深度学习的互动书**（[view on GitHub](https://github.com/d2l-ai/d2l-en))
  * 快速开始：
    * [Run this book locally, using Jupyter Notebooks](https://d2l.ai/chapter_installation/index.html)
    * [Run this book in your browser, using Google Colab](https://d2l.ai/chapter_appendix-tools-for-deep-learning/colab.html)
  * “整本书都是在 Jupyter 笔记本中起草的，将说明图、数学和交互式示例与独立代码无缝集成.”
  * “您可以修改代码和调整超参数以获得即时反馈，以积累深度学习的实践经验.”

<details><summary>More deep learning links</summary>

* **[Prof. Andrew Ng's](https://scholar.google.com/citations?user=mG4imMEAAAAJ&hl=en) [courses on Deep Learning](https://www.coursera.org/specializations/deep-learning)!** 有五门课程，作为 [Deep Learning Specialization on Coursera](https://www.coursera.org/specializations/deep-learning) . 这些课程是他新事业的一部分， [deeplearning.ai](https://www.deeplearning.ai)
  * 关于它的一些课程笔记： [ashishpatel26/Andrew-NG-Notes](https://github.com/ashishpatel26/Andrew-NG-Notes)
* **[_Deep Learning_](https://www.deeplearningbook.org/)，麻省理工学院出版社出版的免费书籍.** 作者：Ian Goodfellow、Yoshua Bengio 和 Aaron Courville.
  * 一个值得注意的证明书在这里： ["What are the best ways to pick up Deep Learning skills as an engineer?"](https://www.quora.com/What-are-the-best-ways-to-pick-up-Deep-Learning-skills-as-an-engineer)
* [`fastai/fastbook`](https://github.com/fastai/fastbook) 作者：Jeremy Howard 和 Sylvain Gugger —“深度学习、fastai 和 PyTorch 简介.”
* [`explosion/thinc`](https://github.com/explosion/thinc) 是一个有趣的库，它包装了 **PyTorch**、**TensorFlow** 和 **MXNet** 模型.
  * “模型定义的简洁函数式编程方法，使用组合而不是继承.”
  *“用于描述对象树和超参数的集成配置系统.”
* [paperswithcode.com](https://paperswithcode.com/) — “Papers with Code 的使命是创建一个包含机器学习论文、代码、数据集、方法和评估表的免费开放资源.”
* [`labmlai/annotated_deep_learning_paper_implementations`](https://github.com/labmlai/annotated_deep_learning_paper_implementations)  — “深度学习论文的实现/教程，并附有注释.” 其中 50 多个！ 真的很好地注释和解释.
* [Distill.pub](https://distill.pub/about/) 发布可探索的解释，绝对值得探索和关注！

</details>

----

## Collaborate with Domain Experts

机器学习可以很强大，但它并不神奇.

每当您应用机器学习来解决问题时，您都会在某个特定的问题领域中工作. 要获得好的结果，您或您的团队将需要“实质性专业知识”/“领域知识”. 尽你所能，为自己学习......但你也应该**与专家合作.**如果你与专家合作，你会得到更好的结果 [subject-matter experts and domain experts](https://en.wikipedia.org/wiki/Subject-matter_expert#Domain_expert_(software)).

### Machine Learning and User Experience (UX)

我不能说得更好：

&gt; **机器学习不会弄清楚要解决什么问题.**如果你不符合人类的需求，你只会构建一个非常强大的系统来解决一个非常小的——或者可能不存在的——问题.

那句话来自 ["The UX of AI" by Josh Lovejoy](https://design.google/library/ux-ai/) . 换句话说， **[You Are Not The User](https://www.nngroup.com/articles/false-consensus/).** 建议阅读： [Martin Zinkevich's "Rules of ML Engineering", Rule #23: "You are not a typical end user"](https://developers.google.com/machine-learning/guides/rules-of-ml/#human_analysis_of_the_system)

## Skilling up

有哪些方法可以练习？

<details>
<summary><strong>一种方式：</strong>比赛和挑战</summary>

你需要**练习.** [On Hacker News, user olympus commented to say you could use competitions to practice 和 evaluate yourself](https://news.ycombinat或者.com/item?id=10508565). [Kaggle](https://www.kaggle.com/competitions) 和 [ChaLearn](http://www.chalearn.或者g/) 是机器学习竞赛的中心.  （你可以找到更多比赛 [here](https://github.com/paperswithcode/releasing-research-code#results-leaderboards) 或者 [here](https://towardsdatascience.com/12-data-science-ai-competitions-to-advance-your-skills-in-2021-32e3fcb95d8c).)

你还需要**理解.**你应该回顾一下 Kaggle 竞赛获奖者对他们的解决方案的看法， [for example, the "No Free Hunch" blog](http://blog.kaggle.com/) . 起初这些可能超出您的理解范围，但一旦您开始理解和欣赏这些，您就会知道您正在取得进展.

比赛和挑战只是练习的一种方式！ [Machine Learning isn't just about Kaggle competitions](https://jvns.ca/blog/2014/06/19/machine-learning-isnt-kaggle-competitions).

</details>

<details>
<summary><strong>另一种方法：</strong>尝试做一些实践研究</summary>

这是练习的补充方法：**做练习研究.**

 1. **问一个问题. 开始探索一些数据.** ["most important thing in data science is the question"](https://github.com/DataScienceSpecialization/courses/blob/master/01_DataScientistToolbox/03_02_whatIsData/index.Rmd#the-data-is-the-second-most-important-thing) ([Dr. Jeff T. Leek](https://github.com/jtleek) ). 所以从一个问题开始. 然后，找到 [real data](https://github.com/caesar0301/awesome-public-datasets) . 分析一下. 然后 ...
 2. **交流结果.**当你认为你有一个新发现时，请求审查. 当你还在学习的时候，在非正式的社区（有些是 [linked below](#some-communities-to-know-about)).
3. **从反馈中学习.**考虑 [learning in public](https://www.swyx.io/learn-in-public/) ，它对某些人很有用.  （不过不要给自己压力！每个人都是不同的，了解你的学习风格是件好事.）

你怎么能提出有趣的问题？ 这是一种方法. 每周选择一天来 [look for public datasets](https://github.com/caesar0301/awesome-public-datasets) 并写下想到的一些问题. 另外，注册 [Data is Plural](https://tinyletter.com/data-is-plural) ，有趣的数据集通讯. 当一个问题激发了您的灵感时，请尝试使用您正在学习的技能来探索它.

这个建议，做实践研究和从复习中学习，是基于 [a conversation](https://github.com/hangtwenty/dive-into-machine-learning/issues/11#issuecomment-153934120) 和 [Dr. Randal S. Olson](http://www.randalolson.com/) . 这是奥尔森的更多建议， [quoted 和 permission:](https://github.com/hangtwenty/dive-into-machine-learning/issues/11#issuecomment-154135498)

 &gt; 我认为最好的建议是告诉人们始终清楚地展示他们的方法并避免过度解释他们的结果. 成为专家的一部分是知道很少有明确的答案，尤其是当您处理真实数据时.

当你重复这个过程时，你的实践研究会变得更科学、更有趣、更专注. 还， [here's a video about the scientific method in data science.](https://101.datascience.community/2012/06/27/the-data-scientific-method/))

</details>

<details>
<summary>更多机器学习职业相关链接</summary>

* ["Advice on building a machine learning career and reading research papers by Prof. Andrew Ng"](https://www.kdnuggets.com/2019/09/advice-building-machine-learning-career-research-papers-andrew-ng.html)
* 一些用于查找/关注有趣论文/代码的链接：
  * [Papers With Code](https://paperswithcode.com/) 是一个值得关注的热门站点，它可以引导您找到其他资源. [github.com/paperswithcode](https://github.com/paperswithcode)
  * [MIT: Papers + Code](https://mitibmwatsonailab.mit.edu/research/papers-code/) — "Peer-review is the lifeblood of scientific validation and a guardrail against runaway hype in AI. Our commitment to publishing in the top venues reflects our grounding in what is real, reproducible, and truly innovative."
  * [papers.labml.ai/papers/weekly](https://papers.labml.ai/papers/weekly), [monthly](https://papers.labml.ai/papers/monthly/)
* 欢迎拉取请求！

</details>

---

## More Data Science materials

以下是一些额外的数据科学资源：

* **[Python Data Science Handbook, as Jupyter Notebooks](https://jakevdp.github.io/PythonDataScienceHandbook/)**
* [`r0f1/datascience`](https://github.com/r0f1/datascience) — “使用 Python 练习数据科学的精选资源列表，不仅包括库，还包括指向教程、代码片段、博客文章和讲座的链接.”

### Aside: Bayesian Statistics and Machine Learning

From [the "Bayesian Machine Learning" overview on Metacademy](https://metacademy.org/roadmaps/rgrosse/bayesian_machine_learning):

 &gt; ... 贝叶斯思想在过去 20 年左右的时间里对机器学习产生了重大影响，因为它们在构建现实世界现象的结构化模型方面提供了灵活性. 算法的进步和计算资源的增加使得拟合丰富的、高度结构化的模型成为可能，这些模型以前被认为是难以处理的.

<details>
<summary>这里有一些学习贝叶斯方法的好资源.</summary>

* **免费书籍** _[Probabilistic Programming and Bayesian Methods for Hackers](http://camdavidsonpilon.github.io/Probabilistic-Programming-and-Bayesian-Methods-for-Hackers/)_. Made with a "computation/understanding-first, mathematics-second point of view." Uses [PyMC](https://github.com/pymc-devs/pymc) . 它也有印刷版！
 * 喜欢边玩边学？ 我也是. 尝试 [19 Questions](https://github.com/fulldecent/19-questions)，“一种机器学习游戏，它会问你问题并猜测你正在思考的对象”，并且**解释了它使用的是哪种贝叶斯统计技术！**
* [_Time Series Forecasting with Bayesian Modeling by Michael Grogan_](https://www.manning.com/liveprojectseries/time-series-forecasting-with-bayesian-modeling)，一个包含 5 个项目的系列 - 付费但第一个项目免费.
* [Bayesian Modelling in Python](https://github.com/markdregan/Bayesian-Modelling-in-Python) . 用途 [PyMC](https://github.com/pymc-devs/pymc) 以及.

</details>


----

## More ways to "Dive into Machine Learning"

以下是学习机器学习的其他一些指南.

* [Machine Learning for Software Engineers, by Nam Vu](https://github.com/ZuzooVn/machine-learning-for-software-engineers) . 用他们的话说，这是“专为软件工程师设计的自上而下和结果优先的方法”. 绝对书签并使用它. 它可以回答许多问题并将您与大量资源联系起来.
* [`ujjwalkarn/Machine-Learning-Tutorials`](https://github.com/ujjwalkarn/Machine-Learning-Tutorials)
* [`josephmisiti/awesome-machine-learning`](https://github.com/josephmisiti/awesome-machine-learning)
  * [`microsoft/ML-For-Beginners`](https://github.com/microsoft/ML-For-Beginners), [`microsoft/Data-Science-For-Beginners`](https://github.com/microsoft/Data-Science-For-Beginners)
  * [Machine Learning Crash Course from Google](https://developers.google.com/machine-learning/crash-course/) ([more of their options](https://cloud.google.com/training/machinelearning-ai))
  * [Amazon AWS](https://aws.amazon.com/machine-learning/mlu/) ([more of their options](https://aws.amazon.com/machine-learning/learn/))
* **2022:** [_Machine Learning with PyTorch and Scikit-Learn_ by Sebastian Raschka, Yuxi (Hayden) Liu, and Vahid Mirjalili](https://github.com/rasbt/machine-learning-book)
