<div class="github-widget" data-repo="craftcms/awesome"></div>
## Craft CMS ![Awesome](https://badgen.net/badge/icon/Resources?icon=awesome&label=Craft%20CMS&labelColor=red&color=black)

官方名单 [awesome](https://github.com/topics/awesome) 制作 CMS 资源、文章和其他闪亮的东西.

&gt; **注意**  
&gt; 缺少什么？ [Edit this page](https://github.com/craftcms/awesome/edit/main/README.md)!


### Contributing
请看一下 [contribution guidelines](https://github.com/craftcms/awesome/blob/master/CONTRIBUTING.md) . 如果您在此处看到不再维护或不合适的文章或资源，请提交拉取请求. 我们感谢您的意见！

<!-- PLEASE USE `doctoc --maxlevel 3 README.md` TO KEEP THE TOC TO AN APPROPRIATE SIZE -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->



<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Official Links

- **网站** - [craftcms.com](https://craftcms.com)
- **时事通讯** - [craftcms.com/newsletter](https://craftcms.com/newsletter)
- **工艺品贸易** - [craftcms.com/commerce](https://craftcms.com/commerce)
- **演示** - [craftcms.com/demo](https://craftcms.com/demo)
- **教程** - [craftcms.com/docs/getting-started-tutorial](https://craftcms.com/docs/getting-started-tutorial/)
- **Craft CMS 4 文档** - [craftcms.com/docs/4.x](https://craftcms.com/docs/4.x/) - [Class Reference](https://docs.craftcms.com/api/v4)
- **商务 4 文档** - [craftcms.com/docs/commerce/4.x](https://craftcms.com/docs/commerce/4.x/) - [Class Reference](https://docs.craftcms.com/commerce/api/v4)
- **知识库** - [craftcms.com/knowledge-base](https://craftcms.com/knowledge-base)
- **伙伴** - [craftcms.com/partners](https://craftcms.com/partners)
- **工艺控制台** - [console.craftcms.com](https://console.craftcms.com)
- **存储库** - [github.com/craftcms/cms](https://github.com/craftcms/cms)
- **入门项目** - [github.com/craftcms/craft](https://github.com/craftcms/craft)
- **点所有会议** - [craftcms.com/events](https://craftcms.com/events)

---

## Community

- [Craft Coding Challenge](https://craftcodingchallenge.com/) - Craft CMS 开发人员测试和提高编码技能的培训基地.
- [Craft Cookbook](https://craftcookbook.net/) - 常见 Craft CMS 问题的快速解决方案.
- [CraftQuest](https://craftquest.io/) - 无限制地参加工艺培训（以及更多）.
- [Discord](https://discord.me/craftcms) - Craft CMS 的官方 Discord 社区.
- [Facebook](https://www.facebook.com/craftcms/) - 喜欢官方 Craft CMS Facebook 页面.
- [Issues, Feedback, Discussions](https://github.com/craftcms/cms/issues) - 在 GitHub 上发布功能想法和错误报告.
- [Meetups](https://craftcms.com/meetups) - 寻找当地的 Craft 聚会.
- [StackExchange](https://craftcms.stackexchange.com) - 针对管理员、最终用户、开发人员和设计人员的问答.
- [Twitter](https://twitter.com/craftcms) - 关注对话，官方社区标签是 [`#craftcms`](https://twitter.com/hashtag/craftcms).
- [Mastodon](https://mastodon.social/@CraftCMS) - 最新消息，在最新的网络上.
- [Work With Craft](https://www.workwithcraft.com/) - 专门的工作委员会旨在将雇主与工艺专业人士联系起来.

---

## Plugins

- [Craft 4 Plugins](https://plugins.craftcms.com/?craft4)
- [Craft 3 Plugins](https://plugins.craftcms.com/?craft3)
- [Developer Portal](https://console.craftcms.com/)
- [Generator](https://github.com/craftcms/generator/)

---

## Resources

### Core Technologies
- [PHP](http://www.php.net/) - 一种流行的通用脚本语言.
- [Yii](https://www.yiiframework.com/) - 一个快速、安全、高效的 PHP 框架.
- [Twig](https://twig.symfony.com/) - 灵活、快速、安全的 PHP 模板引擎.
- [MySQL](https://www.mysql.com/) - 世界上最受欢迎的开源数据库.
- [PostgreSQL](https://www.postgresql.org/) - 世界上最先进的开源数据库.

### Articles

##### Assets
- [9 Tips For Speeding Up Your Imager Transforms](https://www.vaersaagod.no/en/9-tips-for-speeding-up-your-imager-transforms-in-craftcms) 作者：André Elvan/Værsågod - `2017 年 6 月 12 日`
- [Creating Optimized Images in Craft CMS](https://nystudio107.com/blog/creating-optimized-images-in-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 9 月 9 日`
- [Responsive Images with `srcset` & Craft](https://www.viget.com/articles/responsive-images-with-srcset-craft) 作者：Trevor Davis/Viget - `2016 年 3 月 22 日`
- [Simple Static Asset Versioning in Craft CMS](https://nystudio107.com/blog/simple-static-asset-versioning) 作者：Andrew Welch/nystudio107 - `2018 年 1 月 6 日`
- [Support for Imgix in Imager for Craft](https://www.vaersaagod.no/en/support-for-imgix-in-imager-for-craftcms) 作者：André Elvan/Værsågod - `2017 年 7 月 10 日`

##### Commerce
- [Multi-attribute variant selection in Craft Commerce](https://www.vaersaagod.no/en/multi-attribute-variant-selection-in-craft-commerce) 作者：André Elvan/Værsågod - `2017 年 2 月 13 日`

- [Craft CMS Content Builder: The Client Experience](https://designbycosmic.com/articles/development/craft-cms-content-builder-the-client-experience) 通过 Cosmic - `2017 年 2 月 1 日`
- [Creating a Content Builder in Craft CMS](https://nystudio107.com/blog/creating-a-content-builder-in-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 1 月 16 日`

- [Add users to Craft with content migrations](https://joren.co/add-users-to-craft-with-content-migrations/) 作者：Joren Van Hee - `2018 年 10 月 28 日`
- [Using Content Migrations in Craft 3](https://adigital.agency/blog/using-content-migrations-in-craft-3) 作者：Matt Shearing/A Digital - `2018 年 2 月 23 日`

##### Craft 3
- [11 Things You Need to Know About Craft 3](https://mijingo.com/blog/11-things-you-need-to-know-about-craft-3) 作者：Ryan Irelan/Mijingo
- [Why you should update your website to Craft CMS 3](https://weareabstrakt.com/views/why-you-should-update-your-website-to-craft-cms-3) 作者：Lauren Swarbrick/Abstrakt - `2019 年 11 月 22 日`

##### Deployment
- [Atomic Deployments Without Tears](https://nystudio107.com/blog/executing-atomic-deployments) 安德鲁·韦尔奇/nystudio107

##### Element API
- [Global Sets in the Craft Element API](https://mijingo.com/blog/accessing-global-sets-from-the-element-api-in-craft) 作者：Ryan Irelan/Mijingo
- [Lazy Loading with the Element API & VueJS](https://nystudio107.com/blog/lazy-loading-with-the-element-api-vuejs) 作者：Andrew Welch/nystudio107 - `2017 年 1 月 14 日`

##### Environments
- [Database & Asset Syncing Between Environments in Craft CMS](https://nystudio107.com/blog/database-asset-syncing-between-environments-in-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 4 月 7 日`
- [Localization & Multi-Environment Setup in Craft](https://designkarma.co.uk/blog/localization-multi-environment-setup-in-craft) 作者：Ian Ebden/Design Karma - `2017 年 4 月 4 日`
- [Multi-Environment Config for Craft CMS](https://nystudio107.com/blog/multi-environment-config-for-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 9 月 4 日`

##### Front End
- [Craft CMS AJAX Page Transitions with `history.pushState`](https://designbycosmic.com/articles/development/craft-cms-ajax-page-transitions-with-history-pushstate) 通过 Cosmic - `2017 年 2 月 1 日`
- [Editing a Front End Form with Matrix](https://caffeinecreations.ca/blog/editing-a-front-end-form-with-matrix/) 肖恩史密斯/咖啡因创作
- [Language switcher for Craft 3](https://www.thebasement.be/language-switcher-for-craft-3/) 作者：Jan D&#39;Hollander - `2018 年 7 月 25 日`

##### Getting Started
- [20 Principles for Craft CMS](https://hackernoon.com/20-principles-for-craft-cms-ae08d80c17de) 作者：Knut Melvær - `2017 年 9 月 30 日`
- [Craft CMS 3 Orientation Guide](https://nystudio107.com/blog/craft-cms-3-orientation-guide-welcome) 作者：Andrew Welch/nystudio107 - `2018 年 7 月 31 日`
- [Craft CMS through the eyes of a website designer](https://adigital.agency/blog/craft-cms-through-the-eyes-of-a-website-designer) 作者：Laura Montgomery/A Digital Agency– `2021 年 9 月 3 日`
- [How To Get Started With SEO In Craft CMS](https://blog.galaxyweblinks.com/how-to-get-started-with-seo-in-craft-cms/) 通过 Galaxy Weblinks - `2018 年 6 月 22 日`
- [Setting up a New Craft CMS 3 Project](https://nystudio107.com/blog/setting-up-a-craft-cms-3-project) 作者：Andrew Welch/nystudio107 - `2018 年 1 月 12 日`

##### Integrations
- [Sending notifications to Slack and other channels with Craft CMS](https://rias.be/blog/sending-notifications-to-slack-and-other-channels-with-craft-cms) 在 Rias Van der Veken
- [The Living Component Library](https://clearleft.com/posts/443) 作者：Graham Smith/Clearleft - `2017 年 3 月 13 日`

##### Local Dev
- [Getting Started with Craft CMS 2 and Laravel Valet](https://medium.com/@jalendport/running-craft-cms-2-on-laravel-valet-8a750d1c19e) 作者：Jalen Davenport - `2018 年 2 月 9 日`
- [Getting Started with Craft CMS 3 and Laravel Valet](https://medium.com/@jalendport/running-craft-cms-3-on-laravel-valet-6df61e5193fd) 作者：Jalen Davenport - `2018 年 2 月 23 日`
- [How I Automate My Local Development Craft CMS 2.x Installs](https://medium.com/@timknight/how-i-automate-my-craft-cms-2-x-installs-8427f70914e4) 作者：Tim Knight - `2017 年 7 月 17 日`
- [A Craft CMS Development Workflow With Docker: Part 1 - Local Development](https://mattgrayisok.com/a-craft-cms-development-workflow-with-docker-part-1-local-development) 作者：Matt Gray - `2018 年 12 月 4 日`

##### Modules
- [Enhancing a Craft CMS 3 Website with a Custom Module](https://nystudio107.com/blog/enhancing-a-craft-cms-3-website-with-a-custom-module) 作者：Andrew Welch/nystudio107 - `2018 年 3 月 19 日`

##### Performance and Testing
- [A/B Split Testing with Nginx & Craft CMS](https://nystudio107.com/blog/a-b-split-testing-with-nginx-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 11 月 29 日`
- [Debug Tool in Craft 3: Here’s all you need to know about it](https://medium.com/@galaxyweblinks/debug-tool-in-craft-3-heres-all-you-need-to-know-about-it-be8a3395ebbd) 通过 Galaxy Weblinks - `2018 年 7 月 2 日`
- [Large websites and performance in Craft CMS](http://madebyshape.co.uk/web-design-blog/large-websites-and-performance-in-craft-cms) 作者：Jason Mayo/MadeByShape - `2017 年 4 月 2 日`
- [Profiling your Website with Craft CMS 3’s Debug Toolbar](https://nystudio107.com/blog/profiling-your-website-with-craft-cms-3s-debug-toolbar) 作者：Andrew Welch/nystudio107 - `2018 年 4 月 9 日`
- [Speed up your Craft CMS Templates with Eager Loading](https://nystudio107.com/blog/speed-up-your-craft-cms-templates-with-eager-loading) 作者：Andrew Welch/nystudio107 - `2017 年 12 月 21 日`
- [Static File Caching with Craft CMS 3, aka The Best Of Both Worlds](https://putyourlightson.com/articles/static-file-caching-with-craft-cms-3-aka-the-best-of-both-worlds) 作者：Ben Croker/PutYourLightsOn - `2018 年 11 月 21 日`
- [Static Page Caching with Craft CMS](https://nystudio107.com/blog/static-caching-with-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 12 月 25 日`
- [The Craft `{% cache %}` Tag In-Depth](https://nystudio107.com/blog/the-craft-cache-tag-in-depth) 作者：Andrew Welch/nystudio107 - `2018 年 1 月 24 日`
- [Thoughts on full page caching in Craft](https://angell.io/blog/thoughts-on-full-page-caching-in-craft) Josh Angell - `2017 年 8 月 29 日`

##### Plugins
- [3 Things to Know About Craft Plugin Development](https://mijingo.com/blog/3-things-to-know-about-craft-plugin-development) 作者：Ryan Irelan/Mijingo
- [Craft Plugins in Craft 3](https://mijingo.com/blog/craft-plugins-in-craft-3) 作者：Ryan Irelan/Mijingo
- [Getting Started with Craft Plugin Development with Ben Croker](https://mijingo.com/blog/getting-started-with-craft-plugin-development-with-ben-croker) 作者：Ryan Irelan/Mijingo
- [Inspiration for Your First Craft Plugin](https://mijingo.com/blog/inspiration-for-your-first-craft-plugin) 作者：Ryan Irelan/Mijingo
- [Craft CMS E-Commerce: Why and How I Built a Snipcart Plugin](https://snipcart.com/blog/craft-cms-ecommerce-plugin) 通过马特斯坦

##### Publications
- [The Guide to Craft CMS Development](https://gomasuga.com/course/craft-cms-guide) 通过瑞安 Masuga
- [The Ultimate Craft CMS vs WordPress Guide](https://gomasuga.com/info/content-management-systems-craft-cms-vs-wordpress) 通过瑞安 Masuga
- [Introduction to Craft CMS](https://github.com/jeromecoupe/iad_craftcms_introduction) 作者：Jérôme Coupé/Webstoemp（在 Github 上）

##### Security
- [Securing Front-End User Profile and Entry Forms in Craft](https://putyourlightson.com/articles/securing-front-end-user-profile-and-entry-forms-in-craft) 作者：Ben Croker/PutYourLightsOn - `2021 年 5 月 4 日`
- [Securing Your Craft Site in 2022—Part 3](https://putyourlightson.com/articles/securing-your-craft-site-in-2022-part-3) 作者：Ben Croker/PutYourLightsOn - `2022 年 5 月 24 日`
- [Securing Your Craft Site in 2021—Part 2](https://putyourlightson.com/articles/securing-your-craft-site-in-2021-part-2) 作者：Ben Croker/PutYourLightsOn - `2021 年 1 月 26 日`
- [Securing Your Craft Site in 2021—Part 1](https://putyourlightson.com/articles/securing-your-craft-site-in-2021-part-1) 作者：Ben Croker/PutYourLightsOn - `2021 年 1 月 13 日`
- [Storing Secrets in Craft CMS](https://putyourlightson.com/articles/storing-secrets-in-craft-cms) 作者：Ben Croker/PutYourLightsOn - `2021 年 7 月 6 日`
- [Common Security Vulnerabilities in Craft CMS Plugins](https://putyourlightson.com/articles/common-security-vulnerabilities-in-craft-cms-plugins) 作者：Ben Croker/PutYourLightsOn - `2021 年 10 月 31 日`
- [Enforcing better passwords in Craft CMS](https://rias.be/blog/enforcing-better-passwords-in-craft-cms) - 里亚斯
- [Hardening Craft CMS Permissions](https://nystudio107.com/blog/hardening-craft-cms-permissions) 作者：Andrew Welch/nystudio107 - `2017 年 3 月 19 日`
- [Hashing Redirect Params in Craft](https://mijingo.com/blog/hashing-redirect-params-in-craft) 作者：Ryan Irelan/Mijingo
- [The Case of the Missing PHP Session](https://nystudio107.com/blog/the-case-of-the-missing-php-session) 作者：Andrew Welch/nystudio107 - `2017 年 10 月 3 日`

##### Taxonomies
- [Using Categories in Craft CMS](https://mijingo.com/blog/using-categories-in-craft-cms) 作者：Ryan Irelan/Mijingo

##### Templating
- [Brief Overview of Craft Routing to Templates](https://mijingo.com/blog/brief-overview-of-craft-routing-to-templates) 作者：Ryan Irelan/Mijingo
- [Building Complex Queries by Extending the ElementCriteriaModel](https://tighten.co/blog/craft-cms-building-complex-queries-by-extending-the-elementcriteriamodel) 作者：Keith Damiani/Tighten Co - `2016 年 2 月 10 日`
- [Creating an Age Drop-down with Twig range()](https://mijingo.com/blog/using-twig-range-to-create-an-age-drop-down) 作者：Ryan Irelan/Mijingo
- [DRY Templating with Twig and Craft CMS](https://medium.com/base-voices/dry-templating-with-twig-and-craft-cms-543292d114aa) 作者：Pierre Stoffe/Base Digital - `2017 年 5 月 31 日`
- [Filters in Twig and Craft](https://mijingo.com/blog/filters-in-twig-and-craft) 作者：Ryan Irelan/Mijingo
- [Handling Errors Gracefully in Craft CMS](https://nystudio107.com/blog/handling-errors-gracefully-in-craft-cms) 作者：Andrew Welch/nystudio107 - `2017 年 10 月 20 日`
- [How to check for undefined variables](https://cruftlesscraft.com/how-to-check-for-undefined-variables) 作者：Ben Rogerson - `2018 年 7 月 24 日`
- [Key Value Arrays in Twig](https://mijingo.com/blog/key-value-arrays-in-twig) 作者：Ryan Irelan/Mijingo
- [Passing data from Twig to JavaScript](https://cruftlesscraft.com/passing-data-from-twig-to-javascript) 作者：Ben Rogerson - `2018 年 8 月 1 日`
- [Quick Tips: Craft CMS](http://gregorterrill.com/blog/2017/quick-tips-craft-cms) 作者：Gregor Terrill - `2017 年 5 月 26 日`
- [Three Twig Tag Types in Craft CMS Explained](https://mijingo.com/blog/three-tag-types-in-craft-cms-explained) 作者：Ryan Irelan/Mijingo
- [Twig Processing Order & Scope](https://nystudio107.com/blog/twig-processing-order-and-scope) 作者：Andrew Welch/nystudio107 - `2017 年 1 月 3 日`
- [Using Macros in Twig and Craft](https://mijingo.com/blog/using-macros-in-twig-and-craft) 作者：Ryan Irelan/Mijingo
- [Using Variables in Twig and Craft CMS](https://mijingo.com/blog/using-variables-in-twig-and-craft-cms) 作者：Ryan Irelan/Mijingo
- [Where am I in the Twig Loop?](https://mijingo.com/blog/where-am-i-in-the-twig-loop) 作者：Ryan Irelan/Mijingo
- [Tips for Craft multilingual websites](https://www.webstoemp.com/blog/craft-multilingual-websites-tips/) 作者：Jérôme Coupé/Webstoemp - `2015 年 7 月 15 日`
- [Combined searches and filters using Craft](https://www.webstoemp.com/blog/combined-searches-and-filters-craft-cms/) 作者：Jérôme Coupé/Webstoemp - `2016 年 2 月 17 日`
- [SVG Sprites and Twig Macros in Craft CMS](https://caffeinecreations.ca/blog/svg-sprites-and-twig-macros-in-craft-cms/) 作者：Sean Smith/Caffeine Creations - `2018 年 6 月 29 日`
- [Responsive tables in Craft](https://www.thebasement.be/responsive-tables-in-craft/) 作者：Jan D&#39;Hollander - `2018 年 7 月 10 日`

### Videos

##### Assets
- [Craft 3 Remote Volumes with AWS S3](https://mijingo.com/blog/craft-3-remote-volumes-with-aws-s3) 作者：Ryan Irelan/Mijingo
- [Image Editing in Craft 3](https://mijingo.com/lessons/image-editor-craft-cms-3/) 作者：Ryan Irelan/Mijingo
- [Images and Image Editing in Craft 3](https://www.youtube.com/watch?v=_chcVWpA3K8) 作者：Ben Parizek/Straight Up Craft - `2017 年 3 月 17 日`
- [Remote Asset Sources in Craft](https://mijingo.com/lessons/remote-asset-sources-in-craft/) 作者：Ryan Irelan/Mijingo

##### Commerce
- [Fundamentals of Craft Commerce](https://mijingo.com/products/screencasts/craft-commerce/) 作者：Ryan Irelan/Mijingo - `付费`
- [Introduction to Craft Commerce II](https://www.youtube.com/watch?v=oMA9nJkinxg) 作者：Ben Parizek/Straight Up Craft - `2016 年 2 月 12 日`

- [Pushing the Limits of Craft CMS's Matrix Field](https://www.youtube.com/watch?v=HXy_-LLjV_U) 作者：Ben Parizek/Straight Up Craft - `2017 年 3 月 17 日`

##### Control Panel
- [Customizing the Craft Control Panel](https://www.youtube.com/watch?v=PDflVN28iR4&t=1s) 作者：Ben Parizek/Straight Up Craft - `2016 年 7 月 1 日`

##### Craft 3
- [An initial look at Craft 3](https://www.youtube.com/watch?v=1Zly_rVbJpc) 作者：Ben Parizek/Straight Up Craft - `2016 年 8 月 5 日`
- [Craft 3 Command Line](https://mijingo.com/lessons/craft-3-command-line/) 作者：Ryan Irelan/Mijingo
- [Craft 3: What You Need to Know](https://mijingo.com/lessons/craft-3-what-you-need-to-know/) 作者：Ryan Irelan/Mijingo

##### Development
- [Better Build Processes with Gulp and Craft](https://www.youtube.com/watch?v=4er0UaAvfVs) 作者：Ben Parizek/Straight Up Craft - `2016 年 6 月 29 日`

##### Element API
- [Creating an Element API in Craft](https://mijingo.com/lessons/creating-an-element-api-in-craft-cms/) 作者：Ryan Irelan/Mijingo

##### Getting Started
- [Craft CMS 3 Manual Installation](https://www.youtube.com/watch?v=JNe4E6r7jgY) 作者：Ryan Irelan/Mijingo - `2018 年 4 月 5 日`
- [Craft CMS Essentials](https://mijingo.com/craft-essentials) 作者：Ryan Irelan/Mijingo - `付费`
- [Craft Starter Pack](https://mijingo.com/products/bundles/craft-starter-pack/) 作者：Ryan Irelan/Mijingo - `付费`
- [Up and Running with Craft](https://mijingo.com/products/screencasts/up-and-running-with-craft/) 作者：Ryan Irelan/Mijingo - `付费`

##### Integration
- [Craft-Powered Apps](https://www.youtube.com/watch?v=MPWckTSJnX0) 作者：Ben Parizek/Straight Up Craft - `2016 年 9 月 16 日`

##### Installation and Upgrading
- [Composer and Craft 3](https://www.youtube.com/watch?v=q7-_y8r2W4M) 作者：Ben Parizek/Straight Up Craft - `2018 年 4 月 20 日`
- [Installing Composer](https://mijingo.com/lessons/installing-composer-craft-cms/) 作者：Ryan Irelan/Mijingo
- [Installing Craft 3 (beta)](https://mijingo.com/lessons/installing-craft-cms-3/) 作者：Ryan Irelan/Mijingo
- [Installing Craft CMS](https://mijingo.com/lessons/installing-craft-cms/) 作者：Ryan Irelan/Mijingo
- [Updating Craft 3 Beta](https://mijingo.com/lessons/updating-craft-3-beta-with-composer/) 作者：Ryan Irelan/Mijingo
- [Upgrading Craft 2 to Craft 3](https://mijingo.com/lessons/upgrade-to-craft-cms-3/) 作者：Ryan Irelan/Mijingo

##### Multi-site
- [Managing Multiple Sites in Craft 3 – Sites and Localization](https://www.youtube.com/watch?v=u_Yqwvx-gA0) 作者：Ben Parizek/Straight Up Craft - `2017 年 3 月 10 日`
- [Using Craft CMS 3 Multi-Site](https://mijingo.com/lessons/craft-3-multi-site/) 作者：Ryan Irelan/Mijingo

##### Nitro
- [How I Use Craft Scripts in Craft CMS Running in Craft Nitro 2](https://andreademers.substack.com/p/craft-scripts-craft-cms-craft-nitro-2)
- [Hot Module Reloading with Laravel Mix v6 and Craft Nitro 2](https://andrewmeni.ch/blog/hot-module-reloading-with-laravel-mix-v6-and-craft-nitro-2)
- [Local Development with Craft Nitro](https://craftquest.io/courses/local-development-localhosting-craft-nitro)

##### Performance and Testing
- [Yii Debug Toolbar in Craft CMS 3](https://mijingo.com/lessons/yii-debug-toolbar-craft-cms/) 作者：Ryan Irelan/Mijingo

##### Plugins
- [Craft 3 Plugin Development - Controllers & Variables](https://www.youtube.com/watch?v=N2N1TQgdSL0) 作者：Ben Parizek/Straight Up Craft - `2017 年 4 月 7 日`
- [Craft Plugin Development](https://mijingo.com/products/screencasts/craft-plugin-development/) 作者：Ben Croker/Mijingo - `付费`
- [Craft Plugin Development Workbook](https://mijingo.com/products/workbooks/craft-plugin-development-workbook/) 作者：Ben Croker/Mijingo - `付费`
- [Getting Started with Craft Plugin Development (Craft 3)](https://craftquest.io/courses/how-to-create-craft-plugin) 通过 Ben Croker/CraftQuest
- [Getting Started with Craft Plugin Development (Craft 2)](https://mijingo.com/blog/getting-started-with-craft-plugin-development) 作者：Ryan Irelan/Mijingo
- [Migrating a Field Type plugin from Craft 2 to Craft 3](https://www.youtube.com/watch?v=lx6GkcT8SyU) 作者：Ben Parizek/Straight Up Craft - `2017 年 3 月 24 日`
- [Migrating a plugin from Craft 2 to Craft 3](https://www.youtube.com/watch?v=twQY7GbpYGg&t=34s) 作者：Ben Parizek/Straight Up Craft - `2017 年 3 月 3 日`
- [Migrating a website with plugins from Craft 2 to Craft 3](https://www.youtube.com/watch?v=T6wBZbH0oDU) 作者：Ben Parizek/Straight Up Craft - `2018 年 5 月 4 日`
- [Plugins in Craft 3](https://mijingo.com/lessons/plugins-in-craft-3/) 作者：Ryan Irelan/Mijingo
- [Tools for getting started with plugin development?](https://www.youtube.com/watch?v=DrT9tjkDeQY) 作者：Ben Parizek/Straight Up Craft - `2016 年 3 月 11 日`
- [Writing Bulletproof Database Migrations](https://www.youtube.com/watch?v=FkdPiWVd8BI) 作者：Ben Parizek/Straight Up Craft - `2016 年 9 月 2 日`
- [Craft CMS E-Commerce: Why and How I Built a Snipcart Plugin](https://snipcart.com/blog/craft-cms-ecommerce-plugin)


##### Security
- [Critical Updates and Craft CMS](https://www.youtube.com/watch?v=Fl1DZVHTFio) 作者：Ben Parizek/Straight Up Craft - `2016 年 9 月 2 日`
- [Hashing Redirects in Craft](https://mijingo.com/lessons/hashing-redirect-parameter-in-craft/) 作者：Ryan Irelan/Mijingo
- [Security and Craft CMS](https://www.youtube.com/watch?v=EsI5FgF3BAI&t=5s) 作者：Ben Parizek/Straight Up Craft - `2016 年 4 月 22 日`

##### Templating
- [Changing Section Labels in Craft](https://mijingo.com/lessons/changing-section-labels-in-craft/) 作者：Ryan Irelan/Mijingo
- [Control Flow in Twig](https://mijingo.com/products/screencasts/control-flow-in-twig/) 作者：Ryan Irelan/Mijingo - `付费`
- [Craft 3 Service APIs in Templates](https://mijingo.com/lessons/craft-3-service-apis-in-templates/) 作者：Ryan Irelan/Mijingo
-[DRY Templating Techniques](https://www.youtube.com/watch?v=SaSmesi3GoY) 作者：Ben Parizek/Straight Up Craft - `2016 年 4 月 1 日`
- [Eager-Loading Elements](https://www.youtube.com/watch?v=H52sphm4YM0) 作者：Ben Parizek/Straight Up Craft - `2016 年 3 月 18 日`
- [Flexbox and Craft](https://www.youtube.com/watch?v=9x7FZ22N15U) 作者：Ben Parizek/Straight Up Craft - `2016 年 5 月 27 日`
- [Flexible Twig Templates in Craft](https://mijingo.com/products/screencasts/reusable-twig-templates-craft/) 作者：Ryan Irelan/Mijingo - `付费`
- [How I build components in CraftCMS with Twig](https://www.youtube.com/watch?v=FNIM8MvUL-Q) 作者：Alex Carpenter - `2017 年 12 月 28 日`
- [How to build a content builder in Craft CMS](https://www.youtube.com/watch?v=VSXglzqJ2Z4) 作者：Alex Carpenter - `2018 年 3 月 30 日`
- [How to build a reusable carousel component with Craft CMS](https://www.youtube.com/watch?v=e-6bk2VnBCk&feature=youtu.be) 作者：Alex Carpenter - `2018 年 4 月 22 日`
- [Matrix as a Layout Builder](https://www.youtube.com/watch?v=IJpCMkA2Bxw) 作者：Ben Parizek/Straight Up Craft - `2016 年 5 月 13 日`
- [Navigating Navigation in Craft CMS](https://www.youtube.com/watch?v=eDAdIkXBH48) 作者：Ben Parizek/Straight Up Craft - `2016 年 5 月 20 日`
- [Nested navigation based on Structure section](https://www.youtube.com/watch?v=AylyBOqlooc) 作者：Ryan Irelan/Mijingo - `2018 年 1 月 30 日`
- [Passing Data with Twig Include](https://mijingo.com/lessons/passing-data-with-the-twig-include-statement/) 作者：Ryan Irelan/Mijingo
- [Twig Templates in Craft](https://mijingo.com/products/screencasts/twig-templates-in-craft/) 作者：Ryan Irelan/Mijingo - `付费`
- [Twig's null-coalescing operator (??)!](https://www.youtube.com/watch?v=DAQ2qh8pebs) 作者：Ben Parizek/Straight Up Craft - `2016 年 4 月 8 日`
- [Using `.all()` in Craft 3](https://mijingo.com/lessons/using-dot-all-in-craft-3-element-queries/) 作者：Ryan Irelan/Mijingo
- [Using the Batch Filter in Twig](https://mijingo.com/lessons/using-the-batch-filter-in-twig/) 作者：Ryan Irelan/Mijingo

##### Tutorials
- [Building a Blog in Craft CMS](https://www.youtube.com/watch?v=lfDZ6v23KcE) 作者：Ryan Irelan/Mijingo - `2018 年 1 月 23 日`
- [Contact Form in Craft CMS](https://mijingo.com/lessons/contact-form-in-craft-cms/) 作者：Ryan Irelan/Mijingo

### Presentations
- [Building a Smarter Craft Commerce Website](https://speakerdeck.com/sjcallender/building-a-smarter-craft-commerce-website) 作者：Stephen Callender - `2018 年 9 月 27 日`
- [Craft 3 Plugin Development](https://speakerdeck.com/brandonkelly/craft-3-plugin-development) 作者：Brandon Kelly - `2017 年 4 月 26 日`
- [Crafting Modern SEO](https://speakerdeck.com/nystudio107/crafting-modern-seo) 作者：Andrew Welch - `2017 年 10 月 23 日`
- [Design Processes and Systems in Craft](https://www.slideshare.net/CourtneyBradford/design-processes-and-systems-in-craft-116882979) 作者：Courtney Bradford - `2018 年 9 月 27 日`
- [Designers Guide to Craft CMS Plugins](https://speakerdeck.com/bymayo/designers-guide-to-craft-cms-plugins) - 杰森梅奥 - `2016 年 11 月 3 日`
- [Dot All 2017 Keynote](https://speakerdeck.com/brandonkelly/dot-all-2017-keynote) 作者：Brandon Kelly - `2017 年 10 月 23 日`
- [How to Migrate Legacy Content to Craft Without Losing Your Sanity](https://speakerdeck.com/jamesgreig/how-to-migrate-legacy-content-to-craft-without-losing-your-sanity) 作者：James Greig - `2018 年 9 月 28 日`
- [Intro to Craft](https://speakerdeck.com/philipzaengle/intro-to-craft) 作者：Philip Zaengle - `2016 年 4 月 29 日`
- [Intro to Craft 3](https://speakerdeck.com/brandonkelly/intro-to-craft-3) 作者：Brandon Kelly - `2017 年 4 月 26 日`
- [Making a Craft CMS Website That Flies](https://speakerdeck.com/nystudio107/making-a-craft-cms-website-that-flies) 作者：Andrew Welch - `2018 年 9 月 27 日`
- [Modern Frontends with Craft CMS, GraphQL, and React](https://pauloelias.github.io/modern-frontends-craft-react-graphql-v1/#0) 保罗埃利亚斯
- [Multilingual Sites in Craft 3](https://speakerdeck.com/drifteaur/multilingual-sites-in-craft-3) 作者：Zoltan Varady - `2018 年 9 月 27 日`
- [Running Craft as a 12-factor app on Heroku](https://drive.google.com/file/d/16SJp0c8FvXi3Xfr0WtgXtH7-rY_-BGoj/view) by Bob Olde Hampsink - `27 Sep 2018`
- [Scaling Craft CMS Sites for Large Launches](https://speakerdeck.com/mattweinberg/scaling-craft-cms-sites-for-large-launches) 作者：Matt Weinberg - `2018 年 9 月 28 日`
- [State of Craft 2018](https://speakerdeck.com/brandonkelly/state-of-craft-2018) 作者：Brandon Kelly - `2018 年 9 月 28 日`
- [The Art Of Plugin Development](https://speakerdeck.com/putyourlightson/the-art-of-plugin-development) 作者：Ben Croker - `2018 年 9 月 27 日`
- [Twig Super Power Roundup](https://speakerdeck.com/bymayo/twig-super-power-roundup-craft-cms-3) 作者：Jason Mayo - `2018 年 11 月 1 日`
- [What’s the Deal with Craft CMS?](https://speakerdeck.com/brandonkelly/whats-the-deal-with-craft-cms) 作者：Brandon Kelly - `2016 年 4 月 21 日`
- [Working with Craft Commerce](https://speakerdeck.com/bymayo/working-with-craft-commerce) 作者：Jason Mayo - `2017 年 11 月 2 日`

### Praises
- [10 Reasons Why We Love Craft CMS](http://taechogroup.com/blog/10-reasons-why-we-love-craft-cms) by 太草集团
- [A Review of Craft Commerce](http://www.newmediacampaigns.com/blog/a-review-of-craft-commerce) 作者：Adam Fairholm/New Media Campaigns - `2017 年 5 月 19 日`
- [A love letter to Craft CMS](https://medium.com/diesdas-direct/a-love-letter-to-craft-cms-737f60d756cc) Harry Keller/diesdas.digital - `2017 年 4 月 18 日`
- [An Overview of Pixel & Tonic’s Craft CMS](https://medium.com/@msoyka91/an-overview-of-pixel-tonics-craft-cms-4bd9d5768ed0) 作者：Matthew Soyka - `2017 年 2 月 21 日`
- [Craft CMS vs WordPress: A comparison & why we love Craft CMS](https://www.madebybridge.com/blog/craft-cms-vs-wordpress-a-comparison) 作者：Chris Cox/Bridge 制作 - `2021 年 11 月 17 日`
- [Craft CMS Vs WordPress: Why Choose Craft?](https://medium.com/@galaxyweblinks/craft-cms-vs-wordpress-why-choose-craft-7a557cdb604d) -`2018 年 6 月 19 日`
- [Crazy About Craft](http://www.newmediacampaigns.com/blog/review-of-craft-cms-tips-to-get-started) 作者：Nathan Huening/New Media Campaigns - `2017 年 2 月 27 日`
- [How we chose Craft CMS for our product websites](https://wildbit.com/blog/2016/11/01/how-we-chose-craft-cms-for-products-websites) 作者：Eugene Fedorenko/Wildbit - `2016 年 11 月 1 日`
- [Why Content Managers Love Craft CMS](https://weareabstrakt.com/blog/2017/why-content-managers-love-craft-cms/) 作者：Lauren Swarbrick/Abstrakt - `2017 年 5 月 17 日`
- [Why Content Writers Love Craft CMS](https://caffeinecreations.ca/why-content-writers-love-craft-cms/) 肖恩史密斯/咖啡因创作
- [Why Craft CMS is the best content management system we (and you) have ever used](https://www.ten4design.co.uk/insight/why-craft-cms-is-the-best-content-management-system) 作者：Owen Matthews 和 Andy Green/Ten4 Design - `2017 年 4 月 21 日`
- [Why We Love Craft CMS](https://www.viget.com/articles/why-we-love-craft-cms) 作者：Trevor Davis/Viget - `2014 年 10 月 17 日`
- [Why We Use Craft CMS](https://designbycosmic.com/articles/development/why-we-use-craft-cms) 通过 Cosmic - `2017 年 2 月 1 日`
- [Why We Use Craft CMS](https://builtbymasonry.com/journal/why-we-use-craft-cms) 通过 Masonry - `2017 年 11 月 7 日`
- [Why We're Craft CMS Developers](https://honcho.agency/blog/why-were-craft-cms-developers) 作者：Honcho - `2019 年 4 月 16 日`
- [Why We've Fallen Head Over Heels for Craft CMS](https://welfordmedia.co.uk/blog/design-development/we-love-craft-cms) Welford Media - `2016 年 10 月 14 日`
- [Why we develop websites using Craft CMS instead of Wordpress](https://weareabstrakt.com/blog/2017/why-we-develop-websites-using-craft-cms-instead-of-wordpress/) 作者：Abstrakt - `2017 年 4 月 25 日`
- [Why you should be considering Craft over WordPress](http://madebykind.com/thinking/why-you-should-be-considering-craft-over-wordpress) 作者：Sam Goddard/Kind - `2017 年 3 月 21 日`
- [Why Craft?](https://www.webstoemp.com/blog/why-craft-cms/) 作者：Jérôme Coupé/Webstoemp - `2015 年 6 月 17 日`

### Podcasts

- [Craft.Podcast](http://craftpodcast.com/) - A voice for the #CraftCMS community.
- [Craft CMS 3 as an Application Platform](https://devmode.fm/episodes/craft-cms-3-as-an-application-platform) - devmode.fm 和 Ben Crocker 讨论使用 Craft CMS 3 作为应用程序平台.
- [Craft CMS 3 with Pixel & Tonic Founder Brandon Kelly!](https://devmode.fm/episodes/craft-cms-3-with-pixel-tonic-founder-brandon-kelly) - 了解内部人士对 Craft CMS 3 开发的看法.
- [Dot All 2018 Conference Recap & Analysis, Live from Berlin!](https://devmode.fm/episodes/dot-all-2018-conference-recap-analysis-live-from-berlin) - dev Mode .fm 工作人员回顾了在柏林举行的 Dot All 2018 大会.
- [Talk­ing Craft CMS 3 RC1!](https://devmode.fm/episodes/talking-craft-cms-rc1) - `dev Mode .fm` 播客的第一集.
- [Commerce Minded](https://www.fostercommerce.com/podcast) - 以 Craft Commerce 为中心的播客，在幕后与电子商务商家、开发商和供应商聊天.

### Dev Tools

- [Craft CLI](https://github.com/rsanchez/craft-cli) - Craft CMS 2 的命令行界面.
- [Craft CMS Bootstrap](https://github.com/timkelty/craftcms-bootstrap) - 简化 Craft CMS 引导和配置.
- [Craft CMS Docker](https://github.com/atillay/craftcms3-docker) - 开始使用 Docker 在几个命令行中使用 Craft CMS 3.
- [Craft 3 Multi-environment](https://github.com/nystudio107/craft3-multi-environment) - [Craft 2 Version](https://github.com/nystudio107/craft-multi-environment) - 高效灵活的 Craft CMS 多环境配置.
- [Craft Scripts](https://github.com/nystudio107/craft-scripts) - 用于管理 Craft CMS 环境之间常见任务的 Shell 脚本.
- [Craftman](https://github.com/gabrielmoreira/craftman) - 帮助加快设置并顺利启动新的 Craft CMS 安装.
- [Crafty Vagrant](https://github.com/niceandserious/crafty-vagrant) - 用于快速启动 Craft CMS 项目的样板开发环境.
- [Generator Craft Install](https://github.com/nystudio107/generator-craftinstall) - 用于 Craft CMS 安装的 Yeoman 生成器.
- [Happy Lager Demo Site](https://github.com/timkelty/HappyLager/tree/neutrino) - Craft CMS 演示站点的分支，针对 Craft 3 进行了更新.
- [Nginx Craft](https://github.com/nystudio107/nginx-craft) - 用于 Craft CMS 的 Nginx 虚拟主机配置，实现了许多最佳实践.
- [Plugin Factory](https://pluginfactory.io/) - 生成符合 P&amp;T 编码标准的 Craft CMS 插件代码脚手架.

---

## Showcase

### Official Case Studies

- [% Arabica](https://craftcms.com/in-the-field/arabica) - 项目： [arabicacoffee.hk](https://arabicacoffee.hk/) 经过 [Digital Butter](https://www.butter.com.hk/)
- [Associated Press](https://craftcms.com/in-the-field/associated-press) - 项目： [blog.ap.org](https://blog.ap.org) + [insights.ap.org](https://insights.ap.org) 经过 [Vector Media Group](https://www.vectormediagroup.com/)
- [Barefoot Contessa](https://craftcms.com/in-the-field/barefoot-contessa) - 项目： [barefootcontessa.com](https://barefootcontessa.com) 经过 [Apartment One](https://aptone.com/) & [Jonathan Melville](https://codemdd.io/)
- [Grill'd](https://craftcms.com/in-the-field/grilld) - 项目： [grilld.com.au](https://www.grilld.com.au/) 经过 [Evolution 7](https://www.evolution7.com.au/)
- [iDE Global](https://craftcms.com/in-the-field/ide-global) - 项目： [ideglobal.org](https://ideglobal.org) 经过 [Flipbox Digital](https://www.flipboxdigital.com/)
- [Kappa Alpha Theta Fraternity](https://craftcms.com/in-the-field/kappa-alpha-theta-fraternity) - 项目： [kappaalphatheta.org](https://www.kappaalphatheta.org/) 经过 [TrendyMinds](https://trendyminds.com/)
- [McKinnon and Harris](https://craftcms.com/in-the-field/mckinnon-and-harris) - 项目： [mckinnonharris.com](https://www.mckinnonharris.com) 经过 [Foster Made](https://fostermade.co)
- [Mixmag Media](https://craftcms.com/in-the-field/mixmag) - 项目： [mixmag.net](http://mixmag.net) 经过 [The Rye Agency](http://rye.agency)
- [Poki](https://craftcms.com/in-the-field/poki) - 项目： [poki.com](https://poki.com/) 来自 Evermade
- [Samuelsohn](https://craftcms.com/in-the-field/samuelsohn) - 项目： [samuelsohn.com](http://samuelsohn.com) 经过 [Digital Surgeons](http://digitalsurgeons.com/)
- [Segway](https://craftcms.com/in-the-field/segway) - 项目： [uk-en.segway.com](https://uk-en.segway.com/) 通过 Wirelab 数字代理
- [Simon Fraser University (SFU) Beedie School of Business](https://craftcms.com/in-the-field/simon-fraser-university-sfu-beedie-school-of-business) - 项目： [beedie.sfu.ca](https://beedie.sfu.ca/) 通过山羊
- [Ultimate.ai](https://craftcms.com/in-the-field/ultimate-ai) - 项目： [ultimate.ai](https://www.ultimate.ai/) 按功能和形式数字
- [YumEarth](https://craftcms.com/in-the-field/yumearth) - 项目： [yumearth.com](https://yumearth.com) 通过 Electric Enjin

### Organizations Using Craft

- [Agatha Christie](http://www.agathachristie.com)
- [An Event Apart](http://aneventapart.com)
- [Associated Press: Blog](https://blog.ap.org) - 再加上 [Insights](https://insights.ap.org) 网站.
- [Atkins](http://www.atkins.com)
- [Atlassian: Design](https://atlassian.design)
- [Betterteam](https://www.betterteam.com/)
- [BigCommerce](https://www.bigcommerce.com)
- [Bill Nye](https://www.billnye.com/)
- [Canary Media](https://www.canarymedia.com/)
- [City of Marion, IN](https://cityofmarion.in.gov/)
- [City of Oakland](https://www.oaklandca.gov/)
- [Confab Events](http://confabevents.com)
- [Dalai Lama](https://www.dalailama.com)
- [Dialpad](https://www.dialpad.com/)
- [Duck Brand](http://www.duckbrand.com)
- [Emily Carr University](http://www.ecuad.ca)
- [Field Notes](https://fieldnotesbrand.com) - 用途 [Craft Commerce](https://craftcommerce.com).
- [Foursquare for Business](http://business.foursquare.com)
- [Grill'd](https://www.grilld.com.au/)
- [Guy Fieri](http://www.guyfieri.com/)
- [Hootsuite](https://hootsuite.com)
- [Icon Motorsports](http://www.rideicon.com)
- [iDE Global](https://ideglobal.org)
- [Intel: Managed Service Providers](http://msp.intel.com)
- [Klipsch](http://www.klipsch.com)
- [LA Marathon](http://lamarathon.com)
- [Layer Tennis](http://www.layertennis.com) - A [Coudal Partners](http://coudal.com/) 生产赞助 [Adobe](https://www.adobe.com/).
- [Medialoot](https://medialoot.com)
- [Mini: Miles Ahead](http://www.bemilesahead.net/)
- [Mixmag Media](http://mixmag.net)
- [NameSnack](https://www.namesnack.com/)
- [Naughty Dog](https://www.naughtydog.com/)
- [Naviance](http://www.naviance.com)
- [Netflix: Media Center](https://media.netflix.com)
- [Nissin Foods](http://nissinfoods.com/)
- [OneSignal](https://onesignal.com)
- [Outreach](https://www.outreach.io)
- [PBS Kids Games](https://itunes.apple.com/us/app/pbs-kids-games/id1050773989) - Craft 为应用程序使用的 API 提供支持.
- [PBS Parents](http://www.pbs.org/parents/child-development/social-emotional)
- [Pingdom](https://www.pingdom.com)
- [Princeton Theological Seminary](http://ptsem.edu)
- [ProPublica](https://www.propublica.org)
- [Reddit Inc.](https://www.redditinc.com/)
- [SalesforceIQ](https://www.salesforceiq.com)
- [Samuelsohn](http://samuelsohn.com)
- [Sonos](https://www.sonos.com)
- [Stanford Research Park](http://www.stanfordresearchpark.com)
- [Stearns & Foster](http://www.stearnsandfoster.com)
- [Visit Victoria: Corporate](https://corporate.visitvictoria.com)
- [Wildbit](https://wildbit.com)
- [Yale Environment 360](http://e360.yale.edu)
