<div class="github-widget" data-repo="dylanrees/citizen-science"></div>
## Digital Tools for Citizen Science

Below is a curated list of awesome software and other resources to enable those who want to use scientific tools to empower communities and/or practice various forms of non-institutional science.  It is largely inspired by [this repository](https://github.com/drewrwilson/toolsforactivism) listing digital tools for activists.  Feel free to share suggestions. If you add software to the list, free and open-source software is strongly encouraged over proprietary software.

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)



## Software

### Lab Equipment Software

 * [Grafana](http://grafana.org/) - Create a dashboard (online if you wish) that visualizes your experimental data.
 * [mMass](http://www.mmass.org/) - Open-source software for mass spectrometers.
 * [Stellarium](http://www.stellarium.org/) - Open-source planetarium software.

### Modeling and Computation

 * [OpenSCAD](http://www.openscad.org/) - 3D modeling software.
 * [SageMath](https://cloud.sagemath.com/) - Open-source cloud-based computation (similar to MATLAB and Mathematica).
 * [GNU Octave](https://www.gnu.org/software/octave/) - Free software numerical computation program, similar to MATLAB.
 * [Dia](http://dia-installer.de/) - Open-source software for making diagrams.
 * [Gephi](https://gephi.org/) - Open graph visualization platform.
 * [QGIS](http://www.qgis.org/en/site/) - Open GIS software.
 * [Mineways](http://www.realtimerendering.com/erich/minecraft/public/mineways/) - a tool for turning Minecraft model files into 3D-printable .stl files
 * [ALOHA](https://www.epa.gov/cameo/aloha-software) - A piece of software disributed by the EPA that models the threat zone for various types of chemical spill and explosion hazards.
 * [vegan](http://vegan.r-forge.r-project.org/) - R package for statistical work in community ecology.
 * [BOINC](https://boinc.berkeley.edu/) - Open-source cross-platform volunteer computing network connecting computers of volunteers/citizen scientists to scientific research projects. Used by CERN and universities around the world.

### Publishing , Collaboration and Organization

 * [Zotero](https://www.zotero.org/) - Open-source citation management software.
 * [TiddlyWiki](http://tiddlywiki.com/) - Easily create your own wikis to organize information.
 * [Evergreen ILS](http://evergreen-ils.org/) - Software for managing a library of books (and the loaning process).
 * [ISLE](https://github.com/nasa/isle) - Open-source laboratory equipment inventory management system developed by NASA.
 * [GanttProject](http://www.ganttproject.biz/) - Productivity tool for scheduling tasks and making Gantt charts.
 * [Open Science Framework](https://osf.io/) - Open-source collaborative project manager for scientific research.
 * [Calibre](http://calibre-ebook.com/) - eBook management software.
 * [LibraryThing](https://www.librarything.com/) - an online platform for organizing your library.
 * [PECE](http://www.worldpece.org/) - The Platform for Experimental and Collaborative Ethnography.  This project provides an online platform for academic collaboration that helps keep track of complex attribution of credit.  It is geared toward anthropologists but is expanding to become more broad.
 * [RapidPro](https://github.com/rapidpro/rapidpro) - An open-source platform for building scalable applications that users can interact with via SMS.
 * [eu-citizen.science](https://eu-citizen.science/) - links to 200 projects
 * [Zooniverse](https://github.com/zooniverse) - website for zoo & universe projects
 
 ### Graphs and Visualization
 * [GraphViz](https://graphviz.org/) - tool for creating scientific graphs
 
## Educational

 * [Light and Matter](http://lightandmatter.com/) - Benjamin Crowell's free-to-download, cheap-to-buy open source physics textbooks.
 * [OpenStax](https://openstax.org/) - Repository of open-licensed and collaboratively-edited textbooks on many basic subjects. You can download them as ebooks or order print copies.
 * [PhET Simulations](https://phet.colorado.edu/en/simulations/category/chemistry) - CU Boulder interactive physics and chemistry simulations.
 * [United Diversity Co-op Library](http://library.uniteddiversity.coop/) - A vast library of interesting textbooks and other resources in PDF form on such topics as permaculture, agriculture, economics, crafts and activism.
 * [Microbe Wiki](https://microbewiki.kenyon.edu/index.php/MicrobeWiki) - A large student-edited multi-institutional wiki for microbiology.
 * [OpenCulture Textbooks](http://www.openculture.com/free_textbooks) - The textbook section of a website dedicated to the open sharing of information.
 * [Free Tech Books](http://www.freetechbooks.com/categories) - Free ebooks (mostly computer science and engineering).
 * [OpenWetWare](http://openwetware.org/wiki/Main_Page) - A site that maintains a list of bio lab protocols as well as an electronic lab notebook for team use.

## Tools and Equipment

### Biology and Chemistry

 * [The ODIN](http://www.the-odin.com/) - A distributor of affordable DIY biology equipment.
 * [Bento Box](https://www.bento.bio/) - A low-cost PCR workstation from Bento Lab.
 * [OpenTrons](http://opentrons.com/) - An open-source liquid-handling robot.
 * [OpenPCR](http://openpcr.org/) - An open-source PCR thermocycler.
 * [SGD](http://www.yeastgenome.org) - Stanford University's Saccharomyces Genome Database.
 * [BLAST](http://blast.ncbi.nlm.nih.gov/Blast.cgi) - Search tool for local alignment.
 * [IORodeo](http://iorodeo.com/) - Sells a cheap open-source potentiostat, a colorimeter, and some other equipment.
 * [BioSurplus](http://www.biosurplus.com/) - A supplier of used bio lab equipment.
 * [DremelFuge](http://www.thingiverse.com/thing:1483) - A biology centrifuge that takes the form of a dremel attachment.
 * [Paperfuge](http://www.biorxiv.org/content/early/2016/08/30/072207.full.pdf+html) - An ultra-low cost, hand-powered centrifuge inspired by the mechanics of a whirligig toy.
 * [Ministat](http://www.hivebio.org/projects/ministat-2/) - A DIY chemostat.
 * [MinION](https://nanoporetech.com/products/minion) - An affordable, portable DNA/RNA sequencer.
 * [SpikerBox](https://backyardbrains.com/products/spikerbox) - A bioamplifier for DIY neuroscience.
 
### Environmental Science and Geology

 * [Raspberry Shake](https://www.kickstarter.com/projects/angelrodriguez/raspberry-shake-your-personal-seismograph) - A seismograph compatible with the Raspberry Pi.
 * [Smoky Mountain Scientific](http://www.smokymtsci.com/) - Modular, Low cost, open-source instrumentation for environmental monitoring.
 * [AWEsome](https://www.lhc-ilc.physik.uni-bonn.de/research-groups/experimental-physics/prof.-k.-desch/research/airborne-wind-energy) - An affordable airborne wind turbine prototype.

### 3D Printing and Fabrication

 * [Printables](https://www.printables.com/) - Database of 3D-printable models with contests and an active community
 * [Thingiverse](https://www.thingiverse.com/) - A search engine for 3D-printable models.
 * [Ember](https://ember.autodesk.com/) - A comprehensively open-source DLP SLA 3D Printer project, powered by Autodesk.
 * [3D Printable Science Equipment](http://www.appropedia.org/3D_printable_science_equipment) - A list of different 3d-printable science objects with models.
 * [Precious Plastic](https://preciousplastic.com/en/videos/build/extrusion/) - Make your own 3D printer filament.

### Electronics

  * [C.H.I.P](https://getchip.com/pages/chip) - A $9 Linux computer.
  * [Raspberry Pi Zero](https://www.raspberrypi.org/products/pi-zero/) - The cheapest, smallest Raspberry Pi ($5).
  * [Particle Electron](https://www.particle.io/products/hardware/electron-cellular-dev-kit?) - Raspberry Pi-like microcontroller for connecting the devices you make to the cellular network.
  * [SparkFun](https://www.sparkfun.com/) - A company selling all sorts of electronics for DIY projects, including sensors.
  * [Red Pitaya](http://redpitaya.com/) - Open-source tool with multiple signal processing functions, such as an oscilloscope, spectrum analyzer, signal generator, and more.
  * [Podo](http://podolabs.com/#buy) - A stickable, hi-resolution Bluetooth camera.

### Other

 * [Global Village Construction Set](http://opensourceecology.org/gvcs/gvcs-machine-index/) - Open-source farm equipment and other civilization-building tools.
 * [Farming Concrete Data Collection Toolkit](https://farmingconcrete.org/toolkit/) - "Methods for measuring the outcomes and impacts of community gardens and urban farms."
 * [Build My Lab Contest](http://www.instructables.com/contest/buildmylab/) - A competition to create instructables for DIY lab equipment.
 * [Generic Lab Equipment](http://hackteria.org/wiki/Generic_Lab_Equipment) - Wiki with instructions on building DIY lab equipment.
 
## Publishing and Doing Research

 * [Citizen Science: Theory and Practice](http://theoryandpractice.citizenscienceassociation.org/) - An open-access, peer-reviewed journal dedicated to discussion about methods in citizen science.
 * [Scholar Subreddit](https://www.reddit.com/r/scholar) - A great place to request help getting access to scientific papers that are beyond paywalls.
 * [Library Genesis](https://en.wikipedia.org/wiki/Library_Genesis) - An online tool for gaining access to scientific articles that are normally beyond paywalls.
 * [SciHub](https://sci-hub.tw/) - Another site for gaining access to science papers that are normally behind paywalls.
 * [Public Library of Science (PLOS)](https://plos.org/) - Nonprofit organization that publishes open-access journals and also advocates for openness and tranparency in science.
 * [arXiv](http://arxiv.org/) - A Cornell-supported site for sharing and discussing early drafts of scientific papers (mostly physics and math).
 * [Directory of Open Access Journals](https://doaj.org/) - Over 9000 journals listed.
 * [Investigative Dashboard](https://investigativedashboard.org/) - A tool for researchers, especially journalists, to share documents and findings.
 * [Taskade](https://www.taskade.com) - Collaborative outliner, notes, and task manager.
 
## Literature

### Citizen Science Theory
 * [Citizen Science: Probing the Virtues and Contexts of Participatory Research](http://estsjournal.org/article/view/99/58)
 * [Buckets of Resistance: Standards and the Effectiveness of Citizen Science](https://www.academia.edu/7622292/Buckets_of_Resistance_Standards_and_the_Effectiveness_of_Citizen_Science?auto=download)
 * [The Potentials and Limitations of Civil Society Research: Getting Undone Science Done](http://davidjhess.net/uploads/3/4/8/1/34811322/socinquiry.2009.draft.pdf)
 * [Citizen Engineering: Disrupting Expertise in Classroom and Community](https://peer.asee.org/citizen-engineering-disrupting-expertise-in-classroom-and-community) - A paper introducing the concept of "citizen engineering" as a companion to citizen science
 * [Institutions for Civic Technoscience: How Critical Making is Transforming Environmental Research](https://www.researchgate.net/publication/263120833_Institutions_for_Civic_Technoscience_How_Critical_Making_is_Transforming_Environmental_Research)
 * [Citizen Science as an Ecological Research Tool: Challenges and Benefits](http://www.jstor.org/stable/pdf/27896218.pdf)
 * [Academic Research in the 21st Century: Maintaining Scientific Integrity in a Climate of Perverse Incentives and Hypercompetition ](http://online.liebertpub.com/doi/10.1089/ees.2016.0223)
 * [The Science Wars and the Future of the American Academic Profession](http://www.its.caltech.edu/~bi/labinger/nontechpdfs/7sciencewars.pdf) - Caltech chemistry professor Jay A. Labinger's paper about the need for scientists to engage with critical science studies scholars.
 * [Science for the People](http://science-for-the-people.org/) - A late 1960s/early 1970s radical science movement whose literature has been organized on a website by UMass Amherst.
 * [From the March for Science to an Abolitionist Science](https://www.fromthesquare.org/march-science-abolitionist-science/#.WPpQv2nyuUl) - An article that offers several historical and current critiques of science that propose alternative ways of doing scientific work.
 * [Whole Earth Catalog](http://www.wholeearth.com/index.php) - A site that contains the remnants of a famous late 1960s and early 1970s maker/ecology magazine.
### Citizen Science Practice
 * [Lead Concentrations in Inner-City Soils As a Factor in the Child Lead Problem](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC1651267/pdf/amjph00647-0022.pdf) - A 1983 pharmacology paper detailing a low-cost, low-tech method of doing soil heavy metal testing.
 * [How to Run a Feminist Science Lab Meeting](https://civiclaboratory.nl/2017/03/31/how-to-run-a-feminist-science-lab-meeting/) - A guide by the Civic Laboratory in St. John's, Newfoundland
 * [Spectrophotometric Determination of Lead](http://www.pharmtech.com/spectrophotometric-determination-lead) - Another simple DIY lead testing procedure.
 * [First-Ever Video May Show Pig-Like Animals Mourning Their Dead](https://news.nationalgeographic.com/2017/12/animals-grieving-peccaries-death-mourning/) - An example of an important scientific discovery being made by someone who was not an institutional academic (an 8-year-old boy).  The boy received lead author credit in a scientific paper.
 
## Citizen Science Spaces and Projects

### Genetics/Biohacking

 * [Genspace](http://genspace.org/) - One of the oldest and most successful DIY Bio labs, located in Brooklyn, NYC.
 * [BioCurious](http://biocurious.org/) - The first biohacking space in the world, located in Sunnyvale, CA
 * [HiveBio](http://hivebio.org/) - Seattle community bio lab.
 * [SynthTechBio Network](http://www.syntechbio.com/) - Latin American biohackers' network.
 * [Four Thieves Vinegar Collective](https://fourthievesvinegar.org/) - A group working on DIY pharma-hacking projects, such as a $30 alternative to $600 epi-pens.

### Environment

 * [The Community Science Initiative](http://www.communityscience.org/) - A nonprofit water testing and environmental data organization in Ithaca, NY.
 * [Sanctuary for Weedy Species](http://ellieirons.com/projects/sanctuary/) - A Brooklyn-based urban ecology project.
 * [Coweeta Listening Project](https://listening.coweeta.uga.edu/#) - Southern Appalachian project combining ecological research with civic action.
 * [The Radix Center](https://radixcenter.org/) - Community-based urban sustainability / agriculture education center in Albany, NY.
 * [The Bucket Brigade](http://www.labucketbrigade.org/) - A Norco, LA - based citizen science group fighting for environmental justice.
 * [Safecast](http://blog.safecast.org/) - An online citizen science project collecting and visualizing radioactivity data across the globe.
 * [Rainforest Connection](https://rfcx.org/) - Project sing old smartphones as sensors to combat illegal logging.

### Other

 * [The Citizen Science Lab](http://www.thecitizensciencelab.org/) - A community science lab based in Pittsburgh, PA.
 * [BioBus](http://www.biobus.org/) - A mobile science education lab.
 * [Hillsboro Library of Things](http://www.hillsboro-oregon.gov/departments/library/explore-the-collections/library-of-things) - A library for physical objects based in Hillsboro, OR.  Includes some science and tech supplies.
 * [Fab Foundation](http://fabfoundation.org/) - an organization that facilitaties a network of digital fabrication "Fab Labs"
 * [Farm Hack](http://farmhack.org/tools) - A project for producing open farm tools.
 
## Art and Science Spaces
*Community-driven science labs tend to operate differently from conventional labs. Their member-led and curiosity-driven approach often produces work that breaks down conventional disciplines, such as bio-art.  This section is for listing spaces that may or may not be conventional makerspaces but capture this spirit of interdisciplinarity*.
 * [Coalesce: Center for Biological Arts](https://www.buffalo.edu/genomeenvironmentmicrobiome/coalesce.html) - A bioart studio-lab at SUNY Buffalo.
 * [MIT Media Lab](http://www.media.mit.edu/) - An interdisciplinary art, science and technology research center that is part of the Massachusetts Institute of Technology.
 * [Interspecifics](http://www.interspecifics.cc/) - A Mexico City-based collective working on projects at the intersection of art and science, especially related to biologically-generated sound.
 * [Center for Science and the Imagination](http://csi.asu.edu/) - A collaboration between artists and scientists at Arizona State University.
 * [STEM to STEAM](http://stemtosteam.org/) - An initiative out of Rhode Island School of Design to bring more art and design into STEM education.
 * [The Waag Society](https://waag.org/en/) - An institute for collaborative art, science and technology based in the Netherlands.

## Funding and Support

### Financial Resources
 * [Experiment.com](https://experiment.com/) - A science crowdfunding platform.
 * [The Awesome Foundation](http://www.awesomefoundation.org/) - A nonprofit that funds awesome projects with microgrants $1000 at a time.
 * [Endeavorist](https://www.endeavorist.org/#!/) - A "curiosity network" for science and technology that combines a social network with crowdfunding.
 * [Herb Society of America](http://www.herbsociety.org/support/grants-scholarships/grant-details.html) - Offers some grants that are compatible with small, non-institutional research projects.
 * [Seeding Labs](https://seedinglabs.org/) - Equipment and funding for labs in developing countries.
 * [EPA Environmental Education Grants](https://www.epa.gov/education/environmental-education-ee-grants) - Grants available for small community organizations.

### Other Types of Support
 * [DIYbio.org](https://diybio.org/) - An online community for DIY biologists.
 * [CollabFinder](http://collabfinder.com/) - A place to find collaborators for your project.
 * [OpenLab-Blueprint](http://openlab-blueprint.org/) - Informational resources for upstart DIY science labs, put together by members of Genspace.
 * [SciStarter](http://scistarter.com/finder) - A search engine for finding citizen science projects to participate in.
 * [Federal Crowdsourcing and Citizen Science Toolkit](https://crowdsourcing-toolkit.sites.usa.gov/) - Maintained by the US government.
 * [Public Lab](https://publiclab.org/) - A DIY environmental science network.
 * [Welcome to How To Grow (almost) Anything in GaudiLabs - Switzerland](http://bio.academany.org/2015/labs/luzern/final_project.html) - A guide to setting up a basic microbiology lab.
 
## Conferences and Events
 * [Innovative Citizen](http://www.innovative-citizen.de/) - An annual citizen science festival in the Ruhr area, Germany, with an emphasis on organic fabrication, bio-hacking, mobile agriculture, and sustainability in urban ecosystems. 
 * [iGEM](http://igem.org/Main_Page) - Student synthetic biology competition with connections to many DIY bio labs.
 * [Biofabricate](http://www.biofabricate.co/) - A design-focused annual conference that focuses on biotechnology-affiliated design, materials, and techniques.
 * [Biodesign Challenge](http://biodesignchallenge.org/) - Student design competition that concentrates on envisioning the future application of biotechnology.
 
## Other Resources
 * [MOST](http://www.appropedia.org/Category:MOST) - The Pearce Research Group at Michigan Tech in Open Sustainability Technology.
 * [OSGeo](http://www.osgeo.org/) - The Open Source Geospatial Foundation, which offers a lot of open tools for working with GIS data.
 * [Open source engineering software](http://www.appropedia.org/Open_source_engineering_software#Software_Listing) - A large list maintained on Appropedia.
 * [The Open Source Hardware Association](http://www.oshwa.org/) - A resource for all things open hardware, including designs and legal considerations.
 * [Biocanvas](http://biocanvas.net/) - A collection of biological images as art.
 * [The Powercube](https://www.powercube.net/) - Some literature and workshops by community organizers for understanding power and mobilizing.
 * [Detroit Future City: A Field Guide to Working with Lots](https://dfc-lots.com/resources/) - Guides for urban agriculture from Detroit.
 
## Questions and Knowledge Gaps

* Ethics in research are often overseen by federal agencies or institutional review boards (IRBs). Is there a bottom-up, citizen-driven alternative to this?
 
## How do I contribute to this list?

Have an idea of a tool that should be on this list? Here's how you can add it:
 * **Familiar with GitHub?** Send a pull request with your suggestions. Please also see the [contribution guidelines](https://github.com/dylanrees/toolsforcitizenscience/blob/master/contributing.md).
 * **Not familiar with GitHub?** You can leave a comment on this page by clicking on the `Issues` tab on the right and adding a New Issue (that's just like a comment). You'll need to create a GitHub account first.

## License

No copyright intended.

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, Dylan Rees has waived all copyright and related or neighboring rights to this work.
