<div class="github-widget" data-repo="hackerkid/bots"></div>
<p align="center">
  <img src="https://raw.githubusercontent.com/hackerkid/bots/master/bots3d.png" />
</p>
<br>

<p align="center"><a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img src="https://camo.githubusercontent.com/13c4e50d88df7178ae1882a203ed57b641674f94/68747470733a2f2f63646e2e7261776769742e636f6d2f73696e647265736f726875732f617765736f6d652f643733303566333864323966656437386661383536353265336136336531353464643865383832392f6d656469612f62616467652e737667" alt="Awesome" data-canonical-src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" style="max-width:100%;"></a> <a href="http://makeapullrequest.com" rel="nofollow"><img src="https://camo.githubusercontent.com/a34cfbf37ba6848362bf2bee0f3915c2e38b1cc1/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f5052732d77656c636f6d652d627269676874677265656e2e7376673f7374796c653d666c61742d737175617265" alt="PRs Welcome" data-canonical-src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square" style="max-width:100%;"></a> <a href="https://gitter.im/hackerkid/bots?utm_source=badge&amp;utm_medium=badge&amp;utm_campaign=pr-badge&amp;utm_content=badge" rel="nofollow"><img src="https://camo.githubusercontent.com/fe6988d65fff4cc1047f3dad8af636bb523c6ef1/68747470733a2f2f6261646765732e6769747465722e696d2f6861636b65726b69642f626f74732e737667" alt="Join the chat at https://gitter.im/hackerkid/bots" data-canonical-src="https://badges.gitter.im/hackerkid/bots.svg" style="max-width:100%;"></a></p>

<br>
<h1  align="center">
  
  查看我的最新项目 - <a href="http://bit.ly/diff-bots">diff.blog</a>
</h1>
<br>


目录
-----------------


## Platform Documentation
* [IBM Bot Asset Exchange](https://developer.ibm.com/code/exchanges/bots/)
* [Facebook messenger](https://developers.facebook.com/products/messenger/)
* [Slack](https://api.slack.com/bot-users)
* [Discord](https://blog.discordapp.com/the-robot-revolution-has-unofficially-begun/)
* [Telegram](https://core.telegram.org/bots/api)
* [Kik](https://dev.kik.com/#/home)
* [Zulip](https://zulip.com/integrations/)
* [HipChat](https://developer.atlassian.com/hipchat/getting-started)
* [Skype](https://developer.microsoft.com/en-us/skype/bots)
* [Cisco Spark](https://developer.ciscospark.com/getting-started.html)
* [Microsoft Bot Framework](https://dev.botframework.com/)
* [WeChat](https://admin.wechat.com/)
* [VKontakte](https://new.vk.com/dev/bizmessages)
* [Hangouts Chat](https://developers.google.com/hangouts/chat/concepts/)

## Tools For Building Bots
* [wit.ai ](https://wit.ai/) - 轻松创建人类可以与之聊天的基于文本或语音的机器人.
* [Botkit](https://howdy.ai/botkit/) - Botkit 简化了设计和运行 Slack 内部机器人的过程.
* [Dialogflow](https://dialogflow.com/) - 建立自然而丰富的对话体验.
* [Text It](https://textit.in/) - 可视化构建短信和语音应用程序以吸引您的客户.
* [Chatfuel](https://chatfuel.com/)  - 具有 AI 导航功能的直观机器人构建器. 无需编码.
* [Watson](http://www.ibm.com/cloud-computing/bluemix/watson/) - 为您的应用程序带来认知计算的力量.
* [Beep Boop](https://beepboophq.com/) - Beep Boop 是一个简单的托管平台，适用于您的 Slack 和 Messenger 机器人.
* [Dexter](https://rundexter.com/app/spreadsheet-bot) - 获取一个 Slack 机器人，它会根据您自己的 Google 表格中的答案做出响应.
* [Converse AI](http://www.converse.ai/) - 使用智能聊天机器人技术即时回复客户问题.
* [Gupshup](https://www.gupshup.io/developer/home) - 在任何渠道上构建和部署机器人的最简单和最快的方式.
* [Haven OnDemand](https://dev.havenondemand.com/apis) - 它们是与 watson 类似的 API，但有据可查且有免费增值版本.
* [Recast.AI](https://recast.ai) - 面向开发人员的协作机器人平台：轻松构建对话机器人.
* [ChatterBot](https://github.com/gunthercox/ChatterBot) - 以 Python 构建的基于机器学习的会话对话引擎
* [Google Cloud Platform](https://cloud.google.com/natural-language) - 使用文本块的情感分析来为对话机器人添加决策树逻辑.
* [Messenger Demo Viewer](https://messenger-demo-viewer.kilianvalkhof.com/) - 在不显示个人聊天记录的情况下演示 FB Messenger 机器人
* [BotStar](https://www.botstar.com/) - 通过智能训练直观地设计和开发聊天机器人的强大平台.

## Tools For Bot Analytics
* [ChatMetrics](https://chatmetrics.io/)  - 机器人的参与平台.  ChatMetrics 允许重新激活不活跃的用户并通过向用户发送“智能”通知来提高保留率.
* [Dialog](https://dialoganalytics.com/) - 供营销人员使用的聊天机器人分析平台，可推动用户参与、保留、转化和了解行为.
* [Dashbot](https://www.dashbot.io/) - 可操作的机器人分析：增加用户参与度、获取和货币化.
* [Botmetrics](https://www.getbotmetrics.com/)  - 发展并留住您的聊天机器人客户. 企业级开源对话分析、营销自动化和 CRM 集成到单个代码片段中.

## Tools For Bot Conversation Mockups
* [Bot Society](https://www.botsociety.io) - 用于演示和演示的机器人对话模型.
* [Bot Sketch](https://dribbble.com/shots/2674603-Facebook-Messenger-UI-Kit-for-Chatbots-Sketch) - 素描聊天机器人 UI（仅限 Mac）
* [Botframe](https://botframe.com) - 设计机器人的游乐场（对话模型）.
* [Botmock](https://botmock.com) - 从一个简单的拖放编辑器创建对话流和交互式原型，然后共享或测试这些原型并在一个集中位置获得反馈.
* [BotStar](https://www.botstar.com) - 一个成熟的聊天机器人平台，但可视化编辑器也可以用作模型工具.


## Libraries

### General
* [Qtypes](https://github.com/superscriptjs/qtypes) - Node.js 中基于规则的答案类型分类系统.
* [BotKit](https://github.com/howdyai/botkit) - Botkit 是用于制作机器人应用程序的工具包.
* [Claudia Bot Builder](https://github.com/claudiajs/claudia-bot-builder) - 为 FB、Slack、Skype 和 Telegram 创建聊天机器人，并在几分钟内部署到 AWS Lambda.
* [Universal Bot Framework](https://bitbucket.org/phips28/universal-bot-framework/overview) - 仅使用一种逻辑为 FB Messenger、Kik、Telegram 和 Skype 创建跨平台聊天机器人.
* [Pandorabots](http://www.pandorabots.com/) - 用于构建和部署聊天机器人的网络服务.
* [Microsoft Bot Framework](http://docs.botframework.com) - 用于构建、连接、测试和部署功能强大的智能机器人的 Node.js/.NET 库. 
* [Bottender](https://github.com/Yoctol/bottender) - 以您的方式快速灵活地制作机器人.
* [BotMan](https://github.com/botman/botman) - PHP Bot Framework 支持十几个平台（FB、Instagram、MS Bot Framework 等）

### Facebook Messenger
* [Node.js](https://github.com/Yoctol/messaging-apis/tree/master/packages/messaging-api-messenger)
* [Go](https://github.com/paked/messenger)

### Slack
* [Node.js (Official)](https://github.com/slackhq/node-slack-sdk)
* [Node.js](https://github.com/Yoctol/messaging-apis/tree/master/packages/messaging-api-slack)
* [Python (Official)](https://github.com/slackhq/python-slackclient)
* [Relax (scalable RTM library to scale to 1000's of teams)](https://github.com/zerobotlabs/relax)

### Telegram
* [Node.js](https://github.com/yagop/node-telegram-bot-api)
* [Node.js](https://github.com/telegraf/telegraf)
* [Node.js](https://github.com/Yoctol/messaging-apis/tree/master/packages/messaging-api-telegram)
* [PHP](https://github.com/irazasyed/telegram-bot-sdk)
* [PHP](https://github.com/php-telegram-bot/core)
* [Python](https://github.com/python-telegram-bot/python-telegram-bot)
* [C#](https://github.com/MrRoundRobin/telegram.bot)
* [Go](https://github.com/tucnak/telebot)
* [Java](https://github.com/pengrad/java-telegram-bot-api)

### Discord
###### Node.js
* [Eris](https://github.com/abalabahaha/eris)
* [Discord.js](https://github.com/hydrabolt/discord.js)
* [Discordie](https://github.com/qeled/discordie)
* [Discord.io](https://github.com/izy521/discord.io)

###### C
* [Concord](https://github.com/Cogmasters/concord)

###### C#
* [Discord.Net](https://github.com/RogueException/Discord.Net)
* [DSharpPlus](https://github.com/NaamloosDT/DSharpPlus)

###### Python
* [discord.py](https://github.com/Rapptz/discord.py)

###### Java
* [JDA](https://github.com/DV8FromTheWorld/JDA/)

###### Rust
* [Serenity](https://github.com/zeyla/serenity)

###### Lua
* [Discordia](https://github.com/SinisterRectus/Discordia)

###### Go
* [Discordgo](https://github.com/bwmarrin/discordgo)

### Kik
* [Python](https://github.com/kikinteractive/kik-python)
* [Node.JS](https://github.com/kikinteractive/kik-node)


## Bot Stores
* [There is a bot for that](https://thereisabotforthat.com) - 机器人搜索引擎
* [ChatBottle](https://chatbottle.co/) - 聊天机器人搜索引擎
* [BotList](https://botlist.co/) - 机器人应用程序商店.
* [Slack Store](https://slack.com/apps) - 官方 Slack 机器人商店.
* [Telegram Store](https://storebot.me/) - 非官方的 Telegram 机器人商店.
* [Product Hunt](https://www.producthunt.com/topics/bots) - Product Hunt 机器人列表.
* [Dashbot](http://www.dashbot.io/bots) - Dashbot 机器人目录.
* [Skype Bot Directory](https://bots.botframework.com/) - Microsoft Bot Framework 的官方 skype 机器人列表
* [Teamchat](http://www.teamchat.com/en/bot-store/) - 团队聊天机器人商店.
* [Discord Bots](https://bots.discord.pw/) - 一份非官方的不和谐机器人列表.
* [Discord Bot List](https://discordbots.org/) - 一份非官方的不和谐机器人列表.
* [Telegram Botlist](https://t.me/botlist) - Telegram 的机器人列表.
* [Mayo Bot List](https://botlist.space/) - 一份非官方的不和谐机器人列表.
* [Terminal Bot List](https://ls.terminal.ink/) - 一份非官方的不和谐机器人列表.

## Tutorials
* [The Complete Beginner’s Guide To Chatbots](https://chatbotsmagazine.com/the-complete-beginner-s-guide-to-chatbots-8280b7b906ca).
* [The Secret To Making Your Own Facebook Messenger Bot In Less Than 15 Minutes.](https://chatbotsmagazine.com/have-15-minutes-create-your-own-facebook-messenger-bot-481a7db54892)
* [How to create a chatbot without coding a single line](https://chatbotsmagazine.com/how-to-create-a-chatbot-without-coding-a-single-line-e716840c7245#.kimh0igkz)
* [How To Build Bots for Messenger.](https://developers.facebook.com/blog/post/2016/04/12/bots-for-messenger/)
* [Creating A Chat Bot.](https://medium.freecodecamp.com/creating-a-chat-bot-42861e6a2acd#.32hmkqfq7)
* [A Beginner’s Guide To Your First Bot.](https://slackhq.com/a-beginners-guide-to-your-first-bot)
* [Pair Programming a Facebook Messenger Bot.](https://www.youtube.com/watch?v=zFO1cRr5-qY)
* [Facebook Chatbot Tutorial](https://github.com/AdrianKrebs/facebook-chatbot-tutorial)
* [Design Framework For Chatbots](https://chatbotsmagazine.com/design-framework-for-chatbots-aa27060c4ea3)
* [UX of Chatbots](http://uxofchatbots.com/)

## Communities
* [Bots](https://www.facebook.com/groups/chatbot/) - 脸书群组.
* [UX for Bots](https://www.facebook.com/groups/uxforbots/) - 脸书群组.
* [Chat Bot Magazine](https://chatbotsmagazine.com/) - 中等的.
* [HH Bots](https://www.facebook.com/groups/hhbots/) - 脸书群组.
* [Messenger Platform Developer Community](https://www.facebook.com/groups/242384196138564/) - 官方脸书群组.
* [Chatbots and Conversational Agents](https://www.quora.com/topic/Chatbots-and-Conversational-Agents) - 知乎主题
* [Bot Developer Hangouts](http://dev4slack.xoxco.com/) - 适用于所有机器人平台的 Slack 社区.
* [BotList Chat](http://t.me/botlistchat) - 电报组.
* [Bot Development](http://t.me/botdevelopment) - 电报组.

## Conferences
* [ChatbotConf](https://chatbotconf.com/)
* [Talkabot](https://talkabot.ai/)

## Developers
* [BotMakers](https://botmakers.net/) - 聘请聊天机器人开发人员的最佳场所
* [Botgig](http://www.botgig.com/) - 从经过审查的人才库中聘请顶级聊天机器人开发人员.

## Testing
* [ChatbotTest](http://chatbottest.com/) - Chatbottest 是一个开源指南，可帮助您识别聊天机器人在 7 个不同类别下的设计问题.
* [BotTesting](http://bottesting.co/)  - 测试你的机器人！ 将您的电子邮件和机器人链接发送给我们，我们将检查您的机器人的性能和可用性

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Vishnu Ks](http://www.vishnuks.com) 已放弃该作品的所有版权和相关或邻接权.
