<div class="github-widget" data-repo="jorgebucaran/awsm.fish"></div>
## awsm.fish [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> Fish is the sassy & user-friendly command line shell you never knew you needed for Linux, macOS, and the whole gang. Out with the old-fashioned shells that skimp on features for the sake of every last byte of RAM—finally, a command line shell for the 90s!

Welcome to the ultimate treasure trove of handpicked plugins, prompts, and other [Fish](https://fishshell.com/) goodies. You see, this isn't just any collection—we curate only the best of the best Fish projects for your friendly interactive shell. Got a top-notch project you want featured here? [Send us a pull request](https://github.com/jorgebucaran/awesome-fish/fork), join the crew!



## Official Resources

- [Official Site](https://fishshell.com)
- [GitHub Repository](https://github.com/fish-shell/fish-shell)
- [Try in browser!](https://rootnroll.com/d/fish-shell/) 🍤

## Community Resources

- [r/fishshell](https://www.reddit.com/r/fishshell) - The Reddit hangout
- [Gitter Channel](https://gitter.im/fish-shell/fish-shell) - Come chat with us!
- [Stack Overflow `#fish`](https://stackoverflow.com/questions/tagged/fish) - Got questions? We've got answers!
- [The Fish Cookbook](https://github.com/jorgebucaran/cookbook.fish) - From Shell to Plate: Savor the Zest of Fish 🦞

## Prompts

- [Tide](https://github.com/IlanCosman/tide) - A modern prompt manager for Fish
- [Pure](https://github.com/pure-fish/pure/) - [_That_](https://github.com/sindresorhus/pure) ZSH prompt, now in Fish flavor
- [Hydro](https://github.com/jorgebucaran/hydro) - Lag-free prompt with async Git status (ooh la la)

## Plugins

- [z](https://github.com/jethrokuan/z) - Pure-Fish [`rupa/z`](https://github.com/rupa/z)-like directory jumping
- [fzf](https://github.com/PatrickF1/fzf.fish) - Ef-🐟-ient key bindings for [`junegunn/fzf`](https://github.com/junegunn/fzf). ([Alternative](https://github.com/jethrokuan/fzf))
- [nvm](https://github.com/jorgebucaran/nvm.fish) - Node.js version manager lovingly made for Fish
- [Done](https://github.com/franciscolourenco/done) - Automatically receive notifications after a long process finishes
- [Replay](https://github.com/jorgebucaran/replay.fish) - Run Bash commands replaying changes in Fish. ([Alternative](https://github.com/edc/bass))
- [Spark](https://github.com/jorgebucaran/spark.fish) - Sparklines for Fish
- [Fisher](https://github.com/jorgebucaran/fisher) - Manage functions, completions, bindings, and snippets from the CLI
- [Fundle](https://github.com/danhper/fundle) - `config.fish`-based plugin manager
- [GitNow](https://github.com/joseluisq/gitnow) - A collection of utility functions to speed up your git workflow
- [Sponge](https://github.com/meaningful-ooo/sponge) - Clean command history from typos automatically
- [Autopair](https://github.com/jorgebucaran/autopair.fish) - Auto-complete matching pairs in the Fish command-line. ([Alternative](https://github.com/laughedelic/pisces))
- [Getopts](https://github.com/jorgebucaran/getopts.fish) - CLI options parser (alternative to the [`argparse`](https://fishshell.com/docs/current/cmds/argparse.html) builtin)
- [Fishtape](https://github.com/jorgebucaran/fishtape) - TAP-based test runner for Fish
- [Pufferfish](https://github.com/nickeb96/puffer-fish) - Text Expansions for Fish
- [Projectdo](https://github.com/paldepind/projectdo) - Context-aware single-letter abbreviations to build, run, and test any project
- [Virtualfish](https://github.com/adambrenecki/virtualfish) - Virtualenv wrapper
- [Async Prompt](https://github.com/acomagu/fish-async-prompt) - Make your prompt asynchronous
- [Apple Touchbar](https://github.com/rodrigobdz/fish-apple-touchbar) - Customize your [Touch Bar](https://developer.apple.com/design/human-interface-guidelines/macos/touch-bar/touch-bar-overview) in iTerm2
- [Abbreviation Tips](https://github.com/Gazorby/fish-abbreviation-tips) - Remembering abbreviations by displaying tips when you can use them
- [Base16 Fish](https://github.com/FabioAntunes/base16-fish-shell) - A pure Fish solution to change your shell's default ANSI colors

## Docker

- [Alpine Image](https://hub.docker.com/r/purefish/docker-fish)
- [Ubuntu LTS Image](https://hub.docker.com/r/dideler/fish-shell)
