<div class="github-widget" data-repo="cristianoliveira/awesome4girls"></div>
## awesome4girls [![Travis branch](https://img.shields.io/travis/rust-lang/rust/master.svg?style=flat-square&label=awesomeness)](https://travis-ci.org/cristianoliveira/awesome4girls) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![CodeOfConduct](https://img.shields.io/badge/code%20of%20conduct-1.3.0-ff69b4.svg)](http://contributor-covenant.org/version/1/3/0/)
一份精选的科技领域女性包容性活动/项目/倡议清单.

----


----

## Events/Meetups

  This section contains all the specifics for meetups/events.

### Clojure

  - [ClojureBridge](http://www.clojurebridge.org)

    ClojureBridge 旨在通过为女性提供免费、适合初学者的 Clojure 编程研讨会来增加 Clojure 社区的多样性.

### Design

  - [Ladies Wine and Design](http://ladieswinedesign.com/)

    每月在 200 多个城市举办沙龙之夜，为女性设计师举办偶尔的跨界编码活动.


### Go-lang

  - [Women Who Go](http://www.womenwhogo.org/)

    基于 Golang 的女性社区.  （推特：https://twitter.com/womenwhogo）.

### Java

  - [JDuchess](https://www.facebook.com/jduchess.org/)

     Duchess 是 Java 技术女性的全球性组织，其成员遍布 60 多个国家.  Duchess 提供了一个平台，使用 Java 的女性可以通过该平台相互联系并更多地参与 Java 社区.

### Javascript

  - [Js-Girls](http://js-girls.org/)

    Js-Girls 是一个为期 1 天的研讨会，面向想要学习 Javascript 的女孩.

  - [Js4Girls](https://raw.githubusercontent.com/Webschool-io/js4girls) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

    一项巴西倡议，旨在为没有男性的环境中的女性提供免费的 javascript 课程.

  - [JsLadies BR](https://raw.githubusercontent.com/jsladiesbr) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

    一个面向对 Web 开发和 javascript 感兴趣的女性的团体，提供公开和免费的会议、研讨会和讲座.

  - [NodeGirls](https://nodegirls.com/)

     Node Girls 举办为期 1 天的免费 Node.js 研讨会. 他们为正在学习编码的女性提供了一个友好的环境，并得到了一群经验丰富的女性导师的支持.

### PHP

  - [PHPWomen](https://phpwomen.org/)

    一个包容性的全球用户组，在 PHP 社区内提供支持网络.

### Python

  - [Django Girls](https://djangogirls.org/)

    免费的 Python 和 Django 研讨会，他们还创建开源在线教程并策划令人惊叹的技术初体验.

  - [PyLadies](http://www.pyladies.com/)

    一个国际指导小组，致力于帮助更多女性成为 Python 开源社区的积极参与者和领导者.

### R

  - [R-Ladies](https://rladies.org/)

    R-Ladies 是一个全球性组织，其使命是促进 R 社区的性别多样性.

  - [R-Ladies São Paulo - Brazil](https://www.meetup.com/R-Ladies-Sao-Paulo)- *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30">)

### Ruby

  - [Rails Bridge](http://www.railsbridge.org/)

    研讨会是开始使用 Rails、Ruby 和其他 Web 技术或提高其水平的一种免费且有趣的方式. 我们的活动侧重于增加技术的多样性，以便所有背景的人都能在我们的行业中感到受欢迎和舒适.

  - [RailsGirls](http://railsgirls.com/)

    RailsGirls 是一个跨国社区，为女孩和女性提供工具来构建她们的想法.

  - [RailsGirls Summer of Code](http://railsgirlssummerofcode.org/)

      Rails Girls Summer of Code 是一项面向女性和非二进制编码人员的全球奖学金计划. 学生将获得为期三个月的奖学金，用于从事现有的开源项目并扩展他们的技能.


### UX

  - [Hexagon UX](https://hexagonux.com/)

    Hexagon 旨在建立一个支持性社区，促进女性的多样性、支持、赋权和指导.
    The first Hexagon UX event was held at Google HQ in October 2013, where attendees created “story cards” that represented themselves or their journey into UX.

  - [Ladies that UX](http://ladiesthatux.com/)

    Ladies that UX 是每月一次的聚会，它创建了一个热情、透明的社区，由从事 UX 工作的女性组成，她们积极促进和互相教导.

## General

  - [Ada Lovelace Day](https://findingada.com/)

     Ada Lovelace Day 是每年 10 月的第二个星期二举行的节日，是庆祝 STEM 领域女性的国际节日. 这一天是为了庆祝女性在 STEM 领域做出的贡献，并鼓励其他女性通过提高对这些贡献的认识来追求这些领域. 有一个主要活动在英国伦敦举行，但任何人都可以通过组织活动或在线分享自己的故事来庆祝 ALD.

  - [AnitaB.org](https://anitab.org/)
    
     AnitaB.org 是一家由 Anita Borg 创立的社会企业，支持技术领域的女性，以及雇用她们的组织和培训下一代的学术机构. 他们的 GitHub 项目非常适合初学者，适合任何有兴趣开始开源项目的人（很多初学者问题）.

  - [Anitas](http://anitas.com.br/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30">

     Anitas 是一群在技术和创业领域致力于女性赋权的女性，基于思想、知识和经验的交流. 为此，Anitas 组织了课程、研讨会、讲座，并参与了旨在让女性参与技术和创业的倡议.

  - [Bay Area Girls](http://girlgeek.io/about/)

    在旧金山举办了赞助晚宴，邀请来自各地的女性与来自女性技术社区的知名演讲者一起分享她们的经验. 这些活动还提供网络和赞助公司的潜在招聘. 它已由 100 多家公司主办，并且每月举办多场活动.

  - [Byte Girl](http://bytegirl.com.br/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

     Byte Girl 是一项由志愿者组织的非营利性开放活动，专注于喜欢科技的女性. 它的目标是通过分享宝贵的技术知识和经验的专业人士的演讲来赋予女性权力.

  - [Byte Hacks](http://bytehacks.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    ByteHacks 是 9 月 1 日和 2 日在 Thoughtworks NYC 举行的 24 小时编程马拉松，鼓励所有年龄和技能的女性组建团队并创建具有积极社会影响的技术项目.
    黑客马拉松将有研讨会、技术讲座、导师、赞助商和免费食物. 无论您是设计师、企业家、艺术家还是编码员，ByteHacks 都欢迎您. 我们甚至还有来自 Adafruit 创始人兼首席执行官 Limor Fried 的主题演讲.

  - [Code Girl](http://www.codegirl.com.br/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

     Code Girl 是一项以励志演讲为特色的活动，主题是关于克服在科技行业工作的女性所面临的挑战. 该活动以女性演讲者为特色，旨在激励业内女性.

  - [Czechitas](https://www.czechitas.cz/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/commons/c/cb/Flag_of_the_Czech_Republic.svg" alt="Czech Republic" width="30">

     Czechitas 是一家位于捷克共和国的非营利组织，它组织活动、课程和夏令营，以帮助妇女、女孩和儿童探索 IT 世界. 这些活动涵盖编程、Web 开发、图形设计、数字营销和数据分析等主题.

  - [Geek Girls Carrots](http://gocarrots.org) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/e/e9/Flag_of_Poland_%28normative%29.svg/1280px-Flag_of_Poland_%28normative%29.svg.png" alt="Poland" width="30">

     Geek Girls Carrots 是一个全球草根组织，专注于科技领域的女性和女性企业家. 胡萝卜通过提高女性对新技术的参与度来改变 IT 行业的现状. 团队内部的多样性有助于促进公司的创新和更好的经济效益.  GGC创建一个国际社区，通过持续的团队支持、相互激励和友好的个人成长环境.

  - [Girls4Tech](https://girls4tech.ebanx.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

     Girls 4 Tech 是一个在线编程课程，完全免费，由女性制作. 该语言易于理解，不需要先前的知识，并且对所有人开放.

  - [League of Women Coders](http://lwc.tech/)

    League of Women Coders (formerly Ladies Who Code, est. June 2011) is a meetup that focuses on coding, hacking, and learning collaboratively. The group meets up at least once a month in New York City and Boston. The meetups focus on talks, technical questions and ideation, and occasionally feature female speakers.

  - [RodAda Hacker](http://rodadahacker.org/)  - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

     RodAda Hacker 是一个巴西网络，提供专为女孩和女性设计的编程协作研讨会. 对于那些想要梦想、构建出色项目并重新思考现有技术的人来说，这是一个空间.

  - [Tech Ladies Brasil](http://www.techladies.com.br/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30">

     Tech Ladies Brasil 网络是一个由女性推动的空间，她们通过志愿工作奉献自己的时间来交流知识、专业进步、个人发展和欣赏女性. 我们举办研讨会和一年一度的活动，从女士到女士，带来三个方面：讲座、研讨会和圆桌会议； 讨论符合 Tech Ladies Brazil 宗旨的主题，即女性在技术方面的赋权.

  - [Technovation](http://www.technovationchallenge.org/)

    面向女孩的全球技术创业计划. 学生以团队合作的方式开发移动应用程序初创公司，以解决社区中的实际问题.

  - [Women of Silicon Roundabout](http://www.women-in-technology.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/ae/Flag_of_the_United_Kingdom.svg" alt="United Kingdom" width="30">

     Women of Silicon Roundabout 使人们和组织能够就性别多样性和包容性进行联系、学习和采取行动. 我们不回避争议，我们希望通过突破界限让人们对新想法敞开心扉.
    通过鼓舞人心的主题演讲、关于商业战略的小组讨论、技术课程和职业发展研讨会，这次会议提供了在科技领域蓬勃发展所需的所有内容和交流机会.

  - [Women Who Code](https://www.womenwhocode.com) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

     Women Who Code (WWCode) 是一家总部位于美国的 501(c)(3) 非营利组织，致力于激励女性在技术职业中脱颖而出.  WWCpde 将杰出女性与全球其他志同道合的杰出女性联系起来，她们团结在一个简单的概念下——科技世界因女性而变得更加美好.

  - [Wonder Women Tech Summit](https://wonderwomentech.com/)

     Wonder Women Tech 的使命是突出、庆祝和教育 STEM 行业中的女性和弱势群体. 会议活动和研讨会将变革者、先驱者、创新者、高级别演讲者和与会者聚集在一起，探索想法、讨论和解决方案，帮助女性和弱势群体取得成功和繁荣.

## Initiatives/Programs

  旨在为女性从事技术职业做好准备的举措.

### Academy/Camp

  在其活动中有任何类型的学院/夏令营的项目.

  - [ACM-W](https://women.acm.org/)

    计算机协会的女性计算计划在国际上支持、庆祝和倡导女性全面参与计算领域的各个方面，为 ACM 成员提供广泛的计划和服务，并在更大的社区中工作以推动技术女性的贡献.

  - [Ada Developers Academy](http://adadevelopersacademy.org/)

    为过渡到软件开发的女性提供为期一年的免学费强化课程. 可用的最全面的开发人员培训计划之一：七个月的全日制课堂教学加上五个月的实地培训（类似于实习）.

  - [App Camp 4 Girls](http://appcamp4girls.com/)

    App Camp For Girls 是一个女孩可以通过设计和构建应用程序发挥创造力的地方，同时更多地了解软件业务并受到该领域女性导师的启发.

  - [Black Girls Code](http://www.blackgirlscode.com/)

    Black Girls Code 的重点是通过让 7 至 17 岁的有色人种女孩成为 STEM 领域的创新者、社区的领导者以及通过接触计算机来建设自己的未来，从而增加数字空间中有色人种女性的数量科学和技术.

  - [BlackHoodie](https://www.blackhoodie.re/)

     BlackHoodie 是一个免费的、仅限女性的逆向工程研讨会. 这个研讨会背后的动机是为女性工程师提供一个舒适的学习环境. 大多数情况下，该主题很复杂，并且学习曲线陡峭，一开始通常会使学生失去动力. 因此，举办活动的想法将支持信息安全的少数群体之一，即女士们.

  - [Chicas Poderosas](https://chicaspoderosas.org/home/)

     Chicas Poderosas 是一个致力于将美洲拉丁裔女性带入数字新闻前沿的社区. 通过活动、聚会和指导，Chicas 旨在让更多女性参与开发新闻应用程序、制作互动内容以及将新工具集成到她们的新闻编辑室中.

  - [Code First Girl](http://www.codefirstgirls.org.uk) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/ae/Flag_of_the_United_Kingdom.svg" alt="United Kingdom" width="30">

     Code First Girl 为英国从圣安德鲁斯到南安普顿的年轻女性开设免费的兼职编码课程. 大多数课程作为大学分会开设，研究生课程在伦敦开设.

  - [DigiGirlz Day](https://www.microsoft.com/en-us/diversity/programs/digigirlz/digigirlzday.aspx)

     DigiGirlz Day 是 Microsoft 赞助的为期一天的活动，旨在让初中和高中女生更好地了解职业机会. 这个机会为与会者提供职业规划帮助、练习和 Microsoft 产品演示，同时与真正的 Microsoft 员工和经理互动. 此前，该活动已在全球范围内的微软地点如田纳西州纳什维尔举行； 加利福尼亚州圣地亚哥； 和埃及开罗，列出了未来的地点.

  - [DIY Girls](http://www.diygirls.org/)

     DIY（“自己动手”）女孩的使命是通过创新的教育体验和导师关系提高女孩在技术、工程和制作方面的兴趣和成功.  DIY Girls 开发和实施教育计划和活动，旨在鼓励参与技术、提升自信并支持对技术职业的渴望.

  - [Girl Develop It](https://www.girldevelopit.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    Girl Develop It 是一个非营利组织，为有兴趣在无评判环境中学习网络和软件开发的成年女性提供负担得起的项目.

  - [Girls Can Code](https://gcc.prologin.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/thumb/c/c3/Flag_of_France.svg/250px-Flag_of_France.svg.png" alt="French" width="30">

     Girls Can Code 是在 3 个不同城市进行的实习，是结识受编程激励的其他女孩并按照自己的节奏共同进步的绝佳机会. 实习将包括编程练习和一些由从事计算机科学工作的女性讲授的课程.

  - [Girls In Tech](http://www.girlsintech.org/)

     GIT 是一家全球性非营利组织，专注于对技术充满热情的女孩和女性的参与、教育和赋权. 我们的目标是加速进入高科技行业并建立成功初创企业的创新女性的成长.

  - [Girls Teaching Girls to Code](https://www.girlsteachinggirlstocode.org/)
    
     Girls Teaching Girls to Code 是一项将攻读计算机科学和工程学位的女性与想要学习新技能并将其应用到 CS 相关项目的高中女生联系起来的计划.  GTC 全年举办身临其境的年度 Code Camp 以及研讨会和办公室参观等小型活动. 

  - [Girls Who Code](http://girlswhocode.com/)

    我们是一家全国性非营利组织，致力于缩小技术和工程领域的性别差距.Girls Who Code 暑期沉浸式课程是一门为期 7 周的计算机科学强化课程，在科技公司和大学开设课堂.

  - [Hackbright Academy](https://hackbrightacademy.com/)

    Hackbright Academy 是领先的女性软件工程学院，于 2012 年在旧金山成立.该学院每年毕业的女工程师人数超过斯坦福大学和加州大学伯克利分校.

  - [Ladies Learning Code](http://ladieslearningcode.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/c/cf/Flag_of_Canada.svg" alt="Canada" width="30">

    我们是一个非营利组织，其使命是成为女性和青年的主要资源，通过以实践、社交和协作的方式学习技术技能，成为技术的热情建设者——而不仅仅是消费者.

  - [Minas Program](http://minasprogramam.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30">

     Minas 计划每年夏天在圣保罗的 Avenida Paulista 提供为期两周的入门编程课程. 它包括 13 天内 51 小时的培训，而且是免费的. 该课程向所有人开放，但专门针对获得技术培训机会较少的女性.

  - [Tech Girlz](http://www.techgirlz.org/)

    我们是一个致力于减少——并希望最终消除——技术职业中的性别差距的非营利组织. 我们举办研讨会和一年一度的创业夏令营，旨在让中学生亲身体验各种技术，并使她们能够与在技术领域取得成功的女性进行互动.

  - [Women in Computer Science](http://web.stanford.edu/group/wics/)

     WICS 是斯坦福大学的一个学生组织，通过网络和专业化活动促进和支持 CS 和技术领域的女性. 他们得到了谷歌、甲骨文和 Facebook 等公司的行业赞助.  WICS 网站还定期更新本科生和研究生（包括非斯坦福附属学生）的活动、会议和奖学金列表. 
  
  - [Women’s Technology Program at MIT](http://wtp.mit.edu/)

    麻省理工学院的女性技术项目是一个为期四周的暑期项目，向高中生介绍工程和计算机科学. 该计划旨在增强来自历史上代表性不足和服务不足社区的学生以及将成为家庭中第一个上大学的学生的能力. 

### Chatrooms

  在线聊天室，例如 slack teams、gitter、IRC 等.

  - [Systers](https://anitab.org/systers/)

    一个由 Anita Borg Institute 成员组成的社区. 它提供了一个讨论和贡献开源项目、参与活动和讨论技术的任何方面的空间.

  - [Women in Tech](http://witchat.github.io/)

    一个安全、保密的空间，供从事技术工作的女性聊天和互相支持.

### Communities/Groups

  在线社区和团体.

  - [AspireIT](https://www.aspirations.org/aspireit)

     AspireIT 是面向 K-12 女孩的国家妇女和信息技术教育计划和网络中心. 该计划连接了美国 45 个州、华盛顿特区、美属维尔京群岛和波多黎各学校的近 700 个编程和计算机科学组织.  AspireIT 还为教育工作者提供学生奖励和本地项目开发支持. 

  - [Association for Women in Science](https://www.awis.org/)
    
     AWIS 是一个全球网络，旨在激发大胆的领导力、研究和解决方案，以推动女性在 STEM 领域的发展、激发创新、促进组织成功并推动系统变革. 除了网络和职业发展支持外，他们还出版杂志、提供奖学金和助学金以及举办活动. 

  - [Built by Girls](https://www.builtbygirls.com/)

     Built by Girls 是一个支持女性和非二元技术专业人士的早期职业社区. 该小组维护着研讨会、座谈会、办公室参观和社交活动的日历.  WAVE 导师计划每三个月为参与者匹配一位不同的行业专业人士作为顾问. 

  - [Chicago WomenTech](https://www.meetup.com/Chicago-WomenTech/)
    
    Chicago WomenTech 是一个 Meetup 团体，拥有超过 4500 名成员，供科技女性在芝加哥地区进行协作和交流. 

  - [Code Girls](http://codegirls.de/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/commons/b/ba/Flag_of_Germany.svg" alt="Germany" width="30"> - *Lang：仅限德语*

    一群热心的女士专注于网络技术，她们想要学习编码，需要编码方面的支持，或者只是想了解网络是如何制作的. 他们每两周定期开会. 欢迎所有人.

  - [Codess](https://www.codess.net/)
    
     Codes是微软发起的一个女性程序员国际社区.  Codes 的成立旨在探索促进工程领域性别多样性的方法. 他们为科技行业的女性提供社交活动和指导机会. 

  - [Lambda Ladies](http://www.lambdaladies.com/)

     Lambda Ladies 是一个在线社区，面向所有认同为女孩或女性并对函数式编程感兴趣的人. 欢迎初学者.

  - [Oracle Women in Technology](https://community.oracle.com/groups/otn-women-in-technology/overview)

     Oracle WIT 社区组 - 一个分享经验和指导高科技女性的地方. 她们分享知识和技术资源，并与整个 Oracle 技术社区的其他女性进行交流.

  - [San Francisco Women in Tech](https://www.meetup.com/SanFranciscoWomenandDiversityInTech/)
    
    San Francisco Women in Tech 是一个 Meetup 团体，拥有 3200 多名旧金山和硅谷女性成员，可以在重视行业多样性的背景下交流和了解新技术和机会. 

  - [Women Hack For Non-Profits (WHFNP)](http://www.womenhackfornonprofits.com/)

     Women Hack for Non-Profits (WHFNP) 是一个志愿者社区，旨在提高女性的技术技能、支持她们的发展并提供探索开源的机会. 该小组将有技能的女性与正在为非营利组织、慈善机构和个人开发的开源项目相匹配，以产生积极的社会影响.

### Conferences/Talks

  以演讲、研讨会、网络和其他活动为特色的会议.

  - [ACT-W](https://act-w.org/)

    由 ChickTech 主办，ACT-W：推进技术 Womxn 的职业发展是一个充满动感的会议，有才华的 womxn 和盟友可以在这里培养技能，发展他们的社区，并加速他们的职业道路. 会议的所有收益都用于 ChickTech 的计划，该计划为当地高中青年提供 STEM 教育，并传播 ChickTech 的影响力，为所有人创造包容的文化. 

  - [AlterConf](https://alterconf.com/)

     AlterConf 是一个巡回会议系列，为边缘化人群和那些在科技和游戏行业支持他们的人提供安全的机会.

  - [Ela Conf](http://elaconf.com) *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" width="30" />

    A safe, inclusive tech leadership conference and community for adult (18+) women (cis and trans), trans men, and genderqueer people to connect with and empower one another.

  - [European Women In Technology](http://www.europeanwomenintech.com)

    旨在激励和联系在科技行业工作的女性的会议. 它提供由行业先驱提供的交互式面板和深入研讨会. 男性和女性都可以参加讨论与女性在技术领导、女性创始人、弥合性别差距、技术领域的非技术女性以及激励未来几代女孩进入该行业有关的问题.

  - [Female Founders Conference](http://www.femalefoundersconference.org/)

    由加速器 Y Combinator 组织的年度会议，面向女性创始人和企业家. 该活动以演讲和小组讨论为特色，包括女性创始人分享经验和提供创业指导的会议.

  - [Girls in Tech Catalyst Conference](http://catalystsf.girlsintech.org/)

     Girls in Tech Catalyst 的亮点是来自女性领导者的鼓舞人心的主题演讲. 会议还为与会者提供了真实的交流机会，这是一个交流思想并与其他鼓舞人心的女性建立联系的平台. 我们将举办有意义的研讨会和晚间娱乐活动，包括开球鸡尾酒会.

  - [Global Tech Women's Annual Voices Conference](http://www.globaltechwomen.com/voices-global-conference.html/)

    这个一年一度的免费活动是全球唯一一次为女性技术人员举办的会议，它为所有人提供了参加和实际参与或虚拟参与的完全机会，消除了所有参与障碍. 代表们单独和集体出席，讨论、合作和庆祝技术女性的贡献.

  - [Grace Hopper Celebration of Women in Computing](https://ghc.anitab.org/)

     Grace Hopper 计算机界女性庆典是世界上最大的女性技术人员聚会. 它由 Anita Borg Institute 制作，并与 ACM 合作呈现.

  - [Johnson Women in Technology Conference](http://www.johnsonwomenintech.com)

    约翰逊科技女性会议 (JWiT) 由康奈尔大学约翰逊管理研究生院的学生组织. 该活动旨在吸引学生和专业人士，包括引人入胜的小组讨论、有价值的社交活动、收入前推介比赛等.

  - [Lesbians Who Tech](http://lesbianswhotech.org//)

    Lesbians Who Tech 是一个由科技界或科技界酷儿女性（以及热爱她们的人）组成的社区.

  - [She's Geeky](http://shesgeeky.org/)

    *unConference* 各种女性极客分享、联系、网络、学习、启发和享受很多乐趣.

  - [SheSharp](http://www.shesharp.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/commons/5/5c/Flag_of_Greece.svg" alt="Greece" width="30">

    一个致力于促进女性参与技术和科学的希腊社区. 它的主要活动包括免费研讨会、对任何感兴趣的人开放的聚会，以及与其他技术社区和塞萨洛尼基当地分会的合作伙伴关系.

  - [SWE](http://societyofwomenengineers.swe.org/)

    女工程师协会 (SWE) 是一个非营利性教育和服务组织，旨在帮助女性在工程领域取得成功和进步，并因其作为工程师和领导者做出的改变生活的贡献而受到认可. 它促进了女性工程师的年度会议.

  - [Tech Up for Women](https://corporatelearninghub.com/techupforwomen/)

     Tech Up for Women 是一项为期一天的活动，旨在通过教育、资源和网络提高女性在技术方面的地位. 该活动将重点关注新技术进步、网络安全以及初创企业和私营公司的不同融资渠道. 该活动将为女性提供资源和机会，以提高她们的数字素养，并成功竞争和打破工作环境中的性别失衡.
    该活动的目的是消除技术中的恐惧因素并赋予女性权力.

  - [Watermark Conference for Women](http://www.watermarkconferenceforwomen.org) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    妇女大会的使命是促进、交流和扩大妇女在工作场所内外的影响力. 在一年一度的无党派、非营利性会议上，它汇集了数千名活跃的专业人士，在社区中联系、更新和寻找灵感.

  - [We RISE](https://werise.tech/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

     We RISE 致力于培养和展示科技领域的女性. 在两天的时间里，We RISE 以来自世界各地的女性和盟友做着令人惊叹的工作为特色.

  - [WECode](http://www.wecodeharvard.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

     WECode 是“每年 2 月在哈佛大学举行的最大的学生主办的计算机科学女性会议.我们的使命是扩大全球技术女性的技能、网络和社区.我们在这两天的精彩活动中将女性聚集在一起，以分享关于技术和创新的想法和对话.”  2月27日、2月28日直播在https://live.cs50.net/wecode.

  - [WITI](http://www.witi.com/)

     WITI 是帮助精通技术的女性实现职业目标的首要全球组织.  WITI 为女性组织活动和峰会.

  - [Women in Tech Summit Series](http://womenintechsummit.net/)

     Women in Tech Summit 是一系列活动，旨在激励、教育和联系技术行业的女性，从学生到高级管理人员的各个层面. 活动在丹佛、费城、罗利-达勒姆和华盛顿特区举行

  - [Women of the Channel Leadership Summit WEST](http://www.thechannelco.com/events/wotcw17/about) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    来自整个渠道（管理、销售、营销、技术和运营）的女性领导者齐聚一堂，相互学习并建立新的关系.

  - [Women Who Tech](http://womenwhotech.com/)

    Organizers of the yearly Women Who Tech TeleSummit, with talks by women in technology, startups, and social media. Creators of the #Women2Follow hashtag on Twitter.

  - [Write/Speak/Code](http://www.writespeakcode.com/)

     Write/Speak/Code 的使命是让女性软件开发人员成为思想领袖、会议发言人和开源贡献者. 他们在美国各地举办会议和活动.

### Hackerspace/Makerspace

  具有黑客/创客文化的协作空间，用于设施制作、学习、探索和分享知识.


  - [Maria Lab](https://www.programaria.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    它是一个黑客空间/创客空间，专注于在安全环境中通过赋予女性权力来教授和传播技术.  Maria Lab 提倡女性的多样性和团结.

  - [Mothership HackerMoms](https://mothership.hackermoms.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    这是第一个全女性黑客空间，这个空间位于伯克利，目标是探索黑客/制造者文化，并在动手工作坊中学习创业、设计、DIY 工艺品. 这些工作坊可以面向各种性别的妈妈或孩子们.
  
### Linux/OpenSource

  开源组织支持的项目.

  - [Debian Women](https://www.debian.org/women/)

    Debian Women 项目成立于 2004 年 5 月.我们通过积极吸引感兴趣的女性并鼓励她们更多地参与 Debian 来寻求平衡和多样化 Debian 项目.

  - [Fedora Women](https://fedoraproject.org/wiki/Women)

    Fedora Women 是一个旨在联系和帮助有兴趣使用 Fedora 并为 Fedora 做出贡献的女性的项目.

  - [KDE Women](https://community.kde.org/KDE_Women)

     KDE Women 是 KDE 社区中的一群女性. 我们在这里帮助增加开源中的女性人数并相互支持.

  - [Linux Chix](https://en.wikipedia.org/wiki/LinuxChix)

    这是一个面向女性的 Linux 社区. 它旨在为女性 Linux 用户提供技术和社会支持，同时鼓励男性提供帮助和贡献.

  - [Ubuntu Women](http://wiki.ubuntu-women.org/)

     Ubuntu 女性项目成立于 2006 年，旨在通过指导和启发来培养女性贡献者和社区参与.  Ubuntu 女性团队有许多项目，我们试图通过这些项目提高女性在 Ubuntu 所有领域的知名度，我们邀请您提供帮助.

### Mentorship

  有指导机会的项目.

  - [Chick Tech](http://chicktech.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg" alt="United States" width="30">

    我们促进以技术为中心的实践活动，以赋权、支持和增强妇女和女孩的信心. 通过我们的活动，我们建立社区，使参与者能够将自己视为领导者，并在快速发展的高科技行业中提供交流和指导机会.

  - [OS4W](https://os4w.org/)

     OS4W 是一种资源，可将所有女性（包括有色人种女性和变性女性）与欢迎、包容和欣赏其贡献者多样性的开源项目联系起来. 该站点有一个用于寻找导师和配对伙伴的目录，以及一个包含行为准则的开源项目精选列表.

  - [She++](http://www.sheplusplus.org/)

    这是一家社会企业，旨在帮助女性在科技行业留下自己的印记. 我们相信，当女性在技术开发中有平等的代表时，我们会为最需要的人加速创新.

## Other Initiatives

### Awards

  - [RedHat - Women in Open Source](https://www.redhat.com/en/about/women-in-open-source)

    荣誉. 庆祝. 启发. 我们相信开源是技术的未来——是时候承认女性所做的贡献了.

  - [The Ada Awards](http://adaawards.com/)

     Ada 奖是数字领导力研究所的一项倡议，该研究所是总部位于布鲁塞尔的国际非政府组织，其使命是弥合全球的性别差距和数字鸿沟. 该奖项旨在表彰科技领域的杰出女性，以及在欧洲、非洲及其他地区支持她们的组织.


  - [Code it Like a Girl](http://www.codeitlikeagirl.com/?lang=en) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/commons/5/5c/Flag_of_Greece.svg" alt="Greece" width="30">

     Code it Like a Girl 是一个数字媒体集体，它创作的内容旨在激励那些自我认同为女性的人追寻自己的梦想. 从技术新闻和操作指南到世界各地人们的非凡故事、关于女权主义的文章或任何我们喜欢谈论-写作-拍摄的内容，我们将分享我们的 POV 任何可以被证明有力量、有价值的东西，给我们的听众提供信息或娱乐.

  - [Global Fund for Women](http://ignite.globalfundforwomen.org/about)

     IGNITE 以女性和女孩的故事为特色，她们在科学、技术、工程和数学领域处于领先地位并进行创新. 该项目还强调了技术方面的性别差距，并倡导妇女和女孩增加对技术的获取和控制.

  - [InspirAda na Computação](https://inspiradanacomputacao.com/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

    协作博客，为计算机、科学和技术领域的女性发声. 该博客旨在分享内容，以激发女性对科技领域的兴趣. 它促进了对技术知识的获取，并因此带来了机会均等.

  - [Made with Code](https://www.madewithcode.com/)

     Made with Code 是谷歌于 2014 年 7 月 19 日发起的一项计划.谷歌的目标是为初中和高中的年轻女性提供计算机编程技能. 该网站围绕为年轻女孩提供学习编码的在线活动而展开.

  - [OxenTIMenina](http://oxentimenina.com.br)

    他们的目标是让女孩和妇女有机会获得经验和制造技术，无论她们来自哪个社会阶层、她们的知识或任何被认为是限制的东西.

  - [PrograMaria](http://www.programaria.org/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

     PrograMaria 是一项让更多女孩和女性参与技术和编程领域的倡议. 内容制作和活动是在三大支柱下制作的：启发、讨论和学习.

  - [WomenTechmakers](https://www.womentechmakers.com/)

     Google 的全球计划，为技术领域的女性提供知名度、社区和资源. 为开始职业生涯的女性和在技术领域拥有成熟职业的女性提供资源，以进一步取得成功.

  - [Womoz](http://www.womoz.org/blog/)

     Womoz 博客. 来自女性和 Mozilla 项目的程序更新和新闻.

### Documentaries/Movies

  - [Code Girls](http://www.codegirlmovie.com/)

    纪录片讲述了为 Technovation Challenge 编写和开发应用程序创意的女孩解决社区中的问题并尝试通过使用技术解决问题.

  - [She started it](http://www.shestarteditfilm.com/)

    认识五位决心追求创业梦想的年轻女性. 她开始了这是一部由 Nora Poggi 和 Insiyah Saeed 拍摄的纪录片，讲述了 Stacey Ferreira、Thuy Truong、Brienne Ghafourifar、Sheena Allen 和 Agathe Molinar 在 2 年多的时间里，讲述了这些企业家在建立新企业时所面临的起伏.

  - [She++ The Documentary](http://sheplusplus.org/film/)

    这部纪录片（12 分钟：TV-14 DL；2013 年 4 月 1 日发行）通过讲述聪明、有创造力和开拓性的好女孩变成极客的故事来介绍技术世界.

### Jobs

  - [Lane by Women 2.0](https://lane.women2.com/)

     Lane 是由 Women 2.0 创建的招聘和求职平台. 重点是科技领域的女性，并鼓励那些关心通过包容让公司更成功的工作场所.

  - [Outreach Program for Women](https://www.gnome.org/opw/)

     Outreach Program for Women 一直在帮助女性（顺式和跨式）、跨性别男性和性别酷儿参与免费和开源软件. 它提供了一个支持社区，可以在全年的任何时间开始做出贡献，并提供每年两次与许多自由软件组织的重点实习机会.

  - [PowerToFly](https://www.powertofly.com/)

    将女性与实际导致工作与生活平衡的工作联系起来. 专门从事女性远程工作. 除了工作板，它还包含有关时间管理、自我效能等的信息.

  - [Rewriting the Code](http://rewritingthecode.org)

    Rewriting the Code Fellowship 是一项为期一年的计划，提供在各行各业的顶尖科技公司实习的机会，并获得在科技行业脱颖而出所需的基本个人技能和建立信心的技能.

  - [Women in Tech](http://www.womenintechnology.co.uk/)

    Women in Technology 是一个商业组织，致力于帮助具有适当资格和经验的女性寻找信息技术领域的职业机会.

### Speakers

  - [CallbackWomen](http://www.callbackwomen.com/)

     CallbackWomen 的使命是从根本上扩大专业程序员会议讲台上的性别多样性. 提案征集 (CFP) 通过 Twitter 共享：https://twitter.com/callbackwomen.

  - [Mulheres Palestrantes](http://insideoutproject.xyz/mulheres-palestrantes/) - *地方：* <img src="https://upload.wikimedia.org/wikipedia/en/0/05/Flag_of_Brazil.svg" alt="Brazil" width="30"> - *Lang: PT-BR only*

    鉴于在巴西这里的活动（尤其是技术）中发言的女性人数仍然很少，因此创建了一个电子表格来提高这些女性的知名度并鼓励其他人开始.
    Mulheres Palestrantes 是一个保留一份女性名单的项目，这些女性谈论与编程、设计、创业和技术相关的主题，这个项目的诞生是为了尝试以更直观的方式组织工作表的数据，方便访问，减少重复并促进研究.

## Organisation toolkits

  如果您正在尝试组织自己的活动，这些资源可能会有所帮助.

  - [AdaCamp Toolkit](https://adacamp.org/)

     Ada Camp 曾经是一个受欢迎的会议，致力于提高女性对开放技术和文化的参与度，但现在已经停办. 然而，他们以开源 AdaCamp 工具包的形式发布了所有指南和资源，供那些想要组织自己的女权主义会议的人使用.

## Other Lists

  - [awesome-diversity](https://github.com/folkswhocode/awesome-diversity)

    关于技术多样性的精彩文章、网站和资源的精选列表.

  - [tech-gender-gap](https://github.com/apdaros/tech-gender-gap)

    有关科技界女性以及该行业性别差距的倡议和信息清单.

----

## License   [![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

这项工作已获得许可 [CC0 1.0 Universal (CC0 1.0).](https://creativecommons.org/publicdomain/zero/1.0/)
