<div class="github-widget" data-repo="zolagonano/awesome-zeronet"></div>
<p align="center">
  <br>
  <a href="https://zeronet.io"><img width="100" src="https://raw.githubusercontent.com/zolagonano/awesome-zeronet/master/./assets/logo.png" alt="ZeroNet's logo"></a>
  <br>
</p>


## Awesome ZeroNet [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> An Awesome & curated list of [ZeroNet](https://en.wikipedia.org/wiki/ZeroNet) implementations, plugins, tools, and zites. 

ZeroNet is a decentralized web-like network of peer-to-peer users.



## Zites

> Zite is shortened version of ZeroNet Site.

### Search Engines

| Name | Description | Address | Domain Name |
|:---- | :--- | :---: | :--- |
| Kaffiene Search | Caffeinated Search & Index | `1Mr5rX9TauvaGReB4RjCaE6D37FJQaY5Ba` | `zerosearch.bit` |
| Zoogle Zearch | Google Search for ZeroNet | `13EYKqmPpwzBU4iaQq9Y4vfVMgj8dHeLkc` | N/A |
| Dream Search | Dream Search - The most data scanning search engine in ZeroNet | `1JBFNPrAGp1nQX6RsAN6oRqCfvtoeWoion` | N/A |
| Search And Index Zites |  A Simple search engine and index | `1xiwbXaTbo9XU32hEpW4NyjZHrugSFdo6` | N/A |
| 0find0go | Every public website on ZeroNet in one search engine | `1Jj3kjHmjPYWGfCdyd8Pr6pm5sJawrLmrp` | N/A |
| Important Zites | Index of user-added zites | `15Pf9VVuDT8NSWj1qUBh4V89yPmrmzRw6a` | N/A |

### Zite Indexes

| Name | Description | Address | Domain Name |
|:---- | :--- | :---: | :--- |
| ZeroSitesX | Sites of ZeroNetX | `1SitesVCdgNfHojzf2aGKQrD4dteAZR1k` | `Sites.ZeroNetX.bit` |
| ZeroSites | Sites of ZeroNet | `1SiTEs2D3rCBxeMoLHXei2UYqFcxctdwB` | `Sites.ZeroNetwork.bit` |
| ZeroWiki | ZeroWiki site list | `138R53t3ZW7KDfSfxVpWUsMXgwUnsDNXLP/?Page:list-of-zites` | N/A |
| Search And Index Zites | Site directory by Krixano | `1xiwbXaTbo9XU32hEpW4NyjZHrugSFdo6` | N/A |
| ZeroShortener | Make your zerolinks way shorter and easier to remember | `1GNTAKCimBv5xEnt7QvkDn8sTkEPj7ZYTL` | `0sh.bit` |
| ZeroCentral | A Zite index with ability to sort by votes | `1Dt7FR5aNLkqAjmosWh8cMWzJu633GYN6u` | N/A |


### Chat Rooms

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| ThunderWave | A beautiful chat for ZeroNet | `1CWkZv7fQAKxTVjZVrLZ8VHcrN6YGGcdky` | N/A |

### Forums
 
| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| The All-Night Bookstore and Cafe | A Friendly Local Forum | `13gLfTixjjktySEGHBMnmrQu4qMJpoRuXw` | N/A |
| UnlimitTalk | For those who are cramped in ZeroTalk limits | `1HMLvnRWViMnuvZc5LK4Dm86sZNcSH1jdh` | N/A |
| ThreadIt | Decentralized Forum from ZeroNetX Team | `15UYrA7aXr2Nto1Gg4yWXpY3EAJwafMTNk` | `ThreadIt.bit` |
| NetTalk | Discussion about interne…s and other electronics | `1LfvE91ZF18jdG3wW62Dw7NtfTZh737KPL` | N/A |
| ZeroTalk++ | Decentralized forum engine | `1EgyL4nj9DmeSSQg3fytxGJjihxtmMon5y` | N/A |
| Linux.net | Discussion about Linux | `16Go5kc2U9Ff4jeaY8kYiDEgpMYdgyboPY` | N/A |
| ZeroTalk Tech | Talk about Anything having to do with Technology | `1EfLnw7GDXbZfJmGNoXGQ4XkuHGWkRZTMq` | N/A |
| 1stZC: ZeroNet Development | 1stZC's ZeroNet Development forum | `1fznczNZUMEMvCiqSmCZGUiv5sVnRcsTD` | N/A |
| 1stZC: Talks: General | 1stZC's general forum | `1fznctFebYHnmjmFZCmAWPd7nnamAy3Tg` | N/A |
| 1stZC: ZeroNet Support | 1stZC's support forum | `1fznc4VQbbrQAf4UzHrWS6W2mpGFqXSeD` | N/A |
| 1stZC: Talks: Politics | 1stZC's politics forum | `1fzncJdLpbsT5eeeYP14EKSaStHhtn5LY` | N/A |
| Programming.net | A forum about programming | `17YUF4geTD7gBDPeMtQtnV7uhhNcjrYi9u` | N/A |
| ZeroNet DevZone | ZeroNet core & plugins: issues, pull requests, ideas, RFCs and documentation | `18ryVioVmwFYzhRZKTjKqGYCjkUjoxH3k6` | N/A |
| ZeroDev Talk | Place for developers to collaborate | `142jqssVAj2iRxMACJg2dzipB5oicZYz5w` | N/A |
| ZeroTorrent | Torrent sharing forum | `192dZ1EG5tU7PnCfuwGMDEBrr2eLqvs4t3` | `ZeroTorrent.bit` |
| New GFW Talk | Forum dedicated to Great Firewall of China | `19BPUZYAdCMxExKHoVSG3cG95wfUfFTEC9` | `NewGFWTalk.bit` |
| IranTalk | Forum dedicated to Persian speaking users of ZeroNet | `1AS355T7MGApApoBeE9JgxvvvDxf33Eyh1` | N/A |
| Pirate Party Forum | Forum dedicated to Pirate Party | `1CLQ81TNixktJ67YFkZtbtsESy3MwZqLEG` | N/A |

### Mail Providers

**Note:** Email services that are built based on ZeroMail are End-to-End encrypted and nobody should be able to see the actual message you're sending, but the username of senders and receptors are publicly available.

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| ZeroMailX | End-to-end encrypted messaging | `1MaiLX6j5MSddyu8oh5CxxGrhMcSmRo6N8` | `Mail.ZeroNetX.bit` |

### Social Media Zites

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| XeroMe | ZeroMe with an easy-on-eyes theme | `1JgcgZQ5a2Gxc4Cfy32szBJC68mMGusBjC` | N/A |
| 0Hub | List Of ZeroMe Hubs | `1GLndW2MJn7japuF3X2tbfBqgPMR52zaLQ` | `0hub.bit` |
| AsocioHub | A ZeroMe Hub | `1MxqEM11KaAuKE2X9anKV2hz5NYmM1jaSP` | N/A |
| PersianHub | A ZeroMe Hub dedicated to persian speaking users | `13YccBekYK3S5LE1sva2wE2cUo6tk3BaWV` | N/A |
| Modkraft ZeroMe | A ZeroMe Hub for danish speaking perople | `1FS2XUptdQFnFaZiJtGKE1RB1PQuqLEK1r` | N/A |
| GigaByteHub | A ZeroMe Hub with 100GB limit | `185bkA3iwv1uuprQMbBCN37ArRDFPbnpBg` | N/A |

### Movies

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| NGnoidTV | Video site, also named KopyKate | `18Pfr2oswXvD352BbJvo59gZ3GbdbipSzh` | `big.kopykate.bit` |
| Play | Movie torrents | `1PLAYgDQboKojowD3kwdb3CtWmWaokXvfp` | `0play.bit` |
| TV Episodes | Magnet links for TV episodes | `1MagneTSMMkNmJTMsTGJtfuNsqGjzzXgQv` | `tvmagnets.bit` |
| eh anime? | Anime torrents | `1E8Z8sk3cGeWdQumBaYEh6LraqC2BRnutV` | N/A |
| StreamZ | Real-time streaming platform for Zeronet | `1BTZh5pymEKzMYr3qgDtgr4dMmap77QvEs` | N/A |
| Box HD | TV series boxsets in HD | `1BoxHDypbjd2yakQtjPwwbJMWR1KbHt1j9` | N/A |
| Play Anime | Anime torrents | `1AnimePihDhcbVdK1nvnbSEtH4oKU8RAYG` | N/A |

### Books
| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| ZeroPub | Book torrents | `1DYwX4W1qfSaiihfN5gW6ahLp5332TawH5` | `zeropub.bit` |

### ID Providers

| Name | Description | Address | Domain Name | UniqueIDs | Centralized |
| :--- | :--- | :---: | :---: | :---: | :--- |
| ZeroId | Sample trusted authorization provider | `1iD5ZQJMNXu43w1qLB8sfdHVKppVMduGz` | `zeroid.bit` | :heavy_check_mark: | :heavy_check_mark: |
| KaffieId | Decentralized ID provider | `1K3tM7irQqSX4Hx3JvNgkimkQzY6jPtBfz` | `kaffie.bit` | :heavy_multiplication_x: | :heavy_multiplication_x: |
| GateWay | Manually approved ID by Caryoscelus | `144vF644nw3X9dUb4uqsethDjjskhkpavH` | N/A | :heavy_check_mark: | :heavy_check_mark: |

### Productivity Tools

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| NullPaste | Decentralized paste-bin | `1MgHVPCE1ve6QfKrgsqCURzRj72HrRWioz` | N/A |

### Block lists

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| Privact blocklist | Blocks websites with external files | `18zoKfKYPnVBuHtKpK1mhAuVsWXV72obA1` | N/A |
| Kaffie's Spamlist | Mute/ban list for spammers |`1CufK1ZtvekbFXEpSyKT2gDjf9jnqW8KwG` | N/A |
| Pornography blocklist | ZeroNet pornography blocklist | `13CgSQeywg2ius5pjXVCk7dKUCRkz5xvW3` | N/A |
| NoMiner blocklist | This is a blocklist that blocks all known sites that cointains a miner. | `1NominErMMEodukCTKD5NN6HqgmtsG4Z8U` | N/A |
| 0net-preview blocklist | | 0net-preview's blocklist | `16soWyYc1kTobaevbN25FJjWL2qf9PWvFG` | N/A |

### Entertaining Zites

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| xkcd mirror | A mirror of randall munroe's xkcd.com | `1XKCDh5XeLm5eN4jM8b1Mk4wKrnUJxV12` | N/A |

### Games

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| Zero Bird | Flappy Bird inside ZeroNet | `1LMG9b3mhvnfAiMpRccSNzvTbq6bYCQWLf` | N/A |
| Snake Game | Simple snake game inside ZeroNet | `1JsJ1JitaLboc8pvo4fxh9dvP8mt6toPrE` | N/A |
| Pac Man | PacMan inside ZeroNet | `14Q1So3DH9qvHts5VuLDgqGp7yCXceujop` | N/A |
| ZeroSudoku |  Simple Sudoku game inside ZeroNet | `16Gn4QBd8iXFnDcVEcsmYw8soBKCeBezzS` | N/A |
| Taxi Drift | 2D taxi driving game | `1EzPDDHciaG9AH4ErxsmAKsF4hsrJPktiM` | N/A |
| Game of Life | Conway's Game of Life inside ZeroNet | `19TrFbEUS1mdznSX24FqnxZgftzNpxCXv8` | N/A |
| TypinMaster | Simple game to test your typing speed | `1KNvxg3ww7ZLxZRPT8MX4tRcFxwGhWRRK3` | N/A |
| Games Nintendo | JSNES Nintendo Entertainment System Emulator | `19za8TViGJF4xdvkQHLXK2UCb2gLC1nSVT` | N/A |

### Developer Tools

| Name | Description | Address | Domain Name |
| :--- | :--- | :---: | :--- |
| Git Center | Git Center is a decentralized hosting platform for Git repositories | `1GitLiXB6t5r8vuU2zC6a8GYj9ME6HMQ4t` | N/A |

### Tracker Lists

| Name | Address | Domain Name |
| :--- | :---: | :---: |
| Syncronite | `15CEFKBRHFfAP9rmL6hhLmHoXrrgmw4B5o` | N/A |
| Onion V3 trackers | `13hNAdge5ntxJmcnKzAxeLCuyowJkdvFxF` | N/A |
| Trackers Site | `1EsjAWNxu7iWVNdtAp7zZyTZmuM52jgiLQ` | N/A |
| Yggdrasil trackers | `1Bd2mgwbxQAHdHnWyDD7URBLDuwxxybw8t` | N/A |

### File Sharing Zites

| Name | Description | Address | Domain Name |
| :--- | :---: | :---: | :--- |
| StoreAge | Upload and share files using BitTorrent | `1UPLoADsqDWzMEyqLNin8GPcWoqiihu1g` | `StorAge.ZeroNetX.bit` |

## Implementations

### Python

**Note:** The original version of ZeroNet is not maintained anymore, and using it is not recommended, so please consider using other forks of the project.

| Repo URL | Description | Fork |
| :--- | :--- | :--- |
| https://github.com/ZeroNetX/ZeroNet | A fork of ZeroNet with HiddenService v3 support | :heavy_check_mark: |
| https://github.com/zeronet-conservancy/zeronet-conservancy | A fork of ZeroNet that is dedicated to sustaining existing p2p network and developing its values of decentralization and freedom, while gradually switching to a better designed network |:heavy_check_mark: |

### Rust

| Repo URL | Description |
| :--- | :--- |
| https://github.com/canewsin/zerunet | Rust Implementation of ZeroNet. Note: **This project is not completed yet** |
| https://github.com/canewsin/zeronet-rs | Rust Implementation of ZeroNet Core. Note: **This project is not completed yet** |

### Android Clients

| Repo URL | Description |
| :--- | :--- |
| https://github.com/ZeroNetX/zeronet_mobile | ZeroNet Mobile is an Native Client for Mobile Devices running Android |

## Plugins

| Name | Description | URL |
| :--- | :--- | :--- |
| Name.Yo Plugin | Centralized Domain Names for ZeroNet | https://github.com/ZeroNetX/Plugin-NameYo |
| Name.Trust Plugin | Centralized Domain Names for ZeroNet | http://127.0.0.1:43110/1PtFxzJ8NECkYQzziGWoEfzScD6NiEgqDY ([mirror](https://proxy.zeronet.dev/1PtFxzJ8NECkYQzziGWoEfzScD6NiEgqDY), [Official GitHub Mirror](https://github.com/rdp-studio/0net-NameTRUST-Resolver)) |

## Guides And Documentations

| Description | URL |
| :--- | :--- |
| A Very Technical Look at ZeroNet | https://zolagonano.github.io/blog/posts/a-very-technical-look-at-zeronet |
| A Guide to Security, Privacy, and Anonymity on ZeroNet | https://zolagonano.github.io/blog/posts/a-guide-to-security-privacy-and-anonymity-on-zeronet |
| Creating an Encrypted Portable Container for ZeroNet | https://zolagonano.github.io/blog/posts/creating-an-encrypted-portable-container-for-zeronet |

### Installation

| Description | URL |
| :--- | :--- |
| Original ZeroNet installation guide **Note: Original ZeroNet is not maintained anymore** | https://github.com/HelloZeroNet/ZeroNet#how-to-join |
| ZeroNetX installation guide | https://github.com/ZeroNetX/ZeroNet#how-to-join |
| Zeronet-Conservancy installation guide | https://github.com/zeronet-conservancy/zeronet-conservancy#how-to-join |

### Site Development

| Description | URL |
| :--- | :--- |
| Original ZeroNet's guide on site development | https://zeronet.io/docs/site_development/getting_started/ |
| The Truth about ZeroNet by [imachug](https://github.com/imachug) | https://github.com/imachug/The-Truth-about-ZeroNet |
| How to build a decentralized chatroom in ZeroNet | http://127.0.0.1:43110/Blog.ZeroNetwork.bit/?Post:99:ZeroChat+tutorial ([mirror](https://proxy.zeronet.dev/Blog.ZeroNetwork.bit/?Post:99:ZeroChat+tutorial)) |
| Tutorials on site and plugin development | http://127.0.0.1:43110/DevCenter.bit/?/ ([mirror](https://https://0net-preview.com/DevCenter.bit/?/)) |
| Wiki on ZeroNet site development | http://127.0.0.1:43110/138R53t3ZW7KDfSfxVpWUsMXgwUnsDNXLP ([mirror](https://0net-preview.com/138R53t3ZW7KDfSfxVpWUsMXgwUnsDNXLP)) |

## Proxies(Instances)

| URL |  Allows to add new sites |
| :--- | :--- |
| https://0net-preview.com | :heavy_multiplication_x: |
| https://proxy.zeronet.dev | :heavy_multiplication_x: |
| https://portal.ngnoid.tv | :heavy_multiplication_x: |
| https://zeronet.ipfsscan.io | :heavy_check_mark: |

**WARNING: _Do not sign in into ZeroNet through public proxies as proxies have access to the private keys and there is chance for your identity to get stolen by the proxy._**

## Communities

- ZeroNet community on Reddit https://reddit.com/r/zeronet
- ZeroNet community on Matrix https://matrix.to/#/#zeronetx:matrix.org
- ZeroNet community on Session https://sessioncommunities.online/#zeronet+c975

## Footnotes

### Support/Donation

If you find this project helpful and would like to show your appreciation, consider making a donation. Your contributions helps me dedicate more time working on Free and open-source projects :heart:

[https://zolagonano.github.io/support](https://zolagonano.github.io/support)
