<div class="github-widget" data-repo="XamSome/awesome-xamarin"></div>
## Awesome-Xamarin [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)

A hand-picked bookmark collection of subjectively modern/interesting and ideally open-source libraries/tools for Xamarin Android/iOS/Windows/OSX




## General

- [AutoMapper ★5,724](https://github.com/AutoMapper/AutoMapper) - A convention-based object-object mapper in .NET.
- [Fluent Validation ★3,570](https://github.com/FluentValidation/FluentValidation) - Fluent interface and lambda expressions for building validation rules.
- [Humanizer ★3,426](https://github.com/Humanizr/Humanizer) - Manipulation and displaying of strings, enums, dates, times, timespans, numbers and quantities.
- [NodaTime ★970](https://github.com/nodatime/nodatime) - Alternative date and time API for .NET.
- [Polly ★4,666](https://github.com/App-vNext/Polly) - Exception handling policies such as Retry, Retry Forever, Wait and Retry or Circuit Breaker.


## Architecture

- [Behaviors Toolkit ★34](https://github.com/ThomasLebrun/XamarinBehaviorsToolkit) - A means of adding common and reusable interactivity to your Xamarin applications with minimal code.
- [Conditions ★48](https://github.com/ghuntley/conditions) - Library that helps developers write pre- and postcondition validations in a fluent manner.
- [Stateless ★2,294](https://github.com/dotnet-state-machine/stateless) - State Machines.


## Async

- [AsyncEx ★1,253](https://github.com/StephenCleary/AsyncEx) - A helper library for async/await.
- [LinqToAwait ★99](https://github.com/anaisbetts/LinqToAwait) - A Task-based LINQ designed to work with async/await.


## Charts

- [MicroCharts ★1052](https://github.com/microcharts-dotnet/Microcharts) - Create cross-platform (Xamarin, Windows, ...) simple charts.
- [MPAndroidChart/iOSCharts ★6](https://github.com/bulubuloa/Ultimate-Xamarin-Forms-KIT) - MPAndroidChart/iOSCharts binding support use in Xamarin Forms.
- [OxyPlot ★1,311](https://github.com/oxyplot/oxyplot) - Cross-platform plotting library for .NET.


## Cloud

- [Azure](https://docs.microsoft.com/en-us/xamarin/cross-platform/data-cloud/) - Microsoft Azure.
- [Bugfender ★10](https://github.com/bugfender/bugfender-xamarin) - Store your application logs on the cloud (iOS & Android).
- [FireSharp ★479](https://github.com/ziyasal/FireSharp) - Firebase REST API wrapper.


## Database

- [Akavache ★1,692](https://github.com/reactiveui/akavache) - An Asynchronous Key-Value Store for Native Applications.
- [Breeze ★63](https://github.com/Breeze/breeze.sharp) - Data management library for developers of rich client applications.
- [Couchbase.Lite ★299](https://github.com/couchbase/couchbase-lite-net) - Lightweight embedded NoSQL database.
- [Lager ★2](https://github.com/ghuntley/Lager) - Cross-platform settings storage that uses Akavache as a storage backend.
- [Massive ★1,708](https://github.com/FransBouma/Massive) - "wrapper" for your DB tables and uses System.Dynamic extensively.
- [Realm ★690](https://github.com/realm/realm-dotnet) - Mobile database that runs directly inside phones, tablets or wearables.
- [Settings ★58](https://github.com/aritchie/settings) - Cross platform settings plugin for Xamarin and Windows.
- [SQLite.Net-PCL ★340](https://github.com/oysteinkrog/SQLite.Net-PCL) - SQLite 3 databases support, PCL, async.
- [LiteDB ★4245](https://github.com/mbdavid/LiteDB) -  A .NET NoSQL Document Store in a single data file.
- [DB4O-GPL ★8](https://github.com/iboxdb/db4o-gpl) -  Object-Oriented Database, Embedded and Remote connections supported.

## Fody

- [Fody ★2,150](https://github.com/Fody/Fody) - Extensible tool for weaving .net assemblies.
	- [AutoDependencyProperty.Fody](https://bitbucket.org/robertvazan/autodependencyproperty.fody/src) - Automatically generates DependencyProperty boilerplate from simple C# properties.
	- [PropertyChanged.Fody ★820](https://github.com/Fody/PropertyChanged/) - Injects INotifyPropertyChanged code into properties at compile time.
	- [ReactiveUI.Fody ★105](https://github.com/kswoll/ReactiveUI.Fody) - Generate RaisePropertyChange notifications for properties and ObservableAsPropertyHelper properties.


## Framework

- [Ammy](http://www.ammyui.com/) - Modern UI language for XAML platforms. Free for non-commercial development.
- [Appercode.UIFramework ★13](https://github.com/Appercode/Appercode.UIFramework) - Allows to build user interface of cross-platform mobile applications with single XAML layout.
- [Invention](https://gitlab.com/hodgskin-callan/Invention) - Develop native apps for iOS, Android and Windows with 100% code sharing using Visual Studio and C#.NET.
- [SimplyMobile ★103](https://github.com/sami1971/SimplyMobile) - Collection of abstracted mobile functionalities.
- [Xamu-Infrastructure ★104](https://github.com/xamarinhq/xamu-infrastructure) - Extensions, MVVM classes, behaviors and other misc. useful code bits from Xamarin University.

## Game Engine

- [CocosSharp ★463](https://github.com/mono/CocosSharp) - CSharp implementation of the Cocos2D and Cocos3D APIs.
- [MonoGame ★5,276](https://github.com/MonoGame/MonoGame) - Open source implementation of the Microsoft XNA 4.x Framework.
- [Paradox ★1,706](https://github.com/SiliconStudio/xenko) - Paradox3D + Silicon Studio .NET.
- [UrhoSharp ★275](https://github.com/xamarin/urho) - Cross-platform high-level 3D and 2D engine.
- [CocosCreator ★2](https://github.com/toanlcgift/xamarin-cocos-creator) - Xamarin binding for CocosCreator Engine.


## IO/Storage

- [IO ★6](https://github.com/aritchie/io) - Access system folders and files using a familiar api.
- [PCL Storage ★270](https://github.com/dsplaisted/PCLStorage) - Consistent, portable set of local file IO APIs for .NET.
- [FilePicker-Plugin-for-Xamarin ★37](https://github.com/jfversluis/FilePicker-Plugin-for-Xamarin-and-Windows) - Simple cross-platform plug-in that allows you to pick files and work with them.


## IOC/DI

- [Autofac ★2,169](https://github.com/autofac/Autofac) - An addictive .NET IoC container.
- [DryIoc](https://github.com/dadhi/DryIoc) - Fast, small, full-featured IoC Container for .NET.
- [Funq ★2](https://github.com/thiagoromam/FunqPortable) - High performance DI framework by eliminating all runtime reflection through the use of lambdas and generic functions as factories.
- [LightInject ★320](https://github.com/seesharper/LightInject) - Light, simple and stunningly fast IoC container for .NET.
- [Ninject ★2,034](https://github.com/ninject/Ninject) - The ninja of .net dependency injectors.
- [Stiletto ★36](https://github.com/benjamin-bader/stiletto) - .NET port of Dagger, the lightweight Android dependency injector from Square.
- [TinyIoC ★585](https://github.com/grumpydev/TinyIoC) - Single-class easy IoC container.


## Internationalization

- [I18NPortable ★49](https://github.com/xleon/I18N-Portable) - Simple and cross platform internationalization/translations for Xamarin and .NET.
- [Resxible ★9](https://github.com/apcurium/resxible) - Tool to generate automatically several platform-dependent resource files from a single RESX file.
- [Vernacular ★167](https://github.com/rdio/vernacular) - Cross Platform Localisation, tools to convert standard strings formats.
- [SimpleLocalize ★19](https://github.com/simplelocalize/simplelocalize-cli) - Open source tool for managing i18n keys in Xmarin projects.


## Layout

- [Flex ★128](https://github.com/xamarin/flex) - Flexible box layout system.


## Media

- [EZ-Compress ★11](https://github.com/VictorGrunn/EZ-Compress-for-Xamarin) - A simple image stream compression plugin for Xamarin.
- [Fast & Furious Image Loading ★820](https://github.com/luberda-molinet/FFImageLoading) - Xamarin library to load images quickly & easily.
- [Lottie ★643](https://github.com/Baseflow/LottieXamarin) - Render After Effects animations natively on Android and iOS for Xamarin.
- [LibVLCSharp ★174](https://github.com/videolan/libvlcsharp) - Xamarin bindings for libvlc, the multimedia framework powering the VLC applications made by VideoLAN.
- [MediaManager ★269](https://github.com/Baseflow/XamarinMediaManager) - Cross platform Xamarin plugin to play Media from PCL.
- [NGraphics ★482](https://github.com/praeclarum/NGraphics) - Cross platform library for rendering vector graphics.
- [PDFReader ★51](https://github.com/AlexanderMac/mTouch-PDFReader) -  iOS (-only) library to display PDF documents on iPad and iPhone.
- [Screenshot Plugin ★21](https://github.com/wilsonvargas/ScreenshotPlugin) - A simple Screenshot plugin for Xamarin and Windows to get and save screenshot in yours apps.
- [SkiaSharp ★920](https://github.com/mono/SkiaSharp) - Powerful C# API for doing 2D graphics. It is powered by Google’s Skia library.
- [Splat ★590](https://github.com/reactiveui/splat) - Cross platform image loading, colors and stuff.
- [SimpleAudioPlayer ★14](https://github.com/adrianstevens/Xamarin-Plugins/tree/master/SimpleAudioPlayer) - Simple plugin for plays local files and audio data as a stream.
- [ZXing.Net.Mobile ★570](https://github.com/Redth/ZXing.Net.Mobile) - Barcode Scanning Library for MonoTouch, Mono for Android, and Windows Phone.
- [SupportMediaXF ★2](https://github.com/bulubuloa/SupportMediaXF) - Simple cross platform plugin to take photos or pick them from a gallery from shared code


## MVVM

- [Bind ★158](https://github.com/praeclarum/Bind) - Bind gives you easy two-way data binding between properties of objects.
- [EBind](https://github.com/SIDOVSKY/EBind) - Concise, fast and feature-rich .NET data binding with some Xamarin goodies.
- [FreshMvvm ★324](https://github.com/rid00z/FreshMvvm) - Super light Mvvm Framework designed specifically for Xamarin.Forms.
- [Infinite Scroll Plugin ★24](https://github.com/HBSequence/Sequence.Plugins) - A Plugin which facilitates forward-only incremental scrolling for a paged data source.
- [MVVMCross ★2,657](https://github.com/MvvmCross/MvvmCross) - Cross-platform mvvm mobile development framework.
  - [Cheesebaron.MvxPlugins ★79](https://github.com/Cheesebaron/Cheesebaron.MvxPlugins) - A collection of plugins.
  - [MvxAms ★1](https://github.com/MobiliTips/MvxPlugins/tree/master/MvxAms) - MVVMCross Azure Mobile Services plugin.
  - [MvxForms ★1](https://github.com/MobiliTips/MvxPlugins/tree/master/MvxForms) - MVVMCross plugin for using Xamarin.Forms.
- [MugenMvvmToolkit ★127](https://github.com/MugenMvvmToolkit/MugenMvvmToolkit) - Cross-platform MVVM toolkit.
- [MVVMLight](https://github.com/lbugnion/mvvmlight) - Cross-platform MVVM development framework.
- [MvvmNano ★46](https://github.com/aspnetde/MvvmNano) - Small and smart MVVM framework made with ❤ for Xamarin.Forms.
- [Prism ★2,365](https://github.com/prismlibrary/prism) - Cross-platform MVVM development framework.
- [ReactiveUI ★3,917](https://github.com/reactiveui/ReactiveUI) - Rx MVVM framework.
- [Wires ★28](https://github.com/dotnet-ad/Wires) - Wires is a simple binding library.


## Network

- [Apizr ★4](https://github.com/Respawnsive/Apizr) - Refit based web api client, but resilient (retry, connectivity, cache, auth, log, priority, etc...).
- [Connectivity ★200](https://github.com/jamesmontemagno/ConnectivityPlugin) - Cross-platform network/connection status.
- [CrossDownloadManager ★67](https://github.com/SimonSimCity/Xamarin-CrossDownloadManager) - A cross platform download manager for Xamarin.
- [Flurl ★1,295](https://github.com/tmenier/Flurl) - Flurl is a modern, fluent, asynchronous, testable, portable, buzzword-laden URL builder and HTTP client library.
- [Fusillade ★216](https://github.com/reactiveui/Fusillade) - Set of HttpMessageHandlers that make your mobile applications more efficient and responsive.
- [Messaging ★1](https://github.com/cjlotz/Xamarin.Plugins/tree/master/Messaging) - Make a phone call, send a sms or send an e-mail using the default messaging applications.
- [ModernHttpClient](https://github.com/alexrainman/ModernHttpClient) - Accelerates HTTP requests by using mobile-optimized libs (NSURLSession / OkHttp).
- [NFC ★14](https://github.com/smstuebe/xamarin-nfc) - Xamarin plugin for reading NFC tags.
- [Push Notification ★1](https://github.com/rdelrosario/xamarin-plugins/tree/master/PushNotification) - Simple cross platform plugin to handle push notification events such as registering, unregistering and messages arrival on Android and iOS.
- [Reachability ★25](https://github.com/has-taiar/Reachability.Net) - Online/offline connected check.
- [Refit ★2,762](https://github.com/reactiveui/refit) - The automatic type-safe REST library for Xamarin and .NET.
- [RestEase ★339](https://github.com/canton7/RestEase) - Refit on steroids, simpler auth, parsing...
- [RestLess ★57](https://github.com/letsar/RestLess) - The automatic type-safe-reflectionless REST API client library for .Net Standard.
- [RestSharp ★6,994](https://github.com/restsharp/RestSharp) - Simple REST and HTTP API Client for .NET.
- [Sockets ★185](https://github.com/rdavisau/sockets-for-pcl) - An abstraction over the socket helper classes of .NET and WinRT.
- [Tiny.RestClient ★31](https://github.com/jgiacomini/Tiny.RestClient) - Description Simpliest Fluent REST client for Xamarin and .NET.


## Reactive

- [Akavache ★1,692](https://github.com/reactiveui/Akavache) - An Asynchronous Key-Value Store for Native Applications.
- [ReactiveUI ★3,917](https://github.com/reactiveui/ReactiveUI) - Rx MVVM framework.
- [Refit ★2,762](https://github.com/reactiveui/refit) - Refit is a library heavily inspired by Square's Retrofit library, and it turns your REST API into a live interface.
- [ReactiveProperty ★361](https://github.com/runceel/ReactiveProperty) - Provides MVVM and asynchronous support features under Reactive Extensions.
- [RxFlow ★18](https://github.com/ugaya40/RxFlow) - Simple Flow Control Library with Rx(Reactive Extensions).
- [Sensors](https://github.com/aritchie/sensors) - ACR Reactive Sensors Plugin for Xamarin & Windows.
- [CrossPlatformLiveData](https://github.com/jakdor/CrossPlatformLiveData) - Android LiveData inspired .NET implementation - lifecycle aware rx streams.


## Security

- [Portable.BouncyCastle ★136](https://github.com/novotnyllc/bc-csharp) - Portable version of Bouncy Castle with support for .NET 4, .NET Standard 2.0, MonoAndroid, Xamarin.iOS, .NET Core.
- [BreachDetector ★11](https://github.com/nmilcoff/BreachDetector) - Detect root, emulation, debug mode and other security concerns in your Xamarin apps.
- [Cryoprison](https://github.com/padresmurfa/cryoprison) - Jailbreak/Root detection for Xamarin
- [Fingerprint Plugin ★165](https://github.com/smstuebe/xamarin-fingerprint) - Xamarin and MvvMCross plugin for accessing the fingerprint sensor.
- [PCLCrypto ★184](https://github.com/AArnott/PCLCrypto) - Cryptography for portable class libraries (MD5,...).
- [Permissions ★255](https://github.com/jamesmontemagno/PermissionsPlugin) - Simple cross platform plugin to check connection status of mobile device, gather connection type, bandwidths, and more.


## Serialization

- [Newtonsoft.Json ★5,812](https://github.com/JamesNK/Newtonsoft.Json) - Popular high-performance JSON framework for .NET.
- [Quicktype ★886](https://app.quicktype.io/?l=cs) - Instantly generate classes and JSON serialization code from JSON.


## TDD/BDD

- [FluentAssertions](https://fluentassertions.com) - TDD/BDD fluent asserts.
- [NBehave ★47](https://github.com/nbehave/NBehave) - Framework for Behaviour-Driven Development.
- [VSMac-CodeCoverage](https://github.com/ademanuele/VSMac-CodeCoverage) - Gather code coverage results for your unit test projects from Visual Studio for Mac.


## Tools

- [Cheeseknife ★53](https://github.com/MarcelBraghetto/Cheeseknife) - A view injection library for Xamarin.Android.
- [IconFont2Code ★52](https://github.com/andreinitescu/IconFont2Code) - Generates a C# class with the glyph Unicode values in your font file (.ttf/.otf).
- [GradleBindings ★103](https://github.com/EgorBo/Xamarin.GradleBindings) - Visual Studio extension, for referencing gradle libs in Android projects.
- [Material icons generator plugin - Xamarin Studio ★14](https://github.com/interisti/xs-material-icons-generator) - Adding material icons to android project.
- [Material icons generator plugin - Visual Studio](https://github.com/interisti/vs-material-icons-generator) - Adding material icons to android project.
- [Mutatio ★18](https://github.com/yuv4ik/Mutatio) - Visual Studio for Mac add-in/extension for converting old PCLs to .NET Standard 2.0 targeting projects automatically.
- [PushSharp ★3,990](https://github.com/Redth/PushSharp) - A server-side library for sending Push Notifications to iOS (iPhone/iPad APNS), Android (C2DM and GCM - Google Cloud Message), Windows Phone, Windows 8, Amazon, Blackberry, and (soon) FirefoxOS devices!
- [Twin Tools Add-In ★20](https://github.com/twintechs/TwinToolsForXamarin) - Productivity plugin for Xamarin Studio.
- [Xamaridea ★69](https://github.com/EgorBo/Xamaridea) - Visual Studio extension, opens *.axml files in Android Studio. 
- [Xavtool ★15](https://github.com/gabrielrobert/xavtool) - Command-line utility to automatically increase iOS / Android / UWP applications version.
- [Xamarin-APRTextFieldSuggestions](https://github.com/aproram/Xamarin-APRTextFieldSuggestions) - Xamarin.iOS Autocomplete suggestions for UITextfield in iOS.
- [VSMac-CodeDistribution](https://github.com/ademanuele/VSMac-CodeDistribution) - A Visual Studio for Mac extension that visualises code distribution between projects. Particularly useful for Xamarin projects to understand the amount of code shared between platforms.


## UI
- [Xamarin.Forms.Breadcrumb](https://github.com/IeuanWalker/Xamarin.Forms.Breadcrumb) - A control that automatically generated a breadcrumb control
- [Xamarin.Forms.StateButton](https://github.com/IeuanWalker/Xamarin.Forms.StateButton) - With this control you are able to create any style of button. This is possible as it acts as a wrapper to your XAML and provides you the events/ commands and properties to bind too.
- [Passcode ★13](https://github.com/kevinskrei/XamarinPasscode) - Xamarin component for locking an app with a passcode.
- [SignaturePad ★117](https://github.com/xamarin/SignaturePad) - Signature Pad makes capturing, saving, exporting, and displaying signatures extremely simple on Xamarin.iOS, Xamarin.Android and Windows.
- [XamEffects ★53](https://github.com/mrxten/XamEffects) - Touch effect for Xamarin.Forms.
- [Showcase View](https://github.com/DigitalSa1nt/Xama.JTPorts.ShowcaseView) - _Xamarin.Android_ Native showcase view. An easy-to-use customizable show case view with circular reveal animation.
- [Animated Circle Loading View](https://github.com/DigitalSa1nt/Xama.JTPorts.AnimatedCircleLoadingView) - A determiante/indetermiante loading view animation.
- [Animated Icon Button](https://github.com/HankiDesign/DOFavoriteButton.Xamarin) - An animated icon button for Xamarin.iOS.
- [SimpleBottomDrawer](https://github.com/galadril/Xam.Plugin.SimpleBottomDrawer) - Just a nice and simple BottomDrawer for your Xamarin Forms project
- [SimpleColorPicker](https://github.com/galadril/Xam.Plugin.SimpleColorPicker) - Just a nice and simple ColorPicker for your Xamarin Forms project
- [SimpleAppIntro](https://github.com/galadril/Xam.Plugin.SimpleAppIntro) - Just a nice and simple AppIntro for your Xamarin Forms project
- [SimpleStaticMap](https://github.com/galadril/Xam.Plugin.SimpleStaticMap) - Just a simple static map control based on the Static API of Google Maps for your Xamarin Forms project
- [TEdito2](https://github.com/bulubuloa/TEditor2) - TEditor2 is a HTML editor for Xamarin, it has so many build-in features and easy to use.
- [IridescentView](https://github.com/alexandrehtrb/IridescentView) - A custom Xamarin.Android ImageView with iridescence effect.


## Wearable

- [WormHoleSharp ★25](https://github.com/Clancey/WormHoleSharp) - Communication between Watch and iDevice.


## Xamarin.Forms

- [Acr-xamarin-forms ★244](https://github.com/aritchie/acr-xamarin-forms) - Camera/Gallery, Barcode Scanning, User Dialogs, Geo-Location, Network Utils, Device Info, Settings, E-Mail, Phone, SMS all for Xamarin.Forms.
- [AdvancedTimer ★35](https://github.com/ufuf/AdvancedTimer) - Timer object and its methods are implemented for extended support for timers.
- [Android AppCompat ★34](https://github.com/nativecode-dev/oss-xamarin) - Provide Material Design themes now for Xamarin.Forms apps natively without hacks.
- [BadgeView ★31](https://github.com/SuavePirate/BadgeView) - A simple Xamarin.Forms control to display a round badge.
- [Circle Image Control](https://github.com/jamesmontemagno/ImageCirclePlugin) - Simple but elegant way of display circle images in your Xamarin.Forms projects.
- [Compass ★19](https://github.com/JarleySoft/CompassPlugin) - Provides and simple way to access the compass on Windows Phone, iOS and Android from you Xamarin.Forms projects.
- [Device Orientation ★28](https://github.com/wcoder/Xamarin.Plugin.DeviceOrientation) - Simple cross-platform plugin to work with screen orientation of mobile device.
- [Device Orientation ★1](https://github.com/aliozgur/Xamarin.Plugins/tree/master/DeviceOrientation) - Simple way to get device orientation or be notified of orientation changes in your Xamarin.Forms projects.
- [NControl ★243](https://github.com/chrfalch/NControl) - Xamarin.Forms control for NGraphics.
- [Magic Gradients ★128](https://github.com/mgierlasinski/MagicGradients) - Provides a simply way to implement a great variety of gradients in Xamarin.Forms.
- [MvxForms ★8](https://github.com/MobiliTips/MvxPlugins) - MVVMCross plugin for using Xamarin.Forms.
- [PancakeView ★454](https://github.com/sthewissen/Xamarin.Forms.PancakeView) - An extended ContentView for Xamarin.Forms with rounded corners, borders, shadows, gradients and more.
- [PullToRefreshLayout ★134](https://github.com/jamesmontemagno/Xamarin.Forms-PullToRefreshLayout) - [DEPRECATED] Pull To Refresh a ScrollView or ListView in Xamarin.Forms.
- [Rb.Forms.Barcode ★34](https://github.com/rebuy-de/rb-forms-barcode) - Xamarin.Forms view for scanning barcodes.
- [Rg.Plugins.Popup](https://github.com/rotorgames/Rg.Plugins.Popup) - A cross platform plugin for Xamarin.Forms which allows to open Xamarin.Forms pages as a popup.
- [SharedTransitions ★223](https://github.com/GiampaoloGabba/Xamarin.Plugin.SharedTransitions) - Shared element transitions between pages in Xamarin.Forms (IOS/Android).
- [Sharpnado.Presentation.Forms ★28](https://github.com/roubachof/Sharpnado.Presentation.Forms) - HorizontalListView, TaskViewLoader, and Paginator.
- [SolTech Xamarin Forms Toolkit ★31](https://github.com/soltechinc/soltechxf) - Set of helpful extensions to the Xamarin Forms framework.
- [Store Rating Plugin ★7](https://github.com/voxdev/Xamarin.Plugins) - Rate app popup.
- [SVG ★1](https://github.com/paulpatarinski/Xamarin.Forms.Plugins/tree/master/SVG) - SVG file format support.
- [Swipecards ★80](https://github.com/robinmanuelthiel/swipecards) - A Tinder-like swipe control for Xamarin.Forms.
- [Toasts Plugin ★208](https://github.com/EgorBo/Toasts.Forms.Plugin) - A simple way of showing some notifications inside your Xamarin.Forms application.
- [TwinTechsFormsLib ★187](https://github.com/twintechs/TwinTechsFormsLib) - FastCell, FastImage, FastGridCell.
- [XamarinControls ★17](https://github.com/Intelliabb/XamarinControls) - Cross-platform controls for Xamarin and Xamarin.Forms (Checkbox using SkiaSharp).
- [Xamarin-Forms-Labs ★1,392](https://github.com/XLabs/Xamarin-Forms-Labs) - Powerful and cross platform set of controls and helpers.
- [xamarin-forms-xna ★7](https://github.com/jvlppm/xamarin-forms-xna) - Monogame wrapper for Xamarin.Forms.
- [Xamarin.Forms.GoogleMaps ★250](https://github.com/amay077/Xamarin.Forms.GoogleMaps) - Maps library for Xamarin.Forms using Google Mapps API.
- [XamFormsMvxTemplate ★19](https://github.com/JTOne123/XamFormsMvxTemplate) - MVVMCross.Forms Visual Studio 2017 project template (iOS, Android, UWP).
- [Xamarin.Essentials](https://docs.microsoft.com/en-us/xamarin/essentials/) - Xamarin.Essentials provides developers with cross-platform APIs for their mobile applications.
- [Xamarin.Forms.EntryAutoComplete](https://github.com/krzysztofstepnikowski/Xamarin.Forms.EntryAutoComplete) - Custom control which functionality provides you with suggestions while typing. There are several modes of suggestions. The suggested text can be displayed in a drop-down list so that you can choose from different options.
- [Xamarin.Forms.Skeleton](https://github.com/HorusSoftwareUY/Xamarin.Forms.Skeleton) - The latest trend for loading approaches in Xamarin Forms apps. Skeleton can be easily implemented on each view contained in your Xaml.
- [MaterialDesignControlsPlugin](https://github.com/HorusSoftwareUY/MaterialDesignControlsPlugin) - MaterialDesignControls Plugin for Xamarin Forms is a collection of Xamarin.Forms controls that apply the Material Design Guidelines.

## XPlat APIs

Most of them support Android and iOS, some do Windows Phone 8

- [Calendars ★49](https://github.com/TheAlmightyBob/Calendars) - Calendar API plugin for Xamarin and Windows Phone, Supports basic CRUD operations with calendars and events.
- [Device Motion ★1](https://github.com/rdelrosario/xamarin-plugins/tree/master/DeviceMotion) - Simple cross platform plugin to read motion vectors value for device motion sensors such as: Accelerometer, Gyroscope, Magnetometer, Compass.
- [Estimote ★37](https://github.com/aritchie/estimotes-xplat) - Cross platform implementation of the estimote library for beacons.
- [Fingerprint ★165](https://github.com/smstuebe/xamarin-fingerprint) - Xamarin and MvvMCross plugin for accessing the fingerprint sensor.
- [HybridKit ★21](https://github.com/chkn/HybridKit) - Simple C# – JavaScript bridge for building hybrid iOS and Android apps.
- [Lamp ★1](https://github.com/kphillpotts/Xamarin.Plugins/tree/master/Lamp) - Simple way of controlling the lamp/LED on the back of your phone from Xamarin and Xamarin.Forms projects.
- [ManageSleep ★15](https://github.com/molinch/Xam.Plugins.ManageSleep) - Manage auto sleep / auto lock in all platforms. This is useful when dealing with long running processes.
- [Messaging ★88](https://github.com/cjlotz/Xamarin.Plugins) - The Messaging plugin makes it possible to make a phone call, send a sms or send an e-mail using the default messaging applications on the different mobile platforms.
- [Notifications ★79](https://github.com/aritchie/notifications) - Notifications plugin for Xamarin and Windows.
- [Pontoon ★27](https://github.com/inthehand/Pontoon) - A flexible bridge to the Universal Windows Platform.
- [Shiny ★428](https://github.com/shinyorg/shiny) - A Xamarin Framework for Backgrounding & Device Hardware Services.
- [Telephony ★17](https://github.com/ghuntley/telephony) - Email, sms, voice and video call functionality.
- [userdialogs ★510](https://github.com/aritchie/userdialogs) - Standard user dialogs from a shared/portable library.
- [Version ★1](https://github.com/mtrinder/Xamarin.Plugins/tree/master/Version) - Get app version from bundle.
- [Xamarin.Badge ★33](https://github.com/B1naryStudio/Xamarin.Badge) - Simple cross platform plugin to work with application badge.
- [Xamarin.Essentials ★560](https://github.com/xamarin/Essentials) - Essential cross-platform APIs from Xamarin team for iOS and Android. Provide easy access to or usage of: Acelerometer, App Information, Battery, Clipboard, Compass, Connectivity, Data Transfer (Share), Device Display Information, Device Information, Email, File System Helpers, Flashlight, Geocoding, Geolocation, Gyroscope, Magnetometer, Open Browser, Orientation Sensor, Power, Phone Dialer, Preferences, Screen Lock, Secure Storage, SMS, Text-to-Speech, Version Tracking, Vibrate.
- [Xamarin.LocalNotifications ★40](https://github.com/B1naryStudio/Xamarin.LocalNotifications) - Simple cross platform plugin to work with mobile local notifications.
- [Xamarin.Mobile ★237](https://github.com/xamarin/Xamarin.Mobile) - Reading the user's address book and using the camera.
- [Xamarin-plugins ★39](https://github.com/domaven/xamarin-plugins) - Device Motion, Geofencing, Push Notifications (Beta).


## Other lists

- [Awesome Xamarin Bookmarks ★9](https://github.com/wcoder/awesome-xamarin-bookmarks) - Hand-picked bookmarks of interesting (must have) links for Xamarin developers.
- [Open Source Xamarin Apps ★11](https://github.com/wcoder/open-source-xamarin-apps) - A list of open source Xamarin apps.
- [Xamarin Bindings ★112](https://github.com/aloisdeniel/Xamarin.Bindings) - A list of existing library bindings.
- [Xamarin Components ★1,338](https://github.com/xamarin/XamarinComponents) - Here you will find a listing of cross platform Plugins for Xamarin that support Xamarin.iOS, Xamarin.Android, Xamarin.Forms, and Windows Platform from a single API.
- [Xamarin Universal Library ★3](https://github.com/xamarinuniverse/XamarinUniversalLibrary/) - This is a universal library that contains everything we need to know about the Xamarin universe.


## Websites

- [Planet Xamarin](https://www.planetxamarin.com) - An aggregator of content from Xamarin Community members. Why subscribe individually when you can subscribe to one convenient RSS feed? If RSS isn't your thing, follow the [Twitter](https://twitter.com/PlanetXamarin) or [Facebook](https://www.facebook.com/login/?next=https%3A%2F%2Fwww.facebook.com%2Fplanetxamarin%2F) accounts which are automatically updated with the latest content from the community.
- [Programming Community Curated Resources For Learning Xamarin](https://hackr.io/tutorials/learn-xamarin) - A curated list of resources for learning Xamarin.
- [Weekly Xamarin](https://weeklyxamarin.com/) - Hand-picked round up of the best Xamarin development links every week. Curated by Geoffrey Huntley and published every Friday. Free.
- [Xamarin Online Courses](https://classpert.com/search/xamarin) - A list of over 60 Online Courses (free and paid) from Classpert Online Course Search.


## License

see [https://github.com/XamSome/awesome-xamarin/blob/master/LICENSE](https://github.com/XamSome/awesome-xamarin/blob/master/LICENSE)
